/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server.impl;

import com.intellij.compiler.server.CompileServerPlugin;
import com.intellij.compiler.server.impl.BuildProcessClasspathManager;
import com.intellij.compiler.server.impl.BuildProcessClasspathManagerKt;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.ArchivedCompilationContextUtil;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0002\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "findClassesRoot", "", "relativePath", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "baseFile", "Ljava/nio/file/Path;", "computeCompileServerPluginsClasspath", "", "getPluginDir", "Ljava/io/File;", "filterOutOlderVersions", "classpath", "intellij.java.compiler.impl"})
@SourceDebugExtension(value={"SMAP\nBuildProcessClasspathManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildProcessClasspathManager.kt\ncom/intellij/compiler/server/impl/BuildProcessClasspathManagerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,279:1\n1#2:280\n1#2:293\n1#2:307\n184#3,2:281\n1172#3:287\n1342#3:288\n1343#3:294\n1173#3:295\n67#4,4:283\n67#4,4:289\n13#4:336\n1642#5,10:296\n1915#5:306\n1916#5:308\n1652#5:309\n1512#5:310\n1538#5,3:311\n1541#5,3:321\n1220#5,2:324\n1249#5,4:326\n777#5:330\n873#5:331\n1786#5,3:332\n874#5:335\n383#6,7:314\n*S KotlinDebug\n*F\n+ 1 BuildProcessClasspathManager.kt\ncom/intellij/compiler/server/impl/BuildProcessClasspathManagerKt\n*L\n225#1:293\n270#1:307\n200#1:281,2\n225#1:287\n225#1:288\n225#1:294\n225#1:295\n222#1:283,4\n228#1:289,4\n138#1:336\n270#1:296,10\n270#1:306\n270#1:308\n270#1:309\n271#1:310\n271#1:311,3\n271#1:321,3\n272#1:324,2\n272#1:326,4\n273#1:330\n273#1:331\n277#1:332,3\n273#1:335\n271#1:314,7\n*E\n"})
public final class BuildProcessClasspathManagerKt {
    @NotNull
    private static final Logger LOG;

    private static final String findClassesRoot(String relativePath, IdeaPluginDescriptor plugin, Path baseFile) {
        Path jarFile = baseFile.resolve("lib/" + relativePath);
        if (Files.exists(jarFile, new LinkOption[0])) {
            return ((Object)jarFile).toString();
        }
        if (AppMode.isRunningFromDevBuild()) {
            if (!Files.isDirectory(baseFile, new LinkOption[0])) {
                throw new IllegalStateException("Check failed.");
            }
            return ((Object)baseFile).toString();
        }
        Path classesDir = baseFile.resolve("classes");
        if (Files.isDirectory(classesDir, new LinkOption[0])) {
            return ((Object)classesDir).toString();
        }
        if (PluginManagerCore.isRunningFromSources()) {
            File libraryFile;
            File pluginDir;
            String string = FileUtilRt.getNameWithoutExtension((String)PathUtilRt.getFileName((String)relativePath));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
            String fileName = string;
            String moduleName = StringsKt.startsWith$default((String)relativePath, (String)"modules/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)fileName, (String)"intellij.", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)fileName, (char)'-', (boolean)false, (int)2, null) ? fileName : "intellij." + StringsKt.replace$default((String)fileName, (char)'-', (char)'.', (boolean)false, (int)4, null);
            Map mapping = ArchivedCompilationContextUtil.getArchivedCompiledClassesMapping();
            if (mapping != null) {
                Path moduleJar;
                String string2 = (String)mapping.get("production/" + moduleName);
                if (string2 != null) {
                    String p0 = string2;
                    boolean bl = false;
                    v2 = Path.of(p0, new String[0]);
                } else {
                    v2 = moduleJar = null;
                }
                if (moduleJar != null && Files.exists(moduleJar, new LinkOption[0])) {
                    return ((Object)moduleJar).toString();
                }
            } else {
                Path moduleDir;
                Path baseOutputDir = baseFile.getParent();
                if (Intrinsics.areEqual((Object)((Object)baseOutputDir.getFileName()).toString(), (Object)"test")) {
                    baseOutputDir = baseOutputDir.getParent().resolve("production");
                }
                if (Files.isDirectory(moduleDir = baseOutputDir.resolve(moduleName), new LinkOption[0])) {
                    return ((Object)moduleDir).toString();
                }
            }
            if ((pluginDir = BuildProcessClasspathManagerKt.getPluginDir(plugin)) != null && (libraryFile = new File(pluginDir, "lib/" + PathUtilRt.getFileName((String)relativePath))).exists()) {
                return libraryFile.getPath();
            }
            try {
                Object v4;
                block17: {
                    Enumeration<URL> enumeration = BuildProcessClasspathManager.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
                    Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
                    Sequence urls = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
                    Sequence $this$firstOrNull$iv = SequencesKt.mapNotNull((Sequence)urls, BuildProcessClasspathManagerKt::findClassesRoot$lambda$0);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)PathUtilRt.getFileName((String)it), (Object)relativePath)) continue;
                        v4 = element$iv;
                        break block17;
                    }
                    v4 = null;
                }
                String jarPath = v4;
                if (jarPath != null) {
                    return jarPath;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        LOG.error((Throwable)new PluginException("Cannot add '" + relativePath + "' from '" + plugin.getName() + " " + plugin.getVersion() + "' (plugin path: " + baseFile + ") to compiler classpath", plugin.getPluginId()));
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> computeCompileServerPluginsClasspath() {
        ArrayList<String> classpath = new ArrayList<String>();
        for (CompileServerPlugin serverPlugin : CompileServerPlugin.EP_NAME.getExtensionList()) {
            void $this$mapNotNullTo$iv;
            Object $this$trace$iv;
            PluginId pluginId;
            Intrinsics.checkNotNullExpressionValue((Object)serverPlugin.getPluginDescriptor().getPluginId(), (String)"getPluginId(...)");
            IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)pluginId);
            LOG.assertTrue(plugin != null, (Object)pluginId);
            IdeaPluginDescriptor ideaPluginDescriptor = plugin;
            Intrinsics.checkNotNull((Object)ideaPluginDescriptor);
            Path baseFile = ideaPluginDescriptor.getPluginPath();
            if (Files.isRegularFile(baseFile, new LinkOption[0])) {
                classpath.add(((Object)baseFile).toString());
                $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if (!$this$trace$iv.isTraceEnabled()) continue;
                Object object = $this$trace$iv;
                boolean bl = false;
                object.trace(baseFile + " added to process classpath from " + pluginId);
                continue;
            }
            String string = serverPlugin.getClasspath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClasspath(...)");
            $this$trace$iv = new char[1];
            $this$trace$iv[0] = (Logger)59;
            $this$trace$iv = StringsKt.splitToSequence$default((CharSequence)string, (char[])$this$trace$iv, (boolean)false, (int)0, (int)6, null);
            Collection destination$iv = classpath;
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)baseFile);
                String classesRoot = BuildProcessClasspathManagerKt.findClassesRoot(it, plugin, baseFile);
                if (classesRoot != null) {
                    Logger $this$trace$iv2 = LOG;
                    boolean $i$f$trace = false;
                    if ($this$trace$iv2.isTraceEnabled()) {
                        Logger logger = $this$trace$iv2;
                        boolean bl3 = false;
                        logger.trace(classesRoot + " added to process classpath from " + pluginId);
                    }
                }
                if (classesRoot == null) continue;
                boolean bl4 = false;
                destination$iv.add(it$iv);
            }
        }
        return classpath;
    }

    private static final File getPluginDir(IdeaPluginDescriptor plugin) {
        File extraDirFile;
        String string = StringUtilRt.getShortName((String)plugin.getPluginId().getIdString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortName(...)");
        String pluginDirName = string;
        String extraDir = System.getProperty("idea.external.build.development.plugins.dir");
        if (extraDir != null && (extraDirFile = new File(extraDir, pluginDirName)).isDirectory()) {
            return extraDirFile;
        }
        File pluginHome = PluginPathManager.getPluginHome((String)pluginDirName);
        if (!pluginHome.isDirectory() && StringUtil.isCapitalized((String)pluginDirName)) {
            pluginHome = PluginPathManager.getPluginHome((String)StringUtil.decapitalize((String)pluginDirName));
        }
        return pluginHome.isDirectory() ? pluginHome : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> filterOutOlderVersions(List<String> classpath) {
        void $this$filterTo$iv$iv;
        void $this$associateByTo$iv$iv;
        void $this$groupByTo$iv$iv;
        Object p0;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = classpath;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J,\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"com/intellij/compiler/server/impl/BuildProcessClasspathManagerKt$filterOutOlderVersions$JarInfo", "", "path", "", "title", "version", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lcom/intellij/compiler/server/impl/BuildProcessClasspathManagerKt$filterOutOlderVersions$JarInfo;", "equals", "", "other", "hashCode", "", "toString", "intellij.java.compiler.impl"})
        public final class JarInfo {
            @JvmField
            public final String path;
            @JvmField
            public final String title;
            @JvmField
            public final String version;

            public JarInfo(String path, String title, String version) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)title, (String)"title");
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                this.path = path;
                this.title = title;
                this.version = version;
            }

            public final String component1() {
                return this.path;
            }

            public final String component2() {
                return this.title;
            }

            public final String component3() {
                return this.version;
            }

            public final JarInfo copy(String path, String title, String version) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)title, (String)"title");
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                return new JarInfo(path, title, version);
            }

            public static /* synthetic */ JarInfo copy$default(JarInfo jarInfo, String string, String string2, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string = jarInfo.path;
                }
                if ((n & 2) != 0) {
                    string2 = jarInfo.title;
                }
                if ((n & 4) != 0) {
                    string3 = jarInfo.version;
                }
                return jarInfo.copy(string, string2, string3);
            }

            public String toString() {
                return "JarInfo(path=" + this.path + ", title=" + this.title + ", version=" + this.version + ")";
            }

            public int hashCode() {
                int result = this.path.hashCode();
                result = result * 31 + this.title.hashCode();
                result = result * 31 + this.version.hashCode();
                return result;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof JarInfo)) {
                    return false;
                }
                JarInfo jarInfo = (JarInfo)other;
                if (!Intrinsics.areEqual((Object)this.path, (Object)jarInfo.path)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.title, (Object)jarInfo.title)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.version, (Object)jarInfo.version);
            }
        }
        Iterable<JarInfo> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            JarInfo it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            p0 = (String)element$iv$iv;
            boolean bl2 = false;
            if (BuildProcessClasspathManagerKt.filterOutOlderVersions$readTitleAndVersion((String)p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List jarInfos = (List)destination$iv$iv;
        Iterable $this$groupBy$iv = jarInfos;
        boolean $i$f$groupBy = false;
        destination$iv$iv = $this$groupBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo22 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            JarInfo it = (JarInfo)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.title;
            p0 = destination$iv$iv2;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map titleToInfo = destination$iv$iv2;
        Iterable $this$associateBy$iv = jarInfos;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable $i$f$groupByTo22 = $this$associateBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            JarInfo key$iv$iv = (JarInfo)element$iv$iv;
            Map map = destination$iv$iv3;
            boolean bl = false;
            map.put(it.path, element$iv$iv);
        }
        Map pathToInfo = destination$iv$iv3;
        Iterable $this$filter$iv = classpath;
        boolean $i$f$filter = false;
        Iterable capacity$iv22 = $this$filter$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block13: {
                String path = (String)element$iv$iv;
                boolean bl5 = false;
                if ((JarInfo)pathToInfo.get(path) == null) {
                    bl = true;
                } else {
                    JarInfo pathInfo;
                    List sameTitle = (List)titleToInfo.get(pathInfo.title);
                    if (sameTitle == null || sameTitle.size() <= 1) {
                        bl = true;
                    } else {
                        Iterable $this$all$iv = sameTitle;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                JarInfo it = (JarInfo)element$iv;
                                boolean bl6 = false;
                                if (VersionComparatorUtil.compare((String)it.version, (String)pathInfo.version) <= 0) continue;
                                bl = false;
                                break block13;
                            }
                            bl = true;
                        }
                    }
                }
            }
            if (!bl) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        return (List)destination$iv$iv4;
    }

    private static final String findClassesRoot$lambda$0(URL it) {
        Pair pair = URLUtil.splitJarUrl((String)it.getFile());
        return pair != null ? (String)pair.first : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final filterOutOlderVersions.JarInfo filterOutOlderVersions$readTitleAndVersion(String path) {
        Path file = Path.of(path, new String[0]);
        if (!Files.isRegularFile(file, new LinkOption[0]) || !FileUtil.extensionEquals((String)((Object)file.getFileName()).toString(), (String)"jar")) {
            return null;
        }
        Closeable closeable = new JarFile(file.toFile());
        Throwable throwable = null;
        try {
            String string;
            String string2;
            JarFile it = (JarFile)closeable;
            boolean bl = false;
            Cloneable cloneable = it.getManifest();
            if (cloneable == null || (cloneable = ((Manifest)cloneable).getMainAttributes()) == null) {
                JarInfo jarInfo = null;
                return jarInfo;
            }
            Cloneable attributes = cloneable;
            if (((Attributes)attributes).getValue(Attributes.Name.IMPLEMENTATION_TITLE) == null) {
                JarInfo jarInfo = null;
                return jarInfo;
            }
            String title = string2;
            if (((Attributes)attributes).getValue(Attributes.Name.IMPLEMENTATION_VERSION) == null) {
                JarInfo jarInfo = null;
                return jarInfo;
            }
            String version = string;
            JarInfo jarInfo = new JarInfo(path, title, version);
            return jarInfo;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ List access$filterOutOlderVersions(List classpath) {
        return BuildProcessClasspathManagerKt.filterOutOlderVersions(classpath);
    }

    public static final /* synthetic */ List access$computeCompileServerPluginsClasspath() {
        return BuildProcessClasspathManagerKt.computeCompileServerPluginsClasspath();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BuildProcessClasspathManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

