/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.util;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.AnnotationSessionImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.compiler.options.ValidationConfiguration;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.compiler.Validator;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.PsiElementsValidityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class InspectionValidatorWrapper
implements Validator {
    private final InspectionValidator myValidator;
    private final PsiManager myPsiManager;
    private final CompilerManager myCompilerManager;
    private final InspectionManager myInspectionManager;
    private final InspectionProjectProfileManager myProfileManager;
    private final PsiDocumentManager myPsiDocumentManager;
    private static final ThreadLocal<Boolean> ourCompilationThreads = ThreadLocal.withInitial(() -> Boolean.FALSE);

    private InspectionValidatorWrapper(@NotNull CompilerManager compilerManager, @NotNull InspectionManager inspectionManager, @NotNull InspectionProjectProfileManager profileManager, @NotNull PsiDocumentManager psiDocumentManager, @NotNull PsiManager psiManager, @NotNull InspectionValidator validator) {
        if (compilerManager == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(0);
        }
        if (inspectionManager == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(1);
        }
        if (profileManager == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(2);
        }
        if (psiDocumentManager == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(3);
        }
        if (psiManager == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(4);
        }
        if (validator == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(5);
        }
        this.myCompilerManager = compilerManager;
        this.myInspectionManager = inspectionManager;
        this.myProfileManager = profileManager;
        this.myPsiDocumentManager = psiDocumentManager;
        this.myPsiManager = psiManager;
        this.myValidator = validator;
    }

    @NotNull
    public static InspectionValidatorWrapper create(@NotNull Project project, @NotNull InspectionValidator validator) {
        if (project == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(6);
        }
        if (validator == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(7);
        }
        return new InspectionValidatorWrapper(CompilerManager.getInstance((Project)project), InspectionManager.getInstance((Project)project), InspectionProjectProfileManager.getInstance((Project)project), PsiDocumentManager.getInstance((Project)project), PsiManager.getInstance((Project)project), validator);
    }

    public static boolean isCompilationThread() {
        return ourCompilationThreads.get();
    }

    private static @Unmodifiable List<ProblemDescriptor> runInspectionOnFile(@NotNull PsiFile file, @NotNull LocalInspectionTool inspectionTool) {
        if (file == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(8);
        }
        if (inspectionTool == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(9);
        }
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)file.getProject());
        GlobalInspectionContext context = inspectionManager.createNewGlobalContext();
        return InspectionEngine.runInspectionOnFile((PsiFile)file, (InspectionToolWrapper)new LocalInspectionToolWrapper(inspectionTool), (GlobalInspectionContext)context);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    FileProcessingCompiler.ProcessingItem @NotNull [] getProcessingItems(@NotNull CompileContext context) {
        Project project;
        if (context == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(10);
        }
        if ((project = context.getProject()).isDefault() || !ValidationConfiguration.shouldValidate(this, project)) {
            if (FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY == null) {
                InspectionValidatorWrapper.$$$reportNull$$$0(11);
            }
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        ExcludesConfiguration excludesConfiguration = ValidationConfiguration.getExcludedEntriesConfiguration(project);
        List items = (List)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
            CompileScope compileScope = context.getCompileScope();
            if (!this.myValidator.isAvailableOnScope(compileScope)) {
                return null;
            }
            ArrayList items1 = new ArrayList();
            Processor processor = file -> {
                PsiFile psiFile;
                if (!file.isValid()) {
                    return true;
                }
                if (this.myCompilerManager.isExcludedFromCompilation(file) || excludesConfiguration.isExcluded(file)) {
                    return true;
                }
                Module module = context.getModuleByFile(file);
                if (module != null && (psiFile = this.myPsiManager.findFile(file)) != null) {
                    items1.add(new MyValidatorProcessingItem(psiFile));
                }
                return true;
            };
            ContainerUtil.process((Iterable)this.myValidator.getFilesToProcess(this.myPsiManager.getProject(), context), (Processor)processor);
            return items1;
        });
        if (items == null) {
            if (FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY == null) {
                InspectionValidatorWrapper.$$$reportNull$$$0(12);
            }
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        FileProcessingCompiler.ProcessingItem[] processingItemArray = items.toArray(FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY);
        if (processingItemArray == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(13);
        }
        return processingItemArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileProcessingCompiler.ProcessingItem[] process(@NotNull CompileContext context, // Could not load outer class - annotation placement on inner may be incorrect
    FileProcessingCompiler.ProcessingItem @NotNull [] items) {
        if (context == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(14);
        }
        if (items == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(15);
        }
        context.getProgressIndicator().setText(this.myValidator.getProgressIndicatorText());
        Map<Class<?>, LocalInspectionTool> allTools = InspectionValidatorWrapper.getInspectionToolMap(context.getProject(), this.myProfileManager);
        ArrayList<LocalInspectionTool> inspections = new ArrayList<LocalInspectionTool>();
        for (Class aClass : this.myValidator.getInspectionToolClasses(context)) {
            LocalInspectionTool tool = allTools.get(aClass);
            if (tool == null) continue;
            inspections.add(tool);
        }
        ArrayList<MyValidatorProcessingItem> processedItems = new ArrayList<MyValidatorProcessingItem>();
        for (int i = 0; i < items.length; ++i) {
            MyValidatorProcessingItem item = (MyValidatorProcessingItem)items[i];
            context.getProgressIndicator().checkCanceled();
            context.getProgressIndicator().setFraction((double)i / (double)items.length);
            try {
                ourCompilationThreads.set(Boolean.TRUE);
                if (!this.checkFile(inspections, item, context)) continue;
                processedItems.add(item);
                continue;
            }
            finally {
                ourCompilationThreads.set(Boolean.FALSE);
            }
        }
        return processedItems.toArray(FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY);
    }

    @NotNull
    private static Map<Class<?>, LocalInspectionTool> getInspectionToolMap(@NotNull Project project, @NotNull InspectionProjectProfileManager profileManager) {
        if (project == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(16);
        }
        if (profileManager == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(17);
        }
        IdentityHashMap allTools = new IdentityHashMap();
        InspectionProfileImpl profile = profileManager.getCurrentProfile();
        for (Tools tools : profile.getAllEnabledInspectionTools(project)) {
            InspectionProfileEntry inspectionProfileEntry = tools.getTool().getTool();
            if (!(inspectionProfileEntry instanceof LocalInspectionTool)) continue;
            allTools.put(inspectionProfileEntry.getClass(), (LocalInspectionTool)inspectionProfileEntry);
        }
        IdentityHashMap identityHashMap = allTools;
        if (identityHashMap == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(18);
        }
        return identityHashMap;
    }

    private boolean checkFile(List<? extends LocalInspectionTool> inspections, MyValidatorProcessingItem item, CompileContext context) {
        boolean hasErrors;
        boolean bl = hasErrors = !this.checkUnderReadAction(item, context, (Computable<? extends Map<ProblemDescriptor, HighlightDisplayLevel>>)((Computable)() -> this.myValidator.checkAdditionally(item.getPsiFile())));
        if (!this.checkUnderReadAction(item, context, (Computable<? extends Map<ProblemDescriptor, HighlightDisplayLevel>>)((Computable)() -> {
            PsiFile file = item.getPsiFile();
            if (file instanceof XmlFile) {
                return this.runXmlFileSchemaValidation((XmlFile)file);
            }
            return Collections.emptyMap();
        }))) {
            hasErrors = true;
        }
        InspectionProfileImpl inspectionProfile = this.myProfileManager.getCurrentProfile();
        for (LocalInspectionTool localInspectionTool : inspections) {
            if (this.checkUnderReadAction(item, context, (Computable<? extends Map<ProblemDescriptor, HighlightDisplayLevel>>)((Computable)() -> InspectionValidatorWrapper.lambda$checkFile$5(item, localInspectionTool, (InspectionProfile)inspectionProfile)))) continue;
            hasErrors = true;
        }
        return !hasErrors;
    }

    @NotNull
    public String getId() {
        String string = this.myValidator.getId();
        if (string == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(19);
        }
        return string;
    }

    private boolean checkUnderReadAction(@NotNull MyValidatorProcessingItem item, @NotNull CompileContext context, @NotNull Computable<? extends Map<ProblemDescriptor, HighlightDisplayLevel>> runnable) {
        if (context == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(20);
        }
        if (runnable == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(21);
        }
        if (item == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(22);
        }
        return (Boolean)DumbService.getInstance((Project)context.getProject()).runReadActionInSmartMode(() -> {
            PsiFile file = item.getPsiFile();
            if (file == null) {
                return false;
            }
            Document document = this.myPsiDocumentManager.getCachedDocument(file);
            if (document != null && this.myPsiDocumentManager.isUncommited(document)) {
                String url = file.getViewProvider().getVirtualFile().getUrl();
                context.addMessage(CompilerMessageCategory.WARNING, JavaCompilerBundle.message((String)"warning.text.file.has.been.changed", (Object[])new Object[0]), url, -1, -1);
                return false;
            }
            return !this.reportProblems(context, (Map)runnable.compute());
        });
    }

    private boolean reportProblems(CompileContext context, Map<ProblemDescriptor, HighlightDisplayLevel> problemsMap) {
        if (problemsMap.isEmpty()) {
            return false;
        }
        boolean errorsReported = false;
        for (Map.Entry<ProblemDescriptor, HighlightDisplayLevel> entry : problemsMap.entrySet()) {
            VirtualFile virtualFile;
            ProblemDescriptor problemDescriptor = entry.getKey();
            PsiElement element = problemDescriptor.getPsiElement();
            PsiFile psiFile = element.getContainingFile();
            if (psiFile == null || (virtualFile = psiFile.getVirtualFile()) == null) continue;
            CompilerMessageCategory category = this.myValidator.getCategoryByHighlightDisplayLevel(entry.getValue(), virtualFile, context);
            Document document = this.myPsiDocumentManager.getDocument(psiFile);
            int offset = problemDescriptor.getStartElement().getTextOffset();
            assert (document != null);
            int line = document.getLineNumber(offset);
            int column = offset - document.getLineStartOffset(line);
            context.addMessage(category, problemDescriptor.getDescriptionTemplate(), virtualFile.getUrl(), line + 1, column + 1);
            if (CompilerMessageCategory.ERROR != category) continue;
            errorsReported = true;
        }
        return errorsReported;
    }

    @NotNull
    private static Map<ProblemDescriptor, HighlightDisplayLevel> runInspectionTool(PsiFile file, LocalInspectionTool inspectionTool, HighlightDisplayLevel level) {
        LinkedHashMap<ProblemDescriptor, HighlightDisplayLevel> problemsMap = new LinkedHashMap<ProblemDescriptor, HighlightDisplayLevel>();
        for (ProblemDescriptor descriptor : InspectionValidatorWrapper.runInspectionOnFile(file, inspectionTool)) {
            ProblemHighlightType highlightType = descriptor.getHighlightType();
            HighlightDisplayLevel highlightDisplayLevel = highlightType == ProblemHighlightType.WEAK_WARNING ? HighlightDisplayLevel.WEAK_WARNING : (highlightType == ProblemHighlightType.INFORMATION ? HighlightDisplayLevel.DO_NOT_SHOW : level);
            problemsMap.put(descriptor, highlightDisplayLevel);
        }
        LinkedHashMap<ProblemDescriptor, HighlightDisplayLevel> linkedHashMap = problemsMap;
        if (linkedHashMap == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(23);
        }
        return linkedHashMap;
    }

    private static HighlightDisplayLevel getHighlightDisplayLevel(LocalInspectionTool inspectionTool, InspectionProfile inspectionProfile, PsiElement file) {
        HighlightDisplayKey key = HighlightDisplayKey.find((String)inspectionTool.getShortName());
        return inspectionProfile.isToolEnabled(key, file) ? inspectionProfile.getErrorLevel(key, file) : HighlightDisplayLevel.DO_NOT_SHOW;
    }

    private Map<ProblemDescriptor, HighlightDisplayLevel> runXmlFileSchemaValidation(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(24);
        }
        LinkedHashMap<ProblemDescriptor, HighlightDisplayLevel> problemsMap = new LinkedHashMap<ProblemDescriptor, HighlightDisplayLevel>();
        List annotators = ExternalLanguageAnnotators.allForFile((Language)XMLLanguage.INSTANCE, (PsiFile)xmlFile);
        for (ExternalAnnotator annotator : annotators) {
            AnnotationSessionImpl.computeWithSession((PsiFile)xmlFile, (boolean)false, (ExternalAnnotator)annotator, annotationHolder -> {
                InspectionValidatorWrapper.processAnnotator(xmlFile, (AnnotationHolderImpl)annotationHolder, annotator);
                for (Annotation annotation : (AnnotationHolderImpl)annotationHolder) {
                    PsiElement endElement;
                    HighlightInfo info = HighlightInfo.fromAnnotation((ExternalAnnotator)annotator, (Annotation)annotation, (Document)xmlFile.getFileDocument());
                    if (info.getSeverity() == HighlightSeverity.INFORMATION) continue;
                    PsiElement startElement = xmlFile.findElementAt(info.startOffset);
                    PsiElement psiElement = endElement = info.startOffset == info.endOffset ? startElement : xmlFile.findElementAt(info.endOffset - 1);
                    if (startElement == null || endElement == null) continue;
                    ProblemDescriptor descriptor = this.myInspectionManager.createProblemDescriptor(startElement, endElement, info.getDescription(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0]);
                    HighlightDisplayLevel level = info.getSeverity() == HighlightSeverity.ERROR ? HighlightDisplayLevel.ERROR : HighlightDisplayLevel.WARNING;
                    problemsMap.put(descriptor, level);
                }
                ((AnnotationHolderImpl)annotationHolder).assertAllAnnotationsCreated();
                return null;
            });
        }
        if (problemsMap.isEmpty()) {
            return Collections.emptyMap();
        }
        return problemsMap;
    }

    private static <X, Y> void processAnnotator(@NotNull XmlFile xmlFile, AnnotationHolderImpl holder, ExternalAnnotator<X, Y> annotator) {
        Object result;
        Object initial;
        if (xmlFile == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(25);
        }
        if ((initial = annotator.collectInformation((PsiFile)xmlFile)) != null && (result = annotator.doAnnotate(initial)) != null) {
            holder.applyExternalAnnotatorWithContext((PsiFile)xmlFile, result);
        }
    }

    @NotNull
    @Nls
    public String getDescription() {
        String string = this.myValidator.getDescription();
        if (string == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(26);
        }
        return string;
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return PsiElementsValidityState.load(in);
    }

    private static /* synthetic */ Map lambda$checkFile$5(MyValidatorProcessingItem item, LocalInspectionTool inspectionTool, InspectionProfile inspectionProfile) {
        PsiFile file = item.getPsiFile();
        if (file != null && InspectionValidatorWrapper.getHighlightDisplayLevel(inspectionTool, inspectionProfile, (PsiElement)file) != HighlightDisplayLevel.DO_NOT_SHOW) {
            return InspectionValidatorWrapper.runInspectionTool(file, inspectionTool, InspectionValidatorWrapper.getHighlightDisplayLevel(inspectionTool, inspectionProfile, (PsiElement)file));
        }
        return Collections.emptyMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13, 18, 19, 23, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionManager";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDocumentManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionTool";
                break;
            }
            case 10: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/compiler/util/InspectionValidatorWrapper";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/compiler/util/InspectionValidatorWrapper";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessingItems";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionToolMap";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "runInspectionTool";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runInspectionOnFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getProcessingItems";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 23: 
            case 26: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionToolMap";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkUnderReadAction";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "runXmlFileSchemaValidation";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processAnnotator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13, 18, 19, 23, 26 -> new IllegalStateException(string);
        };
    }

    private class MyValidatorProcessingItem
    implements FileProcessingCompiler.ProcessingItem {
        private final VirtualFile myVirtualFile;
        private final PsiManager myPsiManager;
        private PsiElementsValidityState myValidityState;

        MyValidatorProcessingItem(PsiFile psiFile) {
            if (psiFile == null) {
                MyValidatorProcessingItem.$$$reportNull$$$0(0);
            }
            this.myVirtualFile = psiFile.getVirtualFile();
            this.myPsiManager = psiFile.getManager();
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myVirtualFile;
            if (virtualFile == null) {
                MyValidatorProcessingItem.$$$reportNull$$$0(1);
            }
            return virtualFile;
        }

        @Nullable
        public ValidityState getValidityState() {
            if (this.myValidityState == null) {
                this.myValidityState = this.computeValidityState();
            }
            return this.myValidityState;
        }

        private PsiElementsValidityState computeValidityState() {
            PsiElementsValidityState state = new PsiElementsValidityState();
            PsiFile psiFile = this.getPsiFile();
            if (psiFile != null) {
                for (PsiElement psiElement : InspectionValidatorWrapper.this.myValidator.getDependencies(psiFile)) {
                    state.addDependency(psiElement);
                }
            }
            return state;
        }

        @Nullable
        public PsiFile getPsiFile() {
            return this.myVirtualFile.isValid() ? this.myPsiManager.findFile(this.myVirtualFile) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/compiler/util/InspectionValidatorWrapper$MyValidatorProcessingItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/compiler/util/InspectionValidatorWrapper$MyValidatorProcessingItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

