/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.ConfigurationErrorType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.impl.artifacts.InvalidArtifact;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ArtifactLoadingErrorDescription
extends ConfigurationErrorDescription {
    private final Project myProject;
    private final InvalidArtifact myArtifact;

    public ArtifactLoadingErrorDescription(Project project, InvalidArtifact artifact) {
        super(artifact.getName(), artifact.getErrorMessage());
        this.myProject = project;
        this.myArtifact = artifact;
    }

    public void ignoreInvalidElement() {
        ModifiableArtifactModel model = ArtifactManager.getInstance((Project)this.myProject).createModifiableModel();
        model.removeArtifact((Artifact)this.myArtifact);
        WriteAction.run(() -> model.commit());
    }

    @NotNull
    public String getIgnoreConfirmationMessage() {
        String string = JavaCompilerBundle.message((String)"unknown.artifact.remove.confirmation", (Object[])new Object[]{this.myArtifact.getName()});
        if (string == null) {
            ArtifactLoadingErrorDescription.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isValid() {
        return ArtifactManager.getInstance((Project)this.myProject).getAllArtifactsIncludingInvalid().contains(this.myArtifact);
    }

    @NotNull
    public ArtifactErrorType getErrorType() {
        ArtifactErrorType artifactErrorType = ArtifactErrorType.INSTANCE;
        if (artifactErrorType == null) {
            ArtifactLoadingErrorDescription.$$$reportNull$$$0(1);
        }
        return artifactErrorType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/packaging/impl/artifacts/ArtifactLoadingErrorDescription";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoreConfirmationMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorType";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static final class ArtifactErrorType
    extends ConfigurationErrorType {
        private static final ArtifactErrorType INSTANCE = new ArtifactErrorType();

        private ArtifactErrorType() {
            super(false);
        }

        @NotNull
        @NonNls
        public String getFeatureType() {
            return "com.intellij.packaging.artifacts.ArtifactType";
        }

        @Nls
        @NotNull
        public String getErrorText(int errorCount, @NlsSafe String firstElementName) {
            String string = JavaCompilerBundle.message((String)"artifact.configuration.problem.text", (Object[])new Object[]{errorCount, firstElementName});
            if (string == null) {
                ArtifactErrorType.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/artifacts/ArtifactLoadingErrorDescription$ArtifactErrorType", "getErrorText"));
        }
    }
}

