/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.impl.artifacts.ArtifactPointerImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public final class ArtifactPointerManagerImpl
extends ArtifactPointerManager {
    private static final Logger LOG = Logger.getInstance(ArtifactPointerManagerImpl.class);
    private final Map<String, ArtifactPointerImpl> myNameToPointers;
    private final Lock myLock;
    @NotNull
    private final Project myProject;

    public ArtifactPointerManagerImpl(@NotNull Project project) {
        if (project == null) {
            ArtifactPointerManagerImpl.$$$reportNull$$$0(0);
        }
        this.myNameToPointers = new HashMap<String, ArtifactPointerImpl>();
        this.myLock = new ReentrantLock();
        this.myProject = project;
        project.getMessageBus().connect().subscribe(ArtifactManager.TOPIC, (Object)new ArtifactListener(){

            public void artifactRemoved(@NotNull Artifact artifact) {
                if (artifact == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArtifactPointerManagerImpl.this.invalidatePointer(artifact);
            }

            public void artifactAdded(@NotNull Artifact artifact) {
                if (artifact == null) {
                    1.$$$reportNull$$$0(1);
                }
                ArtifactPointerManagerImpl.this.myLock.lock();
                try {
                    ArtifactPointerImpl pointer = ArtifactPointerManagerImpl.this.myNameToPointers.get(artifact.getName());
                    if (pointer != null) {
                        pointer.setArtifact(artifact);
                    }
                }
                finally {
                    ArtifactPointerManagerImpl.this.myLock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void artifactChanged(@NotNull Artifact artifact, @NotNull String oldName) {
                if (artifact == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (oldName == null) {
                    1.$$$reportNull$$$0(3);
                }
                ArtifactPointerManagerImpl.this.myLock.lock();
                try {
                    ArtifactPointerImpl artifactPointer;
                    if (!oldName.equals(artifact.getName()) && (artifactPointer = ArtifactPointerManagerImpl.this.myNameToPointers.remove(oldName)) != null) {
                        Artifact artifactFromPointer = artifactPointer.getArtifactNoResolve();
                        LOG.assertTrue(artifactFromPointer == null || artifactFromPointer.equals((Object)artifact));
                        String newName = artifact.getName();
                        artifactPointer.setName(newName);
                        ArtifactPointerManagerImpl.this.myNameToPointers.put(newName, artifactPointer);
                    }
                }
                finally {
                    ArtifactPointerManagerImpl.this.myLock.unlock();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "artifact";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldName";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/packaging/impl/artifacts/ArtifactPointerManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "artifactRemoved";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "artifactAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "artifactChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void invalidatePointer(@NotNull Artifact artifact) {
        if (artifact == null) {
            ArtifactPointerManagerImpl.$$$reportNull$$$0(1);
        }
        this.myLock.lock();
        try {
            ArtifactPointerImpl pointer = this.myNameToPointers.get(artifact.getName());
            if (pointer != null) {
                pointer.invalidateArtifact();
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    public ArtifactPointer createPointer(@NotNull String name) {
        if (name == null) {
            ArtifactPointerManagerImpl.$$$reportNull$$$0(2);
        }
        this.myLock.lock();
        try {
            ArtifactPointer artifactPointer = this.myNameToPointers.computeIfAbsent(name, n -> new ArtifactPointerImpl((String)n, this.myProject));
            return artifactPointer;
        }
        finally {
            this.myLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactPointer createPointer(@NotNull Artifact artifact) {
        if (artifact == null) {
            ArtifactPointerManagerImpl.$$$reportNull$$$0(3);
        }
        this.myLock.lock();
        try {
            ArtifactPointerImpl pointer = this.myNameToPointers.computeIfAbsent(artifact.getName(), name -> new ArtifactPointerImpl((String)name, this.myProject));
            pointer.setArtifact(artifact);
            ArtifactPointerImpl artifactPointerImpl = pointer;
            return artifactPointerImpl;
        }
        finally {
            this.myLock.unlock();
        }
    }

    @TestOnly
    public @Unmodifiable @NotNull List<Map.Entry<String, ArtifactPointerImpl>> getResolvedPointers() {
        this.myLock.lock();
        List list = ContainerUtil.filter(this.myNameToPointers.entrySet(), entry -> ((ArtifactPointerImpl)entry.getValue()).getArtifactNoResolve() != null);
        List list2 = list;
        if (list2 == null) {
            ArtifactPointerManagerImpl.$$$reportNull$$$0(4);
        }
        return list2;
        finally {
            this.myLock.unlock();
        }
    }

    public ArtifactPointer createPointer(@NotNull Artifact artifact, @NotNull ArtifactModel artifactModel) {
        if (artifact == null) {
            ArtifactPointerManagerImpl.$$$reportNull$$$0(5);
        }
        if (artifactModel == null) {
            ArtifactPointerManagerImpl.$$$reportNull$$$0(6);
        }
        return this.createPointer(artifactModel.getOriginalArtifact(artifact));
    }

    public void disposePointers(@NotNull List<? extends Artifact> artifacts) {
        if (artifacts == null) {
            ArtifactPointerManagerImpl.$$$reportNull$$$0(7);
        }
        for (Artifact artifact : artifacts) {
            this.invalidatePointer(artifact);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/artifacts/ArtifactPointerManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/artifacts/ArtifactPointerManagerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedPointers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invalidatePointer";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPointer";
                break;
            }
            case 4: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "disposePointers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

