/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.packaging.artifacts.LegacyBridgeJpsArtifactEntitySourceFactory;
import com.intellij.platform.workspace.jps.JpsEntitySourceFactory;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.JpsProjectConfigLocation;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.workspaceModel.ide.JpsProjectConfigLocationUtilKt;
import com.intellij.workspaceModel.ide.NonPersistentEntitySource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/packaging/impl/artifacts/LegacyBridgeJpsArtifactEntitySourceFactoryImpl;", "Lcom/intellij/packaging/artifacts/LegacyBridgeJpsArtifactEntitySourceFactory;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createEntitySourceForArtifact", "Lcom/intellij/platform/workspace/storage/EntitySource;", "externalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "intellij.java.compiler.impl"})
public final class LegacyBridgeJpsArtifactEntitySourceFactoryImpl
implements LegacyBridgeJpsArtifactEntitySourceFactory {
    @NotNull
    private final Project project;

    public LegacyBridgeJpsArtifactEntitySourceFactoryImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public EntitySource createEntitySourceForArtifact(@Nullable ProjectModelExternalSource externalSource) {
        JpsProjectConfigLocation jpsProjectConfigLocation = JpsProjectConfigLocationUtilKt.getJpsProjectConfigLocation((Project)this.project);
        if (jpsProjectConfigLocation == null) {
            return (EntitySource)NonPersistentEntitySource.INSTANCE;
        }
        JpsProjectConfigLocation location = jpsProjectConfigLocation;
        JpsFileEntitySource internalFile = JpsEntitySourceFactory.INSTANCE.createJpsEntitySourceForArtifact(location);
        if (externalSource == null) {
            return (EntitySource)internalFile;
        }
        String string = externalSource.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return (EntitySource)new JpsImportedEntitySource(internalFile, string, ProjectUtilCore.isExternalStorageEnabled((Project)this.project));
    }
}

