/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts.workspacemodel;

import com.intellij.compiler.server.BuildManager;
import com.intellij.java.workspace.entities.ArtifactEntity;
import com.intellij.java.workspace.entities.ArtifactId;
import com.intellij.java.workspace.entities.CustomPackagingElementEntity;
import com.intellij.java.workspace.entities.CustomPackagingElementEntityBuilder;
import com.intellij.java.workspace.entities.CustomPackagingElementEntityModifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.ElementInitializer;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactPointerManagerImpl;
import com.intellij.packaging.impl.artifacts.DefaultPackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.InvalidArtifact;
import com.intellij.packaging.impl.artifacts.workspacemodel.ArtifactBridge;
import com.intellij.packaging.impl.artifacts.workspacemodel.ArtifactModifiableModelBridge;
import com.intellij.packaging.impl.artifacts.workspacemodel.BridgeUtilsKt;
import com.intellij.packaging.impl.artifacts.workspacemodel.DynamicArtifactExtensionsLoaderBridge;
import com.intellij.packaging.impl.artifacts.workspacemodel.PackagingElementInitializer;
import com.intellij.packaging.impl.artifacts.workspacemodel.packaging.MappingsKt;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.MillisecondsMeasurer;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ExternalEntityMapping;
import com.intellij.platform.workspace.storage.ExternalMappingKey;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableExternalEntityMapping;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.VersionedEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.VersionedEntityStorageImpl;
import com.intellij.platform.workspace.storage.instrumentation.ImmutableEntityStorageInstrumentation;
import com.intellij.platform.workspace.storage.instrumentation.MutableEntityStorageInstrumentation;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelImpl;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 >2\u00020\u0001:\u0001>B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0017\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150\u001cH\u0017J\u0013\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0017\u00a2\u0006\u0002\u0010\u0013J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020&H\u0016J&\u0010'\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010)H\u0016J*\u0010*\u001a\u00020+2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u00172\u0010\u0010-\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030/0.H\u0016J$\u0010*\u001a\u00020+2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u00172\n\u00100\u001a\u0006\u0012\u0002\b\u00030/H\u0016J\b\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020+2\u0006\u00104\u001a\u000205H\u0007J\u0010\u00106\u001a\u00020+2\u0006\u00107\u001a\u00020$H\u0002J\b\u00108\u001a\u00020+H\u0003J\u001c\u00109\u001a\u00020+2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020=0;H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006?"}, d2={"Lcom/intellij/packaging/impl/artifacts/workspacemodel/ArtifactManagerBridge;", "Lcom/intellij/packaging/artifacts/ArtifactManager;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "modificationTracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "resolvingContext", "Lcom/intellij/packaging/impl/artifacts/DefaultPackagingElementResolvingContext;", "artifactWithDiffs", "", "Lcom/intellij/packaging/impl/artifacts/workspacemodel/ArtifactBridge;", "getArtifactWithDiffs$intellij_java_compiler_impl", "()Ljava/util/List;", "getArtifacts", "", "()[Lcom/intellij/packaging/impl/artifacts/workspacemodel/ArtifactBridge;", "findArtifact", "Lcom/intellij/packaging/artifacts/Artifact;", "name", "", "getArtifactByOriginal", "artifact", "getOriginalArtifact", "getArtifactsByType", "", "type", "Lcom/intellij/packaging/artifacts/ArtifactType;", "getAllArtifactsIncludingInvalid", "getSortedArtifacts", "createModifiableModel", "Lcom/intellij/packaging/artifacts/ModifiableArtifactModel;", "mutableEntityStorage", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "getResolvingContext", "Lcom/intellij/packaging/elements/PackagingElementResolvingContext;", "addArtifact", "root", "Lcom/intellij/packaging/elements/CompositePackagingElement;", "addElementsToDirectory", "", "relativePath", "elements", "", "Lcom/intellij/packaging/elements/PackagingElement;", "element", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "commit", "artifactModel", "Lcom/intellij/packaging/impl/artifacts/workspacemodel/ArtifactModifiableModelBridge;", "updateCustomElements", "diff", "initBridges", "dropMappings", "selector", "Lkotlin/Function1;", "Lcom/intellij/java/workspace/entities/ArtifactEntity;", "", "Companion", "intellij.java.compiler.impl"})
@SourceDebugExtension(value={"SMAP\nArtifactManagerBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtifactManagerBridge.kt\ncom/intellij/packaging/impl/artifacts/workspacemodel/ArtifactManagerBridge\n+ 2 MillisecondsMeasurer.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 8 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,402:1\n44#2,2:403\n46#2:410\n44#2,2:411\n46#2:416\n44#2,2:417\n46#2:422\n44#2,2:423\n46#2:428\n44#2,2:429\n46#2:455\n44#2,2:456\n46#2:461\n44#2,2:462\n46#2:467\n29#3,2:405\n31#3:409\n29#3,3:413\n29#3,3:419\n29#3,3:425\n29#3,2:431\n31#3:454\n29#3,3:458\n29#3,3:464\n37#4,2:407\n67#5,4:433\n13#5:474\n1#6:437\n1915#7,2:438\n1915#7,2:440\n1915#7:442\n1915#7,2:443\n1916#7:445\n1915#7:446\n1915#7,2:447\n1915#7,2:449\n1916#7:451\n1915#7,2:452\n1915#7,2:468\n1915#7,2:470\n1342#8,2:472\n*S KotlinDebug\n*F\n+ 1 ArtifactManagerBridge.kt\ncom/intellij/packaging/impl/artifacts/workspacemodel/ArtifactManagerBridge\n*L\n70#1:403,2\n70#1:410\n83#1:411,2\n83#1:416\n97#1:417,2\n97#1:422\n148#1:423,2\n148#1:428\n177#1:429,2\n177#1:455\n296#1:456,2\n296#1:461\n391#1:462,2\n391#1:467\n70#1:405,2\n70#1:409\n83#1:413,3\n97#1:419,3\n148#1:425,3\n177#1:431,2\n177#1:454\n296#1:458,3\n391#1:464,3\n79#1:407,2\n180#1:433,4\n337#1:474\n233#1:438,2\n246#1:440,2\n250#1:442\n251#1:443,2\n250#1:445\n254#1:446\n255#1:447,2\n257#1:449,2\n254#1:451\n260#1:452,2\n267#1:468,2\n268#1:470,2\n396#1:472,2\n*E\n"})
public final class ArtifactManagerBridge
extends ArtifactManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final SimpleModificationTracker modificationTracker;
    @NotNull
    private final DefaultPackagingElementResolvingContext resolvingContext;
    @NotNull
    private final List<ArtifactBridge> artifactWithDiffs;
    @NotNull
    private static final Object lock = new Object();
    @NotNull
    private static final ExternalMappingKey<ArtifactBridge> ARTIFACT_BRIDGE_MAPPING_ID = ExternalMappingKey.Companion.create("intellij.artifacts.bridge");
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Condition<Artifact> VALID_ARTIFACT_CONDITION;
    @NotNull
    private static final AtomicLong getArtifactsMs;
    @NotNull
    private static final AtomicLong findArtifactMs;
    @NotNull
    private static final AtomicLong getArtifactsByTypeMs;
    @NotNull
    private static final AtomicLong addArtifactMs;
    @NotNull
    private static final AtomicLong initBridgesMs;
    @NotNull
    private static final AtomicLong commitMs;
    @NotNull
    private static final AtomicLong dropMappingsMs;

    public ArtifactManagerBridge(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.modificationTracker = new SimpleModificationTracker();
        this.resolvingContext = new DefaultPackagingElementResolvingContext(this.project);
        this.artifactWithDiffs = new ArrayList();
        new DynamicArtifactExtensionsLoaderBridge(this).installListeners(coroutineScope);
    }

    @NotNull
    public final List<ArtifactBridge> getArtifactWithDiffs$intellij_java_compiler_impl() {
        return this.artifactWithDiffs;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @NotNull
    public ArtifactBridge[] getArtifacts() {
        void var3_3;
        AtomicLong arg0$iv = getArtifactsMs;
        boolean bl = false;
        ArtifactBridge[] value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        this.initBridges();
        ImmutableEntityStorage store = WorkspaceModelKt.getWorkspaceModel((Project)this.project).getCurrentSnapshot();
        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)store.entities(ArtifactEntity.class), arg_0 -> ArtifactManagerBridge.getArtifacts$lambda$0$0(store, arg_0)), ArtifactManagerBridge::getArtifacts$lambda$0$1));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        value$iv = thisCollection$iv.toArray(new ArtifactBridge[0]);
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return var3_3;
    }

    @RequiresReadLock
    @Nullable
    public Artifact findArtifact(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        AtomicLong arg0$iv = findArtifactMs;
        boolean bl = false;
        ArtifactBridge value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        this.initBridges();
        ImmutableEntityStorage store = WorkspaceModelKt.getWorkspaceModel((Project)this.project).getCurrentSnapshot();
        ArtifactEntity artifactEntity = (ArtifactEntity)store.resolve((SymbolicEntityId)new ArtifactId(name));
        if (artifactEntity == null) {
            return null;
        }
        ArtifactEntity artifactEntity2 = artifactEntity;
        ArtifactBridge artifactBridge = (ArtifactBridge)((Object)Companion.getArtifactsMap((EntityStorage)store).getDataByEntity((WorkspaceEntity)artifactEntity2));
        if (artifactBridge == null) {
            throw new IllegalStateException("All artifact bridges should be already created at this moment".toString());
        }
        value$iv = artifactBridge;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return (Artifact)value$iv;
    }

    @NotNull
    public Artifact getArtifactByOriginal(@NotNull Artifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        return artifact;
    }

    @NotNull
    public Artifact getOriginalArtifact(@NotNull Artifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        return artifact;
    }

    @RequiresReadLock
    @NotNull
    public List<ArtifactBridge> getArtifactsByType(@NotNull ArtifactType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        AtomicLong arg0$iv = getArtifactsByTypeMs;
        boolean bl = false;
        List value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.initBridges();
        ImmutableEntityStorage store = WorkspaceModelKt.getWorkspaceModel((Project)this.project).getCurrentSnapshot();
        String typeId = type.getId();
        value$iv = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)store.entities(ArtifactEntity.class), arg_0 -> ArtifactManagerBridge.getArtifactsByType$lambda$0$0(typeId, arg_0)), arg_0 -> ArtifactManagerBridge.getArtifactsByType$lambda$0$1(store, arg_0)));
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    @RequiresReadLock
    @NotNull
    public List<Artifact> getAllArtifactsIncludingInvalid() {
        ThreadingAssertions.assertReadAccess();
        this.initBridges();
        ImmutableEntityStorage storage = WorkspaceModelKt.getWorkspaceModel((Project)this.project).getCurrentSnapshot();
        return SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)storage.entities(ArtifactEntity.class), arg_0 -> ArtifactManagerBridge.getAllArtifactsIncludingInvalid$lambda$0(storage, arg_0)));
    }

    @RequiresReadLock
    @NotNull
    public ArtifactBridge[] getSortedArtifacts() {
        ArtifactBridge[] artifacts = this.getArtifacts();
        Comparator comparator = ArtifactManager.ARTIFACT_COMPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"ARTIFACT_COMPARATOR");
        ArraysKt.sortWith((Object[])artifacts, (Comparator)comparator);
        return artifacts;
    }

    @NotNull
    public ModifiableArtifactModel createModifiableModel() {
        ImmutableEntityStorage storage = WorkspaceModelKt.getWorkspaceModel((Project)this.project).getCurrentSnapshot();
        return this.createModifiableModel(MutableEntityStorage.Companion.from(storage));
    }

    private final ModifiableArtifactModel createModifiableModel(MutableEntityStorage mutableEntityStorage) {
        return new ArtifactModifiableModelBridge(this.project, mutableEntityStorage, this);
    }

    @NotNull
    public PackagingElementResolvingContext getResolvingContext() {
        return this.resolvingContext;
    }

    @NotNull
    public Artifact addArtifact(@NotNull String name, @NotNull ArtifactType type, @Nullable CompositePackagingElement<?> root) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        AtomicLong arg0$iv = addArtifactMs;
        boolean bl = false;
        ModifiableArtifact value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        value$iv = (ModifiableArtifact)WriteAction.compute(() -> ArtifactManagerBridge.addArtifact$lambda$0$0(this, name, type, root));
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        ModifiableArtifact modifiableArtifact = value$iv;
        Intrinsics.checkNotNullExpressionValue((Object)modifiableArtifact, (String)"addMeasuredTime-impl(...)");
        return (Artifact)modifiableArtifact;
    }

    public void addElementsToDirectory(@NotNull Artifact artifact, @NotNull String relativePath, @NotNull Collection<? extends PackagingElement<?>> elements) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        ModifiableArtifactModel model = this.createModifiableModel();
        CompositePackagingElement compositePackagingElement = model.getOrCreateModifiableArtifact(artifact).getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)compositePackagingElement, (String)"getRootElement(...)");
        CompositePackagingElement root = compositePackagingElement;
        PackagingElementFactory.getInstance().getOrCreateDirectory(root, relativePath).addOrFindChildren(elements);
        WriteAction.run(() -> ArtifactManagerBridge.addElementsToDirectory$lambda$0(model));
    }

    public void addElementsToDirectory(@NotNull Artifact artifact, @NotNull String relativePath, @NotNull PackagingElement<?> element) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter(element, (String)"element");
        this.addElementsToDirectory(artifact, relativePath, CollectionsKt.listOf(element));
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        return (ModificationTracker)this.modificationTracker;
    }

    @RequiresWriteLock
    public final void commit(@NotNull ArtifactModifiableModelBridge artifactModel) {
        PackagingElement it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Object it2;
        Object key;
        Intrinsics.checkNotNullParameter((Object)artifactModel, (String)"artifactModel");
        AtomicLong arg0$iv = commitMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl4 = false;
            logger.trace("Committing artifact manager bridge. diff: " + artifactModel.getDiff$intellij_java_compiler_impl());
        }
        this.updateCustomElements(artifactModel.getDiff$intellij_java_compiler_impl());
        ImmutableEntityStorage current = WorkspaceModelKt.getWorkspaceModel((Project)this.project).getCurrentSnapshot();
        MutableEntityStorage mutableEntityStorage = artifactModel.getDiff$intellij_java_compiler_impl();
        Intrinsics.checkNotNull((Object)mutableEntityStorage, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.instrumentation.MutableEntityStorageInstrumentation");
        List list = (List)((MutableEntityStorageInstrumentation)mutableEntityStorage).collectChanges().get(ArtifactEntity.class);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List changes = list;
        Set removed = new LinkedHashSet();
        List added = new ArrayList();
        List changed = new ArrayList();
        List changedArtifacts = new ArrayList();
        BidirectionalMap modifiableToOriginal = new BidirectionalMap();
        for (Map.Entry entry : ((Map)artifactModel.getModifiableToOriginal$intellij_java_compiler_impl()).entrySet()) {
            key = (ArtifactBridge)((Object)entry.getKey());
            ArtifactBridge value = (ArtifactBridge)((Object)entry.getValue());
            ((Map)modifiableToOriginal).put(key, value);
        }
        for (Object change : changes) {
            key = change;
            if (key instanceof EntityChange.Removed) {
                if ((ArtifactBridge)((Object)Companion.getArtifactsMap((EntityStorage)current).getDataByEntity(((EntityChange.Removed)change).getOldEntity())) != null) {
                    ArtifactBridge it1;
                    boolean bl5 = false;
                    removed.add(it1);
                }
                continue;
            }
            if (key instanceof EntityChange.Added) continue;
            if (key instanceof EntityChange.Replaced) {
                Object object = Companion.getArtifactsMap((EntityStorage)artifactModel.getDiff$intellij_java_compiler_impl()).getDataByEntity(((EntityChange.Replaced)change).getNewEntity());
                Intrinsics.checkNotNull((Object)object);
                ArtifactBridge originalArtifact = (ArtifactBridge)((Object)object);
                List list2 = modifiableToOriginal.getKeysByValue((Object)originalArtifact);
                Intrinsics.checkNotNull((Object)list2);
                ArtifactBridge modifiableArtifact = (ArtifactBridge)((Object)CollectionsKt.single((List)list2));
                if (modifiableArtifact != originalArtifact) {
                    Intrinsics.checkNotNull((Object)((Object)modifiableArtifact));
                    changedArtifacts.add(modifiableArtifact);
                }
                Intrinsics.checkNotNull((Object)((Object)modifiableArtifact));
                originalArtifact.copyFrom(modifiableArtifact);
                WorkspaceEntity workspaceEntity = ((EntityChange.Replaced)change).getOldEntity();
                Intrinsics.checkNotNull((Object)workspaceEntity, (String)"null cannot be cast to non-null type com.intellij.java.workspace.entities.ArtifactEntity");
                changed.add(new Triple((Object)originalArtifact, (Object)((ArtifactEntity)workspaceEntity).getName(), (Object)modifiableArtifact));
                originalArtifact.setActualStorage();
                modifiableToOriginal.remove((Object)modifiableArtifact, (Object)originalArtifact);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        Iterator iterator = modifiableToOriginal.entrySet().iterator();
        while (iterator.hasNext()) {
            ArtifactBridge original;
            Object change;
            Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
            Object modifiable = (ArtifactBridge)((Object)change.getKey());
            if (modifiable == (original = (ArtifactBridge)((Object)change.getValue()))) continue;
            Intrinsics.checkNotNull((Object)modifiable);
            changedArtifacts.add(modifiable);
            String oldName = original.getName();
            original.copyFrom((ArtifactBridge)((Object)modifiable));
            changed.add(new Triple((Object)original, (Object)oldName, modifiable));
        }
        ArtifactPointerManager artifactPointerManager = ArtifactPointerManager.getInstance((Project)this.project);
        Intrinsics.checkNotNull((Object)artifactPointerManager, (String)"null cannot be cast to non-null type com.intellij.packaging.impl.artifacts.ArtifactPointerManagerImpl");
        ((ArtifactPointerManagerImpl)artifactPointerManager).disposePointers(changedArtifacts);
        WorkspaceModelKt.getWorkspaceModel((Project)this.project).updateProjectModel("Commit artifact manager", arg_0 -> ArtifactManagerBridge.commit$lambda$0$2(artifactModel, arg_0));
        this.modificationTracker.incModificationCount();
        Iterable $this$forEach$iv2 = changes;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            it2 = (EntityChange)element$iv;
            boolean bl6 = false;
            Object bl5 = it2;
            if (bl5 instanceof EntityChange.Added) {
                Object object = Companion.getArtifactsMap((EntityStorage)artifactModel.getDiff$intellij_java_compiler_impl()).getDataByEntity(((EntityChange.Added)it2).getNewEntity());
                Intrinsics.checkNotNull((Object)object);
                ArtifactBridge artifactBridge = (ArtifactBridge)((Object)object);
                added.add(artifactBridge);
                artifactBridge.setActualStorage();
                continue;
            }
            if (bl5 instanceof EntityChange.Removed || bl5 instanceof EntityChange.Replaced) continue;
            throw new NoWhenBranchMatchedException();
        }
        $this$forEach$iv2 = this.artifactWithDiffs;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            it2 = (ArtifactBridge)((Object)element$iv);
            boolean bl7 = false;
            ((ArtifactBridge)((Object)it2)).setActualStorage();
        }
        this.artifactWithDiffs.clear();
        WorkspaceModel workspaceModel = WorkspaceModelKt.getWorkspaceModel((Project)this.project);
        Intrinsics.checkNotNull((Object)workspaceModel, (String)"null cannot be cast to non-null type com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal");
        VersionedEntityStorageImpl entityStorage = ((WorkspaceModelInternal)workspaceModel).getEntityStorage();
        Iterable $this$forEach$iv3 = added;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            ArtifactBridge bridge = (ArtifactBridge)((Object)element$iv);
            boolean bl8 = false;
            $this$forEach$iv = bridge.getElementsWithDiff();
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                it = (PackagingElement)element$iv2;
                boolean bl9 = false;
                it.setStorage((VersionedEntityStorage)entityStorage, this.project, (Set)new HashSet(), (ElementInitializer)PackagingElementInitializer.INSTANCE);
            }
            bridge.getElementsWithDiff().clear();
        }
        $this$forEach$iv3 = changed;
        $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            Triple changedItem = (Triple)element$iv;
            boolean bl10 = false;
            $this$forEach$iv = ((ArtifactBridge)((Object)changedItem.getThird())).getElementsWithDiff();
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                it = (PackagingElement)element$iv2;
                boolean bl11 = false;
                it.setStorage((VersionedEntityStorage)entityStorage, this.project, (Set)new HashSet(), (ElementInitializer)PackagingElementInitializer.INSTANCE);
            }
            ((ArtifactBridge)((Object)changedItem.getThird())).getElementsWithDiff().clear();
            $this$forEach$iv = ((ArtifactBridge)((Object)changedItem.getFirst())).getElementsWithDiff();
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                it = (PackagingElement)element$iv2;
                boolean bl12 = false;
                it.setStorage((VersionedEntityStorage)entityStorage, this.project, (Set)new HashSet(), (ElementInitializer)PackagingElementInitializer.INSTANCE);
            }
            ((ArtifactBridge)((Object)changedItem.getFirst())).getElementsWithDiff().clear();
        }
        $this$forEach$iv3 = artifactModel.getElementsWithDiff$intellij_java_compiler_impl();
        $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            PackagingElement it3 = (PackagingElement)element$iv;
            boolean bl13 = false;
            it3.setStorage((VersionedEntityStorage)entityStorage, this.project, (Set)new HashSet(), (ElementInitializer)PackagingElementInitializer.INSTANCE);
        }
        artifactModel.getElementsWithDiff$intellij_java_compiler_impl().clear();
        MessageBus messageBus = this.project.getMessageBus();
        Topic topic = ArtifactManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        Object object = messageBus.syncPublisher(topic);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"syncPublisher(...)");
        ArtifactListener publisher = (ArtifactListener)object;
        ProjectRootManagerEx.getInstanceEx((Project)this.project).mergeRootsChangesDuring(() -> ArtifactManagerBridge.commit$lambda$0$8(removed, added, changed, publisher));
        if (!((Collection)changes).isEmpty()) {
            BuildManager.getInstance().clearState(this.project);
        }
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    private final void updateCustomElements(MutableEntityStorage diff) {
        List customEntities = SequencesKt.toList((Sequence)diff.entities(CustomPackagingElementEntity.class));
        for (CustomPackagingElementEntity customEntity : customEntities) {
            String newState;
            Object state;
            PackagingElement packagingElement;
            if ((PackagingElement)MappingsKt.getElements((EntityStorage)diff).getDataByEntity((WorkspaceEntity)customEntity) == null || packagingElement.getState() == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)JDOMUtil.write((Element)XmlSerializer.serialize((Object)state)), (String)"write(...)");
            if (Intrinsics.areEqual((Object)newState, (Object)customEntity.getPropertiesXmlTag())) continue;
            CustomPackagingElementEntityModifications.modifyCustomPackagingElementEntity((MutableEntityStorage)diff, (CustomPackagingElementEntity)customEntity, arg_0 -> ArtifactManagerBridge.updateCustomElements$lambda$0(newState, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresReadLock
    private final void initBridges() {
        AtomicLong arg0$iv = initBridgesMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        WorkspaceModel workspaceModel = WorkspaceModelKt.getWorkspaceModel((Project)this.project);
        ImmutableEntityStorage immutableEntityStorage = workspaceModel.getCurrentSnapshot();
        Intrinsics.checkNotNull((Object)immutableEntityStorage, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.instrumentation.ImmutableEntityStorageInstrumentation");
        ImmutableEntityStorageInstrumentation current = (ImmutableEntityStorageInstrumentation)immutableEntityStorage;
        if (current.entityCount(ArtifactEntity.class) != Companion.getArtifactsMap((EntityStorage)current).size()) {
            Object object = lock;
            synchronized (object) {
                boolean bl4 = false;
                ImmutableEntityStorage immutableEntityStorage2 = workspaceModel.getCurrentSnapshot();
                Intrinsics.checkNotNull((Object)immutableEntityStorage2, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.instrumentation.ImmutableEntityStorageInstrumentation");
                ImmutableEntityStorageInstrumentation currentInSync = (ImmutableEntityStorageInstrumentation)immutableEntityStorage2;
                ExternalEntityMapping<ArtifactBridge> artifactsMap = Companion.getArtifactsMap((EntityStorage)currentInSync);
                if (currentInSync.entityCount(ArtifactEntity.class) != artifactsMap.size()) {
                    List newBridges = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)currentInSync.entities(ArtifactEntity.class), arg_0 -> ArtifactManagerBridge.initBridges$lambda$0$0$0(artifactsMap, workspaceModel, this, arg_0)));
                    Intrinsics.checkNotNull((Object)workspaceModel, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.WorkspaceModelImpl");
                    ((WorkspaceModelImpl)workspaceModel).updateProjectModelSilent("Initialize artifact bridges", arg_0 -> ArtifactManagerBridge.initBridges$lambda$0$0$1(newBridges, arg_0));
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    @RequiresWriteLock
    public final void dropMappings(@NotNull Function1<? super ArtifactEntity, Boolean> selector) {
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        AtomicLong arg0$iv = dropMappingsMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        WorkspaceModel workspaceModel = WorkspaceModelKt.getWorkspaceModel((Project)this.project);
        Intrinsics.checkNotNull((Object)workspaceModel, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.WorkspaceModelImpl");
        ((WorkspaceModelImpl)workspaceModel).updateProjectModelSilent("Drop artifact mappings", arg_0 -> ArtifactManagerBridge.dropMappings$lambda$0$0(selector, arg_0));
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    private static final ArtifactBridge getArtifacts$lambda$0$0(ImmutableEntityStorage $store, ArtifactEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ArtifactBridge artifactBridge = (ArtifactBridge)((Object)Companion.getArtifactsMap((EntityStorage)$store).getDataByEntity((WorkspaceEntity)it));
        if (artifactBridge == null) {
            throw new IllegalStateException("All artifact bridges should be already created at this moment".toString());
        }
        return artifactBridge;
    }

    private static final boolean getArtifacts$lambda$0$1(ArtifactBridge it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return VALID_ARTIFACT_CONDITION.value((Object)it);
    }

    private static final boolean getArtifactsByType$lambda$0$0(String $typeId, ArtifactEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getArtifactType(), (Object)$typeId);
    }

    private static final ArtifactBridge getArtifactsByType$lambda$0$1(ImmutableEntityStorage $store, ArtifactEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ArtifactBridge artifactBridge = (ArtifactBridge)((Object)Companion.getArtifactsMap((EntityStorage)$store).getDataByEntity((WorkspaceEntity)it));
        if (artifactBridge == null) {
            throw new IllegalStateException("All artifact bridges should be already created at this moment".toString());
        }
        return artifactBridge;
    }

    private static final ArtifactBridge getAllArtifactsIncludingInvalid$lambda$0(ImmutableEntityStorage $storage, ArtifactEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ArtifactBridge artifactBridge = (ArtifactBridge)((Object)Companion.getArtifactsMap((EntityStorage)$storage).getDataByEntity((WorkspaceEntity)it));
        if (artifactBridge == null) {
            throw new IllegalStateException("All artifact bridges should be already created at this moment".toString());
        }
        return artifactBridge;
    }

    private static final ModifiableArtifact addArtifact$lambda$0$0(ArtifactManagerBridge this$0, String $name, ArtifactType $type, CompositePackagingElement $root) {
        ModifiableArtifactModel model = this$0.createModifiableModel();
        ModifiableArtifact modifiableArtifact = model.addArtifact($name, $type);
        Intrinsics.checkNotNullExpressionValue((Object)modifiableArtifact, (String)"addArtifact(...)");
        ModifiableArtifact artifact = modifiableArtifact;
        if ($root != null) {
            artifact.setRootElement($root);
        }
        model.commit();
        return artifact;
    }

    private static final void addElementsToDirectory$lambda$0(ModifiableArtifactModel $model) {
        $model.commit();
    }

    private static final Unit commit$lambda$0$2(ArtifactModifiableModelBridge $artifactModel, MutableEntityStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.applyChangesFrom($artifactModel.getDiff$intellij_java_compiler_impl());
        return Unit.INSTANCE;
    }

    private static final void commit$lambda$0$8(Set $removed, List $added, List $changed, ArtifactListener $publisher) {
        ArtifactBridge it;
        Iterable $this$forEach$iv = $removed;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ArtifactBridge)((Object)element$iv);
            boolean bl = false;
            $publisher.artifactRemoved((Artifact)it);
        }
        $this$forEach$iv = $added;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ArtifactBridge)((Object)element$iv);
            boolean bl = false;
            $publisher.artifactAdded((Artifact)it);
        }
        for (Triple triple : $changed) {
            ArtifactBridge artifact = (ArtifactBridge)((Object)triple.component1());
            String oldName = (String)triple.component2();
            $publisher.artifactChanged((Artifact)artifact, oldName);
        }
    }

    private static final Unit updateCustomElements$lambda$0(String $newState, CustomPackagingElementEntityBuilder $this$modifyCustomPackagingElementEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyCustomPackagingElementEntity, (String)"$this$modifyCustomPackagingElementEntity");
        $this$modifyCustomPackagingElementEntity.setPropertiesXmlTag($newState);
        return Unit.INSTANCE;
    }

    private static final ArtifactBridge initBridges$lambda$0$0$0(ExternalEntityMapping $artifactsMap, WorkspaceModel $workspaceModel, ArtifactManagerBridge this$0, ArtifactEntity it) {
        ArtifactBridge artifactBridge;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($artifactsMap.getDataByEntity((WorkspaceEntity)it) == null) {
            Intrinsics.checkNotNull((Object)$workspaceModel, (String)"null cannot be cast to non-null type com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal");
            artifactBridge = BridgeUtilsKt.createArtifactBridge(it, (VersionedEntityStorage)((WorkspaceModelInternal)$workspaceModel).getEntityStorage(), this$0.project);
        } else {
            artifactBridge = null;
        }
        return artifactBridge;
    }

    private static final Unit initBridges$lambda$0$0$1(List $newBridges, MutableEntityStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BridgeUtilsKt.addBridgesToDiff($newBridges, it);
        return Unit.INSTANCE;
    }

    private static final Unit dropMappings$lambda$0$0(Function1 $selector, MutableEntityStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MutableExternalEntityMapping<ArtifactBridge> map = Companion.getMutableArtifactsMap$intellij_java_compiler_impl(it);
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)it.entities(ArtifactEntity.class), (Function1)$selector);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ArtifactEntity artifact = (ArtifactEntity)element$iv;
            boolean bl = false;
            map.removeMapping((WorkspaceEntity)artifact);
        }
        return Unit.INSTANCE;
    }

    private static final boolean VALID_ARTIFACT_CONDITION$lambda$0(Artifact it) {
        return !(it instanceof InvalidArtifact);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ArtifactManagerBridge.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        VALID_ARTIFACT_CONDITION = ArtifactManagerBridge::VALID_ARTIFACT_CONDITION$lambda$0;
        getArtifactsMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        findArtifactMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        getArtifactsByTypeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        addArtifactMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        initBridgesMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        commitMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        dropMappingsMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        ArtifactManagerBridge.Companion.setupOpenTelemetryReporting(TelemetryManager.Companion.getMeter(PlatformScopesKt.Compiler));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e*\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0010\u0010\u001c\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0010\u0010\u001d\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0010\u0010\u001e\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0010\u0010\u001f\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0010\u0010 \u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0010\u0010!\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001b\u00a8\u0006&"}, d2={"Lcom/intellij/packaging/impl/artifacts/workspacemodel/ArtifactManagerBridge$Companion;", "", "<init>", "()V", "lock", "ARTIFACT_BRIDGE_MAPPING_ID", "Lcom/intellij/platform/workspace/storage/ExternalMappingKey;", "Lcom/intellij/packaging/impl/artifacts/workspacemodel/ArtifactBridge;", "artifactsMap", "Lcom/intellij/platform/workspace/storage/ExternalEntityMapping;", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "getArtifactsMap", "(Lcom/intellij/platform/workspace/storage/EntityStorage;)Lcom/intellij/platform/workspace/storage/ExternalEntityMapping;", "mutableArtifactsMap", "Lcom/intellij/platform/workspace/storage/MutableExternalEntityMapping;", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "getMutableArtifactsMap$intellij_java_compiler_impl", "(Lcom/intellij/platform/workspace/storage/MutableEntityStorage;)Lcom/intellij/platform/workspace/storage/MutableExternalEntityMapping;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "VALID_ARTIFACT_CONDITION", "Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/packaging/artifacts/Artifact;", "getVALID_ARTIFACT_CONDITION", "()Lcom/intellij/openapi/util/Condition;", "getArtifactsMs", "Lcom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer;", "Ljava/util/concurrent/atomic/AtomicLong;", "findArtifactMs", "getArtifactsByTypeMs", "addArtifactMs", "initBridgesMs", "commitMs", "dropMappingsMs", "setupOpenTelemetryReporting", "", "meter", "Lio/opentelemetry/api/metrics/Meter;", "intellij.java.compiler.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExternalEntityMapping<ArtifactBridge> getArtifactsMap(@NotNull EntityStorage $this$artifactsMap) {
            Intrinsics.checkNotNullParameter((Object)$this$artifactsMap, (String)"<this>");
            return $this$artifactsMap.getExternalMapping(ARTIFACT_BRIDGE_MAPPING_ID);
        }

        @NotNull
        public final MutableExternalEntityMapping<ArtifactBridge> getMutableArtifactsMap$intellij_java_compiler_impl(@NotNull MutableEntityStorage $this$mutableArtifactsMap) {
            Intrinsics.checkNotNullParameter((Object)$this$mutableArtifactsMap, (String)"<this>");
            return $this$mutableArtifactsMap.getMutableExternalMapping(ARTIFACT_BRIDGE_MAPPING_ID);
        }

        @NotNull
        public final Condition<Artifact> getVALID_ARTIFACT_CONDITION() {
            return VALID_ARTIFACT_CONDITION;
        }

        private final void setupOpenTelemetryReporting(Meter meter) {
            ObservableLongMeasurement getArtifactsCounter = meter.counterBuilder("compiler.ArtifactManagerBridge.getArtifacts.ms").setDescription("Total time spent in method").buildObserver();
            ObservableLongMeasurement findArtifactCounter = meter.counterBuilder("compiler.ArtifactManagerBridge.findArtifact.ms").setDescription("Total time spent in method").buildObserver();
            ObservableLongMeasurement getArtifactsByTypeCounter = meter.counterBuilder("compiler.ArtifactManagerBridge.getArtifactsByType.ms").setDescription("Total time spent in method").buildObserver();
            ObservableLongMeasurement addArtifactCounter = meter.counterBuilder("compiler.ArtifactManagerBridge.addArtifact.ms").setDescription("Total time spent in method").buildObserver();
            ObservableLongMeasurement initBridgesCounter = meter.counterBuilder("compiler.ArtifactManagerBridge.initBridges.ms").setDescription("Total time spent in method").buildObserver();
            ObservableLongMeasurement commitDurationCounter = meter.counterBuilder("compiler.ArtifactManagerBridge.commit.ms").setDescription("Total time spent in method").buildObserver();
            ObservableLongMeasurement dropMappingsCounter = meter.counterBuilder("compiler.ArtifactManagerBridge.dropMappings.ms").setDescription("Total time spent in method").buildObserver();
            ObservableMeasurement[] observableMeasurementArray = new ObservableMeasurement[]{findArtifactCounter, getArtifactsByTypeCounter, addArtifactCounter, initBridgesCounter, commitDurationCounter, dropMappingsCounter};
            meter.batchCallback(() -> Companion.setupOpenTelemetryReporting$lambda$0(getArtifactsCounter, findArtifactCounter, getArtifactsByTypeCounter, addArtifactCounter, initBridgesCounter, commitDurationCounter, dropMappingsCounter), (ObservableMeasurement)getArtifactsCounter, observableMeasurementArray);
        }

        private static final void setupOpenTelemetryReporting$lambda$0(ObservableLongMeasurement $getArtifactsCounter, ObservableLongMeasurement $findArtifactCounter, ObservableLongMeasurement $getArtifactsByTypeCounter, ObservableLongMeasurement $addArtifactCounter, ObservableLongMeasurement $initBridgesCounter, ObservableLongMeasurement $commitDurationCounter, ObservableLongMeasurement $dropMappingsCounter) {
            $getArtifactsCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)getArtifactsMs));
            $findArtifactCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)findArtifactMs));
            $getArtifactsByTypeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)getArtifactsByTypeMs));
            $addArtifactCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)addArtifactMs));
            $initBridgesCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)initBridgesMs));
            $commitDurationCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)commitMs));
            $dropMappingsCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)dropMappingsMs));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

