/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts.workspacemodel;

import com.intellij.java.workspace.entities.ArtifactEntity;
import com.intellij.java.workspace.entities.ArtifactEntityBuilder;
import com.intellij.java.workspace.entities.ArtifactEntityModifications;
import com.intellij.java.workspace.entities.ArtifactId;
import com.intellij.java.workspace.entities.CompositePackagingElementEntity;
import com.intellij.java.workspace.entities.CompositePackagingElementEntityBuilder;
import com.intellij.java.workspace.entities.PackagingElementEntity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.LegacyBridgeJpsArtifactEntitySourceFactory;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.ElementInitializer;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.artifacts.ArtifactPointerManagerImpl;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.workspacemodel.ArtifactBridge;
import com.intellij.packaging.impl.artifacts.workspacemodel.ArtifactManagerBridge;
import com.intellij.packaging.impl.artifacts.workspacemodel.BridgeUtilsKt;
import com.intellij.packaging.impl.artifacts.workspacemodel.PackagingElementInitializer;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.MillisecondsMeasurer;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.VersionedEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.VersionedEntityStorageImpl;
import com.intellij.platform.workspace.storage.impl.VersionedEntityStorageOnBuilder;
import com.intellij.platform.workspace.storage.instrumentation.MutableEntityStorageInstrumentation;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.text.UniqueNameGenerator;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 A2\u00020\u0001:\u0001AB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020!H\u0016J\u0010\u0010&\u001a\u00020!2\u0006\u0010%\u001a\u00020!H\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020!0(2\u0006\u0010)\u001a\u00020*H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020!0,H\u0016J.\u0010-\u001a\u00020.2\u0006\u0010\"\u001a\u00020#2\u0006\u0010/\u001a\u00020*2\n\u00100\u001a\u0006\u0012\u0002\b\u0003012\b\u00102\u001a\u0004\u0018\u000103H\u0016J\u0010\u00104\u001a\u00020#2\u0006\u00105\u001a\u00020#H\u0002J\u0010\u00106\u001a\u0002072\u0006\u0010%\u001a\u00020!H\u0016J\u0010\u00108\u001a\u00020.2\u0006\u0010%\u001a\u00020!H\u0016J\u0012\u00109\u001a\u0004\u0018\u00010!2\u0006\u0010%\u001a\u00020!H\u0016J\u0010\u0010:\u001a\u0002072\u0006\u0010;\u001a\u00020\u0013H\u0016J\u0010\u0010<\u001a\u0002072\u0006\u0010;\u001a\u00020\u0013H\u0016J\b\u0010=\u001a\u00020>H\u0016J\b\u0010?\u001a\u000207H\u0017J\b\u0010@\u001a\u000207H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0011\u001a\u0015\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u00130\u0012\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/packaging/impl/artifacts/workspacemodel/ArtifactModifiableModelBridge;", "Lcom/intellij/packaging/artifacts/ModifiableArtifactModel;", "project", "Lcom/intellij/openapi/project/Project;", "diff", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "manager", "Lcom/intellij/packaging/impl/artifacts/workspacemodel/ArtifactManagerBridge;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/workspace/storage/MutableEntityStorage;Lcom/intellij/packaging/impl/artifacts/workspacemodel/ArtifactManagerBridge;)V", "getDiff$intellij_java_compiler_impl", "()Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "modifiableToOriginal", "Lcom/intellij/util/containers/BidirectionalMap;", "Lcom/intellij/packaging/impl/artifacts/workspacemodel/ArtifactBridge;", "getModifiableToOriginal$intellij_java_compiler_impl", "()Lcom/intellij/util/containers/BidirectionalMap;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/packaging/artifacts/ArtifactListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "elementsWithDiff", "", "Lcom/intellij/packaging/elements/PackagingElement;", "getElementsWithDiff$intellij_java_compiler_impl", "()Ljava/util/Set;", "versionedOnBuilder", "Lcom/intellij/platform/workspace/storage/impl/VersionedEntityStorageOnBuilder;", "getArtifacts", "", "()[Lcom/intellij/packaging/impl/artifacts/workspacemodel/ArtifactBridge;", "findArtifact", "Lcom/intellij/packaging/artifacts/Artifact;", "name", "", "getArtifactByOriginal", "artifact", "getOriginalArtifact", "getArtifactsByType", "", "type", "Lcom/intellij/packaging/artifacts/ArtifactType;", "getAllArtifactsIncludingInvalid", "", "addArtifact", "Lcom/intellij/packaging/artifacts/ModifiableArtifact;", "artifactType", "rootElement", "Lcom/intellij/packaging/elements/CompositePackagingElement;", "externalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "generateUniqueName", "baseName", "removeArtifact", "", "getOrCreateModifiableArtifact", "getModifiableCopy", "addListener", "listener", "removeListener", "isModified", "", "commit", "dispose", "Companion", "intellij.java.compiler.impl"})
@SourceDebugExtension(value={"SMAP\nArtifactModifiableModelBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtifactModifiableModelBridge.kt\ncom/intellij/packaging/impl/artifacts/workspacemodel/ArtifactModifiableModelBridge\n+ 2 MillisecondsMeasurer.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 8 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,317:1\n44#2,2:318\n46#2:325\n44#2,2:326\n46#2:331\n44#2,2:332\n46#2:337\n44#2,2:338\n46#2:344\n44#2,2:347\n46#2:352\n44#2,2:353\n46#2:372\n29#3,2:320\n31#3:324\n29#3,3:328\n29#3,3:334\n29#3,2:340\n31#3:343\n29#3,3:349\n29#3,2:355\n31#3:371\n37#4,2:322\n1#5:342\n1342#6,2:345\n221#7,2:357\n1915#8,2:359\n1915#8,2:361\n1915#8:363\n1915#8,2:364\n1916#8:366\n1915#8:367\n1915#8,2:368\n1916#8:370\n*S KotlinDebug\n*F\n+ 1 ArtifactModifiableModelBridge.kt\ncom/intellij/packaging/impl/artifacts/workspacemodel/ArtifactModifiableModelBridge\n*L\n55#1:318,2\n55#1:325\n71#1:326,2\n71#1:331\n93#1:332,2\n93#1:337\n130#1:338,2\n130#1:344\n217#1:347,2\n217#1:352\n224#1:353,2\n224#1:372\n55#1:320,2\n55#1:324\n71#1:328,3\n93#1:334,3\n130#1:340,2\n130#1:343\n217#1:349,3\n224#1:355,2\n224#1:371\n66#1:322,2\n179#1:345,2\n228#1:357,2\n243#1:359,2\n260#1:361,2\n267#1:363\n268#1:364,2\n267#1:366\n271#1:367\n272#1:368,2\n271#1:370\n*E\n"})
public final class ArtifactModifiableModelBridge
implements ModifiableArtifactModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final MutableEntityStorage diff;
    @NotNull
    private final ArtifactManagerBridge manager;
    @NotNull
    private final BidirectionalMap<ArtifactBridge, ArtifactBridge> modifiableToOriginal;
    @NotNull
    private final EventDispatcher<ArtifactListener> eventDispatcher;
    @NotNull
    private final Set<PackagingElement<?>> elementsWithDiff;
    @NotNull
    private final VersionedEntityStorageOnBuilder versionedOnBuilder;
    @NotNull
    private static final AtomicLong getArtifactsMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
    @NotNull
    private static final AtomicLong findArtifactMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
    @NotNull
    private static final AtomicLong addArtifactMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
    @NotNull
    private static final AtomicLong getArtifactsByTypeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
    @NotNull
    private static final AtomicLong commitMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
    @NotNull
    private static final AtomicLong disposeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);

    public ArtifactModifiableModelBridge(@NotNull Project project, @NotNull MutableEntityStorage diff, @NotNull ArtifactManagerBridge manager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        Intrinsics.checkNotNullParameter((Object)((Object)manager), (String)"manager");
        this.project = project;
        this.diff = diff;
        this.manager = manager;
        this.modifiableToOriginal = new BidirectionalMap();
        EventDispatcher eventDispatcher = EventDispatcher.create(ArtifactListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        this.elementsWithDiff = new LinkedHashSet();
        this.versionedOnBuilder = new VersionedEntityStorageOnBuilder(this.diff);
    }

    @NotNull
    public final MutableEntityStorage getDiff$intellij_java_compiler_impl() {
        return this.diff;
    }

    @NotNull
    public final BidirectionalMap<ArtifactBridge, ArtifactBridge> getModifiableToOriginal$intellij_java_compiler_impl() {
        return this.modifiableToOriginal;
    }

    @NotNull
    public final Set<PackagingElement<?>> getElementsWithDiff$intellij_java_compiler_impl() {
        return this.elementsWithDiff;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ArtifactBridge[] getArtifacts() {
        void var3_3;
        AtomicLong arg0$iv = getArtifactsMs;
        boolean bl = false;
        ArtifactBridge[] value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        List newBridges = new ArrayList();
        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)this.diff.entities(ArtifactEntity.class), arg_0 -> ArtifactModifiableModelBridge.getArtifacts$lambda$0$0(this, newBridges, arg_0)), ArtifactModifiableModelBridge::getArtifacts$lambda$0$1));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ArtifactBridge[] artifacts = thisCollection$iv.toArray(new ArtifactBridge[0]);
        BridgeUtilsKt.addBridgesToDiff(newBridges, this.diff);
        value$iv = (ArtifactBridge[])UtilKt.mapInPlace((Object[])artifacts, arg_0 -> ArtifactModifiableModelBridge.getArtifacts$lambda$0$2(this, arg_0));
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return var3_3;
    }

    @Nullable
    public Artifact findArtifact(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        AtomicLong arg0$iv = findArtifactMs;
        boolean bl = false;
        Object value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        ArtifactEntity artifactEntity = (ArtifactEntity)this.diff.resolve((SymbolicEntityId)new ArtifactId(name));
        if (artifactEntity == null) {
            return null;
        }
        ArtifactEntity artifactEntity2 = artifactEntity;
        List newBridges = new ArrayList();
        ArtifactBridge artifactBridge = (ArtifactBridge)((Object)ArtifactManagerBridge.Companion.getArtifactsMap((EntityStorage)this.diff).getDataByEntity((WorkspaceEntity)artifactEntity2));
        if (artifactBridge == null) {
            ArtifactBridge artifactBridge2;
            ArtifactBridge it = artifactBridge2 = BridgeUtilsKt.createArtifactBridge(artifactEntity2, (VersionedEntityStorage)this.versionedOnBuilder, this.project);
            boolean bl4 = false;
            newBridges.add(it);
            this.manager.getArtifactWithDiffs$intellij_java_compiler_impl().add(it);
            artifactBridge = artifactBridge2;
        }
        ArtifactBridge bridge = artifactBridge;
        BridgeUtilsKt.addBridgesToDiff(newBridges, this.diff);
        Object object = this.modifiableToOriginal.getKeysByValue((Object)bridge);
        if (object == null || (object = (ArtifactBridge)((Object)CollectionsKt.singleOrNull((List)object))) == null) {
            object = bridge;
        }
        value$iv = object;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return (Artifact)value$iv;
    }

    @NotNull
    public Artifact getArtifactByOriginal(@NotNull Artifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Object object = this.modifiableToOriginal.getKeysByValue((Object)((ArtifactBridge)artifact));
        return object != null && (object = (ArtifactBridge)((Object)CollectionsKt.singleOrNull((List)object))) != null ? (Artifact)object : artifact;
    }

    @NotNull
    public Artifact getOriginalArtifact(@NotNull Artifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        ArtifactBridge artifactBridge = (ArtifactBridge)((Object)this.modifiableToOriginal.get((Object)((ArtifactBridge)artifact)));
        return artifactBridge != null ? (Artifact)artifactBridge : artifact;
    }

    @NotNull
    public Collection<Artifact> getArtifactsByType(@NotNull ArtifactType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        AtomicLong arg0$iv = getArtifactsByTypeMs;
        boolean bl = false;
        Object value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        boolean bl2 = false;
        boolean bl3 = false;
        String typeId = type.getId();
        List newBridges = new ArrayList();
        List artifacts = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)this.diff.entities(ArtifactEntity.class), arg_0 -> ArtifactModifiableModelBridge.getArtifactsByType$lambda$0$0(typeId, arg_0)), arg_0 -> ArtifactModifiableModelBridge.getArtifactsByType$lambda$0$1(this, newBridges, arg_0)));
        BridgeUtilsKt.addBridgesToDiff(newBridges, this.diff);
        return artifacts;
    }

    @NotNull
    public List<Artifact> getAllArtifactsIncludingInvalid() {
        List newBridges = new ArrayList();
        List artifacts = SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)this.diff.entities(ArtifactEntity.class), arg_0 -> ArtifactModifiableModelBridge.getAllArtifactsIncludingInvalid$lambda$0(this, newBridges, arg_0)));
        BridgeUtilsKt.addBridgesToDiff(newBridges, this.diff);
        return artifacts;
    }

    @NotNull
    public ModifiableArtifact addArtifact(@NotNull String name, @NotNull ArtifactType artifactType, @NotNull CompositePackagingElement<?> rootElement, @Nullable ProjectModelExternalSource externalSource) {
        VirtualFileUrl virtualFileUrl;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)artifactType, (String)"artifactType");
        Intrinsics.checkNotNullParameter(rootElement, (String)"rootElement");
        AtomicLong arg0$iv = addArtifactMs;
        boolean bl = false;
        Object value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        boolean bl2 = false;
        boolean bl3 = false;
        String uniqueName = this.generateUniqueName(name);
        String outputPath = ArtifactUtil.getDefaultArtifactOutputPath(uniqueName, this.project);
        VirtualFileUrlManager fileManager = WorkspaceModel.Companion.getInstance(this.project).getVirtualFileUrlManager();
        EntitySource source = LegacyBridgeJpsArtifactEntitySourceFactory.Companion.getInstance(this.project).createEntitySourceForArtifact(externalSource);
        PackagingElementEntity.Builder builder = rootElement.getOrAddEntityBuilder(this.diff, source, this.project);
        Intrinsics.checkNotNull((Object)builder, (String)"null cannot be cast to non-null type com.intellij.java.workspace.entities.CompositePackagingElementEntity.Builder<out com.intellij.java.workspace.entities.CompositePackagingElementEntity>");
        CompositePackagingElementEntity.Builder rootElementEntity = (CompositePackagingElementEntity.Builder)builder;
        BridgeUtilsKt.forThisAndFullTree((PackagingElement)rootElement, arg_0 -> ArtifactModifiableModelBridge.addArtifact$lambda$0$0(this, arg_0));
        String string = outputPath;
        if (string != null) {
            String it = string;
            boolean bl4 = false;
            String string2 = VfsUtilCore.pathToUrl((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathToUrl(...)");
            virtualFileUrl = fileManager.getOrCreateFromUrl(string2);
        } else {
            virtualFileUrl = null;
        }
        VirtualFileUrl outputUrl = virtualFileUrl;
        String string3 = artifactType.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getId(...)");
        ArtifactEntity artifactEntity = (ArtifactEntity)this.diff.addEntity((WorkspaceEntity.Builder)ArtifactEntityModifications.createArtifactEntity((String)uniqueName, (String)string3, (boolean)false, (EntitySource)source, arg_0 -> ArtifactModifiableModelBridge.addArtifact$lambda$0$2(outputUrl, rootElementEntity, arg_0)));
        ArtifactId symbolicId = artifactEntity.getSymbolicId();
        ArtifactBridge modifiableArtifact = new ArtifactBridge(symbolicId, (VersionedEntityStorage)this.versionedOnBuilder, this.project, this.eventDispatcher, null);
        ((Map)this.modifiableToOriginal).put(modifiableArtifact, modifiableArtifact);
        ArtifactManagerBridge.Companion.getMutableArtifactsMap$intellij_java_compiler_impl(this.diff).addMapping((WorkspaceEntity)artifactEntity, (Object)modifiableArtifact);
        ((ArtifactListener)this.eventDispatcher.getMulticaster()).artifactAdded((Artifact)modifiableArtifact);
        return modifiableArtifact;
    }

    private final String generateUniqueName(String baseName) {
        String string = UniqueNameGenerator.generateUniqueName((String)baseName, arg_0 -> ArtifactModifiableModelBridge.generateUniqueName$lambda$1(arg_0 -> ArtifactModifiableModelBridge.generateUniqueName$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateUniqueName(...)");
        return string;
    }

    public void removeArtifact(@NotNull Artifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        ArtifactBridge cfr_ignored_0 = (ArtifactBridge)artifact;
        ArtifactBridge original = (ArtifactBridge)((Object)this.modifiableToOriginal.get((Object)artifact));
        if (original != null) {
            this.modifiableToOriginal.remove((Object)artifact);
            this.diff.removeEntity((WorkspaceEntity)BridgeUtilsKt.get((EntityStorage)this.diff, new ArtifactId(((ArtifactBridge)artifact).getName())));
            ((ArtifactListener)this.eventDispatcher.getMulticaster()).artifactRemoved((Artifact)original);
        } else {
            Sequence entities;
            this.modifiableToOriginal.removeValue((Object)artifact);
            Sequence $this$forEach$iv = entities = ArtifactManagerBridge.Companion.getArtifactsMap((EntityStorage)this.diff).getEntities((Object)artifact);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WorkspaceEntity it = (WorkspaceEntity)element$iv;
                boolean bl = false;
                this.diff.removeEntity(it);
            }
            ((ArtifactListener)this.eventDispatcher.getMulticaster()).artifactRemoved(artifact);
        }
    }

    @NotNull
    public ModifiableArtifact getOrCreateModifiableArtifact(@NotNull Artifact artifact) {
        ArtifactBridge existingModifiableArtifact;
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        if (((Map)this.modifiableToOriginal).containsKey((Object)((ArtifactBridge)artifact))) {
            return (ModifiableArtifact)artifact;
        }
        Object object = SequencesKt.singleOrNull((Sequence)ArtifactManagerBridge.Companion.getArtifactsMap((EntityStorage)this.diff).getEntities((Object)artifact));
        ArtifactEntity artifactEntity = object instanceof ArtifactEntity ? (ArtifactEntity)object : null;
        if (artifactEntity == null) {
            throw new IllegalStateException("Artifact doesn't exist".toString());
        }
        ArtifactEntity entity = artifactEntity;
        ArtifactId artifactId = entity.getSymbolicId();
        List list = this.modifiableToOriginal.getKeysByValue((Object)artifact);
        ArtifactBridge artifactBridge = existingModifiableArtifact = list != null ? (ArtifactBridge)((Object)CollectionsKt.singleOrNull((List)list)) : null;
        if (existingModifiableArtifact != null) {
            return existingModifiableArtifact;
        }
        ArtifactBridge modifiableArtifact = new ArtifactBridge(artifactId, (VersionedEntityStorage)this.versionedOnBuilder, this.project, this.eventDispatcher, (ArtifactBridge)artifact);
        ((Map)this.modifiableToOriginal).put(modifiableArtifact, artifact);
        ((ArtifactListener)this.eventDispatcher.getMulticaster()).artifactChanged((Artifact)modifiableArtifact, ((ArtifactBridge)artifact).getName());
        return modifiableArtifact;
    }

    @Nullable
    public Artifact getModifiableCopy(@NotNull Artifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        List list = this.modifiableToOriginal.getKeysByValue((Object)((ArtifactBridge)artifact));
        return (Artifact)(list != null ? (ArtifactBridge)((Object)CollectionsKt.singleOrNull((List)list)) : null);
    }

    public void addListener(@NotNull ArtifactListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(@NotNull ArtifactListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventDispatcher.removeListener((EventListener)listener);
    }

    public boolean isModified() {
        MutableEntityStorage mutableEntityStorage = this.diff;
        Intrinsics.checkNotNull((Object)mutableEntityStorage, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.instrumentation.MutableEntityStorageInstrumentation");
        return ((MutableEntityStorageInstrumentation)mutableEntityStorage).hasChanges();
    }

    @RequiresWriteLock
    public void commit() {
        AtomicLong arg0$iv = commitMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.manager.commit(this);
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    public void dispose() {
        PackagingElement it;
        Iterable $this$forEach$iv;
        Object it2;
        AtomicLong arg0$iv = disposeMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        List artifacts = new ArrayList();
        BidirectionalMap modifiableToOriginalCopy = new BidirectionalMap();
        Map $this$forEach$iv2 = (Map)this.modifiableToOriginal;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl4 = false;
            ArtifactBridge mod = (ArtifactBridge)((Object)entry.getKey());
            ArtifactBridge orig = (ArtifactBridge)((Object)entry.getValue());
            ((Map)modifiableToOriginalCopy).put(mod, orig);
        }
        for (ArtifactBridge artifact : modifiableToOriginalCopy.keySet()) {
            if (!Intrinsics.areEqual((Object)modifiableToOriginalCopy.get((Object)artifact), (Object)((Object)artifact))) continue;
            Intrinsics.checkNotNull((Object)((Object)artifact));
            artifacts.add(artifact);
        }
        ArtifactPointerManager artifactPointerManager = ArtifactPointerManager.getInstance((Project)this.project);
        Intrinsics.checkNotNull((Object)artifactPointerManager, (String)"null cannot be cast to non-null type com.intellij.packaging.impl.artifacts.ArtifactPointerManagerImpl");
        ((ArtifactPointerManagerImpl)artifactPointerManager).disposePointers(artifacts);
        ImmutableEntityStorage current = WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot();
        MutableEntityStorage mutableEntityStorage = this.diff;
        Intrinsics.checkNotNull((Object)mutableEntityStorage, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.instrumentation.MutableEntityStorageInstrumentation");
        List list = (List)((MutableEntityStorageInstrumentation)mutableEntityStorage).collectChanges().get(ArtifactEntity.class);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List changes = list;
        List added = new ArrayList();
        List changed = new ArrayList();
        Iterable $this$forEach$iv3 = changes;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv3) {
            it2 = (EntityChange)element$iv;
            boolean bl5 = false;
            Object object = it2;
            if (object instanceof EntityChange.Removed) continue;
            if (object instanceof EntityChange.Added) {
                Object object2 = ArtifactManagerBridge.Companion.getArtifactsMap((EntityStorage)this.diff).getDataByEntity(((EntityChange.Added)it2).getNewEntity());
                Intrinsics.checkNotNull((Object)object2);
                ArtifactBridge artifactBridge = (ArtifactBridge)((Object)object2);
                added.add(artifactBridge);
                continue;
            }
            if (object instanceof EntityChange.Replaced) {
                Object object3 = ArtifactManagerBridge.Companion.getArtifactsMap((EntityStorage)this.diff).getDataByEntity(((EntityChange.Replaced)it2).getNewEntity());
                Intrinsics.checkNotNull((Object)object3);
                ArtifactBridge originalArtifact = (ArtifactBridge)((Object)object3);
                List list2 = modifiableToOriginalCopy.getKeysByValue((Object)originalArtifact);
                Intrinsics.checkNotNull((Object)list2);
                ArtifactBridge modifiableArtifact = (ArtifactBridge)((Object)CollectionsKt.single((List)list2));
                modifiableToOriginalCopy.remove((Object)modifiableArtifact, (Object)originalArtifact);
                Intrinsics.checkNotNull((Object)((Object)modifiableArtifact));
                changed.add(modifiableArtifact);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        Set set = modifiableToOriginalCopy.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-entries>(...)");
        $this$forEach$iv3 = set;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv3) {
            ArtifactBridge original;
            it2 = (Map.Entry)element$iv;
            boolean bl6 = false;
            Intrinsics.checkNotNull((Object)it2);
            ArtifactBridge modifiable = (ArtifactBridge)((Object)it2.getKey());
            if (modifiable == (original = (ArtifactBridge)((Object)it2.getValue()))) continue;
            Intrinsics.checkNotNull((Object)((Object)modifiable));
            changed.add(modifiable);
        }
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this.project);
        Intrinsics.checkNotNull((Object)workspaceModel, (String)"null cannot be cast to non-null type com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal");
        VersionedEntityStorageImpl entityStorage = ((WorkspaceModelInternal)workspaceModel).getEntityStorage();
        Iterable $this$forEach$iv4 = added;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv4) {
            ArtifactBridge bridge = (ArtifactBridge)((Object)element$iv);
            boolean bl7 = false;
            $this$forEach$iv = bridge.getElementsWithDiff();
            boolean $i$f$forEach4 = false;
            for (Object element$iv2 : $this$forEach$iv) {
                it = (PackagingElement)element$iv2;
                boolean bl8 = false;
                it.setStorage((VersionedEntityStorage)entityStorage, this.project, (Set)new HashSet(), (ElementInitializer)PackagingElementInitializer.INSTANCE);
            }
            bridge.getElementsWithDiff().clear();
        }
        $this$forEach$iv4 = changed;
        $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv4) {
            ArtifactBridge bridge = (ArtifactBridge)((Object)element$iv);
            boolean bl9 = false;
            $this$forEach$iv = bridge.getElementsWithDiff();
            boolean $i$f$forEach5 = false;
            for (Object element$iv2 : $this$forEach$iv) {
                it = (PackagingElement)element$iv2;
                boolean bl10 = false;
                it.setStorage((VersionedEntityStorage)entityStorage, this.project, (Set)new HashSet(), (ElementInitializer)PackagingElementInitializer.INSTANCE);
            }
            bridge.getElementsWithDiff().clear();
        }
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    private static final ArtifactBridge getArtifacts$lambda$0$0(ArtifactModifiableModelBridge this$0, List $newBridges, ArtifactEntity artifactEntity) {
        Intrinsics.checkNotNullParameter((Object)artifactEntity, (String)"artifactEntity");
        ArtifactBridge artifactBridge = (ArtifactBridge)((Object)ArtifactManagerBridge.Companion.getArtifactsMap((EntityStorage)this$0.diff).getDataByEntity((WorkspaceEntity)artifactEntity));
        if (artifactBridge == null) {
            ArtifactBridge artifactBridge2;
            ArtifactBridge it = artifactBridge2 = BridgeUtilsKt.createArtifactBridge(artifactEntity, (VersionedEntityStorage)this$0.versionedOnBuilder, this$0.project);
            boolean bl = false;
            $newBridges.add(it);
            this$0.manager.getArtifactWithDiffs$intellij_java_compiler_impl().add(it);
            artifactBridge = artifactBridge2;
        }
        return artifactBridge;
    }

    private static final boolean getArtifacts$lambda$0$1(ArtifactBridge it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return ArtifactManagerBridge.Companion.getVALID_ARTIFACT_CONDITION().value((Object)it);
    }

    private static final ArtifactBridge getArtifacts$lambda$0$2(ArtifactModifiableModelBridge this$0, ArtifactBridge it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Object object = this$0.modifiableToOriginal.getKeysByValue((Object)it);
        if (object == null || (object = (ArtifactBridge)((Object)CollectionsKt.singleOrNull((List)object))) == null) {
            object = it;
        }
        return object;
    }

    private static final boolean getArtifactsByType$lambda$0$0(String $typeId, ArtifactEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getArtifactType(), (Object)$typeId);
    }

    private static final ArtifactBridge getArtifactsByType$lambda$0$1(ArtifactModifiableModelBridge this$0, List $newBridges, ArtifactEntity artifactEntity) {
        Intrinsics.checkNotNullParameter((Object)artifactEntity, (String)"artifactEntity");
        ArtifactBridge artifactBridge = (ArtifactBridge)((Object)ArtifactManagerBridge.Companion.getArtifactsMap((EntityStorage)this$0.diff).getDataByEntity((WorkspaceEntity)artifactEntity));
        if (artifactBridge == null) {
            ArtifactBridge artifactBridge2;
            ArtifactBridge it = artifactBridge2 = BridgeUtilsKt.createArtifactBridge(artifactEntity, (VersionedEntityStorage)this$0.versionedOnBuilder, this$0.project);
            boolean bl = false;
            $newBridges.add(it);
            this$0.manager.getArtifactWithDiffs$intellij_java_compiler_impl().add(it);
            artifactBridge = artifactBridge2;
        }
        return artifactBridge;
    }

    private static final ArtifactBridge getAllArtifactsIncludingInvalid$lambda$0(ArtifactModifiableModelBridge this$0, List $newBridges, ArtifactEntity artifactEntity) {
        Intrinsics.checkNotNullParameter((Object)artifactEntity, (String)"artifactEntity");
        ArtifactBridge artifactBridge = (ArtifactBridge)((Object)ArtifactManagerBridge.Companion.getArtifactsMap((EntityStorage)this$0.diff).getDataByEntity((WorkspaceEntity)artifactEntity));
        if (artifactBridge == null) {
            ArtifactBridge artifactBridge2;
            ArtifactBridge it = artifactBridge2 = BridgeUtilsKt.createArtifactBridge(artifactEntity, (VersionedEntityStorage)this$0.versionedOnBuilder, this$0.project);
            boolean bl = false;
            $newBridges.add(it);
            this$0.manager.getArtifactWithDiffs$intellij_java_compiler_impl().add(it);
            artifactBridge = artifactBridge2;
        }
        return artifactBridge;
    }

    private static final Unit addArtifact$lambda$0$0(ArtifactModifiableModelBridge this$0, PackagingElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!it.hasStorage()) {
            it.setStorage((VersionedEntityStorage)this$0.versionedOnBuilder, this$0.project, this$0.elementsWithDiff, (ElementInitializer)PackagingElementInitializer.INSTANCE);
            ((Collection)this$0.elementsWithDiff).add(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit addArtifact$lambda$0$2(VirtualFileUrl $outputUrl, CompositePackagingElementEntity.Builder $rootElementEntity, ArtifactEntityBuilder $this$ArtifactEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$ArtifactEntity, (String)"$this$ArtifactEntity");
        $this$ArtifactEntity.setOutputUrl($outputUrl);
        $this$ArtifactEntity.setRootElement((CompositePackagingElementEntityBuilder)$rootElementEntity);
        return Unit.INSTANCE;
    }

    private static final boolean generateUniqueName$lambda$0(ArtifactModifiableModelBridge this$0, String it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.findArtifact(it) == null;
    }

    private static final boolean generateUniqueName$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        ArtifactModifiableModelBridge.Companion.setupOpenTelemetryReporting(TelemetryManager.Companion.getMeter(PlatformScopesKt.Compiler));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/packaging/impl/artifacts/workspacemodel/ArtifactModifiableModelBridge$Companion;", "", "<init>", "()V", "getArtifactsMs", "Lcom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer;", "Ljava/util/concurrent/atomic/AtomicLong;", "findArtifactMs", "addArtifactMs", "getArtifactsByTypeMs", "commitMs", "disposeMs", "setupOpenTelemetryReporting", "", "meter", "Lio/opentelemetry/api/metrics/Meter;", "intellij.java.compiler.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void setupOpenTelemetryReporting(Meter meter) {
            ObservableLongMeasurement getArtifactsGauge = meter.gaugeBuilder("compiler.ArtifactModifiableModelBridge.getArtifacts.ms").ofLongs().setDescription("Total time spent in method").buildObserver();
            ObservableLongMeasurement findArtifactsGauge = meter.gaugeBuilder("compiler.ArtifactModifiableModelBridge.findArtifacts.ms").ofLongs().setDescription("Total time spent in method").buildObserver();
            ObservableLongMeasurement addArtifactGauge = meter.gaugeBuilder("compiler.ArtifactModifiableModelBridge.addArtifact.ms").ofLongs().setDescription("Total time spent in method").buildObserver();
            ObservableLongMeasurement getArtifactsByTypeGauge = meter.gaugeBuilder("compiler.ArtifactModifiableModelBridge.getArtifactsByType.ms").ofLongs().setDescription("Total time spent in method").buildObserver();
            ObservableLongMeasurement commitGauge = meter.gaugeBuilder("compiler.ArtifactModifiableModelBridge.commit.ms").ofLongs().setDescription("Total time spent in method").buildObserver();
            ObservableLongMeasurement disposeGauge = meter.gaugeBuilder("compiler.ArtifactModifiableModelBridge.dispose.ms").ofLongs().setDescription("Total time spent in method").buildObserver();
            ObservableMeasurement[] observableMeasurementArray = new ObservableMeasurement[]{findArtifactsGauge, addArtifactGauge, getArtifactsByTypeGauge, commitGauge, disposeGauge};
            meter.batchCallback(() -> Companion.setupOpenTelemetryReporting$lambda$0(getArtifactsGauge, findArtifactsGauge, addArtifactGauge, getArtifactsByTypeGauge, commitGauge, disposeGauge), (ObservableMeasurement)getArtifactsGauge, observableMeasurementArray);
        }

        private static final void setupOpenTelemetryReporting$lambda$0(ObservableLongMeasurement $getArtifactsGauge, ObservableLongMeasurement $findArtifactsGauge, ObservableLongMeasurement $addArtifactGauge, ObservableLongMeasurement $getArtifactsByTypeGauge, ObservableLongMeasurement $commitGauge, ObservableLongMeasurement $disposeGauge) {
            $getArtifactsGauge.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)getArtifactsMs));
            $findArtifactsGauge.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)findArtifactMs));
            $addArtifactGauge.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)addArtifactMs));
            $getArtifactsByTypeGauge.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)getArtifactsByTypeMs));
            $commitGauge.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)commitMs));
            $disposeGauge.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)disposeMs));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

