/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.java.workspace.entities.FileOrDirectoryPackagingElementEntity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Objects;
import kotlin.Unit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

public abstract class FileOrDirectoryCopyPackagingElement<T extends FileOrDirectoryCopyPackagingElement>
extends PackagingElement<T> {
    @NonNls
    public static final String PATH_ATTRIBUTE = "path";
    protected String myFilePath;

    public FileOrDirectoryCopyPackagingElement(PackagingElementType type) {
        super(type);
    }

    protected FileOrDirectoryCopyPackagingElement(PackagingElementType type, String filePath) {
        super(type);
        this.myFilePath = filePath;
    }

    @Nullable
    public VirtualFile findFile() {
        return LocalFileSystem.getInstance().findFileByPath(this.myFilePath);
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            FileOrDirectoryCopyPackagingElement.$$$reportNull$$$0(0);
        }
        return element instanceof FileOrDirectoryCopyPackagingElement && this.getMyFilePath() != null && this.getMyFilePath().equals(((FileOrDirectoryCopyPackagingElement)element).getFilePath());
    }

    @Attribute(value="path")
    public String getFilePath() {
        return this.getMyFilePath();
    }

    public void setFilePath(String filePath) {
        String filePathBefore = this.getMyFilePath();
        this.update(() -> {
            this.myFilePath = filePath;
        }, (builder, entity) -> {
            if (filePathBefore.equals(filePath)) {
                return;
            }
            builder.modifyEntity(FileOrDirectoryPackagingElementEntity.Builder.class, (WorkspaceEntity)entity, ent -> {
                VirtualFileUrlManager manager = WorkspaceModel.getInstance((Project)this.myProject).getVirtualFileUrlManager();
                if (filePath != null) {
                    VirtualFileUrl fileUrl = manager.getOrCreateFromUrl(VfsUtilCore.pathToUrl((String)filePath));
                    ent.setFilePath(fileUrl);
                } else {
                    ent.setFilePath(null);
                }
                return Unit.INSTANCE;
            });
        });
    }

    @NotNull
    public PackagingElementOutputKind getFilesKind(PackagingElementResolvingContext context) {
        VirtualFile file = this.findFile();
        if (file == null) {
            PackagingElementOutputKind packagingElementOutputKind = PackagingElementOutputKind.OTHER;
            if (packagingElementOutputKind == null) {
                FileOrDirectoryCopyPackagingElement.$$$reportNull$$$0(1);
            }
            return packagingElementOutputKind;
        }
        if (file.isDirectory() && file.isInLocalFileSystem()) {
            boolean containsDirectories = false;
            boolean containsJars = false;
            for (VirtualFile child : file.getChildren()) {
                if (child.isDirectory() && child.isInLocalFileSystem()) {
                    containsDirectories = true;
                } else {
                    containsJars |= FileOrDirectoryCopyPackagingElement.isJar(child);
                }
                if (containsDirectories && containsJars) break;
            }
            return new PackagingElementOutputKind(containsDirectories, containsJars);
        }
        PackagingElementOutputKind packagingElementOutputKind = FileOrDirectoryCopyPackagingElement.isJar(file) ? PackagingElementOutputKind.JAR_FILES : PackagingElementOutputKind.OTHER;
        if (packagingElementOutputKind == null) {
            FileOrDirectoryCopyPackagingElement.$$$reportNull$$$0(2);
        }
        return packagingElementOutputKind;
    }

    private static boolean isJar(VirtualFile file) {
        String ext = file.getExtension();
        return ext != null && ext.equalsIgnoreCase("jar");
    }

    protected String getMyFilePath() {
        if (this.myStorage == null) {
            return this.myFilePath;
        }
        FileOrDirectoryPackagingElementEntity entity = (FileOrDirectoryPackagingElementEntity)this.getThisEntity();
        String path = JpsPathUtil.urlToPath((String)entity.getFilePath().getUrl());
        if (!Objects.equals(this.myFilePath, path)) {
            this.myFilePath = path;
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/FileOrDirectoryCopyPackagingElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/FileOrDirectoryCopyPackagingElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEqualTo";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

