/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.java.workspace.entities.LibraryFilesPackagingElementEntity;
import com.intellij.java.workspace.entities.PackagingElementEntity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.elements.PackagingExternalMapping;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.impl.elements.LibraryElementType;
import com.intellij.packaging.impl.ui.LibraryElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kotlin.Unit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryPackagingElement
extends ComplexPackagingElement<LibraryPackagingElement> {
    @NonNls
    public static final String LIBRARY_NAME_ATTRIBUTE = "name";
    @NonNls
    public static final String MODULE_NAME_ATTRIBUTE = "module-name";
    @NonNls
    public static final String LIBRARY_LEVEL_ATTRIBUTE = "level";
    private String myLevel;
    private String myLibraryName;
    private String myModuleName;

    public LibraryPackagingElement() {
        super((PackagingElementType)LibraryElementType.LIBRARY_ELEMENT_TYPE);
    }

    public LibraryPackagingElement(String level, String libraryName, String moduleName) {
        super((PackagingElementType)LibraryElementType.LIBRARY_ELEMENT_TYPE);
        this.myLevel = level;
        this.myLibraryName = libraryName;
        this.myModuleName = moduleName;
    }

    public List<? extends PackagingElement<?>> getSubstitution(@NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType) {
        Library library;
        if (context == null) {
            LibraryPackagingElement.$$$reportNull$$$0(0);
        }
        if (artifactType == null) {
            LibraryPackagingElement.$$$reportNull$$$0(1);
        }
        if ((library = this.findLibrary(context)) != null) {
            VirtualFile[] files = library.getFiles(OrderRootType.CLASSES);
            ArrayList<FileCopyPackagingElement> elements = new ArrayList<FileCopyPackagingElement>();
            for (VirtualFile file : files) {
                String localPath = PathUtil.getLocalPath((VirtualFile)file);
                if (localPath == null) continue;
                String path = FileUtil.toSystemIndependentName((String)localPath);
                elements.add((FileCopyPackagingElement)(file.isDirectory() && file.isInLocalFileSystem() ? new DirectoryCopyPackagingElement(path) : new FileCopyPackagingElement(path)));
            }
            return elements;
        }
        return null;
    }

    @NotNull
    public PackagingElementOutputKind getFilesKind(PackagingElementResolvingContext context) {
        Library library = this.findLibrary(context);
        PackagingElementOutputKind packagingElementOutputKind = library != null ? LibraryPackagingElement.getKindForLibrary(library) : PackagingElementOutputKind.OTHER;
        if (packagingElementOutputKind == null) {
            LibraryPackagingElement.$$$reportNull$$$0(2);
        }
        return packagingElementOutputKind;
    }

    @NotNull
    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            LibraryPackagingElement.$$$reportNull$$$0(3);
        }
        if (this.myStorage == null) {
            return new LibraryElementPresentation(this.myLibraryName, this.myLevel, this.myModuleName, this.findLibrary((PackagingElementResolvingContext)context), context);
        }
        LibraryFilesPackagingElementEntity entity = (LibraryFilesPackagingElementEntity)this.getThisEntity();
        return new LibraryElementPresentation(this.getMyLibraryName(entity), this.getMyLevel(entity), this.getMyModuleName(entity), this.findLibrary((PackagingElementResolvingContext)context), context);
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        String moduleName;
        String libraryName;
        String level;
        if (element == null) {
            LibraryPackagingElement.$$$reportNull$$$0(4);
        }
        if (!(element instanceof LibraryPackagingElement)) {
            return false;
        }
        LibraryPackagingElement packagingElement = (LibraryPackagingElement)element;
        if (this.myStorage == null) {
            level = this.myLevel;
            libraryName = this.myLibraryName;
            moduleName = this.myModuleName;
        } else {
            LibraryFilesPackagingElementEntity entity = (LibraryFilesPackagingElementEntity)this.getThisEntity();
            level = this.getMyLevel(entity);
            libraryName = this.getMyLibraryName(entity);
            moduleName = this.getMyModuleName(entity);
        }
        return level != null && libraryName != null && level.equals(packagingElement.getLevel()) && libraryName.equals(packagingElement.getLibraryName()) && Objects.equals(moduleName, packagingElement.getModuleName());
    }

    public LibraryPackagingElement getState() {
        return this;
    }

    public void loadState(@NotNull LibraryPackagingElement state) {
        if (state == null) {
            LibraryPackagingElement.$$$reportNull$$$0(5);
        }
        this.myLevel = state.getLevel();
        this.myLibraryName = state.getLibraryName();
        this.myModuleName = state.getModuleName();
    }

    @Attribute(value="level")
    public String getLevel() {
        return this.myStorage == null ? this.myLevel : this.getMyLevel((LibraryFilesPackagingElementEntity)this.getThisEntity());
    }

    public void setLevel(String level) {
        String levelBefore = this.getLevel();
        this.update(() -> {
            this.myLevel = level;
        }, (builder, entity) -> {
            if (levelBefore.equals(level)) {
                return;
            }
            builder.modifyEntity(LibraryFilesPackagingElementEntity.Builder.class, (WorkspaceEntity)entity, ent -> {
                LibraryId libraryId = ent.getLibrary();
                if (libraryId != null) {
                    LibraryTableId.ProjectLibraryTableId newTableId;
                    if ("project".equals(level)) {
                        newTableId = LibraryTableId.ProjectLibraryTableId.INSTANCE;
                    } else {
                        if ("module".equals(level)) {
                            throw new RuntimeException("Cannot set module level without module name");
                        }
                        newTableId = new LibraryTableId.GlobalLibraryTableId(level);
                    }
                    ent.setLibrary(libraryId.copy(libraryId.getName(), (LibraryTableId)newTableId));
                }
                return Unit.INSTANCE;
            });
        });
    }

    @Attribute(value="name")
    public String getLibraryName() {
        return this.myStorage == null ? this.myLibraryName : this.getMyLibraryName((LibraryFilesPackagingElementEntity)this.getThisEntity());
    }

    public void setLibraryName(String libraryName) {
        this.update(() -> {
            this.myLibraryName = libraryName;
        }, (builder, entity) -> builder.modifyEntity(LibraryFilesPackagingElementEntity.Builder.class, (WorkspaceEntity)entity, ent -> {
            LibraryId libraryId = ent.getLibrary();
            if (libraryId != null) {
                ent.setLibrary(libraryId.copy(libraryName, libraryId.getTableId()));
            }
            return Unit.INSTANCE;
        }));
    }

    @Attribute(value="module-name")
    public String getModuleName() {
        return this.myStorage == null ? this.myModuleName : this.getMyModuleName((LibraryFilesPackagingElementEntity)this.getThisEntity());
    }

    public void setModuleName(String moduleName) {
        String moduleNameBefore = this.getModuleName();
        this.update(() -> {
            this.myModuleName = moduleName;
        }, (builder, entity) -> {
            if (Objects.equals(moduleNameBefore, moduleName)) {
                return;
            }
            builder.modifyEntity(LibraryFilesPackagingElementEntity.Builder.class, (WorkspaceEntity)entity, ent -> {
                LibraryId libraryId = ent.getLibrary();
                if (libraryId != null) {
                    LibraryTableId.ModuleLibraryTableId newTableId = new LibraryTableId.ModuleLibraryTableId(new ModuleId(moduleName));
                    ent.setLibrary(libraryId.copy(libraryId.getName(), (LibraryTableId)newTableId));
                }
                return Unit.INSTANCE;
            });
        });
    }

    public String toString() {
        String level = this.myLevel;
        String libraryName = this.myLibraryName;
        String moduleName = this.myModuleName;
        if (this.myStorage != null) {
            LibraryFilesPackagingElementEntity entity = (LibraryFilesPackagingElementEntity)this.getThisEntity();
            level = this.getMyLevel(entity);
            libraryName = this.getMyLibraryName(entity);
            moduleName = this.getMyModuleName(entity);
        }
        return "lib:" + libraryName + "(" + (String)(moduleName != null ? "module " + moduleName : level) + ")";
    }

    public PackagingElementEntity.Builder<? extends PackagingElementEntity> getOrAddEntityBuilder(@NotNull MutableEntityStorage diff, @NotNull EntitySource source, @NotNull Project project) {
        LibraryFilesPackagingElementEntity entity;
        PackagingElementEntity existingEntity;
        if (diff == null) {
            LibraryPackagingElement.$$$reportNull$$$0(6);
        }
        if (source == null) {
            LibraryPackagingElement.$$$reportNull$$$0(7);
        }
        if (project == null) {
            LibraryPackagingElement.$$$reportNull$$$0(8);
        }
        if ((existingEntity = (PackagingElementEntity)this.getExistingEntity(diff)) != null) {
            return this.getBuilder(diff, existingEntity);
        }
        if (this.myLibraryName == null) {
            entity = (LibraryFilesPackagingElementEntity)diff.addEntity((WorkspaceEntity.Builder)LibraryFilesPackagingElementEntity.create((EntitySource)source));
        } else {
            LibraryId id = this.myLevel.equals("module") ? new LibraryId(this.myLibraryName, (LibraryTableId)new LibraryTableId.ModuleLibraryTableId(new ModuleId(this.myModuleName))) : (this.myLevel.equals("project") ? new LibraryId(this.myLibraryName, (LibraryTableId)LibraryTableId.ProjectLibraryTableId.INSTANCE) : new LibraryId(this.myLibraryName, (LibraryTableId)new LibraryTableId.GlobalLibraryTableId(this.myLevel)));
            entity = (LibraryFilesPackagingElementEntity)diff.addEntity((WorkspaceEntity.Builder)LibraryFilesPackagingElementEntity.create((EntitySource)source, o -> {
                o.setLibrary(id);
                return Unit.INSTANCE;
            }));
        }
        diff.getMutableExternalMapping(PackagingExternalMapping.key).addMapping((WorkspaceEntity)entity, (Object)this);
        return this.getBuilder(diff, (PackagingElementEntity)entity);
    }

    @Nullable
    public Library findLibrary(@NotNull PackagingElementResolvingContext context) {
        if (context == null) {
            LibraryPackagingElement.$$$reportNull$$$0(9);
        }
        return this.findLibrary(context.getModulesProvider(), (level, libraryName) -> context.findLibrary(level, libraryName));
    }

    @Nullable
    public Library findLibrary(@NotNull ModulesProvider modulesProvider, @NotNull PackagingElementResolvingContext.LibraryFinder libraryFinder) {
        Module module;
        if (modulesProvider == null) {
            LibraryPackagingElement.$$$reportNull$$$0(10);
        }
        if (libraryFinder == null) {
            LibraryPackagingElement.$$$reportNull$$$0(11);
        }
        String level = this.myLevel;
        String myLibraryName1 = this.myLibraryName;
        String moduleName = this.myModuleName;
        if (this.myStorage != null) {
            LibraryFilesPackagingElementEntity entity = (LibraryFilesPackagingElementEntity)this.getThisEntity();
            level = this.getMyLevel(entity);
            myLibraryName1 = this.getMyLibraryName(entity);
            moduleName = this.getMyModuleName(entity);
        }
        if (moduleName == null && level != null && myLibraryName1 != null) {
            return libraryFinder.find(level, myLibraryName1);
        }
        if (moduleName != null && (module = modulesProvider.getModule(moduleName)) != null) {
            for (OrderEntry entry : modulesProvider.getRootModel(module).getOrderEntries()) {
                String libraryName;
                LibraryOrderEntry libraryEntry;
                if (!(entry instanceof LibraryOrderEntry) || !(libraryEntry = (LibraryOrderEntry)entry).isModuleLevel() || (libraryName = libraryEntry.getLibraryName()) == null || !libraryName.equals(this.myLibraryName)) continue;
                return libraryEntry.getLibrary();
            }
        }
        return null;
    }

    public static PackagingElementOutputKind getKindForLibrary(Library library) {
        boolean containsDirectories = false;
        boolean containsJars = false;
        for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
            if (file.isInLocalFileSystem()) {
                containsDirectories = true;
                continue;
            }
            containsJars = true;
        }
        return new PackagingElementOutputKind(containsDirectories, containsJars);
    }

    @Nullable
    private String getMyLevel(LibraryFilesPackagingElementEntity entity) {
        LibraryId library = entity.getLibrary();
        String level = null;
        if (library != null) {
            level = library.getTableId().getLevel();
            if (!Objects.equals(level, this.myLevel)) {
                this.myLevel = level;
            }
        } else if (this.myLevel != null) {
            this.myLevel = null;
        }
        return level;
    }

    @Nullable
    private String getMyLibraryName(LibraryFilesPackagingElementEntity entity) {
        LibraryId library = entity.getLibrary();
        String libraryName = null;
        if (library != null) {
            libraryName = library.getName();
            if (!Objects.equals(libraryName, this.myLibraryName)) {
                this.myLibraryName = libraryName;
            }
        } else if (this.myLibraryName != null) {
            this.myLibraryName = null;
        }
        return libraryName;
    }

    @Nullable
    private String getMyModuleName(LibraryFilesPackagingElementEntity entity) {
        LibraryId library = entity.getLibrary();
        String moduleName = null;
        if (library != null) {
            LibraryTableId tableId = library.getTableId();
            if (tableId instanceof LibraryTableId.ModuleLibraryTableId) {
                moduleName = ((LibraryTableId.ModuleLibraryTableId)tableId).getModuleId().getName();
                if (!Objects.equals(moduleName, this.myModuleName)) {
                    this.myModuleName = moduleName;
                }
            } else if (this.myModuleName != null) {
                this.myModuleName = null;
            }
        } else if (this.myModuleName != null) {
            this.myModuleName = null;
        }
        return moduleName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/LibraryPackagingElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diff";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/LibraryPackagingElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitution";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEqualTo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrAddEntityBuilder";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findLibrary";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

