/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.run;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.impl.run.ArtifactChooser;
import com.intellij.packaging.impl.run.ArtifactListenerService;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskBase;
import com.intellij.packaging.impl.run.MyArtifactListener;
import com.intellij.platform.backend.workspace.UseNewWorkspaceModelApiKt;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.impl.ProjectTaskManagerImpl;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b&\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u001d\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0017\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J-\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000bH\u0004J\u0017\u0010\"\u001a\u00028\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H$\u00a2\u0006\u0002\u0010#J\u001e\u0010$\u001a\u00020%2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010&\u001a\b\u0012\u0004\u0012\u00020 0'H$R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/packaging/impl/run/BuildArtifactsBeforeRunTaskProviderBase;", "T", "Lcom/intellij/packaging/impl/run/BuildArtifactsBeforeRunTaskBase;", "Lcom/intellij/execution/BeforeRunTaskProvider;", "taskClass", "Ljava/lang/Class;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/Class;Lcom/intellij/openapi/project/Project;)V", "isConfigurable", "", "configureTask", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "task", "(Lcom/intellij/execution/configurations/RunConfiguration;Lcom/intellij/packaging/impl/run/BuildArtifactsBeforeRunTaskBase;)Z", "createTask", "(Lcom/intellij/execution/configurations/RunConfiguration;)Lcom/intellij/packaging/impl/run/BuildArtifactsBeforeRunTaskBase;", "canExecuteTask", "configuration", "executeTask", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "(Lcom/intellij/openapi/actionSystem/DataContext;Lcom/intellij/execution/configurations/RunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;Lcom/intellij/packaging/impl/run/BuildArtifactsBeforeRunTaskBase;)Z", "setBuildArtifactBeforeRunOption", "", "runConfigurationEditorComponent", "Ljavax/swing/JComponent;", "artifact", "Lcom/intellij/packaging/artifacts/Artifact;", "enable", "doCreateTask", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/packaging/impl/run/BuildArtifactsBeforeRunTaskBase;", "createProjectTask", "Lcom/intellij/task/ProjectTask;", "artifacts", "", "intellij.java.compiler.impl"})
@SourceDebugExtension(value={"SMAP\nBuildArtifactsBeforeRunTaskProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildArtifactsBeforeRunTaskProviderBase.kt\ncom/intellij/packaging/impl/run/BuildArtifactsBeforeRunTaskProviderBase\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n30#2,2:199\n1807#3,3:201\n1642#3,10:204\n1915#3:214\n1916#3:216\n1652#3:217\n1#4:215\n1#4:218\n*S KotlinDebug\n*F\n+ 1 BuildArtifactsBeforeRunTaskProviderBase.kt\ncom/intellij/packaging/impl/run/BuildArtifactsBeforeRunTaskProviderBase\n*L\n71#1:199,2\n113#1:201,3\n141#1:204,10\n141#1:214\n141#1:216\n141#1:217\n141#1:215\n*E\n"})
public abstract class BuildArtifactsBeforeRunTaskProviderBase<T extends BuildArtifactsBeforeRunTaskBase<?>>
extends BeforeRunTaskProvider<T> {
    @NotNull
    private final Class<T> taskClass;
    @NotNull
    private final Project project;

    public BuildArtifactsBeforeRunTaskProviderBase(@NotNull Class<T> taskClass, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(taskClass, (String)"taskClass");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.taskClass = taskClass;
        this.project = project;
        if (UseNewWorkspaceModelApiKt.useReactiveWorkspaceModelApi()) {
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<ArtifactListenerService> serviceClass$iv = ArtifactListenerService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ArtifactListenerService artifactListenerService = (ArtifactListenerService)object;
            Key key = this.getId();
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"getId(...)");
            artifactListenerService.start(key);
        } else {
            MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
            Topic topic = ArtifactManager.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            Key key = this.getId();
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"getId(...)");
            messageBusConnection.subscribe(topic, new MyArtifactListener(this.project, key));
        }
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull T task2) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        Artifact[] artifactArray = ArtifactManager.getInstance((Project)this.project).getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)artifactArray, (String)"getArtifacts(...)");
        Artifact[] artifacts = artifactArray;
        HashSet<ArtifactPointer> pointers = new HashSet<ArtifactPointer>();
        if (!(artifacts.length == 0)) {
            ArtifactPointerManager artifactPointerManager = ArtifactPointerManager.getInstance((Project)this.project);
            int n = artifacts.length;
            for (int i = 0; i < n; ++i) {
                Artifact artifact;
                Artifact artifact2 = artifact = artifacts[i];
                Intrinsics.checkNotNull((Object)artifact2);
                pointers.add(artifactPointerManager.createPointer(artifact2));
            }
        }
        pointers.addAll((Collection)((BuildArtifactsBeforeRunTaskBase)((Object)task2)).getArtifactPointers());
        ArtifactChooser chooser = new ArtifactChooser(CollectionsKt.toList((Iterable)pointers));
        chooser.markElements(((BuildArtifactsBeforeRunTaskBase)((Object)task2)).getArtifactPointers());
        chooser.setPreferredSize((Dimension)JBUI.size((int)400, (int)300));
        DialogBuilder builder = new DialogBuilder(this.project);
        builder.setTitle(JavaCompilerBundle.message((String)"build.artifacts.before.run.selector.title", (Object[])new Object[0]));
        builder.setDimensionServiceKey("#BuildArtifactsBeforeRunChooser");
        builder.addOkAction();
        builder.addCancelAction();
        builder.setCenterPanel((JComponent)((Object)chooser));
        builder.setPreferredFocusComponent((JComponent)((Object)chooser));
        if (builder.show() == 0) {
            ((BuildArtifactsBeforeRunTaskBase)((Object)task2)).setArtifactPointers(chooser.getMarkedElements());
            return true;
        }
        return false;
    }

    @Nullable
    public T createTask(@NotNull RunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        return this.project.isDefault() ? null : (T)this.doCreateTask(this.project);
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull T task2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter(task2, (String)"task");
            List<ArtifactPointer> list = ((BuildArtifactsBeforeRunTaskBase)((Object)task2)).getArtifactPointers();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getArtifactPointers(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ArtifactPointer it = (ArtifactPointer)element$iv;
                    boolean bl2 = false;
                    if (!(it.getArtifact() != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull T task2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        ArrayList artifacts = new ArrayList();
        ApplicationManager.getApplication().runReadAction(() -> BuildArtifactsBeforeRunTaskProviderBase.executeTask$lambda$0(task2, artifacts));
        if (this.project.isDisposed()) {
            return false;
        }
        ProjectTask artifactsBuildProjectTask = this.createProjectTask(this.project, artifacts);
        Object sessionId = ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.get((UserDataHolder)env);
        ProjectTaskContext projectTaskContext = new ProjectTaskContext(sessionId, null, false, null, 14, null);
        env.copyUserDataTo((UserDataHolderBase)projectTaskContext);
        ProjectTaskManagerImpl.putBuildOriginator((Project)this.project, ((Object)((Object)this)).getClass());
        Promise resultPromise = ProjectTaskManager.getInstance((Project)this.project).run(projectTaskContext, artifactsBuildProjectTask);
        ProjectTaskManager.Result taskResult = (ProjectTaskManager.Result)ProjectTaskManagerImpl.waitForPromise((Promise)resultPromise);
        return taskResult != null && !taskResult.isAborted() && !taskResult.hasErrors();
    }

    /*
     * WARNING - void declaration
     */
    protected final void setBuildArtifactBeforeRunOption(@NotNull JComponent runConfigurationEditorComponent, @NotNull Artifact artifact, boolean enable) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)runConfigurationEditorComponent, (String)"runConfigurationEditorComponent");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)runConfigurationEditorComponent);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        ConfigurationSettingsEditorWrapper configurationSettingsEditorWrapper = (ConfigurationSettingsEditorWrapper)ConfigurationSettingsEditorWrapper.CONFIGURATION_EDITOR_KEY.getData(dataContext2);
        if (configurationSettingsEditorWrapper == null) {
            return;
        }
        ConfigurationSettingsEditorWrapper editor = configurationSettingsEditorWrapper;
        List list = editor.getStepsBeforeLaunch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStepsBeforeLaunch(...)");
        Iterable iterable = list;
        boolean $i$f$mapNotNull = false;
        void var9_9 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BuildArtifactsBeforeRunTaskBase buildArtifactsBeforeRunTaskBase;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            BeforeRunTask it = (BeforeRunTask)element$iv$iv;
            boolean bl2 = false;
            if (this.taskClass.isInstance(it)) {
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskBase<*>");
                buildArtifactsBeforeRunTaskBase = (BuildArtifactsBeforeRunTaskBase)it;
            } else {
                buildArtifactsBeforeRunTaskBase = null;
            }
            if (buildArtifactsBeforeRunTaskBase == null) continue;
            BuildArtifactsBeforeRunTaskBase it$iv$iv = buildArtifactsBeforeRunTaskBase;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List tasks = (List)destination$iv$iv;
        if (enable && tasks.isEmpty()) {
            T task2 = this.doCreateTask(this.project);
            ((BuildArtifactsBeforeRunTaskBase)((Object)task2)).addArtifact(artifact);
            task2.setEnabled(true);
            editor.addBeforeLaunchStep((BeforeRunTask)task2);
        } else {
            for (BuildArtifactsBeforeRunTaskBase task3 : tasks) {
                if (enable) {
                    task3.addArtifact(artifact);
                    task3.setEnabled(true);
                    continue;
                }
                task3.removeArtifact(artifact);
                if (!task3.getArtifactPointers().isEmpty()) continue;
                task3.setEnabled(false);
            }
        }
    }

    @NotNull
    protected abstract T doCreateTask(@Nullable Project var1);

    @NotNull
    protected abstract ProjectTask createProjectTask(@NotNull Project var1, @NotNull List<? extends Artifact> var2);

    private static final void executeTask$lambda$0(BuildArtifactsBeforeRunTaskBase $task, ArrayList $artifacts) {
        for (ArtifactPointer pointer : $task.getArtifactPointers()) {
            Artifact p0;
            if (pointer.getArtifact() == null) continue;
            boolean bl = false;
            $artifacts.add(p0);
        }
    }
}

