/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task.impl;

import com.intellij.compiler.impl.CompileDriver;
import com.intellij.compiler.impl.CompileScopeUtil;
import com.intellij.compiler.impl.CompositeScope;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.packaging.impl.compiler.ArtifactsCompiler;
import com.intellij.packaging.impl.compiler.ArtifactsWorkspaceSettings;
import com.intellij.task.EmptyCompileScopeBuildTask;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ModuleResourcesBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.TaskRunnerResults;
import com.intellij.task.impl.JpsBuildData;
import com.intellij.tracing.Tracer;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.SimpleMessageBusConnection;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public final class JpsProjectTaskRunner
extends ProjectTaskRunner {
    private static final Logger LOG = Logger.getInstance(JpsProjectTaskRunner.class);
    @ApiStatus.Internal
    public static final Key<JpsBuildData> JPS_BUILD_DATA_KEY = KeyWithDefaultValue.create((String)"jps_build_data", () -> new MyJpsBuildData());
    @ApiStatus.Internal
    public static final Key<Object> EXECUTION_SESSION_ID_KEY = ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY;

    public Promise<ProjectTaskRunner.Result> run(@NotNull Project project, final @NotNull ProjectTaskContext context, ProjectTask ... tasks) {
        if (project == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(1);
        }
        if (tasks == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(2);
        }
        AsyncPromise promise = new AsyncPromise();
        Tracer.Span jpsRunnerStart = Tracer.start((String)"jps runner");
        context.putUserData(JPS_BUILD_DATA_KEY, (Object)new MyJpsBuildData());
        if (context.isCollectionOfGeneratedFilesEnabled()) {
            SimpleMessageBusConnection fileGeneratedTopicConnection = project.getMessageBus().simpleConnect();
            fileGeneratedTopicConnection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusListener(){

                public void fileGenerated(@NotNull String outputRoot, @NotNull String relativePath) {
                    if (outputRoot == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (relativePath == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    context.fileGenerated(outputRoot, relativePath);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputRoot";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "relativePath";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/task/impl/JpsProjectTaskRunner$1";
                    objectArray[2] = "fileGenerated";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            promise.onProcessed(result -> fileGeneratedTopicConnection.disconnect());
        }
        Map<Class<? extends ProjectTask>, List<ProjectTask>> taskMap = JpsProjectTaskRunner.groupBy(Arrays.asList(tasks));
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), (Condition)project.getDisposed(), () -> {
            try (MyNotificationCollector notificationCollector = new MyNotificationCollector(context, (AsyncPromise<ProjectTaskRunner.Result>)promise);){
                JpsProjectTaskRunner.runModulesResourcesBuildTasks(project, context, notificationCollector, taskMap);
                JpsProjectTaskRunner.runModulesBuildTasks(project, context, notificationCollector, taskMap);
                JpsProjectTaskRunner.runFilesBuildTasks(project, notificationCollector, taskMap);
                JpsProjectTaskRunner.runEmptyBuildTask(project, context, notificationCollector, taskMap);
                JpsProjectTaskRunner.runArtifactsBuildTasks(project, context, notificationCollector, taskMap);
            }
        });
        jpsRunnerStart.complete();
        return promise;
    }

    public boolean canRun(@NotNull ProjectTask projectTask) {
        if (projectTask == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(3);
        }
        return projectTask instanceof ModuleBuildTask || projectTask instanceof EmptyCompileScopeBuildTask || projectTask instanceof ProjectModelBuildTask && ((ProjectModelBuildTask)projectTask).getBuildableElement() instanceof Artifact;
    }

    public boolean isFileGeneratedEventsSupported() {
        return true;
    }

    public static Map<Class<? extends ProjectTask>, List<ProjectTask>> groupBy(@NotNull Collection<? extends ProjectTask> tasks) {
        if (tasks == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(4);
        }
        return tasks.stream().collect(Collectors.groupingBy(o -> {
            if (o instanceof ModuleFilesBuildTask) {
                return ModuleFilesBuildTask.class;
            }
            if (o instanceof ModuleResourcesBuildTask) {
                return ModuleResourcesBuildTask.class;
            }
            if (o instanceof ModuleBuildTask) {
                return ModuleBuildTask.class;
            }
            if (o instanceof ProjectModelBuildTask) {
                return ProjectModelBuildTask.class;
            }
            if (o instanceof EmptyCompileScopeBuildTask) {
                return EmptyCompileScopeBuildTask.class;
            }
            return o.getClass();
        }));
    }

    private static void runModulesBuildTasks(@NotNull Project project, @NotNull ProjectTaskContext context, @NotNull MyNotificationCollector notificationCollector, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> tasksMap) {
        Collection buildTasks;
        if (project == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(5);
        }
        if (context == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(6);
        }
        if (notificationCollector == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(7);
        }
        if (tasksMap == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(8);
        }
        if (ContainerUtil.isEmpty((Collection)(buildTasks = (Collection)tasksMap.get(ModuleBuildTask.class)))) {
            return;
        }
        ModulesBuildSettings buildSettings = JpsProjectTaskRunner.assembleModulesBuildSettings(buildTasks);
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        if (buildSettings.isRebuild()) {
            compilerManager.rebuildClean((CompileStatusNotification)new MyCompileStatusNotification(notificationCollector));
        } else {
            CompileScope scope = JpsProjectTaskRunner.createScope(compilerManager, context, buildSettings.modules, buildSettings.includeDependentModules, buildSettings.includeRuntimeDependencies, buildSettings.includeTests);
            if (buildSettings.isIncrementalBuild) {
                compilerManager.make(scope, (CompileStatusNotification)new MyCompileStatusNotification(notificationCollector));
            } else {
                compilerManager.compile(scope, (CompileStatusNotification)new MyCompileStatusNotification(notificationCollector));
            }
        }
    }

    private static void runEmptyBuildTask(@NotNull Project project, @NotNull ProjectTaskContext context, @NotNull MyNotificationCollector notificationCollector, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> tasksMap) {
        Collection buildTasks;
        if (project == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(9);
        }
        if (context == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(10);
        }
        if (notificationCollector == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(11);
        }
        if (tasksMap == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(12);
        }
        if (ContainerUtil.isEmpty((Collection)(buildTasks = (Collection)tasksMap.get(EmptyCompileScopeBuildTask.class)))) {
            return;
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        CompileScope scope = JpsProjectTaskRunner.createScope(compilerManager, context, Collections.emptySet(), false, false, true);
        EmptyCompileScopeBuildTask task2 = (EmptyCompileScopeBuildTask)buildTasks.iterator().next();
        if (task2.isIncrementalBuild()) {
            compilerManager.make(scope, (CompileStatusNotification)new MyCompileStatusNotification(notificationCollector));
        } else {
            compilerManager.compile(scope, (CompileStatusNotification)new MyCompileStatusNotification(notificationCollector));
        }
    }

    private static void runModulesResourcesBuildTasks(@NotNull Project project, @NotNull ProjectTaskContext context, @NotNull MyNotificationCollector notificationCollector, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> tasksMap) {
        Collection buildTasks;
        if (project == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(13);
        }
        if (context == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(14);
        }
        if (notificationCollector == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(15);
        }
        if (tasksMap == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(16);
        }
        if (ContainerUtil.isEmpty((Collection)(buildTasks = (Collection)tasksMap.get(ModuleResourcesBuildTask.class)))) {
            return;
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        ModulesBuildSettings buildSettings = JpsProjectTaskRunner.assembleModulesBuildSettings(buildTasks);
        CompileScope scope = JpsProjectTaskRunner.createScope(compilerManager, context, buildSettings.modules, buildSettings.includeDependentModules, buildSettings.includeRuntimeDependencies, buildSettings.includeTests);
        List moduleNames = ContainerUtil.map(buildSettings.modules, Module::getName);
        CompileScopeUtil.setResourcesScopeForExternalBuild(scope, moduleNames);
        if (buildSettings.isIncrementalBuild) {
            compilerManager.make(scope, (CompileStatusNotification)new MyCompileStatusNotification(notificationCollector));
        } else {
            compilerManager.compile(scope, (CompileStatusNotification)new MyCompileStatusNotification(notificationCollector));
        }
    }

    private static ModulesBuildSettings assembleModulesBuildSettings(Collection<? extends ProjectTask> buildTasks) {
        boolean includeTests;
        SmartList modules = new SmartList();
        SmartList incrementalTasks = new SmartList();
        SmartList excludeDependentTasks = new SmartList();
        SmartList excludeRuntimeTasks = new SmartList();
        SmartList excludeTests = new SmartList();
        for (ProjectTask projectTask : buildTasks) {
            ModuleBuildTask moduleBuildTask = (ModuleBuildTask)projectTask;
            modules.add(moduleBuildTask.getModule());
            if (moduleBuildTask.isIncrementalBuild()) {
                incrementalTasks.add(moduleBuildTask);
            }
            if (!moduleBuildTask.isIncludeDependentModules()) {
                excludeDependentTasks.add(moduleBuildTask);
            }
            if (!moduleBuildTask.isIncludeRuntimeDependencies()) {
                excludeRuntimeTasks.add(moduleBuildTask);
            }
            if (moduleBuildTask.isIncludeTests()) continue;
            excludeTests.add(moduleBuildTask);
        }
        boolean isIncrementalBuild = incrementalTasks.size() == buildTasks.size();
        boolean bl = excludeDependentTasks.size() != buildTasks.size();
        boolean includeRuntimeDependencies = excludeRuntimeTasks.size() != buildTasks.size();
        boolean bl2 = includeTests = excludeTests.size() != buildTasks.size();
        if (!isIncrementalBuild && !incrementalTasks.isEmpty()) {
            JpsProjectTaskRunner.assertModuleBuildSettingsConsistent((Collection<? extends ModuleBuildTask>)incrementalTasks, "will be built ignoring incremental build setting");
        }
        if (bl && !excludeDependentTasks.isEmpty()) {
            JpsProjectTaskRunner.assertModuleBuildSettingsConsistent((Collection<? extends ModuleBuildTask>)excludeDependentTasks, "will be built along with dependent modules");
        }
        if (includeRuntimeDependencies && !excludeRuntimeTasks.isEmpty()) {
            JpsProjectTaskRunner.assertModuleBuildSettingsConsistent((Collection<? extends ModuleBuildTask>)excludeRuntimeTasks, "will be built along with runtime dependencies");
        }
        if (includeTests && !excludeTests.isEmpty()) {
            JpsProjectTaskRunner.assertModuleBuildSettingsConsistent((Collection<? extends ModuleBuildTask>)excludeTests, "will be built along with test classes");
        }
        return new ModulesBuildSettings(isIncrementalBuild, bl, includeRuntimeDependencies, includeTests, (Collection<? extends Module>)modules);
    }

    private static void assertModuleBuildSettingsConsistent(Collection<? extends ModuleBuildTask> moduleBuildTasks, String warnMsg) {
        String moduleNames = StringUtil.join(moduleBuildTasks, task2 -> task2.getModule().getName(), (String)", ");
        LOG.warn("Module" + (moduleBuildTasks.size() > 1 ? "s" : "") + " : '" + moduleNames + "' " + warnMsg);
    }

    private static CompileScope createScope(CompilerManager compilerManager, ProjectTaskContext context, Collection<? extends Module> modules, boolean includeDependentModules, boolean includeRuntimeDependencies, boolean includeTests) {
        RunConfiguration configuration;
        CompositeScope scope;
        CompositeScope compositeScope = scope = !modules.isEmpty() ? compilerManager.createModulesCompileScope(modules.toArray(Module.EMPTY_ARRAY), includeDependentModules, includeRuntimeDependencies, includeTests) : new CompositeScope(CompileScope.EMPTY_ARRAY);
        if (context.isAutoRun()) {
            CompileDriver.setCompilationStartedAutomatically(scope);
        }
        if ((configuration = context.getRunConfiguration()) != null) {
            scope.putUserData(CompilerManager.RUN_CONFIGURATION_KEY, configuration);
            scope.putUserData(CompilerManager.RUN_CONFIGURATION_TYPE_ID_KEY, configuration.getType().getId());
        }
        ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.set((UserDataHolder)scope, context.getSessionId());
        return scope;
    }

    private static void runFilesBuildTasks(@NotNull Project project, @NotNull MyNotificationCollector notificationCollector, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> tasksMap) {
        Collection filesTargets;
        if (project == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(17);
        }
        if (notificationCollector == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(18);
        }
        if (tasksMap == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(19);
        }
        if (!ContainerUtil.isEmpty((Collection)(filesTargets = (Collection)tasksMap.get(ModuleFilesBuildTask.class)))) {
            VirtualFile[] files = (VirtualFile[])filesTargets.stream().flatMap(target -> Stream.of(((ModuleFilesBuildTask)target).getFiles())).toArray(VirtualFile[]::new);
            CompilerManager.getInstance((Project)project).compile(files, (CompileStatusNotification)new MyCompileStatusNotification(notificationCollector));
        }
    }

    private static void runArtifactsBuildTasks(@NotNull Project project, @NotNull ProjectTaskContext context, @NotNull MyNotificationCollector notificationCollector, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> tasksMap) {
        Collection buildTasks;
        if (project == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(20);
        }
        if (context == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(21);
        }
        if (notificationCollector == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(22);
        }
        if (tasksMap == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(23);
        }
        if (!ContainerUtil.isEmpty((Collection)(buildTasks = (Collection)tasksMap.get(ProjectModelBuildTask.class)))) {
            SmartList toMake = new SmartList();
            SmartList toCompile = new SmartList();
            for (ProjectTask buildProjectTask : buildTasks) {
                ProjectModelBuildTask buildTask = (ProjectModelBuildTask)buildProjectTask;
                ProjectModelBuildableElement buildableElement = buildTask.getBuildableElement();
                if (!(buildableElement instanceof Artifact)) continue;
                if (buildTask.isIncrementalBuild()) {
                    toMake.add((Artifact)buildableElement);
                    continue;
                }
                toCompile.add((Artifact)buildableElement);
            }
            JpsProjectTaskRunner.buildArtifacts(project, (List<? extends Artifact>)toMake, context.getSessionId(), notificationCollector, false);
            JpsProjectTaskRunner.buildArtifacts(project, (List<? extends Artifact>)toCompile, context.getSessionId(), notificationCollector, true);
        }
    }

    private static void buildArtifacts(@NotNull Project project, @NotNull List<? extends Artifact> artifacts, @Nullable Object sessionId, @NotNull MyNotificationCollector notificationCollector, boolean forceArtifactBuild) {
        if (project == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(24);
        }
        if (artifacts == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(25);
        }
        if (notificationCollector == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(26);
        }
        if (!artifacts.isEmpty()) {
            CompileScope scope = ArtifactCompileScope.createArtifactsScope(project, artifacts, forceArtifactBuild);
            ArtifactsWorkspaceSettings.getInstance(project).setArtifactsToBuild(artifacts);
            ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.set((UserDataHolder)scope, sessionId);
            CompilerManager.getInstance((Project)project).make(scope, (CompileStatusNotification)new MyCompileStatusNotification(notificationCollector));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTask";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 18: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationCollector";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksMap";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
        }
        objectArray2[1] = "com/intellij/task/impl/JpsProjectTaskRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "groupBy";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "runModulesBuildTasks";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "runEmptyBuildTask";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "runModulesResourcesBuildTasks";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "runFilesBuildTasks";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "runArtifactsBuildTasks";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "buildArtifacts";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyJpsBuildData
    implements JpsBuildData {
        private final List<CompileContext> myContexts = new ArrayList<CompileContext>();

        private MyJpsBuildData() {
        }

        @Override
        @NotNull
        public Set<String> getArtifactsWrittenPaths() {
            Set<String> set2 = this.myContexts.stream().map(ctx -> ArtifactsCompiler.getWrittenPaths(ctx)).filter(Objects::nonNull).flatMap(set -> set.stream()).collect(Collectors.toSet());
            if (set2 == null) {
                MyJpsBuildData.$$$reportNull$$$0(0);
            }
            return set2;
        }

        @Override
        @NotNull
        public List<CompileContext> getFinishedBuildsContexts() {
            List<CompileContext> list = Collections.unmodifiableList(this.myContexts);
            if (list == null) {
                MyJpsBuildData.$$$reportNull$$$0(1);
            }
            return list;
        }

        private void add(@NotNull CompileContext context) {
            if (context == null) {
                MyJpsBuildData.$$$reportNull$$$0(2);
            }
            this.myContexts.add(context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/task/impl/JpsProjectTaskRunner$MyJpsBuildData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArtifactsWrittenPaths";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFinishedBuildsContexts";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/task/impl/JpsProjectTaskRunner$MyJpsBuildData";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private record ModulesBuildSettings(boolean isIncrementalBuild, boolean includeDependentModules, boolean includeRuntimeDependencies, boolean includeTests, Collection<? extends Module> modules) {
        boolean isRebuild() {
            if (!this.isIncrementalBuild && !this.modules.isEmpty()) {
                Module someModule = this.modules.iterator().next();
                Module[] projectModules = ModuleManager.getInstance((Project)someModule.getProject()).getModules();
                return projectModules.length == this.modules.size();
            }
            return false;
        }
    }

    private static final class MyCompileStatusNotification
    implements CompileStatusNotification {
        private final MyNotificationCollector myCollector;
        private final AtomicBoolean finished;
        private final Tracer.Span mySpan;

        private MyCompileStatusNotification(@NotNull MyNotificationCollector collector2) {
            if (collector2 == null) {
                MyCompileStatusNotification.$$$reportNull$$$0(0);
            }
            this.finished = new AtomicBoolean();
            this.mySpan = Tracer.start((String)"jps task");
            this.myCollector = collector2;
            this.myCollector.add(this);
        }

        public void finished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
            if (compileContext == null) {
                MyCompileStatusNotification.$$$reportNull$$$0(1);
            }
            if (this.finished.compareAndSet(false, true)) {
                this.myCollector.appendJpsBuildResult(aborted, errors, compileContext, this);
                this.mySpan.complete();
            } else {
                LOG.debug("Multiple invocation of the same CompileStatusNotification.");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compileContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/task/impl/JpsProjectTaskRunner$MyCompileStatusNotification";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "finished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyNotificationCollector
    implements AutoCloseable {
        private static final ProjectTaskRunner.Result FAILED_AND_ABORTED = new ProjectTaskRunner.Result(){

            public boolean isAborted() {
                return true;
            }

            public boolean hasErrors() {
                return true;
            }
        };
        @NotNull
        private final ProjectTaskContext myContext;
        private final AsyncPromise<ProjectTaskRunner.Result> myPromise;
        private boolean myCollectingStopped;
        private final Set<MyCompileStatusNotification> myNotifications;
        private int myErrors;
        private boolean myAborted;

        private MyNotificationCollector(@NotNull ProjectTaskContext context, @NotNull AsyncPromise<ProjectTaskRunner.Result> promise) {
            if (context == null) {
                MyNotificationCollector.$$$reportNull$$$0(0);
            }
            if (promise == null) {
                MyNotificationCollector.$$$reportNull$$$0(1);
            }
            this.myNotifications = new ReferenceOpenHashSet();
            this.myContext = context;
            this.myPromise = promise;
        }

        @Override
        public synchronized void close() {
            if (!this.myCollectingStopped) {
                this.myCollectingStopped = true;
                this.notifyFinished();
            }
        }

        private void notifyFinished() {
            if (this.myCollectingStopped && this.myNotifications.isEmpty()) {
                this.myPromise.setResult(this.myAborted && this.myErrors > 0 ? FAILED_AND_ABORTED : (this.myAborted ? TaskRunnerResults.ABORTED : (this.myErrors > 0 ? TaskRunnerResults.FAILURE : TaskRunnerResults.SUCCESS)));
            }
        }

        private synchronized void appendJpsBuildResult(boolean aborted, int errors, @NotNull CompileContext compileContext, @NotNull MyCompileStatusNotification notification) {
            boolean notificationRemoved;
            if (compileContext == null) {
                MyNotificationCollector.$$$reportNull$$$0(2);
            }
            if (notification == null) {
                MyNotificationCollector.$$$reportNull$$$0(3);
            }
            if (!(notificationRemoved = this.myNotifications.remove(notification))) {
                LOG.error("Multiple invocation of the same callback");
            }
            this.myErrors += errors;
            if (aborted) {
                this.myAborted = true;
            }
            MyJpsBuildData jpsBuildData = (MyJpsBuildData)JPS_BUILD_DATA_KEY.get((UserDataHolder)this.myContext);
            jpsBuildData.add(compileContext);
            if (notificationRemoved) {
                this.notifyFinished();
            }
        }

        private synchronized void add(@NotNull MyCompileStatusNotification notification) {
            if (notification == null) {
                MyNotificationCollector.$$$reportNull$$$0(4);
            }
            assert (!this.myCollectingStopped);
            if (!this.myNotifications.add(notification)) {
                LOG.error("Do not use the same callback for different JPS invocations");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "promise";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compileContext";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/task/impl/JpsProjectTaskRunner$MyNotificationCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendJpsBuildResult";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

