/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.CachedTreePresentationData;
import com.intellij.ide.util.treeView.CachedTreePresentationNode;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001J\u001c\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\nJ\u0006\u0010\u0012\u001a\u00020\u0001J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001J\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0001J\u0018\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0001H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u0001H\u0002J\u0016\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0014J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u001cJ&\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001c2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0#H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\b\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\tj\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\tj\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0007`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/ide/util/treeView/CachedTreePresentation;", "", "rootPresentation", "Lcom/intellij/ide/util/treeView/CachedTreePresentationData;", "<init>", "(Lcom/intellij/ide/util/treeView/CachedTreePresentationData;)V", "cachedRoot", "Lcom/intellij/ide/util/treeView/CachedTreePresentationNode;", "children", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "cachedNodeByRealNode", "rootLoaded", "", "realRoot", "childrenLoaded", "parent", "getRoot", "isLeaf", "", "node", "isExpanded", "getChildren", "getCachedChildren", "getCachedNode", "setExpanded", "path", "Ljavax/swing/tree/TreePath;", "getExpandedDescendants", "", "model", "Ljavax/swing/tree/TreeModel;", "parentPath", "result", "", "intellij.platform.ide"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCachedTreePresentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachedTreePresentation.kt\ncom/intellij/ide/util/treeView/CachedTreePresentation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,229:1\n1586#2:230\n1661#2,3:231\n*S KotlinDebug\n*F\n+ 1 CachedTreePresentation.kt\ncom/intellij/ide/util/treeView/CachedTreePresentation\n*L\n193#1:230\n193#1:231,3\n*E\n"})
public final class CachedTreePresentation {
    @NotNull
    private final CachedTreePresentationNode cachedRoot;
    @NotNull
    private final HashMap<CachedTreePresentationNode, List<CachedTreePresentationNode>> children;
    @NotNull
    private final HashMap<Object, CachedTreePresentationNode> cachedNodeByRealNode;

    public CachedTreePresentation(@NotNull CachedTreePresentationData rootPresentation) {
        Intrinsics.checkNotNullParameter((Object)rootPresentation, (String)"rootPresentation");
        this.cachedRoot = new CachedTreePresentationNode(rootPresentation);
        this.children = new HashMap();
        this.cachedNodeByRealNode = new HashMap();
    }

    public final void rootLoaded(@NotNull Object realRoot) {
        Intrinsics.checkNotNullParameter((Object)realRoot, (String)"realRoot");
        if (this.cachedRoot.matches(realRoot)) {
            ((Map)this.cachedNodeByRealNode).put(realRoot, this.cachedRoot);
        }
    }

    public final void childrenLoaded(@NotNull Object parent, @NotNull List<? extends Object> children) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        CachedTreePresentationNode cachedTreePresentationNode = this.getCachedNode(parent);
        if (cachedTreePresentationNode == null) {
            return;
        }
        CachedTreePresentationNode cachedParent = cachedTreePresentationNode;
        List<CachedTreePresentationNode> list = this.getCachedChildren(cachedParent);
        if (list == null) {
            return;
        }
        List<CachedTreePresentationNode> cachedChildren = list;
        if (cachedChildren.size() != children.size()) {
            return;
        }
        int n = ((Collection)children).size();
        for (int index = 0; index < n; ++index) {
            Object real;
            CachedTreePresentationNode cached = cachedChildren.get(index);
            if (!cached.matches(real = children.get(index))) continue;
            ((Map)this.cachedNodeByRealNode).put(real, cached);
        }
    }

    @NotNull
    public final Object getRoot() {
        return this.cachedRoot;
    }

    public final boolean isLeaf(@NotNull Object node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        CachedTreePresentationNode cachedTreePresentationNode = this.getCachedNode(node);
        return cachedTreePresentationNode != null ? cachedTreePresentationNode.isLeaf() : false;
    }

    public final boolean isExpanded(@NotNull Object node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        CachedTreePresentationNode cachedTreePresentationNode = this.getCachedNode(node);
        return cachedTreePresentationNode != null ? cachedTreePresentationNode.isExpanded() : false;
    }

    @Nullable
    public final List<Object> getChildren(@NotNull Object parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        List<CachedTreePresentationNode> list = this.getCachedChildren(parent);
        return list != null ? UtilKt.nullize(list) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CachedTreePresentationNode> getCachedChildren(Object parent) {
        void $this$mapTo$iv$iv;
        List<CachedTreePresentationNode> cachedChildren;
        CachedTreePresentationNode cachedTreePresentationNode = this.getCachedNode(parent);
        if (cachedTreePresentationNode == null) {
            return null;
        }
        CachedTreePresentationNode cachedParent = cachedTreePresentationNode;
        List<CachedTreePresentationNode> list = cachedChildren = this.children.get(cachedParent);
        if (list != null) {
            return list;
        }
        Iterable $this$map$iv = cachedParent.getData().getChildren();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CachedTreePresentationData cachedTreePresentationData = (CachedTreePresentationData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CachedTreePresentationNode((CachedTreePresentationData)it));
        }
        List nodeChildren = (List)destination$iv$iv;
        ((Map)this.children).put(cachedParent, nodeChildren);
        return nodeChildren;
    }

    private final CachedTreePresentationNode getCachedNode(Object node) {
        if (node instanceof CachedTreePresentationNode) {
            return (CachedTreePresentationNode)node;
        }
        Object userObject = TreeUtil.getUserObject(node);
        if (userObject instanceof CachedTreePresentationNode) {
            return (CachedTreePresentationNode)userObject;
        }
        return this.cachedNodeByRealNode.get(node);
    }

    public final void setExpanded(@NotNull TreePath path, boolean isExpanded) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = path.getLastPathComponent();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLastPathComponent(...)");
        CachedTreePresentationNode cachedTreePresentationNode = this.getCachedNode(object);
        if (cachedTreePresentationNode == null) {
            return;
        }
        CachedTreePresentationNode cachedNode = cachedTreePresentationNode;
        cachedNode.setExpanded(isExpanded);
    }

    @NotNull
    public final Collection<TreePath> getExpandedDescendants(@NotNull TreeModel model, @NotNull TreePath parent) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        List result2 = new ArrayList();
        this.getExpandedDescendants(model, parent, result2);
        return result2;
    }

    private final void getExpandedDescendants(TreeModel model, TreePath parentPath, List<TreePath> result2) {
        Object parent = parentPath.getLastPathComponent();
        Intrinsics.checkNotNull((Object)parent);
        CachedTreePresentationNode cachedTreePresentationNode = this.getCachedNode(parent);
        if (cachedTreePresentationNode == null) {
            return;
        }
        CachedTreePresentationNode cachedParent = cachedTreePresentationNode;
        if (!cachedParent.isExpanded()) {
            return;
        }
        ((Collection)result2).add(parentPath);
        int childCount = model.getChildCount(parent);
        for (int i = 0; i < childCount; ++i) {
            Object child = model.getChild(parent, i);
            TreePath treePath = parentPath.pathByAddingChild(child);
            Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"pathByAddingChild(...)");
            this.getExpandedDescendants(model, treePath, result2);
        }
    }
}

