/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileChooser {
    private static final Logger LOG = Logger.getInstance(FileChooser.class);

    private FileChooser() {
    }

    public static VirtualFile @NotNull [] chooseFiles(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project, @Nullable VirtualFile toSelect) {
        if (descriptor2 == null) {
            FileChooser.$$$reportNull$$$0(0);
        }
        return FileChooser.chooseFiles(descriptor2, null, project, toSelect);
    }

    public static VirtualFile @NotNull [] chooseFiles(@NotNull FileChooserDescriptor descriptor2, @Nullable Component parent, @Nullable Project project, @Nullable VirtualFile toSelect) {
        if (descriptor2 == null) {
            FileChooser.$$$reportNull$$$0(1);
        }
        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor2, project, parent);
        VirtualFile[] virtualFileArray = chooser.choose(project, toSelect);
        if (virtualFileArray == null) {
            FileChooser.$$$reportNull$$$0(2);
        }
        return virtualFileArray;
    }

    @Nullable
    public static VirtualFile chooseFile(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project, @Nullable VirtualFile toSelect) {
        if (descriptor2 == null) {
            FileChooser.$$$reportNull$$$0(3);
        }
        return FileChooser.chooseFile(descriptor2, null, project, toSelect);
    }

    @Nullable
    public static VirtualFile chooseFile(@NotNull FileChooserDescriptor descriptor2, @Nullable Component parent, @Nullable Project project, @Nullable VirtualFile toSelect) {
        if (descriptor2 == null) {
            FileChooser.$$$reportNull$$$0(4);
        }
        Component parentComponent = parent == null ? KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() : parent;
        LOG.assertTrue(!descriptor2.isChooseMultiple());
        return (VirtualFile)ArrayUtil.getFirstElement((Object[])FileChooser.chooseFiles(descriptor2, parentComponent, project, toSelect));
    }

    public static void chooseFiles(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project, @Nullable VirtualFile toSelect, @NotNull Consumer<? super List<VirtualFile>> callback) {
        if (descriptor2 == null) {
            FileChooser.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            FileChooser.$$$reportNull$$$0(6);
        }
        FileChooser.chooseFiles(descriptor2, project, null, toSelect, callback);
    }

    public static void chooseFiles(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project, @Nullable Component parent, @Nullable VirtualFile toSelect, @NotNull Consumer<? super List<VirtualFile>> callback) {
        if (descriptor2 == null) {
            FileChooser.$$$reportNull$$$0(7);
        }
        if (callback == null) {
            FileChooser.$$$reportNull$$$0(8);
        }
        Component parentComponent = parent == null ? WindowManager.getInstance().suggestParentWindow(project) : parent;
        FileChooserFactory.getInstance().createPathChooser(descriptor2, project, parentComponent).choose(toSelect, callback);
    }

    public static void chooseFile(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project, @Nullable VirtualFile toSelect, @NotNull Consumer<? super VirtualFile> callback) {
        if (descriptor2 == null) {
            FileChooser.$$$reportNull$$$0(9);
        }
        if (callback == null) {
            FileChooser.$$$reportNull$$$0(10);
        }
        FileChooser.chooseFile(descriptor2, project, null, toSelect, callback);
    }

    public static void chooseFile(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project, @Nullable Component parent, @Nullable VirtualFile toSelect, @NotNull Consumer<? super VirtualFile> callback) {
        if (descriptor2 == null) {
            FileChooser.$$$reportNull$$$0(11);
        }
        if (callback == null) {
            FileChooser.$$$reportNull$$$0(12);
        }
        LOG.assertTrue(!descriptor2.isChooseMultiple());
        FileChooser.chooseFiles(descriptor2, project, parent, toSelect, (Consumer<? super List<VirtualFile>>)((Consumer)files -> callback.consume(files.get(0))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/FileChooser";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/FileChooser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "chooseFiles";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "chooseFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static interface FileChooserConsumer
    extends Consumer<List<VirtualFile>> {
        public void cancelled();
    }
}

