/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ContentsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class PanelWithActionsAndCloseButton
extends JPanel
implements UiCompatibleDataProvider,
Disposable {
    protected final ContentManager myContentManager;
    @NonNls
    private final String myHelpId;
    private final boolean myVerticalToolbar;
    private boolean myCloseEnabled;
    private final DefaultActionGroup myToolbarGroup = new DefaultActionGroup();

    public PanelWithActionsAndCloseButton(ContentManager contentManager, @NonNls String helpId) {
        this(contentManager, helpId, true);
    }

    public PanelWithActionsAndCloseButton(ContentManager contentManager, @NonNls String helpId, boolean verticalToolbar) {
        super(new BorderLayout());
        this.myContentManager = contentManager;
        this.myHelpId = helpId;
        this.myVerticalToolbar = verticalToolbar;
        this.myCloseEnabled = true;
        if (this.myContentManager != null) {
            this.myContentManager.addContentManagerListener(new ContentManagerListener(){

                public void contentRemoved(@NotNull ContentManagerEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event.getContent().getComponent() == PanelWithActionsAndCloseButton.this) {
                        Disposer.dispose((Disposable)PanelWithActionsAndCloseButton.this);
                        PanelWithActionsAndCloseButton.this.myContentManager.removeContentManagerListener((ContentManagerListener)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/ui/PanelWithActionsAndCloseButton$1", "contentRemoved"));
                }
            });
        }
    }

    @NonNls
    public String getHelpId() {
        return this.myHelpId;
    }

    protected void disableClose() {
        this.myCloseEnabled = false;
    }

    protected void init() {
        this.addActionsTo(this.myToolbarGroup);
        this.myToolbarGroup.add(new MyCloseAction());
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar toolbar = actionManager.createActionToolbar("FileHistoryViewToolbar", (ActionGroup)this.myToolbarGroup, !this.myVerticalToolbar);
        JComponent centerPanel = this.createCenterPanel();
        toolbar.setTargetComponent(centerPanel);
        for (AnAction action : this.myToolbarGroup.getChildren(actionManager)) {
            action.registerCustomShortcutSet(action.getShortcutSet(), centerPanel);
        }
        this.add((Component)centerPanel, "Center");
        if (this.myVerticalToolbar) {
            this.add((Component)toolbar.getComponent(), "West");
        } else {
            this.add((Component)toolbar.getComponent(), "North");
        }
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            PanelWithActionsAndCloseButton.$$$reportNull$$$0(0);
        }
        sink.set(PlatformCoreDataKeys.HELP_ID, (Object)this.myHelpId);
    }

    protected abstract JComponent createCenterPanel();

    protected void addActionsTo(DefaultActionGroup group) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/openapi/ui/PanelWithActionsAndCloseButton", "uiDataSnapshot"));
    }

    private class MyCloseAction
    extends CloseTabToolbarAction {
        private MyCloseAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyCloseAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            e.getPresentation().setVisible(PanelWithActionsAndCloseButton.this.myCloseEnabled);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyCloseAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Content content;
            if (e == null) {
                MyCloseAction.$$$reportNull$$$0(2);
            }
            if (PanelWithActionsAndCloseButton.this.myContentManager != null && (content = PanelWithActionsAndCloseButton.this.myContentManager.getContent((JComponent)PanelWithActionsAndCloseButton.this)) != null) {
                ContentsUtil.closeContentTab(PanelWithActionsAndCloseButton.this.myContentManager, content);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/PanelWithActionsAndCloseButton$MyCloseAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/PanelWithActionsAndCloseButton$MyCloseAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

