/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.RemoteDesktopService;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.RootPaneContainer;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0012\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u0012\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u0007J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ui/components/ScrollSettings;", "", "<init>", "()V", "isEligibleFor", "", "component", "Ljava/awt/Component;", "isHighPrecisionEnabled", "Lkotlin/Function0;", "isPixelPerfectEnabled", "isDebugEnabled", "isBackgroundFromView", "scrollHeaderOverCornerEnabled", "isHeaderOverCorner", "viewport", "Ljavax/swing/JViewport;", "isNotSupportedYet", "view", "isGapNeededForAnyComponent", "isHorizontalGapNeededOnMac", "isThumbSmallIfOpaque", "isInterpolationEligibleFor", "scrollbar", "Ljavax/swing/JScrollBar;", "intellij.platform.ide"})
public final class ScrollSettings {
    @NotNull
    public static final ScrollSettings INSTANCE = new ScrollSettings();
    @JvmField
    @NotNull
    public static final Function0<Boolean> isHighPrecisionEnabled = Registry.Companion.booleanValueHotSupplier("idea.true.smooth.scrolling.high.precision", true);
    @JvmField
    @NotNull
    public static final Function0<Boolean> isPixelPerfectEnabled = Registry.Companion.booleanValueHotSupplier("idea.true.smooth.scrolling.pixel.perfect", true);
    @JvmField
    @NotNull
    public static final Function0<Boolean> isDebugEnabled = Registry.Companion.booleanValueHotSupplier("idea.true.smooth.scrolling.debug", false);
    @JvmField
    @NotNull
    public static final Function0<Boolean> isBackgroundFromView = Registry.Companion.booleanValueHotSupplier("ide.scroll.background.auto", true);
    @NotNull
    private static final Function0<Boolean> scrollHeaderOverCornerEnabled = Registry.Companion.booleanValueHotSupplier("ide.scroll.layout.header.over.corner", true);
    @JvmField
    @NotNull
    public static final Function0<Boolean> isGapNeededForAnyComponent = Registry.Companion.booleanValueHotSupplier("ide.scroll.align.component", true);
    @JvmField
    @NotNull
    public static final Function0<Boolean> isHorizontalGapNeededOnMac = Registry.Companion.booleanValueHotSupplier("mac.scroll.horizontal.gap", false);
    @JvmField
    @NotNull
    public static final Function0<Boolean> isThumbSmallIfOpaque = Registry.Companion.booleanValueHotSupplier("ide.scroll.thumb.small.if.opaque", false);

    private ScrollSettings() {
    }

    @JvmStatic
    public static final boolean isEligibleFor(@Nullable Component component) {
        if (component == null || !component.isShowing() || !LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            return false;
        }
        Application app = ApplicationManager.getApplication();
        if (app == null || PowerSaveMode.isEnabled() || RemoteDesktopService.isRemoteSession()) {
            return false;
        }
        UISettings settings = UISettings.Companion.getInstanceOrNull();
        return settings != null && settings.getSmoothScrolling();
    }

    @JvmStatic
    public static final boolean isHeaderOverCorner(@Nullable JViewport viewport) {
        JViewport jViewport = viewport;
        return !ScrollSettings.isNotSupportedYet(jViewport != null ? jViewport.getView() : null) && (Boolean)scrollHeaderOverCornerEnabled.invoke() != false;
    }

    @JvmStatic
    public static final boolean isNotSupportedYet(@Nullable Component view) {
        return view instanceof JTable;
    }

    public final boolean isInterpolationEligibleFor(@NotNull JScrollBar scrollbar) {
        Component[] subComponents;
        Component firstComponent;
        Intrinsics.checkNotNullParameter((Object)scrollbar, (String)"scrollbar");
        Window window = (Window)scrollbar.getTopLevelAncestor();
        if (window instanceof JDialog && Intrinsics.areEqual((Object)((JDialog)window).getTitle(), (Object)"Commit Changes")) {
            return false;
        }
        if (!(window instanceof RootPaneContainer)) {
            return true;
        }
        Component[] components = ((RootPaneContainer)((Object)window)).getContentPane().getComponents();
        if (components.length == 1) {
            String string = components[0].getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"DiffWindow", (boolean)false, (int)2, null)) {
                return false;
            }
        }
        if (components.length == 2 && (firstComponent = components[0]) instanceof Container && (subComponents = ((Container)firstComponent).getComponents()).length == 1) {
            String name = subComponents[0].getClass().getName();
            Intrinsics.checkNotNull((Object)name);
            if (StringsKt.contains$default((CharSequence)name, (CharSequence)"DiffWindow", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)name, (CharSequence)"MergeWindow", (boolean)false, (int)2, null)) {
                return false;
            }
        }
        return true;
    }
}

