/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.attach.dialog.items;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.observable.properties.AtomicLazyProperty;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.xdebugger.attach.XAttachPresentationGroup;
import com.intellij.xdebugger.impl.ui.attach.dialog.AttachDialogDebuggersFilter;
import com.intellij.xdebugger.impl.ui.attach.dialog.AttachDialogProcessItem;
import com.intellij.xdebugger.impl.ui.attach.dialog.ProcessPredicate;
import com.intellij.xdebugger.impl.ui.attach.dialog.items.nodes.AttachDialogElementNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0010J\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u0019\u001a\u00020\u00112\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/AttachToProcessElementsFilters;", "", "selectedFilter", "Lcom/intellij/openapi/observable/properties/AtomicLazyProperty;", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/AttachDialogDebuggersFilter;", "<init>", "(Lcom/intellij/openapi/observable/properties/AtomicLazyProperty;)V", "getSelectedFilter", "()Lcom/intellij/openapi/observable/properties/AtomicLazyProperty;", "processPredicates", "", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/ProcessPredicate;", "speedSearch", "Lcom/intellij/ui/speedSearch/SpeedSearch;", "cache", "", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/nodes/AttachDialogElementNode;", "", "matches", "node", "clear", "", "updatePattern", "filterValue", "", "accept", "item", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/AttachDialogProcessItem;", "", "Lcom/intellij/xdebugger/attach/XAttachPresentationGroup;", "intellij.platform.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nAttachToProcessElementsFilters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachToProcessElementsFilters.kt\ncom/intellij/xdebugger/impl/ui/attach/dialog/items/AttachToProcessElementsFilters\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n4253#2,12:56\n1786#3,3:68\n*S KotlinDebug\n*F\n+ 1 AttachToProcessElementsFilters.kt\ncom/intellij/xdebugger/impl/ui/attach/dialog/items/AttachToProcessElementsFilters\n*L\n19#1:56,12\n48#1:68,3\n*E\n"})
public final class AttachToProcessElementsFilters {
    @NotNull
    private final AtomicLazyProperty<AttachDialogDebuggersFilter> selectedFilter;
    @NotNull
    private final List<ProcessPredicate> processPredicates;
    @NotNull
    private final SpeedSearch speedSearch;
    @NotNull
    private final Map<AttachDialogElementNode, Boolean> cache;

    /*
     * WARNING - void declaration
     */
    public AttachToProcessElementsFilters(@NotNull AtomicLazyProperty<AttachDialogDebuggersFilter> selectedFilter) {
        void $this$speedSearch_u24lambda_u240;
        SpeedSearch speedSearch;
        List list;
        AnAction[] group;
        Intrinsics.checkNotNullParameter(selectedFilter, (String)"selectedFilter");
        this.selectedFilter = selectedFilter;
        AttachToProcessElementsFilters attachToProcessElementsFilters = this;
        AttachToProcessElementsFilters attachToProcessElementsFilters2 = this;
        boolean bl = false;
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction("XDebugger.Attach.Dialog.Settings");
        AnAction[] anActionArray = group = anAction instanceof DefaultActionGroup ? (AnAction[])anAction : null;
        if (group != null && (anActionArray = anActionArray.getChildren(actionManager)) != null) {
            void $this$filterIsInstanceTo$iv$iv;
            AnAction[] $this$filterIsInstance$iv = anActionArray;
            boolean $i$f$filterIsInstance = false;
            AnAction[] anActionArray2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ProcessPredicate)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        attachToProcessElementsFilters2.processPredicates = list;
        SpeedSearch $this$processPredicates_u24lambda_u240 = speedSearch = new SpeedSearch();
        attachToProcessElementsFilters2 = this;
        boolean bl2 = false;
        $this$speedSearch_u24lambda_u240.updatePattern("");
        attachToProcessElementsFilters2.speedSearch = speedSearch;
        this.cache = new LinkedHashMap();
    }

    @NotNull
    public final AtomicLazyProperty<AttachDialogDebuggersFilter> getSelectedFilter() {
        return this.selectedFilter;
    }

    public final boolean matches(@NotNull AttachDialogElementNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Boolean cachedValue = this.cache.get(node);
        if (cachedValue != null) {
            return cachedValue;
        }
        boolean result2 = node.visit(this);
        this.cache.put(node, result2);
        return result2;
    }

    public final void clear() {
        this.cache.clear();
    }

    public final void updatePattern(@NotNull String filterValue) {
        Intrinsics.checkNotNullParameter((Object)filterValue, (String)"filterValue");
        this.speedSearch.updatePattern(filterValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean accept(@NotNull AttachDialogProcessItem item) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (!this.accept(item.getGroups())) return false;
        Iterable $this$all$iv = this.processPredicates;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                ProcessPredicate it = (ProcessPredicate)element$iv;
                boolean bl2 = false;
                if (((Predicate)it.get()).test(item.getProcessInfo())) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        if (this.speedSearch.shouldBeShowing(item.getIndexedString())) return true;
        CharSequence charSequence = item.getCommandLineText();
        String string = this.speedSearch.getFilter();
        if (string == null) {
            string = "";
        }
        if (!StringsKt.contains((CharSequence)charSequence, (CharSequence)string, (boolean)true)) return false;
        return true;
    }

    public final boolean accept(@NotNull Set<? extends XAttachPresentationGroup<?>> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        return ((AttachDialogDebuggersFilter)this.selectedFilter.get()).canBeAppliedTo(item);
    }
}

