/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.actions;

import com.intellij.idea.AppMode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.SplitDebuggerMode;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.SplitDebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeSelectedValue;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImplDelegate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000 \u00112\u00020\u00012\u00020\u0002:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH$J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$BackendOnly;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "perform", "node", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "nodeName", "", "update", "isEnabled", "", "Companion", "intellij.platform.debugger.impl"})
public abstract class XDebuggerTreeActionBase
extends AnAction
implements ActionRemoteBehaviorSpecification.BackendOnly {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public void actionPerformed(@NotNull AnActionEvent e) {
        String nodeName;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        XValueNodeImpl node = Companion.getSelectedNode(dataContext);
        if (node != null && (nodeName = node.getName()) != null) {
            this.perform(node, nodeName, e);
        }
    }

    protected abstract void perform(@NotNull XValueNodeImpl var1, @NotNull String var2, @NotNull AnActionEvent var3);

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        XValueNodeImpl node = Companion.getSelectedNode(dataContext);
        e.getPresentation().setEnabled(node != null && this.isEnabled(node, e));
    }

    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return node.getName() != null;
    }

    @JvmStatic
    @NotNull
    public static final List<XValueNodeImpl> getSelectedNodes(@NotNull DataContext dataContext) {
        return Companion.getSelectedNodes(dataContext);
    }

    @JvmStatic
    @Nullable
    public static final XValueNodeImpl getSelectedNode(@NotNull DataContext dataContext) {
        return Companion.getSelectedNode(dataContext);
    }

    @JvmStatic
    @Nullable
    public static final XValue getSelectedValue(@NotNull DataContext dataContext) {
        return Companion.getSelectedValue(dataContext);
    }

    static {
        Logger logger = Logger.getInstance(XDebuggerTreeActionBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase$Companion;", "", "<init>", "()V", "getSelectedNodes", "", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getSelectedNode", "getSelectedValue", "Lcom/intellij/xdebugger/frame/XValue;", "fetchSelectedValues", "Lcom/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeSelectedValue;", "fetchSelectedNodeValues", "selectedSplitValues", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.debugger.impl"})
    @SourceDebugExtension(value={"SMAP\nXDebuggerTreeActionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XDebuggerTreeActionBase.kt\ncom/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n1642#2,10:141\n1915#2:151\n1916#2:153\n1652#2:154\n1586#2:155\n1661#2,3:156\n777#2:159\n873#2,2:160\n1586#2:162\n1661#2,3:163\n1#3:152\n*S KotlinDebug\n*F\n+ 1 XDebuggerTreeActionBase.kt\ncom/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase$Companion\n*L\n82#1:141,10\n82#1:151\n82#1:153\n82#1:154\n132#1:155\n132#1:156,3\n134#1:159\n134#1:160,2\n135#1:162\n135#1:163,3\n82#1:152\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<XValueNodeImpl> getSelectedNodes(@NotNull DataContext dataContext) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            if (!SplitDebuggerMode.isSplitDebugger()) {
                List list = (List)XDebuggerTree.SELECTED_NODES.getData(dataContext);
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                return list;
            }
            if (SplitDebuggerMode.showSplitWarnings() && AppMode.isRemoteDevHost()) {
                LOG.error("\n          XDebuggerTreeActionBase should not be used in Rem-Dev mode:\n          - for backend only actions use XDebuggerTreeBackendOnlyActionBase\n          - for actions that operate on the frontend use XDebuggerTreeSplitActionBase\n        ");
                return CollectionsKt.emptyList();
            }
            Iterable $this$mapNotNull$iv = this.fetchSelectedValues(dataContext);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                XValueNodeImpl it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                XDebuggerTreeSelectedValue xDebuggerTreeSelectedValue = (XDebuggerTreeSelectedValue)element$iv$iv;
                boolean bl2 = false;
                XValue backendValue = xDebuggerTreeSelectedValue.component1();
                XValueNodeImpl node = xDebuggerTreeSelectedValue.component3();
                if ((node == null ? null : (node.getValueContainer() == backendValue ? node : (XValueNodeImpl)new XValueNodeImplDelegate(node, backendValue){
                    final /* synthetic */ XValue $backendValue;
                    {
                        this.$backendValue = $backendValue;
                        super($node, $backendValue);
                    }

                    public XValue getValueContainer() {
                        return this.$backendValue;
                    }
                })) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        @Nullable
        public final XValueNodeImpl getSelectedNode(@NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            return (XValueNodeImpl)CollectionsKt.firstOrNull(this.getSelectedNodes(dataContext));
        }

        @JvmStatic
        @Nullable
        public final XValue getSelectedValue(@NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            XDebuggerTreeSelectedValue xDebuggerTreeSelectedValue = (XDebuggerTreeSelectedValue)CollectionsKt.firstOrNull(this.fetchSelectedValues(dataContext));
            return xDebuggerTreeSelectedValue != null ? xDebuggerTreeSelectedValue.getXValue() : null;
        }

        private final List<XDebuggerTreeSelectedValue> fetchSelectedValues(DataContext dataContext) {
            List<XDebuggerTreeSelectedValue> splitValues = SplitDebuggerUIUtil.getXDebuggerTreeSelectedBackendValues(dataContext);
            return CollectionsKt.plus((Collection)splitValues, (Iterable)this.fetchSelectedNodeValues(splitValues, dataContext));
        }

        /*
         * WARNING - void declaration
         */
        private final List<XDebuggerTreeSelectedValue> fetchSelectedNodeValues(List<XDebuggerTreeSelectedValue> selectedSplitValues, DataContext dataContext) {
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            XValueNodeImpl it;
            Collection collection;
            void $this$mapTo$iv$iv;
            if (!SplitDebuggerMode.isSplitDebugger()) {
                return CollectionsKt.emptyList();
            }
            List list = (List)XDebuggerTree.SELECTED_NODES.getData(dataContext);
            if (list == null) {
                return CollectionsKt.emptyList();
            }
            List selectedNodes = list;
            Iterable $this$map$iv = selectedSplitValues;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                XDebuggerTreeSelectedValue xDebuggerTreeSelectedValue = (XDebuggerTreeSelectedValue)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((XDebuggerTreeSelectedValue)((Object)it)).getNode());
            }
            List splitValueNodes = (List)destination$iv$iv;
            $this$map$iv = selectedNodes;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (XValueNodeImpl)element$iv$iv;
                boolean bl = false;
                if (!(!splitValueNodes.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (XValueNodeImpl)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Object ValueContainer = it.getValueContainer();
                Intrinsics.checkNotNullExpressionValue(ValueContainer, (String)"getValueContainer(...)");
                collection.add(new XDebuggerTreeSelectedValue((XValue)ValueContainer, it.getName(), it));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

