/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage.persistence;

import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventsSchemePathSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@State(name="EventLogAllowedList", storages={@Storage(value="EventLogAllowedList.xml", roamingType=RoamingType.LOCAL)})
@ApiStatus.Internal
public final class EventLogMetadataSettingsPersistence
implements PersistentStateComponent<Element> {
    private static final String RECORDER_ID = "recorder-id";
    private static final String PATH = "path";
    private static final String CUSTOM_PATH = "custom-path";
    private static final String USE_CUSTOM_PATH = "use-custom-path";
    private static final String OPTIONS = "options";
    private static final String OPTION = "option";
    private static final String OPTION_NAME = "name";
    private static final String OPTION_VALUE = "value";
    private static final String INTERNAL = "internal";
    private static final String BUILD = "build";
    private static final String BUILD_NUMBER = "build-number";
    private final Object optionsLock = new Object();
    private boolean internal = false;
    private final Map<String, EventsSchemePathSettings> recorderToPathSettings = new HashMap<String, EventsSchemePathSettings>();
    private final Map<String, EventLogExternalOptions> options = new HashMap<String, EventLogExternalOptions>();
    private final Map<String, String> recorderToBuildNumber = new HashMap<String, String>();

    public static EventLogMetadataSettingsPersistence getInstance() {
        return (EventLogMetadataSettingsPersistence)ApplicationManager.getApplication().getService(EventLogMetadataSettingsPersistence.class);
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Map<String, String> getOptions(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogMetadataSettingsPersistence.$$$reportNull$$$0(0);
        }
        Object object = this.optionsLock;
        // MONITORENTER : object
        EventLogExternalOptions options = this.options.get(recorderId);
        if (options == null) {
            Map<String, String> map = Collections.emptyMap();
            // MONITOREXIT : object
            if (map != null) return map;
            EventLogMetadataSettingsPersistence.$$$reportNull$$$0(1);
            return map;
        }
        Map<String, String> map = options.getOptions();
        // MONITOREXIT : object
        if (map != null) return map;
        EventLogMetadataSettingsPersistence.$$$reportNull$$$0(2);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOptions(@NotNull String recorderId, Map<String, String> options) {
        if (recorderId == null) {
            EventLogMetadataSettingsPersistence.$$$reportNull$$$0(3);
        }
        Object object = this.optionsLock;
        synchronized (object) {
            if (!this.options.containsKey(recorderId)) {
                this.options.put(recorderId, new EventLogExternalOptions());
            }
            this.options.get(recorderId).putOptions(options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Map<String, String> updateOptions(@NotNull String recorderId, @NotNull @Unmodifiable Map<String, String> newOptions) {
        if (recorderId == null) {
            EventLogMetadataSettingsPersistence.$$$reportNull$$$0(4);
        }
        if (newOptions == null) {
            EventLogMetadataSettingsPersistence.$$$reportNull$$$0(5);
        }
        Object object = this.optionsLock;
        // MONITORENTER : object
        Map<String, String> persistedOptions = this.getOptions(recorderId);
        HashMap<String, String> changedOptions = new HashMap<String, String>();
        Iterator<Map.Entry<String, String>> iterator = newOptions.entrySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.setOptions(recorderId, changedOptions);
                HashMap<String, String> hashMap = changedOptions;
                // MONITOREXIT : object
                if (hashMap != null) return hashMap;
                EventLogMetadataSettingsPersistence.$$$reportNull$$$0(6);
                return hashMap;
            }
            Map.Entry<String, String> newOption = iterator.next();
            String value = persistedOptions.get(newOption.getKey());
            String newValue = newOption.getValue();
            if (newValue == null || StringUtil.equals((CharSequence)value, (CharSequence)newValue)) continue;
            changedOptions.put(newOption.getKey(), newValue);
        }
    }

    @Nullable
    public EventsSchemePathSettings getPathSettings(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogMetadataSettingsPersistence.$$$reportNull$$$0(7);
        }
        return this.recorderToPathSettings.get(recorderId);
    }

    public void setPathSettings(@NotNull String recorderId, @NotNull EventsSchemePathSettings settings) {
        if (recorderId == null) {
            EventLogMetadataSettingsPersistence.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            EventLogMetadataSettingsPersistence.$$$reportNull$$$0(9);
        }
        this.recorderToPathSettings.put(recorderId, settings);
    }

    @Nullable
    public String getBuildNumber(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogMetadataSettingsPersistence.$$$reportNull$$$0(10);
        }
        return this.recorderToBuildNumber.get(recorderId);
    }

    public void setBuildNumber(@NotNull String recorderId, @NotNull String buildNumber) {
        if (recorderId == null) {
            EventLogMetadataSettingsPersistence.$$$reportNull$$$0(11);
        }
        if (buildNumber == null) {
            EventLogMetadataSettingsPersistence.$$$reportNull$$$0(12);
        }
        this.recorderToBuildNumber.put(recorderId, buildNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element element) {
        String recorder;
        Element internalElement;
        if (element == null) {
            EventLogMetadataSettingsPersistence.$$$reportNull$$$0(13);
        }
        this.internal = (internalElement = element.getChild(INTERNAL)) != null && Boolean.parseBoolean(internalElement.getValue());
        this.recorderToBuildNumber.clear();
        for (Element build : element.getChildren(BUILD)) {
            recorder = build.getAttributeValue(RECORDER_ID);
            if (!StringUtil.isNotEmpty((String)recorder)) continue;
            String buildNumber = build.getAttributeValue(BUILD_NUMBER);
            this.recorderToBuildNumber.put(recorder, buildNumber);
        }
        this.recorderToPathSettings.clear();
        for (Element path : element.getChildren(PATH)) {
            String customPath;
            recorder = path.getAttributeValue(RECORDER_ID);
            if (!StringUtil.isNotEmpty((String)recorder) || (customPath = path.getAttributeValue(CUSTOM_PATH)) == null) continue;
            boolean useCustomPath = EventLogMetadataSettingsPersistence.parseUseCustomPath(path);
            this.recorderToPathSettings.put(recorder, new EventsSchemePathSettings(customPath, useCustomPath));
        }
        Object object = this.optionsLock;
        synchronized (object) {
            this.options.clear();
            for (Element options : element.getChildren(OPTIONS)) {
                String recorderId = options.getAttributeValue(RECORDER_ID);
                if (recorderId == null) continue;
                this.options.put(recorderId, new EventLogExternalOptions().deserialize(options));
            }
        }
    }

    private static boolean parseUseCustomPath(@NotNull Element update) {
        if (update == null) {
            EventLogMetadataSettingsPersistence.$$$reportNull$$$0(14);
        }
        try {
            return Boolean.parseBoolean(update.getAttributeValue(USE_CUSTOM_PATH, "false"));
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public Element getState() {
        Element element = new Element("state");
        if (this.internal) {
            Element internalElement = new Element(INTERNAL);
            internalElement.setText(Boolean.toString(this.internal));
            element.addContent(internalElement);
        }
        for (Map.Entry<String, String> entry : this.recorderToBuildNumber.entrySet()) {
            Element build = new Element(BUILD);
            build.setAttribute(RECORDER_ID, entry.getKey());
            build.setAttribute(BUILD_NUMBER, entry.getValue());
            element.addContent(build);
        }
        for (Map.Entry<String, Object> entry : this.recorderToPathSettings.entrySet()) {
            Element path = new Element(PATH);
            path.setAttribute(RECORDER_ID, entry.getKey());
            EventsSchemePathSettings value = (EventsSchemePathSettings)entry.getValue();
            path.setAttribute(CUSTOM_PATH, value.getCustomPath());
            path.setAttribute(USE_CUSTOM_PATH, String.valueOf(value.isUseCustomPath()));
            element.addContent(path);
        }
        for (Map.Entry<String, Object> entry : this.options.entrySet()) {
            Element options = new Element(OPTIONS);
            options.setAttribute(RECORDER_ID, entry.getKey());
            for (Element option : ((EventLogExternalOptions)entry.getValue()).serialize()) {
                options.addContent(option);
            }
            element.addContent(options);
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/storage/persistence/EventLogMetadataSettingsPersistence";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newOptions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildNumber";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/storage/persistence/EventLogMetadataSettingsPersistence";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "updateOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOptions";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setOptions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateOptions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPathSettings";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setPathSettings";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBuildNumber";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setBuildNumber";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseUseCustomPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6 -> new IllegalStateException(string);
        };
    }

    private static class EventLogExternalOptions {
        private final Map<String, String> myOptions = new HashMap<String, String>();

        private EventLogExternalOptions() {
        }

        @NotNull
        public Map<String, String> getOptions() {
            return new HashMap<String, String>(this.myOptions);
        }

        public void putOptions(@NotNull Map<String, String> options) {
            if (options == null) {
                EventLogExternalOptions.$$$reportNull$$$0(0);
            }
            this.myOptions.putAll(options);
        }

        @NotNull
        public List<Element> serialize() {
            ArrayList<Element> result = new ArrayList<Element>();
            for (Map.Entry<String, String> entry : this.myOptions.entrySet()) {
                Element option = new Element(EventLogMetadataSettingsPersistence.OPTION);
                option.setAttribute(EventLogMetadataSettingsPersistence.OPTION_NAME, entry.getKey());
                option.setAttribute(EventLogMetadataSettingsPersistence.OPTION_VALUE, entry.getValue());
                result.add(option);
            }
            ArrayList<Element> arrayList = result;
            if (arrayList == null) {
                EventLogExternalOptions.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        @NotNull
        public EventLogExternalOptions deserialize(@NotNull Element root) {
            if (root == null) {
                EventLogExternalOptions.$$$reportNull$$$0(2);
            }
            this.myOptions.clear();
            for (Element option : root.getChildren(EventLogMetadataSettingsPersistence.OPTION)) {
                String name = option.getAttributeValue(EventLogMetadataSettingsPersistence.OPTION_NAME);
                String value = option.getAttributeValue(EventLogMetadataSettingsPersistence.OPTION_VALUE);
                if (name == null || value == null) continue;
                this.myOptions.put(name, value);
            }
            EventLogExternalOptions eventLogExternalOptions = this;
            if (eventLogExternalOptions == null) {
                EventLogExternalOptions.$$$reportNull$$$0(3);
            }
            return eventLogExternalOptions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = EventLogMetadataSettingsPersistence.OPTIONS;
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/storage/persistence/EventLogMetadataSettingsPersistence$EventLogExternalOptions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/storage/persistence/EventLogMetadataSettingsPersistence$EventLogExternalOptions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "serialize";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "deserialize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "putOptions";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "deserialize";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3 -> new IllegalStateException(string);
            };
        }
    }
}

