/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ref;

import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Ref;
import com.intellij.reference.SoftReference;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ref.GCUtil;
import com.jetbrains.JBR;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@TestOnly
@ApiStatus.Internal
public final class GCWatcher {
    private static final int NO_TIMEOUT = Integer.MAX_VALUE;
    private final ReferenceQueue<Object> myQueue;
    private final Set<Reference<?>> myReferences;
    private boolean generateHeapDump;

    private GCWatcher(@NotNull Collection<?> objects) {
        if (objects == null) {
            GCWatcher.$$$reportNull$$$0(0);
        }
        this.myQueue = new ReferenceQueue();
        this.myReferences = ConcurrentHashMap.newKeySet();
        this.generateHeapDump = true;
        for (Object o : objects) {
            if (o == null) continue;
            this.myReferences.add(new WeakReference<Object>(o, this.myQueue));
        }
    }

    @Contract(pure=true)
    @NotNull
    public static GCWatcher tracking(Object o1) {
        return new GCWatcher(Collections.singletonList(o1));
    }

    @Contract(pure=true)
    @NotNull
    public static GCWatcher tracking(Object o1, Object o2) {
        return GCWatcher.tracking(Arrays.asList(o1, o2));
    }

    @Contract(pure=true)
    @NotNull
    public static GCWatcher tracking(Object o1, Object o2, Object o3) {
        return GCWatcher.tracking(Arrays.asList(o1, o2, o3));
    }

    @Contract(pure=true)
    @NotNull
    public static GCWatcher tracking(Object o1, Object o2, Object o3, Object o4) {
        return GCWatcher.tracking(Arrays.asList(o1, o2, o3, o4));
    }

    @Contract(pure=true)
    @NotNull
    public static GCWatcher tracking(Object o1, Object o2, Object o3, Object o4, Object o5) {
        return GCWatcher.tracking(Arrays.asList(o1, o2, o3, o4, o5));
    }

    @Contract(pure=true)
    @NotNull
    public static GCWatcher tracking(Object ... objects) {
        throw new UnsupportedOperationException("Use .tracking() method with fixed number of arguments instead");
    }

    @Contract(pure=true)
    @NotNull
    public static GCWatcher tracking(@NotNull Collection<?> objects) {
        if (objects == null) {
            GCWatcher.$$$reportNull$$$0(1);
        }
        return new GCWatcher(objects);
    }

    @NotNull
    public static GCWatcher fromClearedRef(@NotNull Ref<?> ref) {
        if (ref == null) {
            GCWatcher.$$$reportNull$$$0(2);
        }
        GCWatcher result = GCWatcher.tracking(ref.get());
        ref.set(null);
        GCWatcher gCWatcher = result;
        if (gCWatcher == null) {
            GCWatcher.$$$reportNull$$$0(3);
        }
        return gCWatcher;
    }

    public void setGenerateHeapDump(boolean generateHeapDump) {
        this.generateHeapDump = generateHeapDump;
    }

    private boolean isEverythingCollected() {
        return ContainerUtil.all(this.myReferences, e -> e.refersTo(null));
    }

    private void removeQueuedObjects() {
        boolean removed;
        while (true) {
            Reference<Object> ref;
            if ((ref = this.myQueue.poll()) == null) {
                return;
            }
            removed = this.myReferences.remove(ref);
            assert (removed);
        }
    }

    public boolean tryCollect(int timeoutMs) {
        return this.tryCollect(new StringBuilder(), timeoutMs, EmptyRunnable.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    private boolean tryCollect(StringBuilder log, long timeoutDeadline, @NotNull Runnable runnable) {
        if (runnable == null) {
            GCWatcher.$$$reportNull$$$0(4);
        }
        if (JBR.isSystemUtilsSupported()) {
            this.tryCollectOnJbr();
        } else {
            void runWhileWaiting;
            this.tryCollectNoJbr(log, timeoutDeadline, (Runnable)runWhileWaiting);
        }
        return this.isEverythingCollected();
    }

    private void tryCollectOnJbr() {
        assert (JBR.isSystemUtilsSupported()) : "JBR system utils are not supported";
        JBR.getSystemUtils().fullGC();
    }

    /*
     * WARNING - void declaration
     */
    private void tryCollectNoJbr(StringBuilder log, long timeoutDeadline, @NotNull Runnable runnable) {
        void runWhileWaiting;
        if (runnable == null) {
            GCWatcher.$$$reportNull$$$0(5);
        }
        LowMemoryWatcher.runWithNotificationsSuppressed(() -> this.lambda$tryCollectNoJbr$2(log, (Runnable)runWhileWaiting, timeoutDeadline));
    }

    @TestOnly
    public void ensureCollected() throws IllegalStateException {
        StringBuilder log = new StringBuilder();
        boolean collected = this.tryCollect(log, Integer.MAX_VALUE, EmptyRunnable.getInstance());
        if (!collected) {
            this.throwISE(log.toString());
        }
    }

    @TestOnly
    public void ensureCollectedWithinTimeout(int timeoutMs) throws IllegalStateException {
        this.ensureCollectedWithinTimeout(timeoutMs, EmptyRunnable.getInstance());
    }

    @TestOnly
    public void ensureCollectedWithinTimeout(int timeoutMs, @NotNull Runnable runWhileWaiting) throws IllegalStateException {
        if (runWhileWaiting == null) {
            GCWatcher.$$$reportNull$$$0(6);
        }
        StringBuilder log = new StringBuilder();
        long startTime = System.currentTimeMillis();
        long timeoutDeadline = startTime + (long)timeoutMs;
        boolean collected = this.tryCollect(log, timeoutMs, runWhileWaiting);
        while (!collected && System.currentTimeMillis() < timeoutDeadline) {
            runWhileWaiting.run();
            TimeoutUtil.sleep((long)10L);
            collected = this.tryCollect(log, timeoutDeadline, runWhileWaiting);
        }
        if (!collected) {
            this.throwISE(log.toString());
        }
    }

    @TestOnly
    public void waitForReferenceQueue() {
        this.ensureCollected();
        this.removeQueuedObjects();
        for (int i = 0; i < 10000 && !this.myReferences.isEmpty(); ++i) {
            LockSupport.parkNanos(1000000L);
            this.removeQueuedObjects();
        }
        if (!this.myReferences.isEmpty()) {
            this.throwISE("Objects were collected, but still not placed to the ReferenceQueue. This might be a bug in the GCWatcher itself.");
        }
    }

    private void throwISE(String log) {
        String message = "Couldn't garbage-collect some objects, they might still be reachable from GC roots: " + String.valueOf(ContainerUtil.mapNotNull(this.myReferences, SoftReference::dereference));
        try {
            if (this.generateHeapDump) {
                Path path = Paths.get(System.getProperty("teamcity.build.tempDir", System.getProperty("java.io.tmpdir")), "GCWatcher.hprof.zip");
                MemoryDumpHelper.captureMemoryDumpZipped((Path)path);
                message = message + "\nMemory snapshot is available at " + String.valueOf(path) + "\n";
                System.out.println("##teamcity[publishArtifacts '" + String.valueOf(path) + "']");
                System.out.println("##teamcity[testMetadata testName='gcwatcher' key='my log' value='" + String.valueOf(path) + "' type='artifact']");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.isEverythingCollected()) {
            message = message + "\nEverything is collected after taking the heap dump.";
        }
        message = message + " Log:\n" + log;
        throw new IllegalStateException(message);
    }

    private /* synthetic */ Object lambda$tryCollectNoJbr$2(StringBuilder log, Runnable runWhileWaiting, long timeoutDeadline) {
        try {
            GCUtil.allocateTonsOfMemory((StringBuilder)log, (Runnable)runWhileWaiting, () -> this.isEverythingCollected() || System.currentTimeMillis() < timeoutDeadline);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ref/GCWatcher";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runWhileWaiting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ref/GCWatcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fromClearedRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tracking";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromClearedRef";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryCollect";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryCollectNoJbr";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "ensureCollectedWithinTimeout";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

