/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff.lst;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diff.comparison.ComparisonManagerImpl;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffRequest;
import com.intellij.openapi.vcs.ex.ExclusionState;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.LocalRange;
import com.intellij.openapi.vcs.ex.MoveChangesLineStatusAction;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.RangeExclusionState;
import com.intellij.openapi.vcs.ex.SimpleLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0011RSTUVWXYZ[\\]^_`abB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JN\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J8\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J.\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0007J(\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u0005H\u0007J \u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020/2\u0006\u0010)\u001a\u00020*2\u0006\u00100\u001a\u00020\u000eH\u0007J(\u00101\u001a\u00020 2\u0006\u0010.\u001a\u00020/2\u0006\u0010)\u001a\u00020*2\u0006\u00102\u001a\u0002032\u0006\u00100\u001a\u00020\u000eH\u0007J-\u00104\u001a\u00070\f\u00a2\u0006\u0002\b52\u0006\u00106\u001a\u00020*2\u0006\u00107\u001a\u00020*2\u0006\u00108\u001a\u00020*2\u0006\u00109\u001a\u00020:H\u0007J\u0010\u0010;\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020=H\u0007J\u0018\u0010>\u001a\u00020*2\u0006\u0010<\u001a\u00020=2\u0006\u00102\u001a\u000203H\u0007J(\u0010?\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010@\u001a\u00020*2\u0006\u0010A\u001a\u00020*2\u0006\u0010,\u001a\u00020\u0005H\u0007J\"\u0010B\u001a\u00020\u000e2\b\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0007J \u0010B\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010E\u001a\u00020FH\u0002J\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020H0\u001b2\u0006\u0010.\u001a\u00020/H\u0007J\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020H0\u001b2\u0006\u0010.\u001a\u00020/H\u0007J\u0016\u0010J\u001a\u00020K2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020M0\u001bH\u0002R\u001a\u0010N\u001a\u0004\u0018\u00010O*\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010Q\u00a8\u0006c"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil;", "", "<init>", "()V", "computeDifferences", "Ljava/lang/Runnable;", "tracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "document1", "Lcom/intellij/openapi/editor/Document;", "document2", "activeChangelistId", "", "allowExcludeChangesFromCommit", "", "textDiffProvider", "Lcom/intellij/diff/tools/util/text/TwosideTextDiffProvider;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "handler", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerDiffHandler;", "handleValidData", "data", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$TrackerData$Valid;", "computeFallbackExclusionState", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "rangeList", "", "Lcom/intellij/openapi/vcs/ex/LocalRange;", "activeChangeListId", "areVCSBoundedActionsDisabled", "installTrackerListener", "", "viewer", "Lcom/intellij/diff/tools/util/base/DiffViewerBase;", "localRequest", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalChangeListDiffRequest;", "createCheckboxToggle", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "line", "", "isExcludedFromCommit", "onClick", "toggleBlockExclusion", "provider", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerActionProvider;", "wasExcludedFromCommit", "toggleLinePartialExclusion", "side", "Lcom/intellij/diff/util/Side;", "getStatusText", "Lorg/jetbrains/annotations/Nls;", "totalCount", "includedIntoCommitCount", "excludedCount", "isContentsEqual", "Lcom/intellij/util/ThreeState;", "shouldShowToggleAreaThumb", "toggleableLineRange", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$ToggleableLineRange;", "getSingleCheckBoxLine", "createToggleAreaThumb", "line1", "line2", "hasIconHighlighters", "project", "Lcom/intellij/openapi/project/Project;", "markupModelEx", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "createTrackerEditorPopupActions", "Lcom/intellij/openapi/actionSystem/AnAction;", "createTrackerShortcutOnlyActions", "getLocalSelectedLines", "Ljava/util/BitSet;", "changes", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerChange;", "partialTracker", "Lcom/intellij/openapi/vcs/ex/PartialLocalLineStatusTracker;", "getPartialTracker", "(Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalChangeListDiffRequest;)Lcom/intellij/openapi/vcs/ex/PartialLocalLineStatusTracker;", "LocalTrackerDiffHandler", "ToggleableLineRange", "LineFragmentData", "TrackerData", "TrackerDiffData", "MyTrackerListener", "MyLineStatusTrackerManagerListener", "CheckboxDiffGutterRenderer", "ToggleAreaThumbRenderer", "MoveSelectedChangesToAnotherChangelistAction", "ExcludeSelectedChangesFromCommitAction", "MySelectedChangesActionBase", "PartiallyExcludeSelectedLinesFromCommitAction", "ExcludeAllCheckboxPanel", "LocalTrackerActionProvider", "SelectedTrackerLine", "LocalTrackerChange", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLocalTrackerDiffUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalTrackerDiffUtil.kt\ncom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,879:1\n1586#2:880\n1661#2,3:881\n1807#2,3:884\n*S KotlinDebug\n*F\n+ 1 LocalTrackerDiffUtil.kt\ncom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil\n*L\n166#1:880\n166#1:881,3\n201#1:884,3\n*E\n"})
public final class LocalTrackerDiffUtil {
    @NotNull
    public static final LocalTrackerDiffUtil INSTANCE = new LocalTrackerDiffUtil();

    private LocalTrackerDiffUtil() {
    }

    @JvmStatic
    @NotNull
    public static final Runnable computeDifferences(@Nullable LineStatusTracker<?> tracker, @NotNull Document document1, @NotNull Document document2, @NotNull String activeChangelistId, boolean allowExcludeChangesFromCommit, @NotNull TwosideTextDiffProvider textDiffProvider, @NotNull ProgressIndicator indicator, @NotNull LocalTrackerDiffHandler handler) {
        Runnable runnable;
        TrackerData data;
        PartialLocalLineStatusTracker partialTracker;
        Intrinsics.checkNotNullParameter((Object)document1, (String)"document1");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document2");
        Intrinsics.checkNotNullParameter((Object)activeChangelistId, (String)"activeChangelistId");
        Intrinsics.checkNotNullParameter((Object)textDiffProvider, (String)"textDiffProvider");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (tracker instanceof SimpleLocalLineStatusTracker) {
            return handler.fallback();
        }
        PartialLocalLineStatusTracker partialLocalLineStatusTracker = partialTracker = tracker instanceof PartialLocalLineStatusTracker ? (PartialLocalLineStatusTracker)tracker : null;
        if (partialTracker == null || !Intrinsics.areEqual((Object)document2, (Object)((PartialLocalLineStatusTracker)tracker).getDocument())) {
            return handler.error();
        }
        indicator.checkCanceled();
        TrackerData trackerData = data = (TrackerData)ActionsKt.runReadAction(() -> LocalTrackerDiffUtil.computeDifferences$lambda$0(partialTracker, tracker, document2, document1));
        if (trackerData instanceof TrackerData.Released) {
            runnable = handler.error();
        } else if (trackerData instanceof TrackerData.Invalid) {
            runnable = Intrinsics.areEqual((Object)CollectionsKt.singleOrNull(((TrackerData.Invalid)data).getAffectedChangelist()), (Object)activeChangelistId) ? (((TrackerData.Invalid)data).isLoading() ? handler.fallbackWithProgress() : handler.fallback()) : handler.retryLater();
        } else if (trackerData instanceof TrackerData.Valid) {
            runnable = INSTANCE.handleValidData((TrackerData.Valid)data, handler, textDiffProvider, indicator, activeChangelistId, allowExcludeChangesFromCommit);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return runnable;
    }

    /*
     * WARNING - void declaration
     */
    private final Runnable handleValidData(TrackerData.Valid data, LocalTrackerDiffHandler handler, TwosideTextDiffProvider textDiffProvider, ProgressIndicator indicator, String activeChangelistId, boolean allowExcludeChangesFromCommit) {
        void $this$mapTo$iv$iv;
        TrackerDiffData diffData = data.getDiffData();
        List<LocalRange> ranges = diffData.getRanges();
        boolean isContentsEqual = ranges.isEmpty();
        CharSequence[] charSequenceArray = new CharSequence[]{diffData.getVcsText(), diffData.getLocalText()};
        CharSequence[] texts = charSequenceArray;
        if (!StringUtil.equals((CharSequence)diffData.getVcsText(), (CharSequence)diffData.getTrackerVcsText())) {
            return handler.error();
        }
        if (textDiffProvider.isHighlightingDisabled()) {
            return handler.done(isContentsEqual, texts, CollectionsKt.emptyList());
        }
        LineOffsets lineOffsets = LineOffsetsUtil.create((CharSequence)diffData.getVcsText());
        Intrinsics.checkNotNullExpressionValue((Object)lineOffsets, (String)"create(...)");
        LineOffsets lineOffsets1 = lineOffsets;
        LineOffsets lineOffsets2 = LineOffsetsUtil.create((CharSequence)diffData.getLocalText());
        Intrinsics.checkNotNullExpressionValue((Object)lineOffsets2, (String)"create(...)");
        LineOffsets lineOffsets22 = lineOffsets2;
        Iterable $this$map$iv = ranges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LocalRange localRange = (LocalRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Range(it.getVcsLine1(), it.getVcsLine2(), it.getLine1(), it.getLine2()));
        }
        List linesRanges = (List)destination$iv$iv;
        boolean areVCSBoundedActionsDisabled = textDiffProvider.noFitnessForParticularPurposePromised();
        List list = textDiffProvider.compare(diffData.getVcsText(), diffData.getLocalText(), linesRanges, indicator);
        Intrinsics.checkNotNull((Object)list);
        List newFragments = list;
        List toggleableLineRanges = new ArrayList();
        RangeExclusionState fallbackExclusionState = this.computeFallbackExclusionState(ranges, activeChangelistId, allowExcludeChangesFromCommit, areVCSBoundedActionsDisabled);
        int n = ((Collection)ranges).size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Collection<ToggleableLineRange> collection;
            LocalRange localRange = ranges.get(i);
            Range lineRange = (Range)linesRanges.get(i);
            RangeExclusionState exclusionState = areVCSBoundedActionsDisabled ? fallbackExclusionState : localRange.getExclusionState();
            LineFragmentData rangesFragmentData = new LineFragmentData(activeChangelistId, localRange.getChangelistId(), exclusionState, localRange.getClientIds());
            if (!areVCSBoundedActionsDisabled && rangesFragmentData.isPartiallyExcluded() && allowExcludeChangesFromCommit) {
                LineFragment fragment;
                Intrinsics.checkNotNullExpressionValue((Object)ComparisonManagerImpl.createLineFragment((int)lineRange.start1, (int)lineRange.end1, (int)lineRange.start2, (int)lineRange.end2, (LineOffsets)lineOffsets1, (LineOffsets)lineOffsets22), (String)"createLineFragment(...)");
                collection = toggleableLineRanges;
                collection.add(new ToggleableLineRange(lineRange, CollectionsKt.listOf((Object)fragment), rangesFragmentData));
                continue;
            }
            collection = newFragments;
            boolean bl = 0 <= i ? i < collection.size() : false;
            if (bl) {
                object = collection.get(i);
            } else {
                int it = i;
                boolean bl2 = false;
                if (_Assertions.ENABLED && !areVCSBoundedActionsDisabled) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                object = CollectionsKt.emptyList();
            }
            List newFragment = (List)object;
            collection = toggleableLineRanges;
            Intrinsics.checkNotNull((Object)newFragment);
            collection.add(new ToggleableLineRange(lineRange, newFragment, rangesFragmentData));
        }
        return handler.done(isContentsEqual, areVCSBoundedActionsDisabled, texts, toggleableLineRanges);
    }

    private final RangeExclusionState computeFallbackExclusionState(List<LocalRange> rangeList, String activeChangeListId, boolean allowExcludeChangesFromCommit, boolean areVCSBoundedActionsDisabled) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = rangeList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LocalRange it = (LocalRange)element$iv;
                    boolean bl2 = false;
                    if (!(LineFragmentData.Companion.isExcluded(it.getChangelistId(), activeChangeListId, it.getExclusionState(), allowExcludeChangesFromCommit) || LineFragmentData.Companion.isPartiallyExcluded(it.getChangelistId(), activeChangeListId, it.getExclusionState()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean isAnyRangeExcluded = bl;
        return areVCSBoundedActionsDisabled && isAnyRangeExcluded ? (RangeExclusionState)RangeExclusionState.Excluded.INSTANCE : (RangeExclusionState)RangeExclusionState.Included.INSTANCE;
    }

    @JvmStatic
    public static final void installTrackerListener(@NotNull DiffViewerBase viewer, @NotNull LocalChangeListDiffRequest localRequest) {
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        Intrinsics.checkNotNullParameter((Object)((Object)localRequest), (String)"localRequest");
        MyTrackerListener trackerListener = new MyTrackerListener(viewer);
        MyLineStatusTrackerManagerListener lstmListener = new MyLineStatusTrackerManagerListener(viewer, localRequest, trackerListener);
        Project project = localRequest.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        LineStatusTrackerManager.Companion.getInstanceImpl(project).addTrackerListener(lstmListener, (Disposable)viewer);
        PartialLocalLineStatusTracker tracker = INSTANCE.getPartialTracker(localRequest);
        if (tracker != null) {
            tracker.addListener(trackerListener, (Disposable)viewer);
        }
    }

    @JvmStatic
    @NotNull
    public static final RangeHighlighter createCheckboxToggle(@NotNull EditorEx editor, int line, boolean isExcludedFromCommit, @NotNull Runnable onClick) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)onClick, (String)"onClick");
        int offset = DiffGutterOperation.lineToOffset((Editor)((Editor)editor), (int)line);
        Icon icon = isExcludedFromCommit ? AllIcons.Diff.GutterCheckBox : AllIcons.Diff.GutterCheckBoxSelected;
        Intrinsics.checkNotNull((Object)icon);
        Icon icon2 = icon;
        RangeHighlighter rangeHighlighter = editor.getMarkupModel().addRangeHighlighter(null, offset, offset, 3000, HighlighterTargetArea.LINES_IN_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        RangeHighlighter checkboxHighlighter = rangeHighlighter;
        String string = DiffBundle.message((String)"action.presentation.diff.include.into.commit.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object message = string;
        KeyboardShortcut shortcut = ActionManager.getInstance().getKeyboardShortcut("Vcs.Diff.IncludeWholeChangedLinesIntoCommit");
        if (shortcut != null) {
            message = (String)message + " (" + KeymapUtil.getShortcutText((Shortcut)((Shortcut)shortcut)) + ")";
        }
        checkboxHighlighter.setGutterIconRenderer((GutterIconRenderer)new CheckboxDiffGutterRenderer(icon2, (String)message, onClick));
        return checkboxHighlighter;
    }

    @JvmStatic
    public static final void toggleBlockExclusion(@NotNull LocalTrackerActionProvider provider, int line, boolean wasExcludedFromCommit) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        PartialLocalLineStatusTracker partialLocalLineStatusTracker = INSTANCE.getPartialTracker(provider.getLocalRequest());
        if (partialLocalLineStatusTracker == null) {
            return;
        }
        PartialLocalLineStatusTracker tracker = partialLocalLineStatusTracker;
        LocalRange localRange = (LocalRange)tracker.getRangeForLine(line);
        if (localRange == null) {
            return;
        }
        LocalRange range = localRange;
        tracker.setExcludedFromCommit((com.intellij.openapi.vcs.ex.Range)range, !wasExcludedFromCommit);
        provider.getViewer().rediff();
    }

    @JvmStatic
    public static final void toggleLinePartialExclusion(@NotNull LocalTrackerActionProvider provider, int line, @NotNull Side side, boolean wasExcludedFromCommit) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        PartialLocalLineStatusTracker partialLocalLineStatusTracker = INSTANCE.getPartialTracker(provider.getLocalRequest());
        if (partialLocalLineStatusTracker == null) {
            return;
        }
        PartialLocalLineStatusTracker tracker = partialLocalLineStatusTracker;
        BitSet lines = new BitSet();
        lines.set(line);
        tracker.setPartiallyExcludedFromCommit(lines, side, !wasExcludedFromCommit);
        provider.getViewer().rediff();
    }

    @JvmStatic
    @NotNull
    public static final String getStatusText(int totalCount, int includedIntoCommitCount, int excludedCount, @NotNull ThreeState isContentsEqual) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)isContentsEqual, (String)"isContentsEqual");
        if (totalCount == 0 && isContentsEqual == ThreeState.NO) {
            String string = DiffBundle.message((String)"diff.all.differences.ignored.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        int actualChanges = totalCount - excludedCount;
        Object[] objectArray2 = new Object[]{totalCount - excludedCount};
        String string = DiffBundle.message((String)"diff.count.differences.status.text", (Object[])objectArray2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object message = string;
        if (includedIntoCommitCount != actualChanges) {
            objectArray = new Object[]{includedIntoCommitCount};
            message = (String)message + DiffBundle.message((String)"diff.included.count.differences.status.text", (Object[])objectArray);
        }
        if (excludedCount > 0) {
            objectArray = new Object[]{excludedCount};
            message = (String)message + " " + DiffBundle.message((String)"diff.inactive.count.differences.status.text", (Object[])objectArray);
        }
        return message;
    }

    @JvmStatic
    public static final boolean shouldShowToggleAreaThumb(@NotNull ToggleableLineRange toggleableLineRange) {
        Intrinsics.checkNotNullParameter((Object)toggleableLineRange, (String)"toggleableLineRange");
        if (toggleableLineRange.getFragmentData().isPartiallyExcluded()) {
            return false;
        }
        BitSet lines1 = new BitSet();
        BitSet lines2 = new BitSet();
        for (LineFragment fragment : toggleableLineRange.getFragments()) {
            lines1.set(fragment.getStartLine1(), fragment.getEndLine1());
            lines2.set(fragment.getStartLine2(), fragment.getEndLine2());
        }
        Range lineRange = toggleableLineRange.getLineRange();
        return lines1.nextClearBit(lineRange.start1) != lineRange.end1 || lines2.nextClearBit(lineRange.start2) != lineRange.end2;
    }

    @JvmStatic
    public static final int getSingleCheckBoxLine(@NotNull ToggleableLineRange toggleableLineRange, @NotNull Side side) {
        Intrinsics.checkNotNullParameter((Object)toggleableLineRange, (String)"toggleableLineRange");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        LineFragment firstFragment = (LineFragment)CollectionsKt.firstOrNull(toggleableLineRange.getFragments());
        if (firstFragment != null) {
            return side.getStartLine(firstFragment);
        }
        Range lineRange = toggleableLineRange.getLineRange();
        return side.select(lineRange.start1, lineRange.start2);
    }

    @JvmStatic
    @NotNull
    public static final RangeHighlighter createToggleAreaThumb(@NotNull EditorEx editor, int line1, int line2, @NotNull Runnable onClick) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)onClick, (String)"onClick");
        TextRange range = DiffUtil.getLinesRange((Document)((Document)editor.getDocument()), (int)line1, (int)line2);
        RangeHighlighter rangeHighlighter = editor.getMarkupModel().addRangeHighlighter(null, range.getStartOffset(), range.getEndOffset(), 5999, HighlighterTargetArea.LINES_IN_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        RangeHighlighter checkboxHighlighter = rangeHighlighter;
        checkboxHighlighter.setLineMarkerRenderer((LineMarkerRenderer)new ToggleAreaThumbRenderer(onClick));
        return checkboxHighlighter;
    }

    @JvmStatic
    public static final boolean hasIconHighlighters(@Nullable Project project, @NotNull EditorEx editor, int line) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        MarkupModelEx markupModelEx = editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        if (INSTANCE.hasIconHighlighters(editor, line, markupModelEx)) {
            return true;
        }
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)((Document)editor.getDocument()), (Project)project, (boolean)false);
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        MarkupModelEx documentModel = (MarkupModelEx)markupModel;
        return INSTANCE.hasIconHighlighters(editor, line, documentModel);
    }

    private final boolean hasIconHighlighters(EditorEx editor, int line, MarkupModelEx markupModelEx) {
        CommonProcessors.FindProcessor<RangeHighlighter> processor2 = new CommonProcessors.FindProcessor<RangeHighlighter>(editor){
            final /* synthetic */ EditorEx $editor;
            {
                this.$editor = $editor;
            }

            protected boolean accept(RangeHighlighter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getGutterIconRenderer() != null && it.getEditorFilter().avaliableIn((Editor)this.$editor);
            }
        };
        DocumentEx documentEx = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        int start2 = document.getLineStartOffset(line);
        int end = document.getLineEndOffset(line);
        markupModelEx.processRangeHighlightersOverlappingWith(start2, end, (Processor)processor2);
        return processor2.isFound();
    }

    @JvmStatic
    @NotNull
    public static final List<AnAction> createTrackerEditorPopupActions(@NotNull LocalTrackerActionProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Object[] objectArray = new DumbAwareAction[]{new MoveSelectedChangesToAnotherChangelistAction(provider), new PartiallyExcludeSelectedLinesFromCommitAction(provider, false), new PartiallyExcludeSelectedLinesFromCommitAction(provider, true)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @JvmStatic
    @NotNull
    public static final List<AnAction> createTrackerShortcutOnlyActions(@NotNull LocalTrackerActionProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        return CollectionsKt.listOf((Object)((Object)new ExcludeSelectedChangesFromCommitAction(provider)));
    }

    private final BitSet getLocalSelectedLines(List<LocalTrackerChange> changes) {
        BitSet selectedLines = new BitSet();
        for (LocalTrackerChange change : changes) {
            int endLine;
            int startLine;
            selectedLines.set(startLine, (startLine = change.getStartLine()) == (endLine = change.getEndLine()) ? startLine + 1 : endLine);
        }
        return selectedLines;
    }

    private final PartialLocalLineStatusTracker getPartialTracker(LocalChangeListDiffRequest $this$partialTracker) {
        LineStatusTracker lineStatusTracker = $this$partialTracker.getLineStatusTracker();
        return lineStatusTracker instanceof PartialLocalLineStatusTracker ? (PartialLocalLineStatusTracker)lineStatusTracker : null;
    }

    private static final TrackerData computeDifferences$lambda$0$0(PartialLocalLineStatusTracker $partialTracker, LineStatusTracker $tracker, Document $document2, Document $document1) {
        TrackerData trackerData;
        if ($partialTracker.isReleased()) {
            return TrackerData.Released.INSTANCE;
        }
        List<String> affectedChangelistIds = $partialTracker.getAffectedChangeListsIds();
        List ranges = $partialTracker.getRanges();
        if (ranges == null) {
            boolean hasPendingUpdate = LineStatusTrackerManager.Companion.getInstanceImpl(((PartialLocalLineStatusTracker)$tracker).getProject()).hasPendingUpdate(((PartialLocalLineStatusTracker)$tracker).getDocument());
            trackerData = new TrackerData.Invalid(affectedChangelistIds, hasPendingUpdate);
        } else {
            CharSequence charSequence = $document2.getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
            CharSequence localText = charSequence;
            CharSequence charSequence2 = $document1.getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getImmutableCharSequence(...)");
            CharSequence vcsText = charSequence2;
            CharSequence charSequence3 = $partialTracker.getVcsDocument().getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence3, (String)"getImmutableCharSequence(...)");
            CharSequence trackerVcsText = charSequence3;
            TrackerDiffData diffData = new TrackerDiffData(ranges, localText, vcsText, trackerVcsText);
            trackerData = new TrackerData.Valid(affectedChangelistIds, diffData);
        }
        return trackerData;
    }

    private static final TrackerData computeDifferences$lambda$0(PartialLocalLineStatusTracker $partialTracker, LineStatusTracker $tracker, Document $document2, Document $document1) {
        return (TrackerData)$partialTracker.readLock(() -> LocalTrackerDiffUtil.computeDifferences$lambda$0$0($partialTracker, $tracker, $document2, $document1));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B&\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\r\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$CheckboxDiffGutterRenderer;", "Lcom/intellij/diff/util/DiffGutterRenderer;", "icon", "Ljavax/swing/Icon;", "tooltip", "", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "onClick", "Ljava/lang/Runnable;", "<init>", "(Ljavax/swing/Icon;Ljava/lang/String;Ljava/lang/Runnable;)V", "getOnClick", "()Ljava/lang/Runnable;", "handleMouseClick", "", "intellij.platform.vcs.impl"})
    private static final class CheckboxDiffGutterRenderer
    extends DiffGutterRenderer {
        @NotNull
        private final Runnable onClick;

        public CheckboxDiffGutterRenderer(@NotNull Icon icon, @Nullable String tooltip, @NotNull Runnable onClick) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)onClick, (String)"onClick");
            super(icon, tooltip);
            this.onClick = onClick;
        }

        @NotNull
        public final Runnable getOnClick() {
            return this.onClick;
        }

        protected void handleMouseClick() {
            this.onClick.run();
        }
    }

    @DirtyUI
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\u0006\u0010\u0019\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$ExcludeAllCheckboxPanel;", "Ljavax/swing/JPanel;", "viewer", "Lcom/intellij/diff/tools/util/base/DiffViewerBase;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/intellij/diff/tools/util/base/DiffViewerBase;Lcom/intellij/openapi/editor/ex/EditorEx;)V", "localRequest", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalChangeListDiffRequest;", "checkbox", "Lcom/intellij/ui/InplaceButton;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "init", "", "allowExcludeChangesFromCommit", "", "doLayout", "getPreferredSize", "Ljava/awt/Dimension;", "updateLayout", "toggleState", "refresh", "intellij.platform.vcs.impl"})
    public static final class ExcludeAllCheckboxPanel
    extends JPanel {
        @NotNull
        private final DiffViewerBase viewer;
        @NotNull
        private final EditorEx editor;
        @Nullable
        private LocalChangeListDiffRequest localRequest;
        @NotNull
        private final InplaceButton checkbox;

        public ExcludeAllCheckboxPanel(@NotNull DiffViewerBase viewer, @NotNull EditorEx editor) {
            Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            super(new BorderLayout());
            this.viewer = viewer;
            this.editor = editor;
            this.checkbox = new InplaceButton(null, AllIcons.Diff.GutterCheckBox, arg_0 -> ExcludeAllCheckboxPanel._init_$lambda$0(this, arg_0));
            this.checkbox.setCursor(Cursor.getPredefinedCursor(12));
            this.checkbox.setVisible(false);
            this.add((Component)this.checkbox, "Center");
            this.editor.getGutterComponentEx().addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ApplicationManager.getApplication().invokeLater(() -> 2.componentResized$lambda$0(this), ModalityState.any());
                }

                private static final void componentResized$lambda$0(ExcludeAllCheckboxPanel this$0) {
                    this$0.updateLayout();
                }
            });
        }

        private final Icon getIcon() {
            PartialLocalLineStatusTracker tracker;
            LocalChangeListDiffRequest localChangeListDiffRequest = this.localRequest;
            PartialLocalLineStatusTracker partialLocalLineStatusTracker = tracker = localChangeListDiffRequest != null ? INSTANCE.getPartialTracker(localChangeListDiffRequest) : null;
            if (tracker == null || !tracker.isValid()) {
                return null;
            }
            LocalChangeListDiffRequest localChangeListDiffRequest2 = this.localRequest;
            Intrinsics.checkNotNull((Object)((Object)localChangeListDiffRequest2));
            String string = localChangeListDiffRequest2.getChangelistId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getChangelistId(...)");
            switch (WhenMappings.$EnumSwitchMapping$0[tracker.getExcludedFromCommitState(string).ordinal()]) {
                case 1: {
                    return AllIcons.Diff.GutterCheckBoxSelected;
                }
                case 2: {
                    return AllIcons.Diff.GutterCheckBox;
                }
                case 3: {
                    return AllIcons.Diff.GutterCheckBoxIndeterminate;
                }
                case 4: {
                    return null;
                }
            }
            return null;
        }

        public final void init(@NotNull LocalChangeListDiffRequest localRequest, boolean allowExcludeChangesFromCommit) {
            Intrinsics.checkNotNullParameter((Object)((Object)localRequest), (String)"localRequest");
            if (allowExcludeChangesFromCommit) {
                this.localRequest = localRequest;
            }
        }

        @Override
        public void doLayout() {
            Dimension size = this.checkbox.getPreferredSize();
            EditorGutterComponentEx editorGutterComponentEx = this.editor.getGutterComponentEx();
            Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"getGutterComponentEx(...)");
            EditorGutterComponentEx gutter = editorGutterComponentEx;
            int gap = this.getHeight() - size.height;
            int y = gap > JBUI.scale((int)8) ? gap - JBUI.scale((int)2) : gap / 2;
            int x = gutter.getIconAreaOffset() + 2;
            this.checkbox.setBounds(Math.min(this.getWidth() - AllIcons.Diff.GutterCheckBox.getIconWidth(), x), Math.max(0, y), size.width, size.height);
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            if (!this.checkbox.isVisible()) {
                return new Dimension();
            }
            Dimension size = this.checkbox.getPreferredSize();
            EditorGutterComponentEx editorGutterComponentEx = this.editor.getGutterComponentEx();
            Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"getGutterComponentEx(...)");
            EditorGutterComponentEx gutter = editorGutterComponentEx;
            int gutterWidth = gutter.getLineMarkerFreePaintersAreaOffset();
            return new Dimension(Math.max(gutterWidth + JBUIScale.scale((int)2), size.width), size.height);
        }

        private final void updateLayout() {
            this.invalidate();
            this.viewer.getComponent().validate();
            this.viewer.getComponent().repaint();
        }

        private final void toggleState() {
            PartialLocalLineStatusTracker tracker;
            LocalChangeListDiffRequest localChangeListDiffRequest = this.localRequest;
            PartialLocalLineStatusTracker partialLocalLineStatusTracker = tracker = localChangeListDiffRequest != null ? INSTANCE.getPartialTracker(localChangeListDiffRequest) : null;
            if (tracker != null && tracker.isValid()) {
                LocalChangeListDiffRequest localChangeListDiffRequest2 = this.localRequest;
                Intrinsics.checkNotNull((Object)((Object)localChangeListDiffRequest2));
                String string = localChangeListDiffRequest2.getChangelistId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getChangelistId(...)");
                ExclusionState exclusionState = tracker.getExcludedFromCommitState(string);
                LocalChangeListDiffRequest localChangeListDiffRequest3 = this.localRequest;
                Intrinsics.checkNotNull((Object)((Object)localChangeListDiffRequest3));
                String string2 = localChangeListDiffRequest3.getChangelistId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getChangelistId(...)");
                tracker.setExcludedFromCommit(string2, exclusionState == ExclusionState.ALL_INCLUDED);
                this.refresh();
                this.viewer.rediff();
            }
        }

        public final void refresh() {
            Icon icon = this.getIcon();
            if (icon != null) {
                this.checkbox.setIcon(icon);
                this.checkbox.setVisible(true);
            } else {
                this.checkbox.setVisible(false);
            }
        }

        private static final void _init_$lambda$0(ExcludeAllCheckboxPanel this$0, ActionEvent it) {
            this$0.toggleState();
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ExclusionState.values().length];
                try {
                    nArray[ExclusionState.ALL_INCLUDED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExclusionState.ALL_EXCLUDED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExclusionState.PARTIALLY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExclusionState.NO_CHANGES.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$ExcludeSelectedChangesFromCommitAction;", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$MySelectedChangesActionBase;", "provider", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerActionProvider;", "<init>", "(Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerActionProvider;)V", "getText", "", "changes", "", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerChange;", "doPerform", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "tracker", "Lcom/intellij/openapi/vcs/ex/PartialLocalLineStatusTracker;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nLocalTrackerDiffUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalTrackerDiffUtil.kt\ncom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$ExcludeSelectedChangesFromCommitAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,879:1\n1807#2,3:880\n1807#2,3:883\n*S KotlinDebug\n*F\n+ 1 LocalTrackerDiffUtil.kt\ncom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$ExcludeSelectedChangesFromCommitAction\n*L\n524#1:880,3\n534#1:883,3\n*E\n"})
    public static final class ExcludeSelectedChangesFromCommitAction
    extends MySelectedChangesActionBase {
        public ExcludeSelectedChangesFromCommitAction(@NotNull LocalTrackerActionProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            super(true, provider);
            ActionUtil.copyFrom((AnAction)((AnAction)this), (String)"Vcs.Diff.IncludeWholeChangedLinesIntoCommit");
        }

        @Override
        @NotNull
        protected String getText(@NotNull List<LocalTrackerChange> changes) {
            String string;
            boolean hasExcluded;
            block5: {
                Intrinsics.checkNotNullParameter(changes, (String)"changes");
                Iterable $this$any$iv = changes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        LocalTrackerChange it = (LocalTrackerChange)element$iv;
                        boolean bl = false;
                        if (!it.getExclusionState().getHasExcluded()) continue;
                        v0 = true;
                        break block5;
                    }
                    v0 = hasExcluded = false;
                }
            }
            if (!((Collection)changes).isEmpty() && !hasExcluded) {
                String string2 = VcsBundle.message((String)"changes.exclude.lines.from.commit", (Object[])new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            } else {
                String string3 = VcsBundle.message((String)"changes.include.lines.into.commit", (Object[])new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            }
            return string;
        }

        @Override
        protected void doPerform(@NotNull AnActionEvent e, @NotNull PartialLocalLineStatusTracker tracker, @NotNull List<LocalTrackerChange> changes) {
            boolean bl;
            BitSet selectedLines;
            block3: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
                Intrinsics.checkNotNullParameter(changes, (String)"changes");
                selectedLines = INSTANCE.getLocalSelectedLines(changes);
                Iterable $this$any$iv = changes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        LocalTrackerChange it = (LocalTrackerChange)element$iv;
                        boolean bl2 = false;
                        if (!it.getExclusionState().getHasExcluded()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            boolean hasExcluded = bl;
            tracker.setExcludedFromCommit(selectedLines, !hasExcluded);
            this.getProvider().getViewer().rediff();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014J\u0006\u0010\u0018\u001a\u00020\u0014J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J7\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001J\u0014\u0010\u001e\u001a\u00020\u00142\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010 \u001a\u00020!H\u00d6\u0081\u0004J\n\u0010\"\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LineFragmentData;", "", "activeChangelistId", "", "changelistId", "exclusionState", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "clientIds", "", "Lcom/intellij/codeWithMe/ClientId;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/vcs/ex/RangeExclusionState;Ljava/util/List;)V", "getActiveChangelistId", "()Ljava/lang/String;", "getChangelistId", "getExclusionState", "()Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "getClientIds", "()Ljava/util/List;", "isFromActiveChangelist", "", "isSkipped", "isExcluded", "allowExcludeChangesFromCommit", "isPartiallyExcluded", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "intellij.platform.vcs.impl"})
    public static final class LineFragmentData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String activeChangelistId;
        @NotNull
        private final String changelistId;
        @NotNull
        private final RangeExclusionState exclusionState;
        @NotNull
        private final List<ClientId> clientIds;

        public LineFragmentData(@NotNull String activeChangelistId, @NotNull String changelistId, @NotNull RangeExclusionState exclusionState, @NotNull List<ClientId> clientIds) {
            Intrinsics.checkNotNullParameter((Object)activeChangelistId, (String)"activeChangelistId");
            Intrinsics.checkNotNullParameter((Object)changelistId, (String)"changelistId");
            Intrinsics.checkNotNullParameter((Object)exclusionState, (String)"exclusionState");
            Intrinsics.checkNotNullParameter(clientIds, (String)"clientIds");
            this.activeChangelistId = activeChangelistId;
            this.changelistId = changelistId;
            this.exclusionState = exclusionState;
            this.clientIds = clientIds;
        }

        @NotNull
        public final String getActiveChangelistId() {
            return this.activeChangelistId;
        }

        @NotNull
        public final String getChangelistId() {
            return this.changelistId;
        }

        @NotNull
        public final RangeExclusionState getExclusionState() {
            return this.exclusionState;
        }

        @NotNull
        public final List<ClientId> getClientIds() {
            return this.clientIds;
        }

        public final boolean isFromActiveChangelist() {
            return Companion.isFromActiveChangelist(this.changelistId, this.activeChangelistId);
        }

        public final boolean isSkipped() {
            return !this.isFromActiveChangelist();
        }

        public final boolean isExcluded(boolean allowExcludeChangesFromCommit) {
            return Companion.isExcluded(this.changelistId, this.activeChangelistId, this.exclusionState, allowExcludeChangesFromCommit);
        }

        public final boolean isPartiallyExcluded() {
            return Companion.isPartiallyExcluded(this.changelistId, this.activeChangelistId, this.exclusionState);
        }

        @NotNull
        public final String component1() {
            return this.activeChangelistId;
        }

        @NotNull
        public final String component2() {
            return this.changelistId;
        }

        @NotNull
        public final RangeExclusionState component3() {
            return this.exclusionState;
        }

        @NotNull
        public final List<ClientId> component4() {
            return this.clientIds;
        }

        @NotNull
        public final LineFragmentData copy(@NotNull String activeChangelistId, @NotNull String changelistId, @NotNull RangeExclusionState exclusionState, @NotNull List<ClientId> clientIds) {
            Intrinsics.checkNotNullParameter((Object)activeChangelistId, (String)"activeChangelistId");
            Intrinsics.checkNotNullParameter((Object)changelistId, (String)"changelistId");
            Intrinsics.checkNotNullParameter((Object)exclusionState, (String)"exclusionState");
            Intrinsics.checkNotNullParameter(clientIds, (String)"clientIds");
            return new LineFragmentData(activeChangelistId, changelistId, exclusionState, clientIds);
        }

        public static /* synthetic */ LineFragmentData copy$default(LineFragmentData lineFragmentData, String string, String string2, RangeExclusionState rangeExclusionState, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = lineFragmentData.activeChangelistId;
            }
            if ((n & 2) != 0) {
                string2 = lineFragmentData.changelistId;
            }
            if ((n & 4) != 0) {
                rangeExclusionState = lineFragmentData.exclusionState;
            }
            if ((n & 8) != 0) {
                list = lineFragmentData.clientIds;
            }
            return lineFragmentData.copy(string, string2, rangeExclusionState, list);
        }

        @NotNull
        public String toString() {
            return "LineFragmentData(activeChangelistId=" + this.activeChangelistId + ", changelistId=" + this.changelistId + ", exclusionState=" + this.exclusionState + ", clientIds=" + this.clientIds + ")";
        }

        public int hashCode() {
            int result2 = this.activeChangelistId.hashCode();
            result2 = result2 * 31 + this.changelistId.hashCode();
            result2 = result2 * 31 + this.exclusionState.hashCode();
            result2 = result2 * 31 + ((Object)this.clientIds).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LineFragmentData)) {
                return false;
            }
            LineFragmentData lineFragmentData = (LineFragmentData)other;
            if (!Intrinsics.areEqual((Object)this.activeChangelistId, (Object)lineFragmentData.activeChangelistId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.changelistId, (Object)lineFragmentData.changelistId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.exclusionState, (Object)lineFragmentData.exclusionState)) {
                return false;
            }
            return Intrinsics.areEqual(this.clientIds, lineFragmentData.clientIds);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J&\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u001e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LineFragmentData$Companion;", "", "<init>", "()V", "isFromActiveChangelist", "", "changelistId", "", "activeChangelistId", "isExcluded", "exclusionState", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "allowExcludeChangesFromCommit", "isPartiallyExcluded", "intellij.platform.vcs.impl"})
        public static final class Companion {
            private Companion() {
            }

            public final boolean isFromActiveChangelist(@NotNull String changelistId, @NotNull String activeChangelistId) {
                Intrinsics.checkNotNullParameter((Object)changelistId, (String)"changelistId");
                Intrinsics.checkNotNullParameter((Object)activeChangelistId, (String)"activeChangelistId");
                return Intrinsics.areEqual((Object)changelistId, (Object)activeChangelistId);
            }

            public final boolean isExcluded(@NotNull String changelistId, @NotNull String activeChangelistId, @NotNull RangeExclusionState exclusionState, boolean allowExcludeChangesFromCommit) {
                Intrinsics.checkNotNullParameter((Object)changelistId, (String)"changelistId");
                Intrinsics.checkNotNullParameter((Object)activeChangelistId, (String)"activeChangelistId");
                Intrinsics.checkNotNullParameter((Object)exclusionState, (String)"exclusionState");
                return !this.isFromActiveChangelist(changelistId, activeChangelistId) || allowExcludeChangesFromCommit && Intrinsics.areEqual((Object)exclusionState, (Object)RangeExclusionState.Excluded.INSTANCE);
            }

            public final boolean isPartiallyExcluded(@NotNull String changelistId, @NotNull String activeChangelistId, @NotNull RangeExclusionState exclusionState) {
                Intrinsics.checkNotNullParameter((Object)changelistId, (String)"changelistId");
                Intrinsics.checkNotNullParameter((Object)activeChangelistId, (String)"activeChangelistId");
                Intrinsics.checkNotNullParameter((Object)exclusionState, (String)"exclusionState");
                return this.isFromActiveChangelist(changelistId, activeChangelistId) && exclusionState instanceof RangeExclusionState.Partial;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerActionProvider;", "", "viewer", "Lcom/intellij/diff/tools/util/base/DiffViewerBase;", "getViewer", "()Lcom/intellij/diff/tools/util/base/DiffViewerBase;", "localRequest", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalChangeListDiffRequest;", "getLocalRequest", "()Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalChangeListDiffRequest;", "allowExcludeChangesFromCommit", "", "getAllowExcludeChangesFromCommit", "()Z", "getSelectedTrackerChanges", "", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerChange;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getSelectedTrackerLines", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$SelectedTrackerLine;", "intellij.platform.vcs.impl"})
    public static interface LocalTrackerActionProvider {
        @NotNull
        public DiffViewerBase getViewer();

        @NotNull
        public LocalChangeListDiffRequest getLocalRequest();

        public boolean getAllowExcludeChangesFromCommit();

        @Nullable
        public List<LocalTrackerChange> getSelectedTrackerChanges(@NotNull AnActionEvent var1);

        @Nullable
        public SelectedTrackerLine getSelectedTrackerLines(@NotNull AnActionEvent var1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerChange;", "", "startLine", "", "endLine", "changelistId", "", "exclusionState", "Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "<init>", "(IILjava/lang/String;Lcom/intellij/openapi/vcs/ex/RangeExclusionState;)V", "getStartLine", "()I", "getEndLine", "getChangelistId", "()Ljava/lang/String;", "getExclusionState", "()Lcom/intellij/openapi/vcs/ex/RangeExclusionState;", "intellij.platform.vcs.impl"})
    public static final class LocalTrackerChange {
        private final int startLine;
        private final int endLine;
        @NotNull
        private final String changelistId;
        @NotNull
        private final RangeExclusionState exclusionState;

        public LocalTrackerChange(int startLine, int endLine, @NotNull String changelistId, @NotNull RangeExclusionState exclusionState) {
            Intrinsics.checkNotNullParameter((Object)changelistId, (String)"changelistId");
            Intrinsics.checkNotNullParameter((Object)exclusionState, (String)"exclusionState");
            this.startLine = startLine;
            this.endLine = endLine;
            this.changelistId = changelistId;
            this.exclusionState = exclusionState;
        }

        public final int getStartLine() {
            return this.startLine;
        }

        public final int getEndLine() {
            return this.endLine;
        }

        @NotNull
        public final String getChangelistId() {
            return this.changelistId;
        }

        @NotNull
        public final RangeExclusionState getExclusionState() {
            return this.exclusionState;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u00002\u00020\u0001J1\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\fJ9\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH&\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0003H&J\b\u0010\u0010\u001a\u00020\u0003H&J\b\u0010\u0011\u001a\u00020\u0003H&J\b\u0010\u0012\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerDiffHandler;", "", "done", "Ljava/lang/Runnable;", "isContentsEqual", "", "texts", "", "", "toggleableLineRanges", "", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$ToggleableLineRange;", "(Z[Ljava/lang/CharSequence;Ljava/util/List;)Ljava/lang/Runnable;", "areVCSBoundedActionsDisabled", "(ZZ[Ljava/lang/CharSequence;Ljava/util/List;)Ljava/lang/Runnable;", "retryLater", "fallback", "fallbackWithProgress", "error", "intellij.platform.vcs.impl"})
    public static interface LocalTrackerDiffHandler {
        @NotNull
        default public Runnable done(boolean isContentsEqual, @NotNull CharSequence[] texts, @NotNull List<ToggleableLineRange> toggleableLineRanges) {
            Intrinsics.checkNotNullParameter((Object)texts, (String)"texts");
            Intrinsics.checkNotNullParameter(toggleableLineRanges, (String)"toggleableLineRanges");
            return this.done(isContentsEqual, true, texts, toggleableLineRanges);
        }

        @NotNull
        public Runnable done(boolean var1, boolean var2, @NotNull CharSequence[] var3, @NotNull List<ToggleableLineRange> var4);

        @NotNull
        public Runnable retryLater();

        @NotNull
        public Runnable fallback();

        @NotNull
        public Runnable fallbackWithProgress();

        @NotNull
        public Runnable error();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$MoveSelectedChangesToAnotherChangelistAction;", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$MySelectedChangesActionBase;", "provider", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerActionProvider;", "<init>", "(Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerActionProvider;)V", "getText", "", "changes", "", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerChange;", "doPerform", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "tracker", "Lcom/intellij/openapi/vcs/ex/PartialLocalLineStatusTracker;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nLocalTrackerDiffUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalTrackerDiffUtil.kt\ncom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$MoveSelectedChangesToAnotherChangelistAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,879:1\n1786#2,3:880\n1786#2,3:883\n*S KotlinDebug\n*F\n+ 1 LocalTrackerDiffUtil.kt\ncom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$MoveSelectedChangesToAnotherChangelistAction\n*L\n490#1:880,3\n504#1:883,3\n*E\n"})
    public static final class MoveSelectedChangesToAnotherChangelistAction
    extends MySelectedChangesActionBase {
        public MoveSelectedChangesToAnotherChangelistAction(@NotNull LocalTrackerActionProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            super(false, provider);
            this.copyShortcutFrom(ActionManager.getInstance().getAction("Vcs.MoveChangedLinesToChangelist"));
        }

        @Override
        @NotNull
        protected String getText(@NotNull List<LocalTrackerChange> changes) {
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            if (!((Collection)changes).isEmpty()) {
                boolean bl;
                block5: {
                    Iterable $this$all$iv = changes;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            LocalTrackerChange it = (LocalTrackerChange)element$iv;
                            boolean bl2 = false;
                            if (!this.isFromActiveChangelist(it)) continue;
                            bl = false;
                            break block5;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    String string = StringUtil.trimMiddle((String)this.getProvider().getLocalRequest().getChangelistName(), (int)40);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimMiddle(...)");
                    String shortChangeListName = string;
                    Object[] objectArray = new Object[]{StringUtil.escapeMnemonics((String)shortChangeListName)};
                    String string2 = VcsBundle.message((String)"changes.move.to.changelist", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    return string2;
                }
            }
            String string = ActionsBundle.message((String)"action.ChangesView.Move.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        protected void doPerform(@NotNull AnActionEvent e, @NotNull PartialLocalLineStatusTracker tracker, @NotNull List<LocalTrackerChange> changes) {
            boolean bl;
            BitSet selectedLines;
            block6: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
                Intrinsics.checkNotNullParameter(changes, (String)"changes");
                selectedLines = INSTANCE.getLocalSelectedLines(changes);
                Iterable $this$all$iv = changes;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        LocalTrackerChange it = (LocalTrackerChange)element$iv;
                        boolean bl2 = false;
                        if (!this.isFromActiveChangelist(it)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                LocalChangeList changeList = ChangeListManager.getInstance((Project)tracker.getProject()).getChangeList(this.getActiveChangelistId());
                if (changeList != null) {
                    tracker.moveToChangelist(selectedLines, changeList);
                }
            } else {
                MoveChangesLineStatusAction.moveToAnotherChangelist(tracker, selectedLines);
            }
            this.getProvider().getViewer().rediff();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$MyLineStatusTrackerManagerListener;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ListenerAdapter;", "viewer", "Lcom/intellij/diff/tools/util/base/DiffViewerBase;", "localRequest", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalChangeListDiffRequest;", "trackerListener", "Lcom/intellij/openapi/vcs/ex/PartialLocalLineStatusTracker$Listener;", "<init>", "(Lcom/intellij/diff/tools/util/base/DiffViewerBase;Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalChangeListDiffRequest;Lcom/intellij/openapi/vcs/ex/PartialLocalLineStatusTracker$Listener;)V", "onTrackerAdded", "", "tracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "intellij.platform.vcs.impl"})
    private static final class MyLineStatusTrackerManagerListener
    extends LineStatusTrackerManager.ListenerAdapter {
        @NotNull
        private final DiffViewerBase viewer;
        @NotNull
        private final LocalChangeListDiffRequest localRequest;
        @NotNull
        private final PartialLocalLineStatusTracker.Listener trackerListener;

        public MyLineStatusTrackerManagerListener(@NotNull DiffViewerBase viewer, @NotNull LocalChangeListDiffRequest localRequest, @NotNull PartialLocalLineStatusTracker.Listener trackerListener) {
            Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
            Intrinsics.checkNotNullParameter((Object)((Object)localRequest), (String)"localRequest");
            Intrinsics.checkNotNullParameter((Object)trackerListener, (String)"trackerListener");
            this.viewer = viewer;
            this.localRequest = localRequest;
            this.trackerListener = trackerListener;
        }

        @Override
        public void onTrackerAdded(@NotNull LineStatusTracker<?> tracker) {
            Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
            if (tracker instanceof PartialLocalLineStatusTracker && Intrinsics.areEqual((Object)((PartialLocalLineStatusTracker)tracker).getVirtualFile(), (Object)this.localRequest.getVirtualFile())) {
                ((PartialLocalLineStatusTracker)tracker).addListener(this.trackerListener, (Disposable)this.viewer);
                this.viewer.scheduleRediff();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001b\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0014J&\u0010\u001e\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\u0018\u001a\u00020\u0003*\u00020\u00138DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0019\u0010\u001a\u001a\u00070\u0015\u00a2\u0006\u0002\b\u001b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$MySelectedChangesActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "forActiveChangelistOnly", "", "provider", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerActionProvider;", "<init>", "(ZLcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerActionProvider;)V", "getProvider", "()Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerActionProvider;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getAffectedChanges", "", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerChange;", "getText", "", "Lorg/jetbrains/annotations/Nls;", "changes", "isFromActiveChangelist", "(Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerChange;)Z", "activeChangelistId", "Lorg/jetbrains/annotations/NotNull;", "getActiveChangelistId", "()Ljava/lang/String;", "doPerform", "tracker", "Lcom/intellij/openapi/vcs/ex/PartialLocalLineStatusTracker;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nLocalTrackerDiffUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalTrackerDiffUtil.kt\ncom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$MySelectedChangesActionBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,879:1\n777#2:880\n873#2,2:881\n*S KotlinDebug\n*F\n+ 1 LocalTrackerDiffUtil.kt\ncom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$MySelectedChangesActionBase\n*L\n583#1:880\n583#1:881,2\n*E\n"})
    public static abstract class MySelectedChangesActionBase
    extends DumbAwareAction {
        private final boolean forActiveChangelistOnly;
        @NotNull
        private final LocalTrackerActionProvider provider;

        public MySelectedChangesActionBase(boolean forActiveChangelistOnly, @NotNull LocalTrackerActionProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            this.forActiveChangelistOnly = forActiveChangelistOnly;
            this.provider = provider;
        }

        @NotNull
        protected final LocalTrackerActionProvider getProvider() {
            return this.provider;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.forActiveChangelistOnly && !this.provider.getAllowExcludeChangesFromCommit()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            if (DiffUtil.isFromShortcut((AnActionEvent)e)) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            PartialLocalLineStatusTracker tracker = INSTANCE.getPartialTracker(this.provider.getLocalRequest());
            List<LocalTrackerChange> affectedChanges = this.getAffectedChanges(e);
            if (tracker == null || affectedChanges == null) {
                e.getPresentation().setVisible(true);
                e.getPresentation().setEnabled(false);
                e.getPresentation().setText(this.getText(CollectionsKt.emptyList()));
                return;
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(!((Collection)affectedChanges).isEmpty());
            e.getPresentation().setText(this.getText(affectedChanges));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            PartialLocalLineStatusTracker partialLocalLineStatusTracker = INSTANCE.getPartialTracker(this.provider.getLocalRequest());
            if (partialLocalLineStatusTracker == null) {
                return;
            }
            PartialLocalLineStatusTracker tracker = partialLocalLineStatusTracker;
            List<LocalTrackerChange> list = this.getAffectedChanges(e);
            if (list == null) {
                return;
            }
            List<LocalTrackerChange> affectedChanges = list;
            if (affectedChanges.isEmpty()) {
                return;
            }
            this.doPerform(e, tracker, affectedChanges);
        }

        /*
         * WARNING - void declaration
         */
        private final List<LocalTrackerChange> getAffectedChanges(AnActionEvent e) {
            List<LocalTrackerChange> list = this.provider.getSelectedTrackerChanges(e);
            if (list == null) {
                return null;
            }
            List<LocalTrackerChange> changes = list;
            if (this.forActiveChangelistOnly) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = changes;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    LocalTrackerChange it = (LocalTrackerChange)element$iv$iv;
                    boolean bl = false;
                    if (!this.isFromActiveChangelist(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            return changes;
        }

        @NotNull
        protected String getText(@NotNull List<LocalTrackerChange> changes) {
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            String string = this.getTemplatePresentation().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }

        protected final boolean isFromActiveChangelist(@NotNull LocalTrackerChange $this$isFromActiveChangelist) {
            Intrinsics.checkNotNullParameter((Object)$this$isFromActiveChangelist, (String)"<this>");
            return Intrinsics.areEqual((Object)$this$isFromActiveChangelist.getChangelistId(), (Object)this.getActiveChangelistId());
        }

        @NotNull
        protected final String getActiveChangelistId() {
            String string = this.provider.getLocalRequest().getChangelistId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getChangelistId(...)");
            return string;
        }

        @RequiresWriteLock
        protected abstract void doPerform(@NotNull AnActionEvent var1, @NotNull PartialLocalLineStatusTracker var2, @NotNull List<LocalTrackerChange> var3);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$MyTrackerListener;", "Lcom/intellij/openapi/vcs/ex/PartialLocalLineStatusTracker$ListenerAdapter;", "viewer", "Lcom/intellij/diff/tools/util/base/DiffViewerBase;", "<init>", "(Lcom/intellij/diff/tools/util/base/DiffViewerBase;)V", "onBecomingValid", "", "tracker", "Lcom/intellij/openapi/vcs/ex/PartialLocalLineStatusTracker;", "onChangeListMarkerChange", "onExcludedFromCommitChange", "scheduleRediff", "intellij.platform.vcs.impl"})
    private static final class MyTrackerListener
    extends PartialLocalLineStatusTracker.ListenerAdapter {
        @NotNull
        private final DiffViewerBase viewer;

        public MyTrackerListener(@NotNull DiffViewerBase viewer) {
            Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
            this.viewer = viewer;
        }

        @Override
        public void onBecomingValid(@NotNull PartialLocalLineStatusTracker tracker) {
            Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
            this.scheduleRediff();
        }

        @Override
        public void onChangeListMarkerChange(@NotNull PartialLocalLineStatusTracker tracker) {
            Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
            this.scheduleRediff();
        }

        @Override
        public void onExcludedFromCommitChange(@NotNull PartialLocalLineStatusTracker tracker) {
            Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
            this.scheduleRediff();
        }

        private final void scheduleRediff() {
            ActionsKt.runInEdt$default(null, () -> MyTrackerListener.scheduleRediff$lambda$0(this), (int)1, null);
        }

        private static final Unit scheduleRediff$lambda$0(MyTrackerListener this$0) {
            this$0.viewer.scheduleRediff();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J \u0010\"\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$PartiallyExcludeSelectedLinesFromCommitAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "provider", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerActionProvider;", "isExclude", "", "<init>", "(Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerActionProvider;Z)V", "getProvider", "()Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LocalTrackerActionProvider;", "()Z", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getAffectedRanges", "", "Lcom/intellij/openapi/vcs/ex/LocalRange;", "selectedLines", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$SelectedTrackerLine;", "isSelected", "range", "isPartiallySelected", "checkPartialSelectionState", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$PartiallyExcludeSelectedLinesFromCommitAction$SelectionState;", "selectionCovers", "selection", "Ljava/util/BitSet;", "startLine", "", "endLine", "selectionIntersects", "SelectionState", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nLocalTrackerDiffUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalTrackerDiffUtil.kt\ncom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$PartiallyExcludeSelectedLinesFromCommitAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,879:1\n1807#2,3:880\n1807#2,3:883\n1807#2,3:886\n1807#2,3:889\n1807#2,3:892\n1915#2,2:895\n777#2:897\n873#2,2:898\n777#2:900\n873#2,2:901\n*S KotlinDebug\n*F\n+ 1 LocalTrackerDiffUtil.kt\ncom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$PartiallyExcludeSelectedLinesFromCommitAction\n*L\n633#1:880,3\n643#1:883,3\n651#1:886,3\n662#1:889,3\n673#1:892,3\n680#1:895,2\n691#1:897\n691#1:898,2\n692#1:900\n692#1:901,2\n*E\n"})
    public static final class PartiallyExcludeSelectedLinesFromCommitAction
    extends DumbAwareAction {
        @NotNull
        private final LocalTrackerActionProvider provider;
        private final boolean isExclude;

        public PartiallyExcludeSelectedLinesFromCommitAction(@NotNull LocalTrackerActionProvider provider, boolean isExclude) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            this.provider = provider;
            this.isExclude = isExclude;
            ActionUtil.copyFrom((AnAction)((AnAction)this), (String)(this.isExclude ? "Vcs.Diff.ExcludeChangedLinesFromCommit" : "Vcs.Diff.IncludeChangedLinesIntoCommit"));
        }

        @NotNull
        public final LocalTrackerActionProvider getProvider() {
            return this.provider;
        }

        public final boolean isExclude() {
            return this.isExclude;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        /*
         * WARNING - void declaration
         */
        public void update(@NotNull AnActionEvent e) {
            boolean isPartialBlockSelection;
            LocalRange it;
            boolean $i$f$any;
            Iterable $this$any$iv;
            List<LocalRange> affectedRanges;
            SelectedTrackerLine selectedLines;
            block21: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!this.provider.getAllowExcludeChangesFromCommit()) {
                    e.getPresentation().setEnabledAndVisible(false);
                    return;
                }
                if (DiffUtil.isFromShortcut((AnActionEvent)e)) {
                    e.getPresentation().setEnabledAndVisible(true);
                    return;
                }
                selectedLines = this.provider.getSelectedTrackerLines(e);
                if (selectedLines == null) {
                    e.getPresentation().setEnabledAndVisible(false);
                    return;
                }
                affectedRanges = this.getAffectedRanges(selectedLines);
                $this$any$iv = affectedRanges;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (LocalRange)element$iv;
                        boolean bl = false;
                        if (!this.isPartiallySelected(it, selectedLines)) continue;
                        v0 = true;
                        break block21;
                    }
                    v0 = isPartialBlockSelection = false;
                }
            }
            if (affectedRanges.isEmpty()) {
                e.getPresentation().setText(this.isExclude ? ActionsBundle.message((String)"action.Vcs.Diff.ExcludeChangedLinesFromCommit.text", (Object[])new Object[0]) : ActionsBundle.message((String)"action.Vcs.Diff.IncludeChangedLinesIntoCommit.text", (Object[])new Object[0]));
                e.getPresentation().setEnabled(false);
            } else if (isPartialBlockSelection) {
                boolean bl;
                Presentation presentation;
                block23: {
                    void $this$any$iv2;
                    String string;
                    boolean bl2;
                    Object element$iv;
                    block22: {
                        Iterable $this$any$iv3 = affectedRanges;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv3) {
                                LocalRange it2 = (LocalRange)element$iv2;
                                boolean bl3 = false;
                                if (!(!(it2.getExclusionState() instanceof RangeExclusionState.Partial))) continue;
                                bl2 = true;
                                break block22;
                            }
                            bl2 = false;
                        }
                    }
                    boolean willSplit = bl2;
                    int rangesCount = willSplit ? affectedRanges.size() : 0;
                    BitSet bitSet = selectedLines.getLocalLines();
                    BitSet bitSet2 = selectedLines.getVcsLines();
                    int selectionSize = (bitSet != null ? bitSet.cardinality() : 0) + (bitSet2 != null ? bitSet2.cardinality() : 0);
                    Presentation presentation2 = e.getPresentation();
                    if (this.isExclude) {
                        element$iv = new Object[]{rangesCount, selectionSize};
                        string = ActionsBundle.message((String)"action.Vcs.Diff.ExcludeChangedLinesFromCommit.template.text", element$iv);
                    } else {
                        element$iv = new Object[]{rangesCount, selectionSize};
                        string = ActionsBundle.message((String)"action.Vcs.Diff.IncludeChangedLinesIntoCommit.template.text", element$iv);
                    }
                    presentation2.setText(string);
                    element$iv = affectedRanges;
                    presentation = e.getPresentation();
                    boolean $i$f$any3 = false;
                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv3 : $this$any$iv2) {
                            LocalRange it3 = (LocalRange)element$iv3;
                            boolean bl4 = false;
                            SelectionState selectionState = this.checkPartialSelectionState(it3, selectedLines);
                            if (!(this.isExclude ? selectionState.getHasIncluded() : selectionState.getHasExcluded())) continue;
                            bl = true;
                            break block23;
                        }
                        bl = false;
                    }
                }
                boolean bl5 = bl;
                presentation.setEnabled(bl5);
            } else {
                boolean bl;
                Presentation presentation;
                block24: {
                    e.getPresentation().setText(this.isExclude ? VcsBundle.message((String)"changes.ExcludeChangedLinesFromCommit.chunks.action.text", (Object[])new Object[0]) : VcsBundle.message((String)"changes.IncludeChangedLinesIntoCommit.chunks.action.text", (Object[])new Object[0]));
                    Iterable willSplit = affectedRanges;
                    presentation = e.getPresentation();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (LocalRange)element$iv;
                            boolean bl6 = false;
                            RangeExclusionState exclusionState = it.getExclusionState();
                            if (!(this.isExclude ? exclusionState.getHasIncluded() : exclusionState.getHasExcluded())) continue;
                            bl = true;
                            break block24;
                        }
                        bl = false;
                    }
                }
                boolean bl7 = bl;
                presentation.setEnabled(bl7);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            boolean isPartialBlockSelection;
            LocalRange it;
            List<LocalRange> affectedRanges;
            PartialLocalLineStatusTracker tracker;
            SelectedTrackerLine selectedLines;
            block10: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SelectedTrackerLine selectedTrackerLine = this.provider.getSelectedTrackerLines(e);
                if (selectedTrackerLine == null) {
                    return;
                }
                selectedLines = selectedTrackerLine;
                PartialLocalLineStatusTracker partialLocalLineStatusTracker = INSTANCE.getPartialTracker(this.provider.getLocalRequest());
                if (partialLocalLineStatusTracker == null) {
                    return;
                }
                tracker = partialLocalLineStatusTracker;
                affectedRanges = this.getAffectedRanges(selectedLines);
                Iterable $this$any$iv = affectedRanges;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (LocalRange)element$iv;
                        boolean bl = false;
                        if (!this.isPartiallySelected(it, selectedLines)) continue;
                        v2 = true;
                        break block10;
                    }
                    v2 = isPartialBlockSelection = false;
                }
            }
            if (isPartialBlockSelection) {
                if (selectedLines.getVcsLines() != null) {
                    tracker.setPartiallyExcludedFromCommit(selectedLines.getVcsLines(), Side.LEFT, this.isExclude);
                }
                if (selectedLines.getLocalLines() != null) {
                    tracker.setPartiallyExcludedFromCommit(selectedLines.getLocalLines(), Side.RIGHT, this.isExclude);
                }
            } else {
                Iterable $this$forEach$iv = affectedRanges;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (LocalRange)element$iv;
                    boolean bl = false;
                    tracker.setExcludedFromCommit((com.intellij.openapi.vcs.ex.Range)it, this.isExclude);
                }
            }
            this.provider.getViewer().rediff();
        }

        private final List<LocalRange> getAffectedRanges(SelectedTrackerLine selectedLines) {
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            String string = this.provider.getLocalRequest().getChangelistId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getChangelistId(...)");
            String activeChangelistId = string;
            PartialLocalLineStatusTracker partialLocalLineStatusTracker = INSTANCE.getPartialTracker(this.provider.getLocalRequest());
            if (partialLocalLineStatusTracker == null) {
                return CollectionsKt.emptyList();
            }
            PartialLocalLineStatusTracker tracker = partialLocalLineStatusTracker;
            List list = tracker.getRanges();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable iterable = list;
            boolean $i$f$filter = false;
            void var6_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LocalRange change = (LocalRange)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)change.getChangelistId(), (Object)activeChangelistId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LocalRange it = (LocalRange)element$iv$iv;
                boolean bl = false;
                if (!this.isSelected(it, selectedLines)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final boolean isSelected(LocalRange range, SelectedTrackerLine selectedLines) {
            return selectedLines.getVcsLines() != null && DiffUtil.isSelectedByLine((BitSet)selectedLines.getVcsLines(), (int)range.getVcsLine1(), (int)range.getVcsLine2()) || selectedLines.getLocalLines() != null && DiffUtil.isSelectedByLine((BitSet)selectedLines.getLocalLines(), (int)range.getLine1(), (int)range.getLine2());
        }

        private final boolean isPartiallySelected(LocalRange range, SelectedTrackerLine selectedLines) {
            if (range.getExclusionState() instanceof RangeExclusionState.Partial) {
                return true;
            }
            if (selectedLines.getLocalLines() != null && range.getLine1() != range.getLine2() && !this.selectionCovers(selectedLines.getLocalLines(), range.getLine1(), range.getLine2())) {
                return true;
            }
            return selectedLines.getVcsLines() != null && range.getVcsLine1() != range.getVcsLine2() && !this.selectionCovers(selectedLines.getVcsLines(), range.getVcsLine1(), range.getVcsLine2());
        }

        private final SelectionState checkPartialSelectionState(LocalRange range, SelectedTrackerLine selectedLines) {
            int changeStart;
            RangeExclusionState exclusionState = range.getExclusionState();
            if (!(exclusionState instanceof RangeExclusionState.Partial)) {
                return new SelectionState(exclusionState.getHasExcluded(), exclusionState.getHasIncluded());
            }
            Ref.BooleanRef hasExcluded = new Ref.BooleanRef();
            Ref.BooleanRef hasIncluded = new Ref.BooleanRef();
            if (selectedLines.getLocalLines() != null) {
                changeStart = range.getLine1();
                ((RangeExclusionState.Partial)exclusionState).iterateAdditionOffsets((arg_0, arg_1, arg_2) -> PartiallyExcludeSelectedLinesFromCommitAction.checkPartialSelectionState$lambda$0(this, selectedLines, changeStart, hasIncluded, hasExcluded, arg_0, arg_1, arg_2));
            }
            if (selectedLines.getVcsLines() != null) {
                changeStart = range.getVcsLine1();
                ((RangeExclusionState.Partial)exclusionState).iterateDeletionOffsets((arg_0, arg_1, arg_2) -> PartiallyExcludeSelectedLinesFromCommitAction.checkPartialSelectionState$lambda$1(this, selectedLines, changeStart, hasIncluded, hasExcluded, arg_0, arg_1, arg_2));
            }
            return new SelectionState(hasExcluded.element, hasIncluded.element);
        }

        private final boolean selectionCovers(BitSet selection, int startLine, int endLine) {
            return selection.nextClearBit(startLine) >= endLine;
        }

        private final boolean selectionIntersects(BitSet selection, int startLine, int endLine) {
            int nextSetBit = selection.nextSetBit(startLine);
            return nextSetBit != -1 && nextSetBit < endLine;
        }

        private static final Unit checkPartialSelectionState$lambda$0(PartiallyExcludeSelectedLinesFromCommitAction this$0, SelectedTrackerLine $selectedLines, int $changeStart, Ref.BooleanRef $hasIncluded, Ref.BooleanRef $hasExcluded, int start2, int end, boolean isIncluded) {
            if (this$0.selectionIntersects($selectedLines.getLocalLines(), $changeStart + start2, $changeStart + end)) {
                if (isIncluded) {
                    $hasIncluded.element = true;
                } else {
                    $hasExcluded.element = true;
                }
            }
            return Unit.INSTANCE;
        }

        private static final Unit checkPartialSelectionState$lambda$1(PartiallyExcludeSelectedLinesFromCommitAction this$0, SelectedTrackerLine $selectedLines, int $changeStart, Ref.BooleanRef $hasIncluded, Ref.BooleanRef $hasExcluded, int start2, int end, boolean isIncluded) {
            if (this$0.selectionIntersects($selectedLines.getVcsLines(), $changeStart + start2, $changeStart + end)) {
                if (isIncluded) {
                    $hasIncluded.element = true;
                } else {
                    $hasExcluded.element = true;
                }
            }
            return Unit.INSTANCE;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$PartiallyExcludeSelectedLinesFromCommitAction$SelectionState;", "", "hasExcluded", "", "hasIncluded", "<init>", "(ZZ)V", "getHasExcluded", "()Z", "getHasIncluded", "intellij.platform.vcs.impl"})
        private static final class SelectionState {
            private final boolean hasExcluded;
            private final boolean hasIncluded;

            public SelectionState(boolean hasExcluded, boolean hasIncluded) {
                this.hasExcluded = hasExcluded;
                this.hasIncluded = hasIncluded;
            }

            public final boolean getHasExcluded() {
                return this.hasExcluded;
            }

            public final boolean getHasIncluded() {
                return this.hasIncluded;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$SelectedTrackerLine;", "", "vcsLines", "Ljava/util/BitSet;", "localLines", "<init>", "(Ljava/util/BitSet;Ljava/util/BitSet;)V", "getVcsLines", "()Ljava/util/BitSet;", "getLocalLines", "intellij.platform.vcs.impl"})
    public static final class SelectedTrackerLine {
        @Nullable
        private final BitSet vcsLines;
        @Nullable
        private final BitSet localLines;

        public SelectedTrackerLine(@Nullable BitSet vcsLines, @Nullable BitSet localLines) {
            this.vcsLines = vcsLines;
            this.localLines = localLines;
        }

        @Nullable
        public final BitSet getVcsLines() {
            return this.vcsLines;
        }

        @Nullable
        public final BitSet getLocalLines() {
            return this.localLines;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$ToggleAreaThumbRenderer;", "Lcom/intellij/openapi/editor/markup/LineMarkerRenderer;", "Lcom/intellij/openapi/editor/markup/ActiveGutterRenderer;", "onClick", "Ljava/lang/Runnable;", "<init>", "(Ljava/lang/Runnable;)V", "getOnClick", "()Ljava/lang/Runnable;", "getDrawArea", "Lkotlin/Pair;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "paint", "", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "getTooltipText", "", "canDoAction", "", "e", "Ljava/awt/event/MouseEvent;", "doAction", "intellij.platform.vcs.impl"})
    private static final class ToggleAreaThumbRenderer
    implements LineMarkerRenderer,
    ActiveGutterRenderer {
        @NotNull
        private final Runnable onClick;

        public ToggleAreaThumbRenderer(@NotNull Runnable onClick) {
            Intrinsics.checkNotNullParameter((Object)onClick, (String)"onClick");
            this.onClick = onClick;
        }

        @NotNull
        public final Runnable getOnClick() {
            return this.onClick;
        }

        private final Pair<Integer, Integer> getDrawArea(Editor editor) {
            Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            EditorGutterComponentEx editorGutterComponentEx = ((EditorEx)editor).getGutterComponentEx();
            Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"getGutterComponentEx(...)");
            EditorGutterComponentEx gutter = editorGutterComponentEx;
            int width = JBUIScale.scale((int)3);
            int x = gutter.getWhitespaceSeparatorOffset() - width;
            return new Pair((Object)x, (Object)(x + width));
        }

        public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            Pair<Integer, Integer> pair = this.getDrawArea(editor);
            int x1 = ((Number)pair.component1()).intValue();
            int x2 = ((Number)pair.component2()).intValue();
            Color color = editor.getColorsScheme().getColor(EditorColors.DIFF_BLOCK_AREA_HIGHLIGHT_MARKER);
            if (color == null) {
                return;
            }
            g.setColor(color);
            g.fillRect(x1, r.y, x2 - x1, r.height);
        }

        @NotNull
        public String getTooltipText() {
            String string = DiffBundle.message((String)"action.presentation.diff.include.into.commit.area.marker.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public boolean canDoAction(@NotNull Editor editor, @NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Pair<Integer, Integer> pair = this.getDrawArea(editor);
            int x1 = ((Number)pair.component1()).intValue();
            int x2 = ((Number)pair.component2()).intValue();
            int n = e.getX();
            return x1 <= n ? n < x2 : false;
        }

        public void doAction(@NotNull Editor editor, @NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.onClick.run();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$ToggleableLineRange;", "", "lineRange", "Lcom/intellij/diff/util/Range;", "fragments", "", "Lcom/intellij/diff/fragments/LineFragment;", "fragmentData", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LineFragmentData;", "<init>", "(Lcom/intellij/diff/util/Range;Ljava/util/List;Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LineFragmentData;)V", "getLineRange", "()Lcom/intellij/diff/util/Range;", "getFragments", "()Ljava/util/List;", "getFragmentData", "()Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$LineFragmentData;", "intellij.platform.vcs.impl"})
    public static final class ToggleableLineRange {
        @NotNull
        private final Range lineRange;
        @NotNull
        private final List<LineFragment> fragments;
        @NotNull
        private final LineFragmentData fragmentData;

        public ToggleableLineRange(@NotNull Range lineRange, @NotNull List<? extends LineFragment> fragments, @NotNull LineFragmentData fragmentData) {
            Intrinsics.checkNotNullParameter((Object)lineRange, (String)"lineRange");
            Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
            Intrinsics.checkNotNullParameter((Object)fragmentData, (String)"fragmentData");
            this.lineRange = lineRange;
            this.fragments = fragments;
            this.fragmentData = fragmentData;
        }

        @NotNull
        public final Range getLineRange() {
            return this.lineRange;
        }

        @NotNull
        public final List<LineFragment> getFragments() {
            return this.fragments;
        }

        @NotNull
        public final LineFragmentData getFragmentData() {
            return this.fragmentData;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$TrackerData;", "", "Released", "Invalid", "Valid", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$TrackerData$Invalid;", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$TrackerData$Released;", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$TrackerData$Valid;", "intellij.platform.vcs.impl"})
    private static sealed interface TrackerData {

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0004H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$TrackerData$Invalid;", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$TrackerData;", "affectedChangelist", "", "", "isLoading", "", "<init>", "(Ljava/util/List;Z)V", "getAffectedChangelist", "()Ljava/util/List;", "()Z", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.platform.vcs.impl"})
        public static final class Invalid
        implements TrackerData {
            @NotNull
            private final List<String> affectedChangelist;
            private final boolean isLoading;

            public Invalid(@NotNull List<String> affectedChangelist, boolean isLoading) {
                Intrinsics.checkNotNullParameter(affectedChangelist, (String)"affectedChangelist");
                this.affectedChangelist = affectedChangelist;
                this.isLoading = isLoading;
            }

            @NotNull
            public final List<String> getAffectedChangelist() {
                return this.affectedChangelist;
            }

            public final boolean isLoading() {
                return this.isLoading;
            }

            @NotNull
            public final List<String> component1() {
                return this.affectedChangelist;
            }

            public final boolean component2() {
                return this.isLoading;
            }

            @NotNull
            public final Invalid copy(@NotNull List<String> affectedChangelist, boolean isLoading) {
                Intrinsics.checkNotNullParameter(affectedChangelist, (String)"affectedChangelist");
                return new Invalid(affectedChangelist, isLoading);
            }

            public static /* synthetic */ Invalid copy$default(Invalid invalid, List list, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    list = invalid.affectedChangelist;
                }
                if ((n & 2) != 0) {
                    bl = invalid.isLoading;
                }
                return invalid.copy(list, bl);
            }

            @NotNull
            public String toString() {
                return "Invalid(affectedChangelist=" + this.affectedChangelist + ", isLoading=" + this.isLoading + ")";
            }

            public int hashCode() {
                int result2 = ((Object)this.affectedChangelist).hashCode();
                result2 = result2 * 31 + Boolean.hashCode(this.isLoading);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Invalid)) {
                    return false;
                }
                Invalid invalid = (Invalid)other;
                if (!Intrinsics.areEqual(this.affectedChangelist, invalid.affectedChangelist)) {
                    return false;
                }
                return this.isLoading == invalid.isLoading;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0083\u0004J\n\u0010\b\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\n\u001a\u00020\u000bH\u00d6\u0081\u0004\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$TrackerData$Released;", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$TrackerData;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.vcs.impl"})
        public static final class Released
        implements TrackerData {
            @NotNull
            public static final Released INSTANCE = new Released();

            private Released() {
            }

            @NotNull
            public String toString() {
                return "Released";
            }

            public int hashCode() {
                return 401144069;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Released)) {
                    return false;
                }
                Released cfr_ignored_0 = (Released)other;
                return true;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0083\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004J\n\u0010\u0016\u001a\u00020\u0004H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$TrackerData$Valid;", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$TrackerData;", "affectedChangelist", "", "", "diffData", "Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$TrackerDiffData;", "<init>", "(Ljava/util/List;Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$TrackerDiffData;)V", "getAffectedChangelist", "()Ljava/util/List;", "getDiffData", "()Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$TrackerDiffData;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.vcs.impl"})
        public static final class Valid
        implements TrackerData {
            @NotNull
            private final List<String> affectedChangelist;
            @NotNull
            private final TrackerDiffData diffData;

            public Valid(@NotNull List<String> affectedChangelist, @NotNull TrackerDiffData diffData) {
                Intrinsics.checkNotNullParameter(affectedChangelist, (String)"affectedChangelist");
                Intrinsics.checkNotNullParameter((Object)diffData, (String)"diffData");
                this.affectedChangelist = affectedChangelist;
                this.diffData = diffData;
            }

            @NotNull
            public final List<String> getAffectedChangelist() {
                return this.affectedChangelist;
            }

            @NotNull
            public final TrackerDiffData getDiffData() {
                return this.diffData;
            }

            @NotNull
            public final List<String> component1() {
                return this.affectedChangelist;
            }

            @NotNull
            public final TrackerDiffData component2() {
                return this.diffData;
            }

            @NotNull
            public final Valid copy(@NotNull List<String> affectedChangelist, @NotNull TrackerDiffData diffData) {
                Intrinsics.checkNotNullParameter(affectedChangelist, (String)"affectedChangelist");
                Intrinsics.checkNotNullParameter((Object)diffData, (String)"diffData");
                return new Valid(affectedChangelist, diffData);
            }

            public static /* synthetic */ Valid copy$default(Valid valid, List list, TrackerDiffData trackerDiffData, int n, Object object) {
                if ((n & 1) != 0) {
                    list = valid.affectedChangelist;
                }
                if ((n & 2) != 0) {
                    trackerDiffData = valid.diffData;
                }
                return valid.copy(list, trackerDiffData);
            }

            @NotNull
            public String toString() {
                return "Valid(affectedChangelist=" + this.affectedChangelist + ", diffData=" + this.diffData + ")";
            }

            public int hashCode() {
                int result2 = ((Object)this.affectedChangelist).hashCode();
                result2 = result2 * 31 + this.diffData.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Valid)) {
                    return false;
                }
                Valid valid = (Valid)other;
                if (!Intrinsics.areEqual(this.affectedChangelist, valid.affectedChangelist)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.diffData, (Object)valid.diffData);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J7\u0010\u0015\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004J\n\u0010\u001b\u001a\u00020\u001cH\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/diff/lst/LocalTrackerDiffUtil$TrackerDiffData;", "", "ranges", "", "Lcom/intellij/openapi/vcs/ex/LocalRange;", "localText", "", "vcsText", "trackerVcsText", "<init>", "(Ljava/util/List;Ljava/lang/CharSequence;Ljava/lang/CharSequence;Ljava/lang/CharSequence;)V", "getRanges", "()Ljava/util/List;", "getLocalText", "()Ljava/lang/CharSequence;", "getVcsText", "getTrackerVcsText", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.vcs.impl"})
    private static final class TrackerDiffData {
        @NotNull
        private final List<LocalRange> ranges;
        @NotNull
        private final CharSequence localText;
        @NotNull
        private final CharSequence vcsText;
        @NotNull
        private final CharSequence trackerVcsText;

        public TrackerDiffData(@NotNull List<LocalRange> ranges, @NotNull CharSequence localText, @NotNull CharSequence vcsText, @NotNull CharSequence trackerVcsText) {
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            Intrinsics.checkNotNullParameter((Object)localText, (String)"localText");
            Intrinsics.checkNotNullParameter((Object)vcsText, (String)"vcsText");
            Intrinsics.checkNotNullParameter((Object)trackerVcsText, (String)"trackerVcsText");
            this.ranges = ranges;
            this.localText = localText;
            this.vcsText = vcsText;
            this.trackerVcsText = trackerVcsText;
        }

        @NotNull
        public final List<LocalRange> getRanges() {
            return this.ranges;
        }

        @NotNull
        public final CharSequence getLocalText() {
            return this.localText;
        }

        @NotNull
        public final CharSequence getVcsText() {
            return this.vcsText;
        }

        @NotNull
        public final CharSequence getTrackerVcsText() {
            return this.trackerVcsText;
        }

        @NotNull
        public final List<LocalRange> component1() {
            return this.ranges;
        }

        @NotNull
        public final CharSequence component2() {
            return this.localText;
        }

        @NotNull
        public final CharSequence component3() {
            return this.vcsText;
        }

        @NotNull
        public final CharSequence component4() {
            return this.trackerVcsText;
        }

        @NotNull
        public final TrackerDiffData copy(@NotNull List<LocalRange> ranges, @NotNull CharSequence localText, @NotNull CharSequence vcsText, @NotNull CharSequence trackerVcsText) {
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            Intrinsics.checkNotNullParameter((Object)localText, (String)"localText");
            Intrinsics.checkNotNullParameter((Object)vcsText, (String)"vcsText");
            Intrinsics.checkNotNullParameter((Object)trackerVcsText, (String)"trackerVcsText");
            return new TrackerDiffData(ranges, localText, vcsText, trackerVcsText);
        }

        public static /* synthetic */ TrackerDiffData copy$default(TrackerDiffData trackerDiffData, List list, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, Object object) {
            if ((n & 1) != 0) {
                list = trackerDiffData.ranges;
            }
            if ((n & 2) != 0) {
                charSequence = trackerDiffData.localText;
            }
            if ((n & 4) != 0) {
                charSequence2 = trackerDiffData.vcsText;
            }
            if ((n & 8) != 0) {
                charSequence3 = trackerDiffData.trackerVcsText;
            }
            return trackerDiffData.copy(list, charSequence, charSequence2, charSequence3);
        }

        @NotNull
        public String toString() {
            return "TrackerDiffData(ranges=" + this.ranges + ", localText=" + this.localText + ", vcsText=" + this.vcsText + ", trackerVcsText=" + this.trackerVcsText + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.ranges).hashCode();
            result2 = result2 * 31 + this.localText.hashCode();
            result2 = result2 * 31 + this.vcsText.hashCode();
            result2 = result2 * 31 + this.trackerVcsText.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TrackerDiffData)) {
                return false;
            }
            TrackerDiffData trackerDiffData = (TrackerDiffData)other;
            if (!Intrinsics.areEqual(this.ranges, trackerDiffData.ranges)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.localText, (Object)trackerDiffData.localText)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.vcsText, (Object)trackerDiffData.vcsText)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.trackerVcsText, (Object)trackerDiffData.trackerVcsText);
        }
    }
}

