/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.CommitMessageProvider;
import com.intellij.vcs.commit.CommitMessage;
import com.intellij.vcs.commit.CommitMessageUi;
import com.intellij.vcs.commit.DefaultCommitMessagePolicy;
import com.intellij.vcs.commit.DelayedCommitMessageProvider;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u0000 %2\u00020\u0001:\u0003%&'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0013H&J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0011H\u0004J\n\u0010#\u001a\u0004\u0018\u00010\u0011H$J\b\u0010$\u001a\u00020\u0013H$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u00188DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001aR\u0014\u0010\u001f\u001a\u0004\u0018\u00010 X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006("}, d2={"Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "commitMessageUi", "Lcom/intellij/vcs/commit/CommitMessageUi;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/commit/CommitMessageUi;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCommitMessageUi", "()Lcom/intellij/vcs/commit/CommitMessageUi;", "vcsConfiguration", "Lcom/intellij/openapi/vcs/VcsConfiguration;", "getVcsConfiguration", "()Lcom/intellij/openapi/vcs/VcsConfiguration;", "lastSetMessage", "Lcom/intellij/vcs/commit/CommitMessage;", "init", "", "onBeforeCommit", "onAfterCommit", "dispose", "clearMessageAfterCommit", "", "getClearMessageAfterCommit", "()Z", "setCommitMessage", "message", "currentMessageIsDisposable", "getCurrentMessageIsDisposable", "delayedMessagesProvidersSupport", "Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy$DelayedMessageProvidersSupport;", "getDelayedMessagesProvidersSupport", "()Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy$DelayedMessageProvidersSupport;", "getNewCommitMessage", "cleanupStoredMessage", "Companion", "DelayedMessageController", "DelayedMessageProvidersSupport", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public abstract class AbstractCommitMessagePolicy
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CommitMessageUi commitMessageUi;
    @Nullable
    private CommitMessage lastSetMessage;

    public AbstractCommitMessagePolicy(@NotNull Project project, @NotNull CommitMessageUi commitMessageUi) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commitMessageUi, (String)"commitMessageUi");
        this.project = project;
        this.commitMessageUi = commitMessageUi;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final CommitMessageUi getCommitMessageUi() {
        return this.commitMessageUi;
    }

    @NotNull
    protected final VcsConfiguration getVcsConfiguration() {
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)vcsConfiguration, (String)"getInstance(...)");
        return vcsConfiguration;
    }

    public final void init() {
        AbstractCommitMessagePolicy.Companion.listenForDelayedProviders(this.commitMessageUi, this);
        CommitMessage commitMessage = this.getNewCommitMessage();
        if (commitMessage == null) {
            commitMessage = CommitMessage.Companion.getEMPTY();
        }
        this.setCommitMessage(commitMessage);
    }

    public void onBeforeCommit() {
        if (!this.getCurrentMessageIsDisposable()) {
            String currentMessage = this.commitMessageUi.getText();
            this.getVcsConfiguration().saveCommitMessage(currentMessage);
        }
    }

    public void onAfterCommit() {
        if (this.getClearMessageAfterCommit()) {
            this.setCommitMessage(CommitMessage.Companion.getEMPTY());
            this.cleanupStoredMessage();
        } else {
            CommitMessage commitMessage = this.getNewCommitMessage();
            if (commitMessage == null) {
                commitMessage = CommitMessage.Companion.getEMPTY();
            }
            this.setCommitMessage(commitMessage);
        }
    }

    public abstract void dispose();

    protected boolean getClearMessageAfterCommit() {
        return this.getVcsConfiguration().CLEAR_INITIAL_COMMIT_MESSAGE;
    }

    protected final void setCommitMessage(@NotNull CommitMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.lastSetMessage = message;
        this.commitMessageUi.setText(message.getText());
    }

    protected final boolean getCurrentMessageIsDisposable() {
        CommitMessage commitMessage = this.lastSetMessage;
        if (commitMessage == null) {
            return false;
        }
        CommitMessage lastSetMessage = commitMessage;
        return lastSetMessage.getDisposable() && Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)lastSetMessage.getText())).toString(), (Object)((Object)StringsKt.trim((CharSequence)this.commitMessageUi.getText())).toString());
    }

    @Nullable
    protected abstract DelayedMessageProvidersSupport getDelayedMessagesProvidersSupport();

    @Nullable
    protected abstract CommitMessage getNewCommitMessage();

    protected abstract void cleanupStoredMessage();

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy$Companion;", "", "<init>", "()V", "listenForDelayedProviders", "", "commitMessageUi", "Lcom/intellij/vcs/commit/CommitMessageUi;", "messagePolicy", "Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy;", "getCommitMessageFromProvider", "Lcom/intellij/vcs/commit/CommitMessage;", "project", "Lcom/intellij/openapi/project/Project;", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void listenForDelayedProviders(CommitMessageUi commitMessageUi, AbstractCommitMessagePolicy messagePolicy) {
            DelayedMessageProvidersSupport delayedMessageProvidersSupport = messagePolicy.getDelayedMessagesProvidersSupport();
            if (delayedMessageProvidersSupport == null) {
                return;
            }
            DelayedMessageProvidersSupport delayedMessageSupport = delayedMessageProvidersSupport;
            DelayedMessageController controller = new DelayedMessageController(messagePolicy, delayedMessageSupport);
            Project project = messagePolicy.getProject();
            DefaultCommitMessagePolicy.Companion.getEXTENSION_POINT_NAME$intellij_platform_vcs_impl().forEachExtensionSafe(arg_0 -> Companion.listenForDelayedProviders$lambda$1(arg_0 -> Companion.listenForDelayedProviders$lambda$0(project, controller, messagePolicy, arg_0), arg_0));
            CommitMessageProvider.EXTENSION_POINT_NAME.forEachExtensionSafe(arg_0 -> Companion.listenForDelayedProviders$lambda$3(arg_0 -> Companion.listenForDelayedProviders$lambda$2(project, commitMessageUi, messagePolicy, arg_0), arg_0));
        }

        @Nullable
        public final CommitMessage getCommitMessageFromProvider(@NotNull Project project, @NotNull LocalChangeList changeList) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
            CommitMessage message = (CommitMessage)DefaultCommitMessagePolicy.Companion.getEXTENSION_POINT_NAME$intellij_platform_vcs_impl().computeSafeIfAny(arg_0 -> Companion.getCommitMessageFromProvider$lambda$0(project, arg_0));
            if (message != null) {
                return message;
            }
            return (CommitMessage)CommitMessageProvider.EXTENSION_POINT_NAME.computeSafeIfAny(arg_0 -> Companion.getCommitMessageFromProvider$lambda$1(changeList, project, arg_0));
        }

        private static final Unit listenForDelayedProviders$lambda$0(Project $project, DelayedMessageController $controller, AbstractCommitMessagePolicy $messagePolicy, DefaultCommitMessagePolicy extension) {
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            if (extension.enabled($project)) {
                extension.initAsyncMessageUpdate($project, $controller, $messagePolicy);
            }
            return Unit.INSTANCE;
        }

        private static final void listenForDelayedProviders$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Unit listenForDelayedProviders$lambda$2(Project $project, CommitMessageUi $commitMessageUi, AbstractCommitMessagePolicy $messagePolicy, CommitMessageProvider extension) {
            if (extension instanceof DelayedCommitMessageProvider) {
                ((DelayedCommitMessageProvider)extension).init($project, $commitMessageUi, $messagePolicy);
            }
            return Unit.INSTANCE;
        }

        private static final void listenForDelayedProviders$lambda$3(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final CommitMessage getCommitMessageFromProvider$lambda$0(Project $project, DefaultCommitMessagePolicy provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            return provider.enabled($project) ? provider.getMessage($project) : null;
        }

        private static final CommitMessage getCommitMessageFromProvider$lambda$1(LocalChangeList $changeList, Project $project, CommitMessageProvider provider) {
            String legacyProviderMessage = provider.getCommitMessage($changeList, $project);
            return legacyProviderMessage != null ? new CommitMessage(legacyProviderMessage, false, 2, null) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy$DelayedMessageController;", "Lcom/intellij/vcs/commit/DefaultCommitMessagePolicy$CommitMessageController;", "messagePolicy", "Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy;", "delayedMessageSupport", "Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy$DelayedMessageProvidersSupport;", "<init>", "(Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy;Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy$DelayedMessageProvidersSupport;)V", "getMessagePolicy", "()Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy;", "getDelayedMessageSupport", "()Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy$DelayedMessageProvidersSupport;", "setCommitMessage", "", "message", "Lcom/intellij/vcs/commit/CommitMessage;", "tryRestoreCommitMessage", "intellij.platform.vcs.impl"})
    private static final class DelayedMessageController
    implements DefaultCommitMessagePolicy.CommitMessageController {
        @NotNull
        private final AbstractCommitMessagePolicy messagePolicy;
        @NotNull
        private final DelayedMessageProvidersSupport delayedMessageSupport;

        public DelayedMessageController(@NotNull AbstractCommitMessagePolicy messagePolicy, @NotNull DelayedMessageProvidersSupport delayedMessageSupport) {
            Intrinsics.checkNotNullParameter((Object)messagePolicy, (String)"messagePolicy");
            Intrinsics.checkNotNullParameter((Object)delayedMessageSupport, (String)"delayedMessageSupport");
            this.messagePolicy = messagePolicy;
            this.delayedMessageSupport = delayedMessageSupport;
        }

        @NotNull
        public final AbstractCommitMessagePolicy getMessagePolicy() {
            return this.messagePolicy;
        }

        @NotNull
        public final DelayedMessageProvidersSupport getDelayedMessageSupport() {
            return this.delayedMessageSupport;
        }

        @Override
        public void setCommitMessage(@NotNull CommitMessage message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            if (!this.messagePolicy.getCurrentMessageIsDisposable()) {
                this.delayedMessageSupport.saveCurrentCommitMessage();
            }
            this.messagePolicy.setCommitMessage(message);
        }

        @Override
        public void tryRestoreCommitMessage() {
            if (this.messagePolicy.getCurrentMessageIsDisposable()) {
                CommitMessage commitMessage = this.delayedMessageSupport.restoredCommitMessage();
                if (commitMessage == null) {
                    commitMessage = CommitMessage.Companion.getEMPTY();
                }
                this.messagePolicy.setCommitMessage(commitMessage);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy$DelayedMessageProvidersSupport;", "", "saveCurrentCommitMessage", "", "restoredCommitMessage", "Lcom/intellij/vcs/commit/CommitMessage;", "intellij.platform.vcs.impl"})
    @ApiStatus.Internal
    public static interface DelayedMessageProvidersSupport {
        public void saveCurrentCommitMessage();

        @Nullable
        public CommitMessage restoredCommitMessage();
    }
}

