/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class StringContentIndentUtil {
    private static final Key<Integer> TEXT_BLOCK_INDENT_KEY = Key.create((String)"TextBlockOffset");
    private static final Key<List<RangeHighlighter>> TEXT_BLOCK_HIGHLIGHTERS_IN_EDITOR_KEY = Key.create((String)"TextBlockHighlightersInEditor");
    private static final Key<Long> LAST_TIME_CONTENT_INDENT_CHANGED = Key.create((String)"LastTimeContentIndentChanged");

    static boolean isDocumentUpdated(@NotNull Editor editor) {
        if (editor == null) {
            StringContentIndentUtil.$$$reportNull$$$0(0);
        }
        Document document = editor.getDocument();
        long stamp = StringContentIndentUtil.getTimestamp(editor, document);
        Long prevStamp = (Long)document.getUserData(LAST_TIME_CONTENT_INDENT_CHANGED);
        return prevStamp == null || prevStamp != stamp;
    }

    static void updateTimestamp(@NotNull Editor editor) {
        if (editor == null) {
            StringContentIndentUtil.$$$reportNull$$$0(1);
        }
        Document document = editor.getDocument();
        long timestamp = StringContentIndentUtil.getTimestamp(editor, document);
        document.putUserData(LAST_TIME_CONTENT_INDENT_CHANGED, (Object)timestamp);
    }

    private static long getTimestamp(@NotNull Editor editor, Document document) {
        if (editor == null) {
            StringContentIndentUtil.$$$reportNull$$$0(2);
        }
        return editor.getSettings().isIndentGuidesShown() ? document.getModificationStamp() : -1L;
    }

    @NotNull
    public static Map<TextRange, RangeHighlighter> getIndentHighlighters(@NotNull Editor editor) {
        List highlighters;
        if (editor == null) {
            StringContentIndentUtil.$$$reportNull$$$0(3);
        }
        if ((highlighters = (List)editor.getUserData(TEXT_BLOCK_HIGHLIGHTERS_IN_EDITOR_KEY)) == null) {
            Map<TextRange, RangeHighlighter> map = Collections.emptyMap();
            if (map == null) {
                StringContentIndentUtil.$$$reportNull$$$0(4);
            }
            return map;
        }
        Map<TextRange, RangeHighlighter> map = highlighters.stream().collect(Collectors.toMap(h -> h.getTextRange(), Function.identity()));
        if (map == null) {
            StringContentIndentUtil.$$$reportNull$$$0(5);
        }
        return map;
    }

    public static void addIndentHighlighters(@NotNull Editor editor, @NotNull List<RangeHighlighter> highlighters) {
        if (editor == null) {
            StringContentIndentUtil.$$$reportNull$$$0(6);
        }
        if (highlighters == null) {
            StringContentIndentUtil.$$$reportNull$$$0(7);
        }
        editor.putUserData(TEXT_BLOCK_HIGHLIGHTERS_IN_EDITOR_KEY, highlighters);
    }

    public static int getIndent(@NotNull RangeHighlighter highlighter) {
        Integer indent;
        if (highlighter == null) {
            StringContentIndentUtil.$$$reportNull$$$0(8);
        }
        return (indent = (Integer)highlighter.getUserData(TEXT_BLOCK_INDENT_KEY)) == null ? -1 : indent;
    }

    public static void setIndent(@NotNull RangeHighlighter highlighter, int indent) {
        if (highlighter == null) {
            StringContentIndentUtil.$$$reportNull$$$0(9);
        }
        highlighter.putUserData(TEXT_BLOCK_INDENT_KEY, (Object)indent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/StringContentIndentUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighters";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/StringContentIndentUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentHighlighters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDocumentUpdated";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateTimestamp";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTimestamp";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIndentHighlighters";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addIndentHighlighters";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setIndent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

