/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.impl.GlobalUsageHelper;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.DaemonTooltipsUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.reference.UnusedDeclarationFixProvider;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaClassFindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHelper;
import com.intellij.find.findUsages.JavaFindUsagesOptions;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.find.findUsages.JavaPackageFindUsagesOptions;
import com.intellij.find.findUsages.JavaVariableFindUsagesOptions;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnusedSymbolUtil {
    public static boolean isInjected(@NotNull Project project, @NotNull PsiModifierListOwner modifierListOwner) {
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(0);
        }
        if (modifierListOwner == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(1);
        }
        return EntryPointsManagerBase.getInstance(project).isEntryPoint((PsiElement)modifierListOwner);
    }

    public static boolean isImplicitUsage(@NotNull Project project, @NotNull PsiModifierListOwner element) {
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(2);
        }
        if (element == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(3);
        }
        if (UnusedSymbolUtil.isInjected(project, element)) {
            return true;
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            ProgressManager.checkCanceled();
            if (!provider.isImplicitUsage((PsiElement)element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isImplicitRead(@NotNull PsiVariable variable) {
        if (variable == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(4);
        }
        return UnusedSymbolUtil.isImplicitRead(variable.getProject(), variable);
    }

    public static boolean isImplicitRead(@NotNull Project project, @NotNull PsiVariable element) {
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(5);
        }
        if (element == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(6);
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            ProgressManager.checkCanceled();
            if (!provider.isImplicitRead((PsiElement)element)) continue;
            return true;
        }
        return UnusedSymbolUtil.isInjected(project, (PsiModifierListOwner)element);
    }

    public static boolean isImplicitWrite(@NotNull PsiVariable variable) {
        if (variable == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(7);
        }
        return UnusedSymbolUtil.isImplicitWrite(variable.getProject(), variable);
    }

    public static boolean isImplicitWrite(@NotNull Project project, @NotNull PsiVariable element) {
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(8);
        }
        if (element == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(9);
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            ProgressManager.checkCanceled();
            if (!provider.isImplicitWrite((PsiElement)element)) continue;
            return true;
        }
        return EntryPointsManager.getInstance((Project)project).isImplicitWrite((PsiElement)element);
    }

    @NotNull
    public static HighlightInfo.Builder createUnusedSymbolInfoBuilder(@NotNull PsiElement element, @NlsContexts.DetailedDescription @NotNull String message, @NotNull HighlightInfoType highlightInfoType, @Nullable String shortName) {
        if (element == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(10);
        }
        if (message == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(11);
        }
        if (highlightInfoType == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(12);
        }
        String tooltip = shortName != null ? DaemonTooltipsUtil.getWrappedTooltip((String)message, (String)shortName, (boolean)true) : XmlStringUtil.wrapInHtml((CharSequence)XmlStringUtil.escapeString((String)message));
        HighlightInfo.Builder info = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(element).description(message).escapedToolTip(tooltip).group(5);
        for (UnusedDeclarationFixProvider provider : UnusedDeclarationFixProvider.EP_NAME.getExtensionList()) {
            IntentionAction[] fixes;
            for (IntentionAction fix : fixes = provider.getQuickFixes(element)) {
                info.registerFix(fix, null, null, null, null);
            }
        }
        HighlightInfo.Builder builder = info;
        if (builder == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(13);
        }
        return builder;
    }

    public static boolean isFieldUsed(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiField field, @NotNull GlobalUsageHelper helper) {
        PsiEnumConstant enumConstant;
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(14);
        }
        if (containingFile == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(15);
        }
        if (field == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(16);
        }
        if (helper == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(17);
        }
        if (helper.isLocallyUsed((PsiNamedElement)field)) {
            return true;
        }
        if (field instanceof PsiEnumConstant && UnusedSymbolUtil.isEnumMethodUsed(project, containingFile, enumConstant = (PsiEnumConstant)field, helper)) {
            return true;
        }
        return !UnusedSymbolUtil.weAreSureThereAreNoUsages(project, containingFile, (PsiMember)field, helper);
    }

    public static boolean isMethodUsed(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiMethod method, @NotNull GlobalUsageHelper helper) {
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(18);
        }
        if (containingFile == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(19);
        }
        if (method == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(20);
        }
        if (helper == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(21);
        }
        if (helper.isLocallyUsed((PsiNamedElement)method)) {
            return true;
        }
        PsiClass containingClass = method.getContainingClass();
        if ("value".equals(method.getName()) && method.getReturnType() instanceof PsiArrayType && containingClass != null && containingClass.isAnnotationType() && UnusedSymbolUtil.isClassUsed(project, containingFile, containingClass, helper)) {
            return true;
        }
        boolean isPrivate = method.hasModifierProperty("private");
        if (JavaHighlightUtil.isSerializationRelatedMethod(method, containingClass)) {
            return true;
        }
        if (isPrivate) {
            if (UnusedSymbolUtil.isIntentionalPrivateConstructor(method, containingClass)) {
                return true;
            }
            if (UnusedSymbolUtil.isImplicitUsage(project, (PsiModifierListOwner)method)) {
                return true;
            }
            if (!helper.isCurrentFileAlreadyChecked()) {
                return !UnusedSymbolUtil.weAreSureThereAreNoUsages(project, containingFile, (PsiMember)method, helper);
            }
        } else {
            if (UnusedSymbolUtil.isTheOnlyConstructor(method, containingClass) && UnusedSymbolUtil.isClassUsed(project, containingFile, containingClass, helper)) {
                return true;
            }
            if (UnusedSymbolUtil.isImplicitUsage(project, (PsiModifierListOwner)method)) {
                return true;
            }
            if (!method.isConstructor() && FindSuperElementsHelper.findSuperElements((PsiElement)method).length != 0) {
                return true;
            }
            return !UnusedSymbolUtil.weAreSureThereAreNoUsages(project, containingFile, (PsiMember)method, helper);
        }
        return false;
    }

    private static boolean isTheOnlyConstructor(@NotNull PsiMethod method, @Nullable PsiClass containingClass) {
        if (method == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(22);
        }
        return method.isConstructor() && containingClass != null && containingClass.getConstructors().length == 1;
    }

    private static boolean weAreSureThereAreNoUsages(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiMember member, @NotNull GlobalUsageHelper helper) {
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(23);
        }
        if (containingFile == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(24);
        }
        if (member == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(25);
        }
        if (helper == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(26);
        }
        UnusedSymbolUtil.log("* " + member.getName() + ": call wearesure");
        if (!helper.shouldCheckUsages(member)) {
            UnusedSymbolUtil.log("* " + member.getName() + ": should not check");
            return false;
        }
        PsiFile ignoreFile = helper.isCurrentFileAlreadyChecked() ? containingFile : null;
        boolean sure = UnusedSymbolUtil.processUsages(project, containingFile, member, ignoreFile, (Processor<? super UsageInfo>)((Processor)info -> {
            PsiFile psiFile = info.getFile();
            if (psiFile == ignoreFile || psiFile == null) {
                return true;
            }
            int offset = info.getNavigationOffset();
            if (offset == -1) {
                return true;
            }
            PsiElement element = psiFile.findElementAt(offset);
            boolean inComment = element instanceof PsiComment;
            UnusedSymbolUtil.log("*     " + member.getName() + ": usage :" + String.valueOf(element));
            return inComment;
        }));
        UnusedSymbolUtil.log("*     " + member.getName() + ": result:" + sure);
        return sure;
    }

    private static void log(@NonNls String s) {
    }

    @NotNull
    public static SearchScope getUseScope(@NotNull PsiMember member) {
        Project project;
        SearchScope useScope;
        if (member == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(27);
        }
        if ((useScope = PsiSearchHelper.getInstance((Project)(project = member.getProject())).getUseScope((PsiElement)member)) instanceof GlobalSearchScope) {
            GlobalSearchScope globalUseScope = (GlobalSearchScope)useScope;
            if (member instanceof PsiClass) {
                GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)project);
                GlobalSearchScope xmlFilesScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)projectScope, (FileType[])new FileType[]{XmlFileType.INSTANCE});
                useScope = globalUseScope.uniteWith(xmlFilesScope);
            }
        }
        SearchScope searchScope = useScope;
        if (searchScope == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(28);
        }
        return searchScope;
    }

    public static boolean processUsages(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiMember member, @Nullable PsiFile ignoreFile, @NotNull Processor<? super UsageInfo> usageInfoProcessor) {
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(29);
        }
        if (containingFile == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(30);
        }
        if (member == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(31);
        }
        if (usageInfoProcessor == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(32);
        }
        return UnusedSymbolUtil.processUsages(project, containingFile, UnusedSymbolUtil.getUseScope(member), member, ignoreFile, usageInfoProcessor);
    }

    public static boolean processUsages(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull SearchScope useScope, @NotNull PsiMember member, @Nullable PsiFile ignoreFile, @NotNull Processor<? super UsageInfo> usageInfoProcessor) {
        JavaFindUsagesOptions options;
        String name;
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(33);
        }
        if (containingFile == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(34);
        }
        if (useScope == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(35);
        }
        if (member == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(36);
        }
        if (usageInfoProcessor == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(37);
        }
        if ((name = member.getName()) == null) {
            UnusedSymbolUtil.log("* " + member.getName() + " no name; false");
            return false;
        }
        PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)project);
        if (useScope instanceof GlobalSearchScope) {
            SearchScope fileScope;
            String propertyName;
            PsiSearchHelper.SearchCostResult cheapEnough = searchHelper.isCheapEnoughToSearch(name, (GlobalSearchScope)useScope, ignoreFile);
            if (cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES && (member.hasModifierProperty("public") || member.hasModifierProperty("protected"))) {
                UnusedSymbolUtil.log("* " + member.getName() + " too many usages; false");
                return false;
            }
            if (cheapEnough == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES && !UnusedSymbolUtil.canBeReferencedViaWeirdNames(member, containingFile)) {
                UnusedSymbolUtil.log("* " + member.getName() + " 0 usages; true");
                return true;
            }
            if (member instanceof PsiMethod && member.hasModifierProperty("public") && (propertyName = PropertyUtilBase.getPropertyName((PsiMember)member)) != null && (fileScope = containingFile.getUseScope()) instanceof GlobalSearchScope && searchHelper.isCheapEnoughToSearch(propertyName, (GlobalSearchScope)fileScope, ignoreFile) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                UnusedSymbolUtil.log("* " + member.getName() + " too many prop usages; false");
                return false;
            }
        }
        SmartList toSearch = new SmartList((Object)member);
        if (member instanceof PsiPackage) {
            options = new JavaPackageFindUsagesOptions(useScope);
            ((FindUsagesOptions)options).isSearchForTextOccurrences = true;
        } else if (member instanceof PsiClass) {
            options = new JavaClassFindUsagesOptions(useScope);
            ((JavaClassFindUsagesOptions)options).isConstructorUsages = false;
            ((FindUsagesOptions)options).isSearchForTextOccurrences = true;
        } else if (member instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)member;
            options = new JavaMethodFindUsagesOptions(useScope);
            ((FindUsagesOptions)options).isSearchForTextOccurrences = method.isConstructor();
            toSearch.addAll(DeepestSuperMethodsSearch.search((PsiMethod)method).findAll());
        } else if (member instanceof PsiVariable) {
            options = new JavaVariableFindUsagesOptions(useScope);
            ((FindUsagesOptions)options).isSearchForTextOccurrences = false;
        } else {
            options = new FindUsagesOptions(useScope);
            ((FindUsagesOptions)options).isSearchForTextOccurrences = true;
        }
        ((FindUsagesOptions)options).isUsages = true;
        return ContainerUtil.process((Iterable)toSearch, arg_0 -> UnusedSymbolUtil.lambda$processUsages$1((FindUsagesOptions)options, usageInfoProcessor, arg_0));
    }

    private static boolean isEnumMethodUsed(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiEnumConstant enumConstant, @NotNull GlobalUsageHelper helper) {
        PsiClass containingClass;
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(38);
        }
        if (containingFile == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(39);
        }
        if (enumConstant == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(40);
        }
        if (helper == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(41);
        }
        if (!((containingClass = enumConstant.getContainingClass()) instanceof PsiClassImpl)) {
            return true;
        }
        PsiMethod valuesMethod = ((PsiClassImpl)containingClass).getValuesMethod();
        PsiMethod valueOfMethod = ((PsiClassImpl)containingClass).getValueOfMethod();
        return valuesMethod == null || UnusedSymbolUtil.isMethodUsed(project, containingFile, valuesMethod, helper) || valueOfMethod == null || UnusedSymbolUtil.isMethodUsed(project, containingFile, valueOfMethod, helper);
    }

    private static boolean canBeReferencedViaWeirdNames(@NotNull PsiMember member, @NotNull PsiFile containingFile) {
        if (member == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(42);
        }
        if (containingFile == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(43);
        }
        if (member instanceof PsiClass) {
            return false;
        }
        if (!(containingFile instanceof PsiJavaFile)) {
            return true;
        }
        if (member instanceof PsiField) {
            return false;
        }
        if (member instanceof PsiMethod) {
            return PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)((PsiMethod)member));
        }
        return false;
    }

    public static boolean isClassUsed(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiClass aClass, @NotNull GlobalUsageHelper helper) {
        Boolean result;
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(44);
        }
        if (containingFile == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(45);
        }
        if (aClass == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(46);
        }
        if (helper == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(47);
        }
        if ((result = helper.unusedClassCache.get(aClass)) == null) {
            result = UnusedSymbolUtil.isReallyUsed(project, containingFile, aClass, helper);
            helper.unusedClassCache.put(aClass, result);
        }
        return result;
    }

    private static boolean isReallyUsed(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiClass aClass, @NotNull GlobalUsageHelper helper) {
        if (project == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(48);
        }
        if (containingFile == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(49);
        }
        if (aClass == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(50);
        }
        if (helper == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(51);
        }
        if (UnusedSymbolUtil.isImplicitUsage(project, (PsiModifierListOwner)aClass) || helper.isLocallyUsed((PsiNamedElement)aClass)) {
            return true;
        }
        if (helper.isCurrentFileAlreadyChecked() && (aClass.getContainingClass() != null && aClass.hasModifierProperty("private") || aClass.getParent() instanceof PsiDeclarationStatement || aClass instanceof PsiTypeParameter)) {
            return false;
        }
        return !UnusedSymbolUtil.weAreSureThereAreNoUsages(project, containingFile, (PsiMember)aClass, helper);
    }

    private static boolean isIntentionalPrivateConstructor(@NotNull PsiMethod method, PsiClass containingClass) {
        if (method == null) {
            UnusedSymbolUtil.$$$reportNull$$$0(52);
        }
        return method.isConstructor() && containingClass != null && containingClass.getConstructors().length == 1;
    }

    private static /* synthetic */ boolean lambda$processUsages$1(FindUsagesOptions options, Processor usageInfoProcessor, PsiMember m) {
        return JavaFindUsagesHelper.processElementUsages((PsiElement)m, options, (Processor<? super UsageInfo>)usageInfoProcessor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoType";
                break;
            }
            case 13: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil";
                break;
            }
            case 15: 
            case 19: 
            case 24: 
            case 30: 
            case 34: 
            case 39: 
            case 43: 
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 17: 
            case 21: 
            case 26: 
            case 41: 
            case 47: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 20: 
            case 22: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 25: 
            case 27: 
            case 31: 
            case 36: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfoProcessor";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useScope";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumConstant";
                break;
            }
            case 46: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnusedSymbolInfoBuilder";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInjected";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitUsage";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitRead";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitWrite";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createUnusedSymbolInfoBuilder";
                break;
            }
            case 13: 
            case 28: {
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isFieldUsed";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isMethodUsed";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isTheOnlyConstructor";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "weAreSureThereAreNoUsages";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getUseScope";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "processUsages";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isEnumMethodUsed";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "canBeReferencedViaWeirdNames";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isClassUsed";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isReallyUsed";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isIntentionalPrivateConstructor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 28 -> new IllegalStateException(string);
        };
    }
}

