/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.java.syntax.JavaSyntaxBundle;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HighlightFixTypoUtil {
    private static final List<ModifierHandler> MODIFIERS = List.of(new ModifierHandler(new String[]{"public", "protected", "private"}, e -> true, (m, e) -> true), new ModifierHandler(new String[]{"static", "default"}, e -> e.getParent() instanceof PsiClass, (m, e) -> {
        PsiClass psiClass;
        PsiElement patt0$temp;
        return !"default".equals(m) || (patt0$temp = e.getParent()) instanceof PsiClass && (psiClass = (PsiClass)patt0$temp).isInterface() && PsiUtil.isAvailable((JavaFeature)JavaFeature.STATIC_INTERFACE_CALLS, (PsiElement)e);
    }), new ModifierHandler(new String[]{"final", "abstract"}, e -> true, (m, e) -> true), new ModifierHandler(new String[]{"sealed", "non-sealed"}, e -> true, (m, e) -> PsiUtil.isAvailable((JavaFeature)JavaFeature.SEALED_CLASSES, (PsiElement)e)), new ModifierHandler(new String[]{"volatile"}, e -> e.getParent() instanceof PsiField, (m, e) -> true));

    private HighlightFixTypoUtil() {
    }

    @Nullable
    static CommonIntentionAction createKeywordTypoFix(@Nullable PsiErrorElement psiErrorElement) {
        if (psiErrorElement == null) {
            return null;
        }
        ModCommandAction fix = HighlightFixTypoUtil.createThrowsTypoFix(psiErrorElement);
        if (fix != null) {
            return fix;
        }
        fix = HighlightFixTypoUtil.createImplementExtendTypoFix(psiErrorElement);
        return fix;
    }

    @Nullable
    static CommonIntentionAction createKeywordTypoFix(@Nullable PsiStatement psiStatement) {
        if (psiStatement == null) {
            return null;
        }
        ModCommandAction fix = HighlightFixTypoUtil.createSwitchDefaultTypoFix(psiStatement);
        return fix;
    }

    private static ModCommandAction createSwitchDefaultTypoFix(@NotNull PsiStatement statement) {
        PsiCodeBlock codeBlock;
        if (statement == null) {
            HighlightFixTypoUtil.$$$reportNull$$$0(0);
        }
        if (!(statement instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
        PsiExpression psiExpression = expressionStatement.getExpression();
        if (!(psiExpression instanceof PsiLambdaExpression)) {
            return null;
        }
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)psiExpression;
        PsiParameterList parameterList = lambdaExpression.getParameterList();
        if (parameterList.getParametersCount() != 1) {
            return null;
        }
        PsiParameter parameter = parameterList.getParameter(0);
        PsiElement psiElement = statement.getParent();
        if (!(psiElement instanceof PsiCodeBlock) || !((codeBlock = (PsiCodeBlock)psiElement).getParent() instanceof PsiSwitchBlock)) {
            return null;
        }
        return QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)parameter, Collections.singleton("default"));
    }

    @Nullable
    static CommonIntentionAction createKeywordTypoFix(@Nullable PsiLabeledStatement labeledStatement) {
        if (labeledStatement == null) {
            return null;
        }
        ModCommandAction fix = HighlightFixTypoUtil.createSwitchDefaultTypoFix(labeledStatement);
        return fix;
    }

    @Nullable
    private static ModCommandAction createImplementExtendTypoFix(@NotNull PsiErrorElement psiErrorElement) {
        if (psiErrorElement == null) {
            HighlightFixTypoUtil.$$$reportNull$$$0(1);
        }
        boolean extendFound = false;
        boolean implementFound = false;
        PsiElement firstReferenceList = PsiTreeUtil.skipWhitespacesBackward((PsiElement)psiErrorElement);
        if (!(firstReferenceList instanceof PsiReferenceList)) {
            return null;
        }
        PsiReferenceList referenceList1 = (PsiReferenceList)firstReferenceList;
        PsiElement secondReferenceList = PsiTreeUtil.skipWhitespacesBackward((PsiElement)firstReferenceList);
        if (!(secondReferenceList instanceof PsiReferenceList)) {
            return null;
        }
        PsiReferenceList referenceList2 = (PsiReferenceList)secondReferenceList;
        for (PsiReferenceList list : Set.of(referenceList1, referenceList2)) {
            PsiJavaCodeReferenceElement ref;
            if (list.getChildren().length == 0) continue;
            PsiElement firstChild = list.getFirstChild();
            if (firstChild instanceof PsiKeyword && "extends".equals(firstChild.getText())) {
                if (extendFound) {
                    return null;
                }
                extendFound = true;
                continue;
            }
            if (!(firstChild instanceof PsiJavaCodeReferenceElement) || !"implements".equals((ref = (PsiJavaCodeReferenceElement)firstChild).getText())) continue;
            if (implementFound) {
                return null;
            }
            implementFound = true;
        }
        PsiElement typeParameters = PsiTreeUtil.skipWhitespacesBackward((PsiElement)secondReferenceList);
        if (!(typeParameters instanceof PsiTypeParameterList)) {
            return null;
        }
        PsiElement identifier = PsiTreeUtil.skipWhitespacesBackward((PsiElement)typeParameters);
        if (!(identifier instanceof PsiIdentifier)) {
            return null;
        }
        PsiElement classKeyword = PsiTreeUtil.skipWhitespacesBackward((PsiElement)identifier);
        if (!(classKeyword instanceof PsiKeyword)) {
            return null;
        }
        PsiErrorElement targetElement = psiErrorElement.getChildren().length < 2 ? psiErrorElement : psiErrorElement.getChildren()[0];
        return switch (classKeyword.getText()) {
            case "class" -> {
                HashSet<String> keywords = new HashSet<String>();
                if (!extendFound) {
                    keywords.add("extends");
                }
                if (!implementFound) {
                    keywords.add("implements");
                }
                yield QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)targetElement, keywords);
            }
            case "interface" -> {
                HashSet<String> keywords = new HashSet<String>();
                if (!extendFound) {
                    keywords.add("extends");
                }
                yield QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)targetElement, keywords);
            }
            case "enum", "record" -> {
                HashSet<String> keywords = new HashSet<String>();
                if (!implementFound) {
                    keywords.add("implements");
                }
                yield QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)targetElement, keywords);
            }
            default -> null;
        };
    }

    @Nullable
    private static ModCommandAction createThrowsTypoFix(@NotNull PsiErrorElement psiErrorElement) {
        PsiParameterList parameterList;
        PsiJavaToken token;
        PsiElement prevVisibleLeaf;
        if (psiErrorElement == null) {
            HighlightFixTypoUtil.$$$reportNull$$$0(2);
        }
        if (!((prevVisibleLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)psiErrorElement)) instanceof PsiJavaToken) || (token = (PsiJavaToken)prevVisibleLeaf).getTokenType() != JavaTokenType.RPARENTH) {
            return null;
        }
        PsiElement psiElement = token.getParent();
        if (!(psiElement instanceof PsiParameterList) || !((parameterList = (PsiParameterList)psiElement).getParent() instanceof PsiMethod)) {
            return null;
        }
        PsiErrorElement element = psiErrorElement.getChildren().length < 2 ? psiErrorElement : psiErrorElement.getChildren()[0];
        return QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)element, Collections.singleton("throws"));
    }

    @Nullable
    static CommonIntentionAction createKeywordTypoFix(@Nullable PsiMethodCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            return null;
        }
        if (methodCallExpression.getMethodExpression().getQualifierExpression() != null) {
            return null;
        }
        CommonIntentionAction action = HighlightFixTypoUtil.createSynchronizedSwitchTypoFix(methodCallExpression);
        if (action != null) {
            return action;
        }
        action = HighlightFixTypoUtil.createCatchFinallyTypoFix((PsiJavaCodeReferenceElement)methodCallExpression.getMethodExpression());
        return action;
    }

    @Nullable
    private static CommonIntentionAction createSynchronizedSwitchTypoFix(@NotNull PsiMethodCallExpression methodCallExpression) {
        PsiExpressionList argumentList;
        PsiExpression[] expressions;
        if (methodCallExpression == null) {
            HighlightFixTypoUtil.$$$reportNull$$$0(3);
        }
        if ((expressions = (argumentList = methodCallExpression.getArgumentList()).getExpressions()).length != 0 && expressions.length != 1) {
            return null;
        }
        HashSet<String> keywords = new HashSet<String>();
        PsiElement parent = methodCallExpression.getParent();
        if (parent instanceof PsiExpressionStatement) {
            keywords.add("synchronized");
            keywords.add("switch");
        } else if (parent instanceof PsiExpression || parent instanceof PsiExpressionList || parent instanceof PsiReturnStatement) {
            keywords.add("switch");
        }
        return QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)methodCallExpression.getMethodExpression(), keywords);
    }

    @Nullable
    static CommonIntentionAction createKeywordTypoFix(@Nullable PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            return null;
        }
        if (ref.isQualified()) {
            return null;
        }
        CommonIntentionAction action = HighlightFixTypoUtil.createVariableTypeTypoFix(ref);
        if (action != null) {
            return action;
        }
        action = HighlightFixTypoUtil.createBooleanNullTypoFix(ref);
        if (action != null) {
            return action;
        }
        action = HighlightFixTypoUtil.createBreakContinueTypoFix(ref);
        if (action != null) {
            return action;
        }
        action = HighlightFixTypoUtil.createSynchronizedSwitchTypoFix(ref);
        if (action != null) {
            return action;
        }
        action = HighlightFixTypoUtil.createClassTypoFix(ref);
        if (action != null) {
            return action;
        }
        action = HighlightFixTypoUtil.createModifiersTypoFix(ref);
        if (action != null) {
            return action;
        }
        action = HighlightFixTypoUtil.createCatchFinallyTypoFix(ref);
        if (action != null) {
            return action;
        }
        action = HighlightFixTypoUtil.createSwitchDefaultTypoFix(ref);
        if (action != null) {
            return action;
        }
        action = HighlightFixTypoUtil.createReturnTypoFix(ref);
        if (action != null) {
            return action;
        }
        action = HighlightFixTypoUtil.createNewTypoFix(ref);
        return action;
    }

    @Nullable
    private static CommonIntentionAction createNewTypoFix(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiReferenceExpression referenceExpression;
        PsiIdentifier identifier;
        PsiElement psiElement;
        if (ref == null) {
            HighlightFixTypoUtil.$$$reportNull$$$0(4);
        }
        if (!(ref instanceof PsiReferenceExpression)) {
            return null;
        }
        if (!(ref.getNextSibling() instanceof PsiErrorElement)) {
            return null;
        }
        PsiElement nextVisibleLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)ref);
        if (!(nextVisibleLeaf instanceof PsiIdentifier && (psiElement = (identifier = (PsiIdentifier)nextVisibleLeaf).getParent()) instanceof PsiReferenceExpression && (referenceExpression = (PsiReferenceExpression)psiElement).getParent() instanceof PsiMethodCallExpression)) {
            return null;
        }
        return QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)ref, Collections.singleton("new"));
    }

    @Nullable
    private static CommonIntentionAction createReturnTypoFix(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiErrorElement errorElement;
        PsiElement psiElement;
        PsiReferenceExpression referenceExpression;
        PsiStatement statement;
        if (ref == null) {
            HighlightFixTypoUtil.$$$reportNull$$$0(5);
        }
        boolean possiblePlace = false;
        PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)ref, PsiStatement.class);
        if (psiElement2 instanceof PsiStatement && (statement = (PsiStatement)psiElement2).getParent() instanceof PsiIfStatement) {
            possiblePlace = true;
        }
        if (!possiblePlace) {
            PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiCodeBlock.class);
            if (codeBlock == null) {
                return null;
            }
            PsiStatement[] statements = codeBlock.getStatements();
            if (statements.length == 0) {
                return null;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)statements[statements.length - 1], (PsiElement)ref, (boolean)false)) {
                possiblePlace = true;
            }
            if (statements.length > 1 && PsiTreeUtil.isAncestor((PsiElement)statements[statements.length - 2], (PsiElement)ref, (boolean)false) && PsiTreeUtil.hasErrorElements((PsiElement)statements[statements.length - 2])) {
                possiblePlace = true;
            }
        }
        if (!possiblePlace) {
            return null;
        }
        if (ref instanceof PsiReferenceExpression && (referenceExpression = (PsiReferenceExpression)ref).getParent() instanceof PsiExpressionStatement && (psiElement = ref.getNextSibling()) instanceof PsiErrorElement && (errorElement = (PsiErrorElement)psiElement).getErrorDescription().equals(JavaSyntaxBundle.message((String)"expected.semicolon", (Object[])new Object[0]))) {
            return QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)ref, Collections.singleton("return"));
        }
        if (ref.getParent() instanceof PsiTypeElement) {
            return QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)ref, Collections.singleton("return"));
        }
        return null;
    }

    @Nullable
    private static CommonIntentionAction createSwitchDefaultTypoFix(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiCodeBlock codeBlock;
        PsiExpressionStatement expressionStatement;
        PsiElement psiElement;
        if (ref == null) {
            HighlightFixTypoUtil.$$$reportNull$$$0(6);
        }
        if (!(ref instanceof PsiReferenceExpression && (psiElement = ref.getParent()) instanceof PsiExpressionStatement && (psiElement = (expressionStatement = (PsiExpressionStatement)psiElement).getParent()) instanceof PsiCodeBlock && (codeBlock = (PsiCodeBlock)psiElement).getParent() instanceof PsiSwitchBlock)) {
            return null;
        }
        return QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)ref, Collections.singleton("default"));
    }

    @Nullable
    private static ModCommandAction createSwitchDefaultTypoFix(@NotNull PsiLabeledStatement labeledStatement) {
        PsiCodeBlock codeBlock;
        PsiElement psiElement;
        if (labeledStatement == null) {
            HighlightFixTypoUtil.$$$reportNull$$$0(7);
        }
        if (!((psiElement = labeledStatement.getParent()) instanceof PsiCodeBlock) || !((codeBlock = (PsiCodeBlock)psiElement).getParent() instanceof PsiSwitchBlock)) {
            return null;
        }
        PsiElement[] children = labeledStatement.getChildren();
        if (children.length < 2) {
            return null;
        }
        PsiElement child = children[0];
        if (!(child instanceof PsiIdentifier)) {
            return null;
        }
        PsiIdentifier identifier = (PsiIdentifier)child;
        return QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)identifier, Collections.singleton("default"));
    }

    @Nullable
    private static CommonIntentionAction createCatchFinallyTypoFix(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiJavaToken token;
        if (ref == null) {
            HighlightFixTypoUtil.$$$reportNull$$$0(8);
        }
        if (!(ref instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement element = PsiTreeUtil.prevVisibleLeaf((PsiElement)ref);
        if (!(element instanceof PsiJavaToken) || (token = (PsiJavaToken)element).getTokenType() != JavaTokenType.RBRACE) {
            return null;
        }
        PsiElement psiElement = token.getParent();
        if (!(psiElement instanceof PsiCodeBlock)) {
            return null;
        }
        PsiCodeBlock block = (PsiCodeBlock)psiElement;
        PsiElement parent = block.getParent();
        if (!(parent instanceof PsiTryStatement) && !(parent instanceof PsiCatchSection)) {
            return null;
        }
        List<@NotNull String> keywords = ref.getParent() instanceof PsiMethodCallExpression ? List.of("catch") : List.of("catch", "finally");
        return QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)ref, keywords);
    }

    @Nullable
    private static CommonIntentionAction createModifiersTypoFix(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiJavaToken javaToken;
        PsiIdentifier identifier;
        PsiErrorElement errorElement;
        PsiErrorElement errorElement2;
        PsiIdentifier psiIdentifier;
        Object object;
        PsiElement psiElement;
        if (ref == null) {
            HighlightFixTypoUtil.$$$reportNull$$$0(9);
        }
        if (!((psiElement = ref.getParent()) instanceof PsiTypeElement)) {
            return null;
        }
        PsiTypeElement psiTypeElement = (PsiTypeElement)psiElement;
        PsiElement parent = psiTypeElement.getParent();
        if (!(parent instanceof PsiField || parent instanceof PsiClass || parent instanceof PsiJavaFile)) {
            return null;
        }
        boolean canBeModifier = false;
        PsiElement forward = PsiTreeUtil.skipWhitespacesForward((PsiElement)psiTypeElement);
        HashSet<String> existedModifiers = new HashSet<String>();
        if (forward instanceof PsiIdentifier && (object = PsiTreeUtil.skipWhitespacesForward((PsiElement)(psiIdentifier = (PsiIdentifier)forward))) instanceof PsiErrorElement && (errorElement2 = (PsiErrorElement)object).getErrorDescription().equals(JavaSyntaxBundle.message((String)"expected.semicolon", (Object[])new Object[0]))) {
            canBeModifier = true;
            HighlightFixTypoUtil.collectModifiers((PsiElement)psiIdentifier, existedModifiers);
        }
        if (!canBeModifier && forward instanceof PsiErrorElement && (errorElement = (PsiErrorElement)forward).getErrorDescription().equals(JavaSyntaxBundle.message((String)"expected.identifier", (Object[])new Object[0]))) {
            canBeModifier = true;
            PsiElement modifierListExpected = PsiTreeUtil.skipWhitespacesForward((PsiElement)errorElement);
            if (modifierListExpected != null && modifierListExpected.textMatches((CharSequence)"-")) {
                modifierListExpected = PsiTreeUtil.nextVisibleLeaf((PsiElement)modifierListExpected);
            }
            if (modifierListExpected instanceof PsiIdentifier) {
                identifier = (PsiIdentifier)modifierListExpected;
                modifierListExpected = PsiTreeUtil.nextVisibleLeaf((PsiElement)identifier);
            }
            HighlightFixTypoUtil.collectModifiers(modifierListExpected, existedModifiers);
        }
        if (!canBeModifier) {
            return null;
        }
        PsiElement modifierListExpected = PsiTreeUtil.skipWhitespacesBackward((PsiElement)psiTypeElement);
        if (modifierListExpected != null && modifierListExpected.getTextLength() == 0) {
            modifierListExpected = PsiTreeUtil.prevVisibleLeaf((PsiElement)modifierListExpected);
        }
        if (modifierListExpected instanceof PsiJavaToken && (javaToken = (PsiJavaToken)modifierListExpected).getTokenType() == JavaTokenType.MINUS && (modifierListExpected = PsiTreeUtil.prevVisibleLeaf((PsiElement)modifierListExpected)) instanceof PsiIdentifier) {
            identifier = (PsiIdentifier)modifierListExpected;
            modifierListExpected = PsiTreeUtil.prevVisibleLeaf((PsiElement)identifier);
        }
        HighlightFixTypoUtil.collectModifiers(modifierListExpected, existedModifiers);
        HashSet<String> modifiers = new HashSet<String>();
        for (ModifierHandler modifier : MODIFIERS) {
            modifier.addModifier(modifiers, existedModifiers, (PsiElement)psiTypeElement);
        }
        return QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)psiTypeElement, modifiers);
    }

    private static void collectModifiers(@Nullable PsiElement modifierListExpected, @NotNull Set<String> existedModifiers) {
        if (existedModifiers == null) {
            HighlightFixTypoUtil.$$$reportNull$$$0(10);
        }
        if (modifierListExpected == null) {
            return;
        }
        PsiElement canBeModifierList = modifierListExpected;
        if (canBeModifierList instanceof PsiModifierListOwner) {
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)canBeModifierList;
            canBeModifierList = modifierListOwner.getModifierList();
        }
        if (canBeModifierList instanceof PsiModifierList) {
            PsiModifierList modifierList = (PsiModifierList)canBeModifierList;
            for (PsiElement element : modifierList.getChildren()) {
                if (!(element instanceof PsiKeyword)) continue;
                PsiKeyword keyword = (PsiKeyword)element;
                existedModifiers.add(keyword.getText());
            }
        }
        if (modifierListExpected instanceof PsiField) {
            PsiField field = (PsiField)modifierListExpected;
            existedModifiers.add((String)HighlightFixTypoUtil.tryExtendKeyword((PsiElement)field.getNameIdentifier()).first);
        }
        if (modifierListExpected instanceof PsiIdentifier || modifierListExpected instanceof PsiKeyword) {
            existedModifiers.add((String)HighlightFixTypoUtil.tryExtendKeyword((PsiElement)modifierListExpected).first);
        }
    }

    @Nullable
    private static CommonIntentionAction createClassTypoFix(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiField field;
        PsiErrorElement errorElement;
        PsiIdentifier identifier;
        PsiErrorElement errorElement2;
        PsiElement psiElement;
        if (ref == null) {
            HighlightFixTypoUtil.$$$reportNull$$$0(11);
        }
        if (!((psiElement = ref.getParent()) instanceof PsiTypeElement)) {
            return null;
        }
        PsiTypeElement typeElement = (PsiTypeElement)psiElement;
        PsiElement parent = typeElement.getParent();
        List<@NotNull String> keywords = List.of("class", "interface", "enum", "record");
        PsiElement psiElement2 = PsiTreeUtil.skipWhitespacesForward((PsiElement)typeElement);
        if (psiElement2 instanceof PsiErrorElement && (errorElement2 = (PsiErrorElement)psiElement2).getErrorDescription().equals(JavaSyntaxBundle.message((String)"expected.identifier", (Object[])new Object[0])) && (parent instanceof PsiClass || parent instanceof PsiJavaFile)) {
            return QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)typeElement, keywords);
        }
        PsiElement psiElement3 = PsiTreeUtil.skipWhitespacesForward((PsiElement)typeElement);
        if (psiElement3 instanceof PsiIdentifier && (psiElement3 = PsiTreeUtil.skipWhitespacesForward((PsiElement)(identifier = (PsiIdentifier)psiElement3))) instanceof PsiErrorElement && (errorElement = (PsiErrorElement)psiElement3).getErrorDescription().equals(JavaSyntaxBundle.message((String)"expected.semicolon", (Object[])new Object[0])) && parent instanceof PsiField && (field = (PsiField)parent).getInitializer() == null) {
            return QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)typeElement, keywords);
        }
        return null;
    }

    @Nullable
    private static CommonIntentionAction createSynchronizedSwitchTypoFix(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiExpressionStatement expressionStatement;
        PsiElement[] children;
        PsiElement psiElement;
        if (ref == null) {
            HighlightFixTypoUtil.$$$reportNull$$$0(12);
        }
        if ((psiElement = ref.getParent()) instanceof PsiExpressionStatement && (children = (expressionStatement = (PsiExpressionStatement)psiElement).getChildren()).length == 2 && children[0] == ref && children[1] instanceof PsiErrorElement) {
            return QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)ref, List.of("synchronized", "switch"));
        }
        return null;
    }

    @Nullable
    private static CommonIntentionAction createBreakContinueTypoFix(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiJavaToken javaToken;
        PsiElement psiElement;
        PsiExpressionStatement expressionStatement;
        PsiElement[] children;
        PsiElement psiElement2;
        if (ref == null) {
            HighlightFixTypoUtil.$$$reportNull$$$0(13);
        }
        if ((psiElement2 = ref.getParent()) instanceof PsiExpressionStatement && (children = (expressionStatement = (PsiExpressionStatement)psiElement2).getChildren()).length == 2 && children[0] == ref && (children[1] instanceof PsiErrorElement || (psiElement = children[1]) instanceof PsiJavaToken && (javaToken = (PsiJavaToken)psiElement).getTokenType() == JavaTokenType.SEMICOLON)) {
            HashSet<String> targetKeywords = new HashSet<String>();
            if (PsiTreeUtil.getParentOfType((PsiElement)expressionStatement, PsiLoopStatement.class) != null) {
                targetKeywords.add("break");
                targetKeywords.add("continue");
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)expressionStatement, PsiSwitchBlock.class) != null) {
                targetKeywords.add("break");
            }
            return QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)ref, targetKeywords);
        }
        return null;
    }

    private static CommonIntentionAction createBooleanNullTypoFix(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            HighlightFixTypoUtil.$$$reportNull$$$0(14);
        }
        if (ref instanceof PsiReferenceExpression) {
            PsiReferenceExpression expression = (PsiReferenceExpression)ref;
            HashSet<String> targetKeywords = new HashSet<String>();
            PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression, false);
            if (expectedType != null) {
                if (TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)PsiTypes.booleanType())) {
                    targetKeywords.add("true");
                    targetKeywords.add("false");
                }
                if (expectedType instanceof PsiClassType) {
                    targetKeywords.add("null");
                }
                return QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)ref, targetKeywords);
            }
        }
        return null;
    }

    @Nullable
    private static CommonIntentionAction createVariableTypeTypoFix(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiExpressionStatement expressionStatement;
        PsiElement[] children;
        PsiElement parent;
        block9: {
            PsiVariable variable;
            PsiTypeElement typeElement;
            block11: {
                block10: {
                    PsiParameter parameter;
                    PsiElement psiElement;
                    if (ref == null) {
                        HighlightFixTypoUtil.$$$reportNull$$$0(15);
                    }
                    if (!((psiElement = ref.getParent()) instanceof PsiTypeElement)) break block9;
                    typeElement = (PsiTypeElement)psiElement;
                    parent = typeElement.getParent();
                    if (parent instanceof PsiClass && typeElement.getNextSibling() instanceof PsiErrorElement) {
                        return QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)typeElement, (Collection)PsiTypes.primitiveTypeNames());
                    }
                    if (!(parent instanceof PsiVariable)) break block10;
                    variable = (PsiVariable)parent;
                    if (!(parent instanceof PsiParameter) || (parameter = (PsiParameter)parent).getParent() instanceof PsiParameterList) break block11;
                }
                return null;
            }
            HashSet<String> targetKeywords = new HashSet<String>(PsiTypes.primitiveTypeNames());
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null && initializer.getType() != null) {
                PsiType initializerType = initializer.getType();
                targetKeywords.removeIf(t -> {
                    PsiPrimitiveType targetType = PsiTypes.primitiveTypeByName((String)t);
                    if (targetType == null) {
                        return true;
                    }
                    return !TypeConversionUtil.isAssignable((PsiType)targetType, (PsiType)initializerType);
                });
            }
            if (parent instanceof PsiLocalVariable && PsiUtil.isAvailable((JavaFeature)JavaFeature.LVTI, (PsiElement)parent)) {
                targetKeywords.add("var");
            }
            return QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)typeElement, targetKeywords);
        }
        parent = ref.getParent();
        if (parent instanceof PsiExpressionStatement && (children = (expressionStatement = (PsiExpressionStatement)parent).getChildren()).length == 2 && children[0] == ref && children[1] instanceof PsiErrorElement) {
            HashSet<String> targetKeywords = new HashSet<String>(PsiTypes.primitiveTypeNames());
            if (PsiUtil.isAvailable((JavaFeature)JavaFeature.LVTI, (PsiElement)expressionStatement)) {
                targetKeywords.add("var");
            }
            return QuickFixFactory.getInstance().createChangeToSimilarKeyword((PsiElement)ref, targetKeywords);
        }
        return null;
    }

    @NotNull
    public static Pair<String, TextRange> tryExtendKeyword(@NotNull PsiElement old) {
        PsiElement secondPart;
        PsiJavaToken javaToken;
        PsiElement psiElement;
        if (old == null) {
            HighlightFixTypoUtil.$$$reportNull$$$0(16);
        }
        if ((psiElement = PsiTreeUtil.nextVisibleLeaf((PsiElement)old)) instanceof PsiJavaToken && (javaToken = (PsiJavaToken)psiElement).getTokenType() == JavaTokenType.MINUS && ((secondPart = PsiTreeUtil.nextVisibleLeaf((PsiElement)javaToken)) instanceof PsiIdentifier || secondPart instanceof PsiKeyword)) {
            String newText = old.getText() + "-" + secondPart.getText();
            TextRange newTextRange = new TextRange(old.getTextRange().getStartOffset(), secondPart.getTextRange().getEndOffset());
            return new Pair((Object)newText, (Object)newTextRange);
        }
        Object newText = PsiTreeUtil.prevVisibleLeaf((PsiElement)old);
        if (newText instanceof PsiJavaToken && (javaToken = (PsiJavaToken)newText).getTokenType() == JavaTokenType.MINUS && (newText = PsiTreeUtil.prevVisibleLeaf((PsiElement)javaToken)) instanceof PsiIdentifier) {
            PsiIdentifier identifier = (PsiIdentifier)newText;
            newText = identifier.getText() + "-" + old.getText();
            TextRange newTextRange = new TextRange(identifier.getTextRange().getStartOffset(), old.getTextRange().getEndOffset());
            return new Pair(newText, (Object)newTextRange);
        }
        return new Pair((Object)old.getText(), (Object)old.getTextRange());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiErrorElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labeledStatement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existedModifiers";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "old";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightFixTypoUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createSwitchDefaultTypoFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createImplementExtendTypoFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createThrowsTypoFix";
                break;
            }
            case 3: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createSynchronizedSwitchTypoFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewTypoFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createReturnTypoFix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createCatchFinallyTypoFix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createModifiersTypoFix";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "collectModifiers";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createClassTypoFix";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "createBreakContinueTypoFix";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "createBooleanNullTypoFix";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createVariableTypeTypoFix";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "tryExtendKeyword";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record ModifierHandler(String @NotNull [] modifiers, @NotNull @NotNull Predicate<@NotNull PsiElement> condition, @NotNull @NotNull BiPredicate<@NotNull String, @NotNull PsiElement> modifierCondition) {
        private final String @NotNull [] modifiers;
        @NotNull
        private final @NotNull Predicate<@NotNull PsiElement> condition;
        @NotNull
        private final @NotNull BiPredicate<@NotNull String, @NotNull PsiElement> modifierCondition;

        private ModifierHandler(String @NotNull [] modifiers, @NotNull @NotNull Predicate<@NotNull PsiElement> condition, @NotNull @NotNull BiPredicate<@NotNull String, @NotNull PsiElement> modifierCondition) {
            if (condition == null) {
                ModifierHandler.$$$reportNull$$$0(0);
            }
            if (modifierCondition == null) {
                ModifierHandler.$$$reportNull$$$0(1);
            }
            if (modifiers == null) {
                ModifierHandler.$$$reportNull$$$0(2);
            }
        }

        public void addModifier(@NotNull @NotNull Set<@NotNull String> collected, @NotNull @NotNull Set<@NotNull String> existing, @NotNull PsiElement element) {
            if (collected == null) {
                ModifierHandler.$$$reportNull$$$0(3);
            }
            if (existing == null) {
                ModifierHandler.$$$reportNull$$$0(4);
            }
            if (element == null) {
                ModifierHandler.$$$reportNull$$$0(5);
            }
            if (!this.condition.test(element)) {
                return;
            }
            for (String modifier : this.modifiers) {
                if (!existing.contains(modifier)) continue;
                return;
            }
            for (String modifier : this.modifiers) {
                if (!this.modifierCondition.test(modifier, element)) continue;
                collected.add(modifier);
            }
        }

        public String @NotNull [] modifiers() {
            if (this.modifiers == null) {
                ModifierHandler.$$$reportNull$$$0(6);
            }
            return this.modifiers;
        }

        @NotNull
        public @NotNull Predicate<@NotNull PsiElement> condition() {
            Predicate<PsiElement> predicate = this.condition;
            if (predicate == null) {
                ModifierHandler.$$$reportNull$$$0(7);
            }
            return predicate;
        }

        @NotNull
        public @NotNull BiPredicate<@NotNull String, @NotNull PsiElement> modifierCondition() {
            BiPredicate<String, PsiElement> biPredicate = this.modifierCondition;
            if (biPredicate == null) {
                ModifierHandler.$$$reportNull$$$0(8);
            }
            return biPredicate;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifierCondition";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifiers";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collected";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existing";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightFixTypoUtil$ModifierHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightFixTypoUtil$ModifierHandler";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "modifiers";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "condition";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "modifierCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addModifier";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7, 8 -> new IllegalStateException(string);
            };
        }
    }
}

