/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModCommandExecutor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeAnyChangeAbstractAdapter;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
final class OptimizeImportRestarter
implements Disposable {
    private final Project myProject;
    private final List<OptimizeRequest> queue = new ArrayList<OptimizeRequest>();

    static OptimizeImportRestarter getInstance(Project project) {
        return (OptimizeImportRestarter)project.getService(OptimizeImportRestarter.class);
    }

    OptimizeImportRestarter(Project project) {
        this.myProject = project;
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, (Object)new DaemonCodeAnalyzer.DaemonListener(){

            public void daemonFinished(@NotNull Collection<? extends FileEditor> __) {
                if (__ == null) {
                    1.$$$reportNull$$$0(0);
                }
                OptimizeImportRestarter.this.onDaemonFinished();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "__", "com/intellij/codeInsight/daemon/impl/analysis/OptimizeImportRestarter$1", "daemonFinished"));
            }
        });
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeAnyChangeAbstractAdapter(){

            protected void onChange(@Nullable PsiFile __) {
                OptimizeImportRestarter.this.clear();
            }
        }, (Disposable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        List<OptimizeRequest> list = this.queue;
        synchronized (list) {
            this.queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDaemonFinished() {
        ArrayList<OptimizeRequest> requests;
        List<OptimizeRequest> list = this.queue;
        synchronized (list) {
            requests = new ArrayList<OptimizeRequest>(this.queue);
            this.queue.clear();
        }
        for (OptimizeRequest request : requests) {
            if (this.myProject.isDisposed()) break;
            PsiFile psiFile = request.psiFile();
            if (psiFile.getModificationStamp() != request.modificationStampBefore() || !psiFile.isWritable()) continue;
            ModCommandAction optimizeFix = request.optimizeFix();
            if (!DaemonCodeAnalyzerEx.getInstanceEx((Project)this.myProject).isErrorAnalyzingFinished(psiFile)) {
                this.scheduleOnDaemonFinish(psiFile, optimizeFix);
                continue;
            }
            ActionContext context = ActionContext.from(null, (PsiFile)psiFile);
            if (optimizeFix.getPresentation(context) == null) continue;
            ReadAction.nonBlocking(() -> optimizeFix.getPresentation(context) != null ? optimizeFix.perform(context) : ModCommand.nop()).expireWhen(() -> this.myProject.isDisposed() || psiFile.getModificationStamp() != request.modificationStampBefore()).finishOnUiThread(ModalityState.defaultModalityState(), command -> CommandProcessor.getInstance().executeCommand(this.myProject, () -> ModCommandExecutor.getInstance().executeInBatch(context, command), CodeInsightBundle.message((String)"process.optimize.imports", (Object[])new Object[0]), null)).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleOnDaemonFinish(@NotNull PsiFile psiFile, @NotNull ModCommandAction optimizeFix) {
        if (psiFile == null) {
            OptimizeImportRestarter.$$$reportNull$$$0(0);
        }
        if (optimizeFix == null) {
            OptimizeImportRestarter.$$$reportNull$$$0(1);
        }
        long modificationStampBefore = psiFile.getModificationStamp();
        List<OptimizeRequest> list = this.queue;
        synchronized (list) {
            this.queue.add(new OptimizeRequest(psiFile, modificationStampBefore, optimizeFix));
        }
    }

    public void dispose() {
        this.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "optimizeFix";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/analysis/OptimizeImportRestarter";
        objectArray[2] = "scheduleOnDaemonFinish";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record OptimizeRequest(@NotNull PsiFile psiFile, long modificationStampBefore, @NotNull ModCommandAction optimizeFix) {
        @NotNull
        private final PsiFile psiFile;
        @NotNull
        private final ModCommandAction optimizeFix;

        /*
         * WARNING - void declaration
         */
        private OptimizeRequest(@NotNull PsiFile psiFile, long modificationStampBefore, @NotNull ModCommandAction modCommandAction) {
            void optimizeFix;
            if (psiFile == null) {
                OptimizeRequest.$$$reportNull$$$0(0);
            }
            if (modCommandAction == null) {
                OptimizeRequest.$$$reportNull$$$0(1);
            }
            this.psiFile = psiFile;
            this.modificationStampBefore = modificationStampBefore;
            this.optimizeFix = optimizeFix;
        }

        @NotNull
        public PsiFile psiFile() {
            PsiFile psiFile = this.psiFile;
            if (psiFile == null) {
                OptimizeRequest.$$$reportNull$$$0(2);
            }
            return psiFile;
        }

        @NotNull
        public ModCommandAction optimizeFix() {
            ModCommandAction modCommandAction = this.optimizeFix;
            if (modCommandAction == null) {
                OptimizeRequest.$$$reportNull$$$0(3);
            }
            return modCommandAction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optimizeFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/OptimizeImportRestarter$OptimizeRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/OptimizeImportRestarter$OptimizeRequest";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "psiFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "optimizeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

