/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CompilerOptionFix;
import com.intellij.openapi.module.Module;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00070\u0005\u00a2\u0006\u0002\b\fH\u0014J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0014R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/daemon/impl/quickfix/AddExportsOptionFix;", "Lcom/intellij/codeInsight/daemon/impl/quickfix/CompilerOptionFix;", "module", "Lcom/intellij/openapi/module/Module;", "targetName", "", "packageName", "useName", "<init>", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "qualifier", "getText", "Lorg/jetbrains/annotations/Nls;", "update", "", "options", "", "intellij.java.analysis.impl"})
public final class AddExportsOptionFix
extends CompilerOptionFix {
    @NotNull
    private final String useName;
    @NotNull
    private final String qualifier;

    public AddExportsOptionFix(@NotNull Module module, @NotNull String targetName, @NotNull String packageName, @NotNull String useName) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)useName, (String)"useName");
        super(module);
        this.useName = useName;
        this.qualifier = targetName + "/" + packageName;
    }

    @Override
    @NotNull
    protected String getText() {
        Object[] objectArray = new Object[]{"--add-exports " + this.qualifier + "=" + this.useName};
        String string = QuickFixBundle.message("add.compiler.option.fix.name", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    protected void update(@NotNull List<String> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        int idx = -1;
        int candidate = -1;
        int offset = 0;
        Iterator iterator = ((Iterable)options).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            String option = (String)iterator.next();
            if (StringsKt.startsWith$default((String)option, (String)"--add-exports", (boolean)false, (int)2, null)) {
                if (option.length() == 13) {
                    candidate = i + 1;
                    offset = 0;
                } else if (option.charAt(13) == '=') {
                    candidate = i;
                    offset = 14;
                }
            }
            if (i != candidate || !StringsKt.startsWith$default((String)option, (String)this.qualifier, (int)offset, (boolean)false, (int)4, null)) continue;
            int qualifierEnd = this.qualifier.length() + offset;
            if (option.length() != qualifierEnd && option.charAt(qualifierEnd) != '=') continue;
            idx = i;
        }
        if (idx == -1) {
            Collection collection = options;
            Object[] objectArray = new String[]{"--add-exports", this.qualifier + "=" + this.useName};
            CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        } else {
            char[] cArray = new char[]{','};
            options.set(idx, StringsKt.trimEnd((String)options.get(idx), (char[])cArray) + "," + this.useName);
        }
    }
}

