/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddTypeArgumentsConditionalFix
extends PsiUpdateModCommandAction<PsiMethodCallExpression> {
    @NotNull
    private final PsiSubstitutor mySubstitutor;

    private AddTypeArgumentsConditionalFix(@NotNull PsiSubstitutor substitutor, @NotNull PsiMethodCallExpression expression) {
        if (substitutor == null) {
            AddTypeArgumentsConditionalFix.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            AddTypeArgumentsConditionalFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)expression);
        this.mySubstitutor = substitutor;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"add.explicit.type.arguments", (Object[])new Object[0]);
        if (string == null) {
            AddTypeArgumentsConditionalFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiMethodCallExpression call) {
        if (context == null) {
            AddTypeArgumentsConditionalFix.$$$reportNull$$$0(3);
        }
        if (call == null) {
            AddTypeArgumentsConditionalFix.$$$reportNull$$$0(4);
        }
        if (!this.mySubstitutor.isValid()) {
            return null;
        }
        String name = this.getFamilyName();
        PsiElement psiElement = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent());
        if (psiElement instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)psiElement;
            if (PsiTreeUtil.isAncestor((PsiElement)conditional.getThenExpression(), (PsiElement)call, (boolean)false)) {
                name = JavaAnalysisBundle.message((String)"add.explicit.type.arguments.then", (Object[])new Object[0]);
            } else if (PsiTreeUtil.isAncestor((PsiElement)conditional.getElseExpression(), (PsiElement)call, (boolean)false)) {
                name = JavaAnalysisBundle.message((String)"add.explicit.type.arguments.else", (Object[])new Object[0]);
            }
        }
        return Presentation.of((String)name).withPriority(PriorityAction.Priority.HIGH).withFixAllOption((ModCommandAction)this);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiMethodCallExpression call, @NotNull ModPsiUpdater updater) {
        Object withTypeArgsText;
        PsiMethod method;
        if (context == null) {
            AddTypeArgumentsConditionalFix.$$$reportNull$$$0(5);
        }
        if (call == null) {
            AddTypeArgumentsConditionalFix.$$$reportNull$$$0(6);
        }
        if (updater == null) {
            AddTypeArgumentsConditionalFix.$$$reportNull$$$0(7);
        }
        if ((method = call.resolveMethod()) == null) {
            return;
        }
        Object[] typeParameters = method.getTypeParameters();
        String typeArguments = "<" + StringUtil.join((Object[])typeParameters, parameter -> {
            PsiType substituteTypeParam = Objects.requireNonNull(this.mySubstitutor.substitute(parameter));
            return GenericsUtil.eliminateWildcards((PsiType)substituteTypeParam).getCanonicalText();
        }, (String)", ") + ">";
        PsiExpression expression = call.getMethodExpression().getQualifierExpression();
        if (expression != null) {
            withTypeArgsText = expression.getText();
        } else if (AddTypeArgumentsConditionalFix.isInStaticContext((PsiElement)call, null) || method.hasModifierProperty("static")) {
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            withTypeArgsText = aClass.getQualifiedName();
        } else {
            withTypeArgsText = "this";
        }
        withTypeArgsText = (String)withTypeArgsText + "." + typeArguments + call.getMethodExpression().getReferenceName();
        PsiExpression withTypeArgs = JavaPsiFacade.getElementFactory((Project)context.project()).createExpressionFromText((String)withTypeArgsText + call.getArgumentList().getText(), (PsiElement)call);
        call.replace((PsiElement)withTypeArgs);
    }

    public static boolean isInStaticContext(PsiElement element, @Nullable PsiClass aClass) {
        return PsiUtil.getEnclosingStaticElement((PsiElement)element, (PsiClass)aClass) != null;
    }

    public static void register(@NotNull Consumer<? super CommonIntentionAction> highlightInfo, @Nullable PsiExpression expression, @NotNull PsiType lType) {
        if (highlightInfo == null) {
            AddTypeArgumentsConditionalFix.$$$reportNull$$$0(8);
        }
        if (lType == null) {
            AddTypeArgumentsConditionalFix.$$$reportNull$$$0(9);
        }
        if (lType != PsiTypes.nullType() && expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression;
            PsiExpression thenExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)conditional.getThenExpression());
            PsiExpression elseExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)conditional.getElseExpression());
            if (thenExpression != null && elseExpression != null) {
                PsiType thenType = thenExpression.getType();
                PsiType elseType = elseExpression.getType();
                if (thenType != null && elseType != null) {
                    PsiMethodCallExpression call;
                    boolean thenAssignable = TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)thenType);
                    boolean elseAssignable = TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)elseType);
                    if (!thenAssignable && thenExpression instanceof PsiMethodCallExpression) {
                        call = (PsiMethodCallExpression)thenExpression;
                        AddTypeArgumentsConditionalFix.inferTypeArgs(highlightInfo, lType, call);
                    }
                    if (!elseAssignable && elseExpression instanceof PsiMethodCallExpression) {
                        call = (PsiMethodCallExpression)elseExpression;
                        AddTypeArgumentsConditionalFix.inferTypeArgs(highlightInfo, lType, call);
                    }
                }
            }
        }
    }

    private static void inferTypeArgs(@NotNull Consumer<? super ModCommandAction> fixConsumer, @NotNull PsiType lType, @NotNull PsiMethodCallExpression call) {
        PsiMethod method;
        if (fixConsumer == null) {
            AddTypeArgumentsConditionalFix.$$$reportNull$$$0(10);
        }
        if (lType == null) {
            AddTypeArgumentsConditionalFix.$$$reportNull$$$0(11);
        }
        if (call == null) {
            AddTypeArgumentsConditionalFix.$$$reportNull$$$0(12);
        }
        if ((method = call.resolveMethod()) != null) {
            PsiType returnType = method.getReturnType();
            PsiClass aClass = method.getContainingClass();
            if (returnType != null && aClass != null && aClass.getQualifiedName() != null) {
                JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)method.getProject());
                PsiDeclarationStatement variableDeclarationStatement = javaPsiFacade.getElementFactory().createVariableDeclarationStatement("xxx", lType, (PsiExpression)call, (PsiElement)call);
                PsiExpression initializer = Objects.requireNonNull(((PsiLocalVariable)variableDeclarationStatement.getDeclaredElements()[0]).getInitializer());
                PsiSubstitutor substitutor = javaPsiFacade.getResolveHelper().inferTypeArguments(method.getTypeParameters(), method.getParameterList().getParameters(), call.getArgumentList().getExpressions(), PsiSubstitutor.EMPTY, (PsiElement)initializer, (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
                PsiType substitutedType = substitutor.substitute(returnType);
                if (substitutedType != null && TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)substitutedType)) {
                    fixConsumer.accept((ModCommandAction)new AddTypeArgumentsConditionalFix(substitutor, call));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsConditionalFix";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfo";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsConditionalFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeArgs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

