/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdjustFunctionContextFix
extends PsiUpdateModCommandAction<PsiMethodCallExpression> {
    private static final Function<PsiMethodCallExpression, Function<PsiType, String>> MAP_NAME_ADJUSTER = call -> type -> {
        PsiType inType;
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (qualifier != null && type.equals(inType = StreamApiUtil.getStreamElementType(qualifier.getType()))) {
            return "map";
        }
        if (PsiTypes.intType().equals(type)) {
            return "mapToInt";
        }
        if (PsiTypes.longType().equals(type)) {
            return "mapToLong";
        }
        if (PsiTypes.doubleType().equals(type)) {
            return "mapToDouble";
        }
        return "mapToObj";
    };
    private static final Function<PsiType, String> FLAT_MAP_NAME_ADJUSTER = type -> {
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.stream.IntStream")) {
            return "flatMapToInt";
        }
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.stream.LongStream")) {
            return "flatMapToLong";
        }
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.stream.DoubleStream")) {
            return "flatMapToDouble";
        }
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.stream.Stream")) {
            return "flatMap";
        }
        return null;
    };
    private static final CallMapper<Function<PsiType, String>> METHOD_NAME_ADJUSTER = new CallMapper<Function<PsiMethodCallExpression, Function<PsiType, String>>>().register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.stream.IntStream", "map", "mapToLong", "mapToDouble"), CallMatcher.instanceCall("java.util.stream.LongStream", "map", "mapToInt", "mapToDouble"), CallMatcher.instanceCall("java.util.stream.DoubleStream", "map", "mapToInt", "mapToLong")), MAP_NAME_ADJUSTER).register((CallMatcher)CallMatcher.instanceCall("java.util.stream.Stream", "flatMap", "flatMapToInt", "flatMapToLong", "flatMapToDouble"), (Function<PsiMethodCallExpression, Function<PsiType, String>>)FLAT_MAP_NAME_ADJUSTER);
    private final String myOriginalName;
    private final String myNewName;

    private AdjustFunctionContextFix(@NotNull PsiMethodCallExpression call, @NotNull String targetMethodName) {
        if (call == null) {
            AdjustFunctionContextFix.$$$reportNull$$$0(0);
        }
        if (targetMethodName == null) {
            AdjustFunctionContextFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)call);
        this.myOriginalName = call.getMethodExpression().getReferenceName();
        this.myNewName = targetMethodName;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiMethodCallExpression call, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            AdjustFunctionContextFix.$$$reportNull$$$0(2);
        }
        if (call == null) {
            AdjustFunctionContextFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            AdjustFunctionContextFix.$$$reportNull$$$0(4);
        }
        ExpressionUtils.bindCallTo(call, this.myNewName);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiMethodCallExpression element) {
        if (context == null) {
            AdjustFunctionContextFix.$$$reportNull$$$0(5);
        }
        if (element == null) {
            AdjustFunctionContextFix.$$$reportNull$$$0(6);
        }
        return Presentation.of((String)QuickFixBundle.message("adjust.method.accepting.functional.expression.fix.text", this.myOriginalName, this.myNewName)).withPriority(PriorityAction.Priority.HIGH).withFixAllOption((ModCommandAction)this);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("adjust.method.accepting.functional.expression.fix.family.name", new Object[0]);
        if (string == null) {
            AdjustFunctionContextFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public static IntentionAction createFix(@NotNull PsiExpression expression) {
        PsiType actualReturnType;
        PsiFunctionalExpression fn;
        if (expression == null) {
            AdjustFunctionContextFix.$$$reportNull$$$0(8);
        }
        if ((fn = (PsiFunctionalExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiFunctionalExpression.class, (boolean)false)) == null) {
            return null;
        }
        if (expression instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)expression;
            actualReturnType = PsiMethodReferenceUtil.getMethodReferenceReturnType((PsiMethodReferenceExpression)methodRef);
        } else {
            actualReturnType = expression.getType();
        }
        return AdjustFunctionContextFix.createFix(actualReturnType, fn);
    }

    @Nullable
    public static IntentionAction createFix(@Nullable PsiType actualReturnType, @NotNull PsiFunctionalExpression fn) {
        PsiExpressionList expressionList;
        if (fn == null) {
            AdjustFunctionContextFix.$$$reportNull$$$0(9);
        }
        if ((expressionList = (PsiExpressionList)ObjectUtils.tryCast((Object)fn.getParent(), PsiExpressionList.class)) == null || expressionList.getExpressionCount() != 1) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expressionList.getParent(), PsiMethodCallExpression.class);
        Function<PsiType, String> remapper = METHOD_NAME_ADJUSTER.mapFirst(call);
        if (remapper == null) {
            return null;
        }
        String targetMethodName = remapper.apply(actualReturnType);
        if (targetMethodName == null) {
            return null;
        }
        return new AdjustFunctionContextFix(call, targetMethodName).asIntention();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMethodName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AdjustFunctionContextFix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AdjustFunctionContextFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

