/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArgumentFixerActionFactory {
    private static final Logger LOG = Logger.getInstance(ArgumentFixerActionFactory.class);

    @Nullable
    protected abstract PsiExpression getModifiedArgument(PsiExpression var1, PsiType var2) throws IncorrectOperationException;

    public void registerCastActions(CandidateInfo @NotNull [] candidates, @NotNull PsiCall call, @NotNull Consumer<? super CommonIntentionAction> info) {
        if (call == null) {
            ArgumentFixerActionFactory.$$$reportNull$$$0(0);
        }
        if (info == null) {
            ArgumentFixerActionFactory.$$$reportNull$$$0(1);
        }
        if (candidates == null) {
            ArgumentFixerActionFactory.$$$reportNull$$$0(2);
        }
        if (candidates.length == 0) {
            return;
        }
        ArrayList<CandidateInfo> methodCandidates = new ArrayList<CandidateInfo>(Arrays.asList(candidates));
        PsiExpressionList list = call.getArgumentList();
        if (list == null) {
            return;
        }
        PsiExpression[] expressions = list.getExpressions();
        if (expressions.length == 0) {
            return;
        }
        block2: for (int i = methodCandidates.size() - 1; i >= 0; --i) {
            CandidateInfo candidate = (CandidateInfo)methodCandidates.get(i);
            PsiMethod method = (PsiMethod)candidate.getElement();
            PsiSubstitutor substitutor = candidate.getSubstitutor();
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (expressions.length != parameters.length && !method.isVarArgs()) {
                methodCandidates.remove(i);
                continue;
            }
            for (int j = 0; j < Math.min(parameters.length, expressions.length); ++j) {
                PsiParameter parameter = parameters[j];
                PsiExpression expression = expressions[j];
                PsiType exprType = expression.getType();
                PsiType parameterType = substitutor.substitute(parameter.getType());
                if (exprType != null && parameterType != null && this.areTypesConvertible(exprType, parameterType, (PsiElement)call)) continue;
                methodCandidates.remove(i);
                continue block2;
            }
        }
        if (methodCandidates.isEmpty()) {
            return;
        }
        try {
            PsiType expectedTypeByParent = PsiTypesUtil.getExpectedTypeByParent((PsiElement)call);
            HashMap<Integer, Set> suggestedCasts = new HashMap<Integer, Set>();
            ArrayList<ArgumentCast> actualCasts = new ArrayList<ArgumentCast>();
            for (CandidateInfo candidate : methodCandidates) {
                ArgumentCast argumentCast2;
                PsiMethod method = (PsiMethod)candidate.getElement();
                PsiSubstitutor substitutor = candidate.getSubstitutor();
                PsiParameter[] parameters = method.getParameterList().getParameters();
                ArrayList<ArgumentCast> potentialCasts = new ArrayList<ArgumentCast>();
                for (int i = 0; i < expressions.length; ++i) {
                    PsiPrimitiveType unboxedParameterType;
                    PsiType psiType;
                    PsiExpression expression = expressions[i];
                    PsiExpression psiExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression);
                    if (psiExpression instanceof PsiFunctionalExpression) {
                        PsiFunctionalExpression fn = (PsiFunctionalExpression)psiExpression;
                        psiType = fn.getFunctionalInterfaceType();
                    } else {
                        psiType = expression.getType();
                    }
                    PsiType exprType = psiType;
                    PsiType originalParameterType = PsiTypesUtil.getParameterType((PsiParameter[])parameters, (int)i, (boolean)true);
                    PsiType parameterType = substitutor.substitute(originalParameterType);
                    if (!PsiTypesUtil.isDenotableType((PsiType)parameterType, (PsiElement)call) || suggestedCasts.computeIfAbsent(i, __ -> new HashSet()).contains(parameterType.getCanonicalText())) continue;
                    if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)exprType) && parameterType instanceof PsiClassType && (unboxedParameterType = PsiPrimitiveType.getUnboxedType((PsiType)parameterType)) != null) {
                        parameterType = unboxedParameterType;
                    }
                    if (Comparing.equal((Object)exprType, (Object)parameterType)) continue;
                    potentialCasts.add(new ArgumentCast(i, parameterType));
                }
                if (potentialCasts.isEmpty()) continue;
                PsiCall newCall = call;
                Iterator iterator = potentialCasts.iterator();
                while (iterator.hasNext() && (newCall = this.replaceWithCast(expressions, newCall, argumentCast2 = (ArgumentCast)iterator.next(), newCall == call)) != null) {
                }
                if (newCall != null) {
                    ArgumentFixerActionFactory.doCheckNewCall(expectedTypeByParent, newCall, () -> {
                        for (ArgumentCast argumentCast : potentialCasts) {
                            ArgumentFixerActionFactory.collectCast(actualCasts, suggestedCasts, argumentCast);
                        }
                        potentialCasts.clear();
                    });
                }
                for (ArgumentCast argumentCast2 : potentialCasts) {
                    PsiCall callWithSingleCast = this.replaceWithCast(expressions, call, argumentCast2, true);
                    if (callWithSingleCast == null) continue;
                    ArgumentFixerActionFactory.doCheckNewCall(expectedTypeByParent, callWithSingleCast, () -> ArgumentFixerActionFactory.collectCast(actualCasts, suggestedCasts, argumentCast2));
                }
            }
            this.putCompilableCastsFirst(actualCasts, expressions).forEach(cast -> this.registerCastIntention(info, list, (ArgumentCast)cast));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void doCheckNewCall(PsiType expectedTypeByParent, PsiCall call, Runnable registerIntentions) {
        JavaResolveResult resolveResult = call.resolveMethodGenerics();
        if (resolveResult.getElement() != null && resolveResult.isValidResult()) {
            PsiCallExpression callExpression;
            PsiType type;
            if (expectedTypeByParent != null && call instanceof PsiCallExpression && (type = (callExpression = (PsiCallExpression)call).getType()) != null && !TypeConversionUtil.isAssignable((PsiType)expectedTypeByParent, (PsiType)type)) {
                return;
            }
            registerIntentions.run();
        }
    }

    private void registerCastIntention(@NotNull Consumer<? super CommonIntentionAction> info, PsiExpressionList list, ArgumentCast argumentCast) {
        IntentionAction action;
        if (info == null) {
            ArgumentFixerActionFactory.$$$reportNull$$$0(3);
        }
        if ((action = this.createFix(list, argumentCast.argumentIndex(), argumentCast.castType())) != null) {
            info.accept((CommonIntentionAction)action);
        }
    }

    @Nullable
    private PsiCall replaceWithCast(PsiExpression[] expressions, @NotNull PsiCall origCall, ArgumentCast argumentCast, boolean shouldCopy) {
        PsiCall newCall;
        int i;
        PsiExpression modifiedExpression;
        if (origCall == null) {
            ArgumentFixerActionFactory.$$$reportNull$$$0(4);
        }
        if ((modifiedExpression = this.getModifiedArgument(expressions[i = argumentCast.argumentIndex()], argumentCast.castType())) == null) {
            return null;
        }
        PsiExpressionList argumentList = origCall.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        PsiCall psiCall = newCall = shouldCopy ? LambdaUtil.copyTopLevelCall((PsiCall)origCall) : origCall;
        if (newCall == null) {
            return null;
        }
        Objects.requireNonNull(newCall.getArgumentList()).getExpressions()[i].replace((PsiElement)modifiedExpression);
        return newCall;
    }

    private static void collectCast(@NotNull @NotNull List<@NotNull ArgumentCast> actualCasts, @NotNull @NotNull Map<@NotNull Integer, @NotNull Set<@NotNull String>> suggestedCasts, @NotNull ArgumentCast argumentCast) {
        if (actualCasts == null) {
            ArgumentFixerActionFactory.$$$reportNull$$$0(5);
        }
        if (suggestedCasts == null) {
            ArgumentFixerActionFactory.$$$reportNull$$$0(6);
        }
        if (argumentCast == null) {
            ArgumentFixerActionFactory.$$$reportNull$$$0(7);
        }
        actualCasts.add(argumentCast);
        suggestedCasts.get(argumentCast.argumentIndex()).add(argumentCast.castType().getCanonicalText());
    }

    private List<ArgumentCast> putCompilableCastsFirst(@NotNull @NotNull List<@NotNull ArgumentCast> casts, @NotNull @NotNull PsiExpression @NotNull [] expressions) {
        if (casts == null) {
            ArgumentFixerActionFactory.$$$reportNull$$$0(8);
        }
        if (expressions == null) {
            ArgumentFixerActionFactory.$$$reportNull$$$0(9);
        }
        ArrayList<ArgumentCast> compilableCasts = new ArrayList<ArgumentCast>();
        ArrayList<ArgumentCast> nonCompilableCasts = new ArrayList<ArgumentCast>();
        for (ArgumentCast argumentCast : casts) {
            if (this.doesFixCauseOtherCompilationErrors(expressions[argumentCast.argumentIndex()], argumentCast.castType())) {
                nonCompilableCasts.add(argumentCast);
                continue;
            }
            compilableCasts.add(argumentCast);
        }
        return ContainerUtil.concat(compilableCasts, nonCompilableCasts);
    }

    protected boolean doesFixCauseOtherCompilationErrors(@NotNull PsiExpression expression, @NotNull PsiType parameterType) {
        if (expression == null) {
            ArgumentFixerActionFactory.$$$reportNull$$$0(10);
        }
        if (parameterType == null) {
            ArgumentFixerActionFactory.$$$reportNull$$$0(11);
        }
        return false;
    }

    public abstract boolean areTypesConvertible(@NotNull PsiType var1, @NotNull PsiType var2, @NotNull PsiElement var3);

    public abstract IntentionAction createFix(PsiExpressionList var1, int var2, PsiType var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origCall";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualCasts";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedCasts";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentCast";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casts";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ArgumentFixerActionFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerCastActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerCastIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceWithCast";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "collectCast";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "putCompilableCastsFirst";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "doesFixCauseOtherCompilationErrors";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record ArgumentCast(int argumentIndex, @NotNull PsiType castType) {
        @NotNull
        private final PsiType castType;

        private ArgumentCast(int argumentIndex, @NotNull PsiType castType) {
            if (castType == null) {
                ArgumentCast.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public PsiType castType() {
            PsiType psiType = this.castType;
            if (psiType == null) {
                ArgumentCast.$$$reportNull$$$0(1);
            }
            return psiType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "castType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ArgumentFixerActionFactory$ArgumentCast";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ArgumentFixerActionFactory$ArgumentCast";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "castType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

