/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeTypeArgumentsFix
extends PsiUpdateModCommandAction<PsiNewExpression> {
    private static final Logger LOG = Logger.getInstance(ChangeTypeArgumentsFix.class);
    @NotNull
    private final PsiMethod myTargetMethod;
    @NotNull
    private final PsiClass myPsiClass;
    @NotNull
    private final @NotNull PsiExpression @NotNull [] myExpressions;

    ChangeTypeArgumentsFix(@NotNull PsiMethod targetMethod, @NotNull PsiClass psiClass, @NotNull @NotNull PsiExpression @NotNull [] expressions, @NotNull PsiNewExpression newExpression) {
        if (targetMethod == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(1);
        }
        if (newExpression == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(2);
        }
        if (expressions == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(3);
        }
        super((PsiElement)newExpression);
        this.myTargetMethod = targetMethod;
        this.myPsiClass = psiClass;
        this.myExpressions = expressions;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"change.type.arguments", (Object[])new Object[0]);
        if (string == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiNewExpression newExpression) {
        if (context == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(5);
        }
        if (newExpression == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(6);
        }
        if (!this.myPsiClass.isValid() || !this.myTargetMethod.isValid()) {
            return null;
        }
        PsiTypeParameter[] typeParameters = this.myPsiClass.getTypeParameters();
        if (typeParameters.length == 0 || newExpression.getArgumentList() == null) {
            return null;
        }
        PsiJavaCodeReferenceElement reference = newExpression.getClassOrAnonymousClassReference();
        if (reference == null) {
            return null;
        }
        PsiReferenceParameterList parameterList = reference.getParameterList();
        if (parameterList == null) {
            return null;
        }
        PsiSubstitutor substitutor = this.inferTypeArguments(newExpression);
        PsiParameter[] parameters = this.myTargetMethod.getParameterList().getParameters();
        if (parameters.length != this.myExpressions.length) {
            return null;
        }
        int length = parameters.length;
        for (int i = 0; i < length; ++i) {
            PsiParameter parameter = parameters[i];
            PsiType expectedType = substitutor.substitute(parameter.getType());
            if (!this.myExpressions[i].isValid()) {
                return null;
            }
            PsiType actualType = this.myExpressions[i].getType();
            if (expectedType != null && actualType != null && TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)actualType)) continue;
            return null;
        }
        for (PsiTypeParameter parameter : typeParameters) {
            if (substitutor.substitute(parameter) != null) continue;
            return null;
        }
        String typeParametersText = StringUtil.join((Object[])this.myPsiClass.getTypeParameters(), typeParameter -> {
            PsiType substituted = substitutor.substitute(typeParameter);
            return substituted != null ? substituted.getPresentableText() : "java.lang.Object";
        }, (String)", ");
        return Presentation.of((String)JavaAnalysisBundle.message((String)"change.type.arguments.to.0", (Object[])new Object[]{typeParametersText})).withPriority(PriorityAction.Priority.HIGH).withFixAllOption((ModCommandAction)this);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiNewExpression newExpression, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(7);
        }
        if (newExpression == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(8);
        }
        if (updater == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(9);
        }
        PsiTypeParameter[] typeParameters = this.myPsiClass.getTypeParameters();
        PsiSubstitutor psiSubstitutor = this.inferTypeArguments(newExpression);
        PsiJavaCodeReferenceElement reference = newExpression.getClassOrAnonymousClassReference();
        LOG.assertTrue(reference != null, (Object)newExpression);
        PsiReferenceParameterList parameterList = reference.getParameterList();
        LOG.assertTrue(parameterList != null, (Object)newExpression);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.project());
        PsiTypeElement[] elements = parameterList.getTypeParameterElements();
        for (int i = elements.length - 1; i >= 0; --i) {
            PsiType typeArg = Objects.requireNonNull(psiSubstitutor.substitute(typeParameters[i]));
            PsiElement replaced = elements[i].replace((PsiElement)factory.createTypeElement(typeArg));
            JavaCodeStyleManager.getInstance((Project)context.project()).shortenClassReferences(replaced);
        }
    }

    private PsiSubstitutor inferTypeArguments(@NotNull PsiNewExpression newExpression) {
        if (newExpression == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(10);
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)newExpression.getProject());
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        PsiParameter[] parameters = this.myTargetMethod.getParameterList().getParameters();
        PsiExpressionList argumentList = newExpression.getArgumentList();
        LOG.assertTrue(argumentList != null);
        PsiExpression[] expressions = argumentList.getExpressions();
        return resolveHelper.inferTypeArguments(this.myPsiClass.getTypeParameters(), parameters, expressions, PsiSubstitutor.EMPTY, newExpression.getParent(), (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
    }

    public static void registerIntentions(JavaResolveResult @NotNull [] candidates, @NotNull PsiConstructorCall call, @NotNull Consumer<? super CommonIntentionAction> info, PsiClass psiClass) {
        if (call == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(11);
        }
        if (info == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(12);
        }
        if (candidates == null) {
            ChangeTypeArgumentsFix.$$$reportNull$$$0(13);
        }
        if (candidates.length == 0) {
            return;
        }
        if (!(call instanceof PsiNewExpression)) {
            return;
        }
        PsiNewExpression newExpression = (PsiNewExpression)call;
        PsiExpressionList list = newExpression.getArgumentList();
        if (list == null) {
            return;
        }
        PsiExpression[] expressions = list.getExpressions();
        for (JavaResolveResult candidate : candidates) {
            PsiMethod method;
            if (!candidate.isStaticsScopeCorrect() || (method = (PsiMethod)candidate.getElement()) == null || !BaseIntentionAction.canModify((PsiElement)method)) continue;
            info.accept((CommonIntentionAction)new ChangeTypeArgumentsFix(method, psiClass, expressions, newExpression));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeTypeArgumentsFix";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeTypeArgumentsFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeArguments";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerIntentions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

