/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlipIntersectionSidesFix
extends PsiUpdateModCommandAction<PsiTypeElement> {
    private static final Logger LOG = Logger.getInstance(FlipIntersectionSidesFix.class);
    private final String myClassName;
    private final PsiTypeElement myConjunct;

    public FlipIntersectionSidesFix(String className, PsiTypeElement conjunct, PsiTypeElement castTypeElement) {
        super((PsiElement)castTypeElement);
        this.myClassName = className;
        this.myConjunct = conjunct;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"move.to.front", (Object[])new Object[0]);
        if (string == null) {
            FlipIntersectionSidesFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiTypeElement castTypeElement) {
        if (context == null) {
            FlipIntersectionSidesFix.$$$reportNull$$$0(1);
        }
        if (castTypeElement == null) {
            FlipIntersectionSidesFix.$$$reportNull$$$0(2);
        }
        if (!this.myConjunct.isValid()) {
            return null;
        }
        PsiTypeElement firstChild = (PsiTypeElement)PsiTreeUtil.findChildOfType((PsiElement)castTypeElement, PsiTypeElement.class);
        if (firstChild == null || this.myConjunct.textMatches((CharSequence)firstChild.getText())) {
            return null;
        }
        return Presentation.of((String)JavaAnalysisBundle.message((String)"move.0.to.the.beginning", (Object[])new Object[]{this.myClassName})).withFixAllOption((ModCommandAction)this);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiTypeElement castTypeElement, @NotNull ModPsiUpdater updater) {
        Object[] conjuncts;
        if (context == null) {
            FlipIntersectionSidesFix.$$$reportNull$$$0(3);
        }
        if (castTypeElement == null) {
            FlipIntersectionSidesFix.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            FlipIntersectionSidesFix.$$$reportNull$$$0(5);
        }
        if ((conjuncts = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)castTypeElement, PsiTypeElement.class)) == null) {
            return;
        }
        PsiTypeElement conjunct = (PsiTypeElement)updater.getWritable((PsiElement)this.myConjunct);
        String intersectionTypeText = StreamEx.of((Object[])conjuncts).without((Object)conjunct).prepend((Object)conjunct).map(PsiElement::getText).joining((CharSequence)" & ");
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)context.project());
        PsiTypeCastExpression fixedCast = (PsiTypeCastExpression)elementFactory.createExpressionFromText("(" + intersectionTypeText + ") a", (PsiElement)castTypeElement);
        PsiTypeElement fixedCastCastType = fixedCast.getCastType();
        LOG.assertTrue(fixedCastCastType != null);
        PsiElement flippedTypeElement = castTypeElement.replace((PsiElement)fixedCastCastType);
        CodeStyleManager.getInstance((Project)context.project()).reformat(flippedTypeElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/FlipIntersectionSidesFix";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castTypeElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/FlipIntersectionSidesFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

