/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.MergeModuleStatementsFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergePackageAccessibilityStatementsFix
extends MergeModuleStatementsFix<PsiPackageAccessibilityStatement> {
    private final String myPackageName;
    private final PsiPackageAccessibilityStatement.Role myRole;

    protected MergePackageAccessibilityStatementsFix(@NotNull PsiJavaModule javaModule, @NotNull String packageName, @NotNull PsiPackageAccessibilityStatement.Role role) {
        if (javaModule == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(0);
        }
        if (packageName == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(1);
        }
        if (role == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(2);
        }
        super(javaModule);
        this.myPackageName = packageName;
        this.myRole = role;
    }

    @Override
    @Nls
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("java.9.merge.module.statements.fix.name", this.getKeyword(), this.myPackageName);
        if (string == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("java.9.merge.module.statements.fix.family.name", this.getKeyword());
        if (string == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getReplacementText(@NotNull List<? extends PsiPackageAccessibilityStatement> statementsToMerge) {
        List<String> moduleNames;
        if (statementsToMerge == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(5);
        }
        if (!(moduleNames = MergePackageAccessibilityStatementsFix.getModuleNames(statementsToMerge)).isEmpty()) {
            String string = this.getKeyword() + " " + this.myPackageName + " to " + MergePackageAccessibilityStatementsFix.joinUniqueNames(moduleNames);
            if (string == null) {
                MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = this.getKeyword() + " " + this.myPackageName;
        if (string == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static List<String> getModuleNames(@NotNull List<? extends PsiPackageAccessibilityStatement> statements) {
        if (statements == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(8);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (PsiPackageAccessibilityStatement psiPackageAccessibilityStatement : statements) {
            List moduleNames = psiPackageAccessibilityStatement.getModuleNames();
            if (moduleNames.isEmpty()) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(9);
                }
                return list;
            }
            result.addAll(moduleNames);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<PsiPackageAccessibilityStatement> getStatementsToMerge(@NotNull PsiJavaModule javaModule) {
        if (javaModule == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(11);
        }
        List list = ((StreamEx)StreamEx.of(MergePackageAccessibilityStatementsFix.getStatements(javaModule, this.myRole).iterator()).filter(statement -> this.myPackageName.equals(statement.getPackageName()))).toList();
        if (list == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    public static MergeModuleStatementsFix<?> createFix(@Nullable PsiPackageAccessibilityStatement statement) {
        String packageName;
        PsiElement parent;
        if (statement != null && (parent = statement.getParent()) instanceof PsiJavaModule && (packageName = statement.getPackageName()) != null) {
            return new MergePackageAccessibilityStatementsFix((PsiJavaModule)parent, packageName, statement.getRole());
        }
        return null;
    }

    @NotNull
    private static Iterable<PsiPackageAccessibilityStatement> getStatements(@NotNull PsiJavaModule javaModule, @NotNull PsiPackageAccessibilityStatement.Role role) {
        if (javaModule == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(13);
        }
        if (role == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(14);
        }
        Iterable iterable = switch (role) {
            default -> throw new MatchException(null, null);
            case PsiPackageAccessibilityStatement.Role.OPENS -> javaModule.getOpens();
            case PsiPackageAccessibilityStatement.Role.EXPORTS -> javaModule.getExports();
        };
        if (iterable == null) {
            MergePackageAccessibilityStatementsFix.$$$reportNull$$$0(15);
        }
        return iterable;
    }

    @NotNull
    private String getKeyword() {
        return switch (this.myRole) {
            default -> throw new MatchException(null, null);
            case PsiPackageAccessibilityStatement.Role.OPENS -> "opens";
            case PsiPackageAccessibilityStatement.Role.EXPORTS -> "exports";
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 9, 10, 12, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "role";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementsToMerge";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacementText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleNames";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementsToMerge";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReplacementText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNames";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStatementsToMerge";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getStatements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 9, 10, 12, 15 -> new IllegalStateException(string);
        };
    }
}

