/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MethodArgumentFix
extends PsiUpdateModCommandAction<PsiExpressionList> {
    private static final Logger LOG = Logger.getInstance(MethodArgumentFix.class);
    protected final int myIndex;
    protected final ArgumentFixerActionFactory myArgumentFixerActionFactory;
    @NotNull
    protected final PsiType myToType;

    protected MethodArgumentFix(@NotNull PsiExpressionList list, int i, @NotNull PsiType toType, @NotNull ArgumentFixerActionFactory fixerActionFactory) {
        if (list == null) {
            MethodArgumentFix.$$$reportNull$$$0(0);
        }
        if (toType == null) {
            MethodArgumentFix.$$$reportNull$$$0(1);
        }
        if (fixerActionFactory == null) {
            MethodArgumentFix.$$$reportNull$$$0(2);
        }
        super((PsiElement)list);
        this.myIndex = i;
        this.myArgumentFixerActionFactory = fixerActionFactory;
        this.myToType = toType instanceof PsiEllipsisType ? ((PsiEllipsisType)toType).toArrayType() : toType;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiExpressionList list) {
        if (context == null) {
            MethodArgumentFix.$$$reportNull$$$0(3);
        }
        if (list == null) {
            MethodArgumentFix.$$$reportNull$$$0(4);
        }
        if (!this.myToType.isValid() || !PsiTypesUtil.allTypeParametersResolved((PsiElement)list, (PsiType)this.myToType)) {
            return null;
        }
        PsiExpression[] args = list.getExpressions();
        if (args.length <= this.myIndex) {
            return null;
        }
        PsiExpression arg = args[this.myIndex];
        if (arg == null || !arg.isValid()) {
            return null;
        }
        if (this.myArgumentFixerActionFactory.getModifiedArgument(arg, this.myToType) == null) {
            return null;
        }
        return Presentation.of((String)this.getText(list));
    }

    @IntentionName
    @NotNull
    abstract String getText(@NotNull PsiExpressionList var1);

    protected void invoke(@NotNull ActionContext context, @NotNull PsiExpressionList list, @NotNull ModPsiUpdater updater) {
        PsiExpression expression;
        if (context == null) {
            MethodArgumentFix.$$$reportNull$$$0(5);
        }
        if (list == null) {
            MethodArgumentFix.$$$reportNull$$$0(6);
        }
        if (updater == null) {
            MethodArgumentFix.$$$reportNull$$$0(7);
        }
        LOG.assertTrue((expression = list.getExpressions()[this.myIndex]) != null && expression.isValid());
        PsiExpression modified = this.myArgumentFixerActionFactory.getModifiedArgument(expression, this.myToType);
        LOG.assertTrue(modified != null, (Object)this.myArgumentFixerActionFactory);
        PsiElement newElement = expression.replace((PsiElement)modified);
        JavaCodeStyleManager.getInstance((Project)context.project()).shortenClassReferences(newElement);
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.argument.family", new Object[0]);
        if (string == null) {
            MethodArgumentFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixerActionFactory";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodArgumentFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodArgumentFix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

