/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class MoveParenthesisFix
extends PsiUpdateModCommandAction<PsiCallExpression> {
    private final int myPos;
    private final int myShiftSize;

    public MoveParenthesisFix(PsiCallExpression call, int pos, int shiftSize) {
        super((PsiElement)call);
        this.myPos = pos;
        this.myShiftSize = shiftSize;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = QuickFixBundle.message("intention.move.parenthesis.name", new Object[0]);
        if (string == null) {
            MoveParenthesisFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiCallExpression element) {
        if (context == null) {
            MoveParenthesisFix.$$$reportNull$$$0(1);
        }
        if (element == null) {
            MoveParenthesisFix.$$$reportNull$$$0(2);
        }
        Presentation presentation = Presentation.of((String)this.getFamilyName()).withPriority(PriorityAction.Priority.HIGH);
        if (presentation == null) {
            MoveParenthesisFix.$$$reportNull$$$0(3);
        }
        return presentation;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiCallExpression call, @NotNull ModPsiUpdater updater) {
        PsiCallExpression copy;
        if (context == null) {
            MoveParenthesisFix.$$$reportNull$$$0(4);
        }
        if (call == null) {
            MoveParenthesisFix.$$$reportNull$$$0(5);
        }
        if (updater == null) {
            MoveParenthesisFix.$$$reportNull$$$0(6);
        }
        if ((copy = MoveParenthesisFix.copyWithShift(call, this.myPos, this.myShiftSize)) != null) {
            new CommentTracker().replaceAndRestoreComments((PsiElement)call, (PsiElement)copy);
        }
    }

    private static PsiCallExpression copyWithShift(PsiCallExpression parentCall, int pos, int shift) {
        int i;
        PsiCallExpression parentCopy = (PsiCallExpression)parentCall.copy();
        PsiExpressionList parentArgsCopy = Objects.requireNonNull(parentCopy.getArgumentList());
        PsiCallExpression childCopy = (PsiCallExpression)parentArgsCopy.getExpressions()[pos];
        PsiExpressionList childArgsCopy = Objects.requireNonNull(childCopy.getArgumentList());
        if (shift > 0) {
            if (shift >= childArgsCopy.getExpressionCount()) {
                return null;
            }
            for (i = 0; i < shift; ++i) {
                PsiExpression lastArg = (PsiExpression)ArrayUtil.getLastElement((Object[])childArgsCopy.getExpressions());
                assert (lastArg != null);
                parentArgsCopy.addAfter((PsiElement)lastArg, (PsiElement)childCopy);
                lastArg.delete();
            }
        }
        if (shift < 0) {
            if (parentArgsCopy.getExpressionCount() <= pos - shift) {
                return null;
            }
            for (i = 0; i > shift; --i) {
                PsiExpression nextArg = parentArgsCopy.getExpressions()[pos + 1];
                childArgsCopy.add((PsiElement)nextArg);
                nextArg.delete();
            }
        }
        return parentCopy;
    }

    public static boolean registerFix(@NotNull Consumer<? super CommonIntentionAction> info, PsiCallExpression callExpression, CandidateInfo[] candidates) {
        PsiExpressionList parent;
        if (info == null) {
            MoveParenthesisFix.$$$reportNull$$$0(7);
        }
        if ((parent = (PsiExpressionList)ObjectUtils.tryCast((Object)callExpression.getParent(), PsiExpressionList.class)) == null) {
            return false;
        }
        PsiCallExpression parentCall = (PsiCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiCallExpression.class);
        if (parentCall == null) {
            return false;
        }
        PsiExpressionList argList = callExpression.getArgumentList();
        if (argList == null) {
            return false;
        }
        PsiExpression[] args = argList.getExpressions();
        if (args.length == 0) {
            return false;
        }
        Object[] parentArgs = parent.getExpressions();
        int pos = ArrayUtil.indexOf((Object[])parentArgs, (Object)callExpression);
        if (pos == -1) {
            return false;
        }
        IntOpenHashSet shifts = new IntOpenHashSet();
        for (CandidateInfo candidate : candidates) {
            PsiMethod candidateMethod = (PsiMethod)ObjectUtils.tryCast((Object)candidate.getElement(), PsiMethod.class);
            if (candidateMethod == null || candidateMethod.isVarArgs()) {
                return false;
            }
            int count = candidateMethod.getParameterList().getParametersCount();
            if (count == 0 || count == args.length) {
                return false;
            }
            shifts.add(args.length - count);
        }
        if (shifts.isEmpty()) {
            return false;
        }
        MoveParenthesisFix fix = null;
        IntIterator intIterator = shifts.iterator();
        while (intIterator.hasNext()) {
            PsiCallExpression childCopy;
            JavaResolveResult childResolve;
            JavaResolveResult parentResolve;
            int shift = (Integer)intIterator.next();
            PsiCallExpression copy = MoveParenthesisFix.copyWithShift(parentCall, pos, shift);
            if (copy == null || !(parentResolve = copy.resolveMethodGenerics()).isValidResult() || !(childResolve = (childCopy = (PsiCallExpression)Objects.requireNonNull(copy.getArgumentList()).getExpressions()[pos]).resolveMethodGenerics()).isValidResult()) continue;
            if (fix != null) {
                return false;
            }
            fix = new MoveParenthesisFix(parentCall, pos, shift);
        }
        if (fix == null) {
            return false;
        }
        info.accept((CommonIntentionAction)fix);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MoveParenthesisFix";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MoveParenthesisFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

