/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class PermuteArgumentsFix
extends PsiUpdateModCommandAction<PsiCall> {
    private static final Logger LOG = Logger.getInstance(PermuteArgumentsFix.class);
    private final PsiCall myPermutation;

    private PermuteArgumentsFix(@NotNull PsiCall call, @NotNull PsiCall permutation) {
        if (call == null) {
            PermuteArgumentsFix.$$$reportNull$$$0(0);
        }
        if (permutation == null) {
            PermuteArgumentsFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)call);
        this.myPermutation = permutation;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("permute.arguments", new Object[0]);
        if (string == null) {
            PermuteArgumentsFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiCall element) {
        if (context == null) {
            PermuteArgumentsFix.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PermuteArgumentsFix.$$$reportNull$$$0(4);
        }
        Presentation presentation = Presentation.of((String)this.getFamilyName()).withPriority(PriorityAction.Priority.HIGH);
        if (presentation == null) {
            PermuteArgumentsFix.$$$reportNull$$$0(5);
        }
        return presentation;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiCall call, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PermuteArgumentsFix.$$$reportNull$$$0(6);
        }
        if (call == null) {
            PermuteArgumentsFix.$$$reportNull$$$0(7);
        }
        if (updater == null) {
            PermuteArgumentsFix.$$$reportNull$$$0(8);
        }
        Objects.requireNonNull(call.getArgumentList()).replace((PsiElement)Objects.requireNonNull(this.myPermutation.getArgumentList()));
    }

    public static boolean registerFix(@NotNull Consumer<? super CommonIntentionAction> info, PsiCall callExpression, CandidateInfo[] candidates) {
        PsiExpression[] expressions;
        if (info == null) {
            PermuteArgumentsFix.$$$reportNull$$$0(9);
        }
        if ((expressions = Objects.requireNonNull(callExpression.getArgumentList()).getExpressions()).length < 2) {
            return false;
        }
        ArrayList permutations = new ArrayList();
        for (CandidateInfo candidate : candidates) {
            if (!(candidate instanceof MethodCandidateInfo)) continue;
            MethodCandidateInfo methodCandidate = (MethodCandidateInfo)candidate;
            PsiMethod method = methodCandidate.getElement();
            PsiSubstitutor substitutor = methodCandidate.getSubstitutor();
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (expressions.length != parameters.length) continue;
            int minIncompatibleIndex = parameters.length;
            int maxIncompatibleIndex = 0;
            int incompatibilitiesCount = 0;
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                PsiType type = substitutor.substitute(parameter.getType());
                if (TypeConversionUtil.areTypesAssignmentCompatible((PsiType)type, (PsiExpression)expressions[i])) continue;
                if (minIncompatibleIndex == parameters.length) {
                    minIncompatibleIndex = i;
                }
                maxIncompatibleIndex = i;
                ++incompatibilitiesCount;
            }
            try {
                PsiExpression[] clonedExpressions = (PsiExpression[])expressions.clone();
                PermuteArgumentsFix.registerSwapFixes(clonedExpressions, callExpression, permutations, methodCandidate, incompatibilitiesCount, minIncompatibleIndex, maxIncompatibleIndex);
                PermuteArgumentsFix.registerShiftFixes(clonedExpressions, callExpression, permutations, methodCandidate, minIncompatibleIndex, maxIncompatibleIndex);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (permutations.size() == 1) {
            PermuteArgumentsFix fix = new PermuteArgumentsFix(callExpression, (PsiCall)permutations.get(0));
            info.accept((CommonIntentionAction)fix);
            return true;
        }
        return false;
    }

    private static void registerShiftFixes(PsiExpression[] expressions, PsiCall callExpression, List<? super PsiCall> permutations, MethodCandidateInfo methodCandidate, int minIncompatibleIndex, int maxIncompatibleIndex) throws IncorrectOperationException {
        PsiMethod method = methodCandidate.getElement();
        PsiSubstitutor substitutor = methodCandidate.getSubstitutor();
        for (int i = 0; i <= minIncompatibleIndex; ++i) {
            for (int j = Math.max(i + 2, maxIncompatibleIndex); j < expressions.length; ++j) {
                ArrayUtil.rotateLeft((Object[])expressions, (int)i, (int)j);
                if (PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)substitutor, (PsiExpression[])expressions) && PermuteArgumentsFix.canShift(expressions, callExpression, permutations, i)) {
                    return;
                }
                ArrayUtil.rotateRight((Object[])expressions, (int)i, (int)j);
                ArrayUtil.rotateRight((Object[])expressions, (int)i, (int)j);
                if (PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)substitutor, (PsiExpression[])expressions) && PermuteArgumentsFix.canShift(expressions, callExpression, permutations, i)) {
                    return;
                }
                ArrayUtil.rotateLeft((Object[])expressions, (int)i, (int)j);
            }
        }
    }

    private static boolean canShift(PsiExpression[] expressions, PsiCall callExpression, List<? super PsiCall> permutations, int i) {
        PsiCall copy = LambdaUtil.copyTopLevelCall((PsiCall)callExpression);
        if (copy == null) {
            return false;
        }
        PsiExpressionList list = copy.getArgumentList();
        if (list == null) {
            return false;
        }
        PsiExpression[] copyExpressions = list.getExpressions();
        for (int k = i; k < copyExpressions.length; ++k) {
            copyExpressions[k].replace((PsiElement)expressions[k]);
        }
        JavaResolveResult result = copy.resolveMethodGenerics();
        if (result.getElement() != null && result.isValidResult()) {
            permutations.add((PsiCall)copy);
            if (permutations.size() > 1) {
                return true;
            }
        }
        return false;
    }

    private static void registerSwapFixes(PsiExpression[] expressions, PsiCall callExpression, List<? super PsiCall> permutations, MethodCandidateInfo candidate, int incompatibilitiesCount, int minIncompatibleIndex, int maxIncompatibleIndex) throws IncorrectOperationException {
        PsiMethod method = candidate.getElement();
        PsiSubstitutor substitutor = candidate.getSubstitutor();
        if (incompatibilitiesCount >= 3) {
            return;
        }
        for (int i = minIncompatibleIndex; i < maxIncompatibleIndex; ++i) {
            for (int j = i + 1; j <= maxIncompatibleIndex; ++j) {
                ArrayUtil.swap((Object[])expressions, (int)i, (int)j);
                if (PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)substitutor, (PsiExpression[])expressions)) {
                    PsiCall copy = LambdaUtil.copyTopLevelCall((PsiCall)callExpression);
                    if (copy == null) {
                        return;
                    }
                    PsiExpressionList argumentList = copy.getArgumentList();
                    if (argumentList == null) {
                        return;
                    }
                    PsiExpression[] copyExpressions = argumentList.getExpressions();
                    copyExpressions[i].replace((PsiElement)expressions[i]);
                    copyExpressions[j].replace((PsiElement)expressions[j]);
                    JavaResolveResult result = copy.resolveMethodGenerics();
                    if (result.getElement() != null && result.isValidResult()) {
                        permutations.add((PsiCall)copy);
                        if (permutations.size() > 1) {
                            return;
                        }
                    }
                }
                ArrayUtil.swap((Object[])expressions, (int)i, (int)j);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permutation";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/PermuteArgumentsFix";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/PermuteArgumentsFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }
}

