/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveRepeatingCallFix
extends PsiUpdateModCommandAction<PsiMethodCallExpression> {
    private final String myMethodName;

    private RemoveRepeatingCallFix(PsiMethodCallExpression call, String methodName) {
        super((PsiElement)call);
        this.myMethodName = methodName;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiMethodCallExpression call, @NotNull ModPsiUpdater updater) {
        PsiExpression qualifier;
        if (context == null) {
            RemoveRepeatingCallFix.$$$reportNull$$$0(0);
        }
        if (call == null) {
            RemoveRepeatingCallFix.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            RemoveRepeatingCallFix.$$$reportNull$$$0(2);
        }
        if ((qualifier = call.getMethodExpression().getQualifierExpression()) == null) {
            return;
        }
        call.replace((PsiElement)qualifier);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiMethodCallExpression element) {
        if (context == null) {
            RemoveRepeatingCallFix.$$$reportNull$$$0(3);
        }
        if (element == null) {
            RemoveRepeatingCallFix.$$$reportNull$$$0(4);
        }
        return Presentation.of((String)JavaAnalysisBundle.message((String)"intention.name.remove.repeating.call", (Object[])new Object[]{this.myMethodName})).withFixAllOption((ModCommandAction)this);
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"intention.family.name.remove.repeating.call", (Object[])new Object[0]);
        if (string == null) {
            RemoveRepeatingCallFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static RemoveRepeatingCallFix createFix(@NotNull PsiMethodCallExpression call) {
        String name;
        if (call == null) {
            RemoveRepeatingCallFix.$$$reportNull$$$0(6);
        }
        if ((name = call.getMethodExpression().getReferenceName()) == null) {
            return null;
        }
        PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
        if (qualifierCall == null) {
            return null;
        }
        String qualifierName = qualifierCall.getMethodExpression().getReferenceName();
        if (!name.equals(qualifierName)) {
            return null;
        }
        if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)call.getArgumentList(), (PsiElement)qualifierCall.getArgumentList())) {
            return null;
        }
        return new RemoveRepeatingCallFix(call, name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRepeatingCallFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRepeatingCallFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

