/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoveUnusedVariableUtil {
    @Contract(value="_, _, null -> false; null, _, _ -> false")
    public static boolean checkSideEffects(PsiExpression element, @Nullable PsiVariable variableToIgnore, List<? super PsiElement> sideEffects) {
        if (sideEffects == null || element == null) {
            return false;
        }
        ArrayList writes = new ArrayList();
        Predicate<PsiElement> allowedSideEffect = variableToIgnore == null ? e -> false : e -> e instanceof PsiAssignmentExpression && ExpressionUtils.isReferenceTo(((PsiAssignmentExpression)e).getLExpression(), variableToIgnore);
        SideEffectChecker.checkSideEffects(element, writes, allowedSideEffect);
        sideEffects.addAll(writes);
        return !writes.isEmpty();
    }

    private static void replaceElementWithExpression(PsiExpression expression, PsiElementFactory factory, PsiElement element) throws IncorrectOperationException {
        PsiElement elementToReplace = element;
        PsiExpression expressionToReplaceWith = expression;
        if (element.getParent() instanceof PsiExpressionStatement || element.getParent() instanceof PsiExpressionListStatement) {
            PsiElement lastChild;
            elementToReplace = element.getParent();
            expressionToReplaceWith = factory.createStatementFromText((expression == null ? "" : expression.getText()) + ";", null);
            if (RemoveUnusedVariableUtil.isForLoopUpdate(elementToReplace) && PsiUtil.isJavaToken((PsiElement)(lastChild = expressionToReplaceWith.getLastChild()), (IElementType)JavaTokenType.SEMICOLON)) {
                lastChild.delete();
            }
        } else if (element.getParent() instanceof PsiDeclarationStatement) {
            expressionToReplaceWith = factory.createStatementFromText((expression == null ? "" : expression.getText()) + ";", null);
        }
        elementToReplace.replace((PsiElement)expressionToReplaceWith);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void deleteWholeStatement(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            RemoveUnusedVariableUtil.$$$reportNull$$$0(0);
        }
        if ((parent = element.getParent()) instanceof PsiExpressionStatement) {
            if (parent.getParent() instanceof PsiCodeBlock || RemoveUnusedVariableUtil.isForLoopUpdate(parent)) {
                parent.delete();
                return;
            }
            String replacement = parent.getParent() instanceof PsiSwitchLabeledRuleStatement ? "{}" : ";";
            PsiStatement result = JavaPsiFacade.getElementFactory((Project)parent.getProject()).createStatementFromText(replacement, null);
            parent.replace((PsiElement)result);
            return;
        }
        if (parent instanceof PsiExpressionList) {
            PsiExpressionList list = (PsiExpressionList)parent;
            if (parent.getParent() instanceof PsiExpressionListStatement) {
                PsiExpression[] expressions = list.getExpressions();
                if (expressions.length != 2) {
                    element.delete();
                    return;
                }
                PsiExpression other = expressions[0] == element ? expressions[1] : expressions[0];
                RemoveUnusedVariableUtil.replaceElementWithExpression(other, JavaPsiFacade.getElementFactory((Project)parent.getProject()), parent);
                return;
            }
        }
        if (element.getParent() instanceof PsiLambdaExpression) {
            element.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)parent.getProject()).createCodeBlock());
            return;
        }
        element.delete();
    }

    public static boolean isForLoopUpdate(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        return parent instanceof PsiForStatement && ((PsiForStatement)parent).getUpdate() == element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedVariableUtil", "deleteWholeStatement"));
    }

    public static enum RemoveMode {
        MAKE_STATEMENT,
        DELETE_ALL,
        CANCEL;

    }
}

