/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceGetClassWithClassLiteralFix
extends PsiUpdateModCommandAction<PsiMethodCallExpression> {
    public ReplaceGetClassWithClassLiteralFix(PsiMethodCallExpression expression) {
        super((PsiElement)expression);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiMethodCallExpression call, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            ReplaceGetClassWithClassLiteralFix.$$$reportNull$$$0(0);
        }
        if (call == null) {
            ReplaceGetClassWithClassLiteralFix.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            ReplaceGetClassWithClassLiteralFix.$$$reportNull$$$0(2);
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)call, PsiClass.class);
        assert (aClass != null);
        PsiExpression classLiteral = JavaPsiFacade.getElementFactory((Project)context.project()).createExpressionFromText(aClass.getName() + ".class", (PsiElement)call);
        new CommentTracker().replaceAndRestoreComments((PsiElement)call, (PsiElement)classLiteral);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiMethodCallExpression call) {
        PsiClass aClass;
        if (context == null) {
            ReplaceGetClassWithClassLiteralFix.$$$reportNull$$$0(3);
        }
        if (call == null) {
            ReplaceGetClassWithClassLiteralFix.$$$reportNull$$$0(4);
        }
        if ((aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)call, PsiClass.class)) == null) {
            return null;
        }
        String className = aClass.getName();
        if (className == null) {
            return null;
        }
        return Presentation.of((String)CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{className + ".class"})).withPriority(PriorityAction.Priority.HIGH);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"replace.get.class.with.class.literal", (Object[])new Object[0]);
        if (string == null) {
            ReplaceGetClassWithClassLiteralFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static void registerFix(PsiMethodCallExpression callExpression, @NotNull Consumer<? super CommonIntentionAction> info) {
        PsiMethod method;
        if (info == null) {
            ReplaceGetClassWithClassLiteralFix.$$$reportNull$$$0(6);
        }
        if (callExpression.getMethodExpression().getQualifierExpression() == null && (method = callExpression.resolveMethod()) != null && PsiTypesUtil.isGetClass((PsiMethod)method)) {
            info.accept((CommonIntentionAction)new ReplaceGetClassWithClassLiteralFix(callExpression));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceGetClassWithClassLiteralFix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceGetClassWithClassLiteralFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

