/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VariableArrayTypeFix
extends PsiUpdateModCommandAction<PsiArrayInitializerExpression> {
    @NotNull
    private final PsiArrayType myTargetType;
    @IntentionName
    private final String myName;
    @IntentionFamilyName
    private final String myFamilyName;

    private VariableArrayTypeFix(@NotNull PsiArrayInitializerExpression initializer, @NotNull PsiArrayType arrayType, @NotNull PsiVariable variable) {
        if (initializer == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(0);
        }
        if (arrayType == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(1);
        }
        if (variable == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(2);
        }
        super((PsiElement)initializer);
        this.myTargetType = arrayType;
        PsiNewExpression myNewExpression = VariableArrayTypeFix.getNewExpressionLocal(initializer);
        this.myName = this.myTargetType.equals((Object)variable.getType()) && myNewExpression != null ? QuickFixBundle.message("change.new.operator.type.text", VariableArrayTypeFix.getNewText((PsiElement)myNewExpression, initializer), this.myTargetType.getCanonicalText(), "") : QuickFixBundle.message("fix.variable.type.text", VariableArrayTypeFix.formatType(variable), variable.getName(), this.myTargetType.getCanonicalText());
        this.myFamilyName = QuickFixBundle.message(this.myTargetType.equals((Object)variable.getType()) && myNewExpression != null ? "change.new.operator.type.family" : "fix.variable.type.family", new Object[0]);
    }

    @Nullable
    public static VariableArrayTypeFix createFix(PsiArrayInitializerExpression initializer, @NotNull PsiType componentType) {
        if (componentType == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(3);
        }
        PsiArrayType arrayType = new PsiArrayType(componentType);
        PsiArrayInitializerExpression arrayInitializer = initializer;
        while (arrayInitializer.getParent() instanceof PsiArrayInitializerExpression) {
            arrayInitializer = (PsiArrayInitializerExpression)arrayInitializer.getParent();
            arrayType = new PsiArrayType((PsiType)arrayType);
        }
        PsiVariable variable = VariableArrayTypeFix.getVariableLocal(arrayInitializer);
        if (variable == null) {
            return null;
        }
        return new VariableArrayTypeFix(arrayInitializer, arrayType, variable);
    }

    private static String formatType(@NotNull PsiVariable variable) {
        if (variable == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(4);
        }
        return JavaElementKind.fromElement((PsiElement)variable).lessDescriptive().subject();
    }

    private static PsiVariable getVariableLocal(@NotNull PsiArrayInitializerExpression initializer) {
        if (initializer == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(5);
        }
        PsiVariable variableLocal = null;
        PsiElement parent = initializer.getParent();
        if (parent instanceof PsiVariable) {
            variableLocal = (PsiVariable)parent;
        } else if (parent instanceof PsiNewExpression) {
            PsiNewExpression newExpressionLocal = (PsiNewExpression)parent;
            PsiElement newParent = newExpressionLocal.getParent();
            if (newParent instanceof PsiAssignmentExpression) {
                variableLocal = VariableArrayTypeFix.getFromAssignment((PsiAssignmentExpression)newParent);
            } else if (newParent instanceof PsiVariable) {
                variableLocal = (PsiVariable)newParent;
            }
        } else if (parent instanceof PsiAssignmentExpression) {
            variableLocal = VariableArrayTypeFix.getFromAssignment((PsiAssignmentExpression)parent);
        }
        return variableLocal;
    }

    private static PsiNewExpression getNewExpressionLocal(@NotNull PsiArrayInitializerExpression initializer) {
        if (initializer == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(6);
        }
        return (PsiNewExpression)ObjectUtils.tryCast((Object)initializer.getParent(), PsiNewExpression.class);
    }

    @Nullable
    private static PsiVariable getFromAssignment(PsiAssignmentExpression assignment) {
        PsiExpression reference = assignment.getLExpression();
        PsiElement referencedElement = reference instanceof PsiReferenceExpression ? ((PsiReferenceExpression)reference).resolve() : null;
        return referencedElement instanceof PsiVariable ? (PsiVariable)referencedElement : null;
    }

    private static String getNewText(PsiElement myNewExpression, PsiArrayInitializerExpression myInitializer) {
        String newText = myNewExpression.getText();
        int initializerIdx = newText.indexOf(myInitializer.getText());
        if (initializerIdx != -1) {
            return newText.substring(0, initializerIdx).trim();
        }
        return newText;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myFamilyName;
        if (string == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiArrayInitializerExpression element) {
        PsiVariable variable;
        if (context == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(8);
        }
        if (element == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(9);
        }
        if ((variable = VariableArrayTypeFix.getVariableLocal(element)) == null || !BaseIntentionAction.canModify((PsiElement)variable) || !this.myTargetType.isValid()) {
            return null;
        }
        return Presentation.of((String)this.myName);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiArrayInitializerExpression initializer, @NotNull ModPsiUpdater updater) {
        PsiVariable variable;
        if (context == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(10);
        }
        if (initializer == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(11);
        }
        if (updater == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(12);
        }
        if ((variable = VariableArrayTypeFix.getVariableLocal(initializer)) == null) {
            return;
        }
        variable = (PsiVariable)updater.getWritable((PsiElement)variable);
        PsiNewExpression myNewExpression = VariableArrayTypeFix.getNewExpressionLocal(initializer);
        if (!this.myTargetType.equals((Object)variable.getType())) {
            this.fixVariableType(context.project(), variable);
        }
        if (myNewExpression != null) {
            this.fixArrayInitializer(initializer, myNewExpression);
        }
    }

    private void fixVariableType(@NotNull Project project, PsiVariable myVariable) {
        if (project == null) {
            VariableArrayTypeFix.$$$reportNull$$$0(13);
        }
        myVariable.normalizeDeclaration();
        Objects.requireNonNull(myVariable.getTypeElement()).replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createTypeElement((PsiType)this.myTargetType));
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)myVariable);
    }

    private void fixArrayInitializer(PsiArrayInitializerExpression myInitializer, PsiNewExpression myNewExpression) {
        @NonNls String text = "new " + this.myTargetType.getCanonicalText() + "{}";
        PsiNewExpression newExpression = (PsiNewExpression)JavaPsiFacade.getElementFactory((Project)myNewExpression.getProject()).createExpressionFromText(text, myNewExpression.getParent());
        PsiElement[] children = newExpression.getChildren();
        children[children.length - 1].replace((PsiElement)myInitializer);
        myNewExpression.replace((PsiElement)newExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "formatType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVariableLocal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNewExpressionLocal";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fixVariableType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

