/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapExpressionFix
extends PsiUpdateModCommandAction<PsiExpression> {
    private static final Logger LOG = Logger.getInstance(WrapExpressionFix.class);
    @Nullable
    private final String myRole;
    private final PsiClassType myExpectedType;
    private final boolean myPrimitiveExpected;
    private final String myMethodPresentation;

    public WrapExpressionFix(@NotNull PsiType expectedType, @NotNull PsiExpression expression, @Nullable String role) {
        if (expectedType == null) {
            WrapExpressionFix.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            WrapExpressionFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)expression);
        this.myRole = role;
        this.myExpectedType = WrapExpressionFix.getClassType(expectedType, (PsiElement)expression);
        this.myPrimitiveExpected = expectedType instanceof PsiPrimitiveType;
        this.myMethodPresentation = WrapExpressionFix.getMethodPresentation(expression, this.myExpectedType, this.myPrimitiveExpected);
    }

    @Nullable
    private static PsiClassType getClassType(PsiType type, PsiElement place) {
        if (type instanceof PsiClassType) {
            return (PsiClassType)type;
        }
        if (type instanceof PsiPrimitiveType) {
            return ((PsiPrimitiveType)type).getBoxedType(place.getManager(), GlobalSearchScope.allScope((Project)place.getProject()));
        }
        return null;
    }

    private static String getMethodPresentation(PsiExpression expression, PsiClassType expectedType, boolean primitiveExpected) {
        PsiClass containingClass;
        PsiMethod wrapper;
        PsiType type = expression.getType();
        if (expectedType != null && type != null && (wrapper = WrapExpressionFix.findWrapper(type, expectedType, primitiveExpected, (PsiElement)expression)) != null && (containingClass = wrapper.getContainingClass()) != null) {
            return containingClass.getName() + "." + wrapper.getName();
        }
        return null;
    }

    @Nullable
    private static PsiMethod findWrapper(@NotNull PsiType type, @NotNull PsiClassType expectedType, boolean primitiveExpected, @NotNull PsiElement context) {
        PsiClass aClass;
        if (type == null) {
            WrapExpressionFix.$$$reportNull$$$0(2);
        }
        if (expectedType == null) {
            WrapExpressionFix.$$$reportNull$$$0(3);
        }
        if (context == null) {
            WrapExpressionFix.$$$reportNull$$$0(4);
        }
        if ((aClass = expectedType.resolve()) != null) {
            PsiClassType expectedReturnType = expectedType;
            if (primitiveExpected) {
                expectedReturnType = PsiPrimitiveType.getUnboxedType((PsiType)expectedType);
            }
            boolean isString = "java.lang.String".equals(aClass.getQualifiedName());
            if (type instanceof PsiArrayType && isString && (aClass = PsiResolveHelper.getInstance((Project)aClass.getProject()).resolveReferencedClass("java.util.Arrays", (PsiElement)aClass)) == null) {
                return null;
            }
            if (expectedReturnType == null) {
                return null;
            }
            PsiMethod[] methods = aClass.getMethods();
            LinkedHashSet<PsiMethod> wrapperMethods = new LinkedHashSet<PsiMethod>();
            for (PsiMethod method : methods) {
                if (!method.hasModifierProperty("static") || method.getParameterList().getParametersCount() != 1 || !Objects.requireNonNull(method.getParameterList().getParameter(0)).getType().isAssignableFrom(type) || method.getReturnType() == null || !expectedReturnType.equals(method.getReturnType())) continue;
                String methodName = method.getName();
                if (methodName.startsWith("parse") || methodName.equals("valueOf") || isString && methodName.equals("toString")) {
                    return method;
                }
                wrapperMethods.add(method);
            }
            if (!wrapperMethods.isEmpty()) {
                return (PsiMethod)wrapperMethods.iterator().next();
            }
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("wrap.expression.using.static.accessor.family", new Object[0]);
        if (string == null) {
            WrapExpressionFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiExpression myExpression) {
        boolean available;
        if (context == null) {
            WrapExpressionFix.$$$reportNull$$$0(6);
        }
        if (myExpression == null) {
            WrapExpressionFix.$$$reportNull$$$0(7);
        }
        boolean bl = available = this.myMethodPresentation != null && PsiImplUtil.getSwitchLabel((PsiCaseLabelElement)myExpression) == null && this.myExpectedType != null && this.myExpectedType.isValid() && myExpression.getType() != null && WrapExpressionFix.findWrapper(myExpression.getType(), this.myExpectedType, this.myPrimitiveExpected, (PsiElement)myExpression) != null;
        if (!available) {
            return null;
        }
        String message = this.myRole == null ? QuickFixBundle.message("wrap.expression.using.static.accessor.text", this.myMethodPresentation) : QuickFixBundle.message("wrap.expression.using.static.accessor.text.role", this.myMethodPresentation, this.myRole);
        return Presentation.of((String)message);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiExpression expression, @NotNull ModPsiUpdater updater) {
        PsiType type;
        if (context == null) {
            WrapExpressionFix.$$$reportNull$$$0(8);
        }
        if (expression == null) {
            WrapExpressionFix.$$$reportNull$$$0(9);
        }
        if (updater == null) {
            WrapExpressionFix.$$$reportNull$$$0(10);
        }
        if ((type = expression.getType()) == null) {
            LOG.error("Expression type is null");
            return;
        }
        PsiMethod wrapper = WrapExpressionFix.findWrapper(type, this.myExpectedType, this.myPrimitiveExpected, (PsiElement)expression);
        if (wrapper == null) {
            LOG.error("Wrapper not found; expectedType = " + this.myExpectedType.getCanonicalText() + "; primitiveExpected = " + this.myPrimitiveExpected);
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.project());
        @NonNls String methodCallText = "Foo." + wrapper.getName() + "()";
        PsiMethodCallExpression call = (PsiMethodCallExpression)factory.createExpressionFromText(methodCallText, null);
        call.getArgumentList().add((PsiElement)expression);
        PsiReferenceExpression qualifier = (PsiReferenceExpression)Objects.requireNonNull(call.getMethodExpression().getQualifierExpression());
        PsiClass wrapperClass = Objects.requireNonNull(wrapper.getContainingClass());
        qualifier.bindToElement((PsiElement)wrapperClass);
        expression.replace((PsiElement)call);
    }

    public static void registerWrapAction(JavaResolveResult[] candidates, PsiExpression[] expressions, @NotNull Consumer<? super CommonIntentionAction> info) {
        if (info == null) {
            WrapExpressionFix.$$$reportNull$$$0(11);
        }
        PsiType expectedType = null;
        PsiExpression expr = null;
        block0: for (int i = 0; i < candidates.length && expectedType == null; ++i) {
            JavaResolveResult candidate = candidates[i];
            PsiSubstitutor substitutor = candidate.getSubstitutor();
            PsiElement element = candidate.getElement();
            assert (element != null);
            PsiMethod method = (PsiMethod)element;
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (!method.isVarArgs() && parameters.length != expressions.length) continue;
            for (int j = 0; j < expressions.length; ++j) {
                PsiExpression expression = expressions[j];
                PsiType exprType = expression.getType();
                if (exprType == null || PsiTypes.nullType().equals(exprType)) continue;
                PsiType paramType = parameters[Math.min(j, parameters.length - 1)].getType();
                if (paramType instanceof PsiEllipsisType) {
                    paramType = ((PsiEllipsisType)paramType).getComponentType();
                }
                if ((paramType = substitutor.substitute(paramType)).isAssignableFrom(exprType)) continue;
                PsiClassType classType = WrapExpressionFix.getClassType(paramType, (PsiElement)expression);
                if (expectedType == null && classType != null && WrapExpressionFix.findWrapper(exprType, classType, paramType instanceof PsiPrimitiveType, (PsiElement)expression) != null) {
                    expectedType = paramType;
                    expr = expression;
                    continue;
                }
                expectedType = null;
                expr = null;
                continue block0;
            }
        }
        if (expectedType != null) {
            info.accept((CommonIntentionAction)new WrapExpressionFix(expectedType, expr, null));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapExpressionFix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapExpressionFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findWrapper";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerWrapAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

