/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.ModCommandAwareExternalAnnotationsManager;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.java.JavaBundle;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiBasedModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddAnnotationModCommandAction
extends PsiBasedModCommandAction<PsiModifierListOwner> {
    @NotNull
    private final String myAnnotation;
    @NotNull
    private final @NotNull String @NotNull [] myAnnotationsToRemove;
    @NotNull
    private final @NotNull PsiNameValuePair @NotNull [] myPairs;
    @IntentionName
    private final String myText;
    @NotNull
    private final ExternalAnnotationsManager.AnnotationPlace myAnnotationPlace;
    private final boolean myExistsTypeUseTarget;
    private final boolean myHasApplicableAnnotations;

    public AddAnnotationModCommandAction(@NotNull String fqn, @NotNull PsiModifierListOwner modifierListOwner, String ... annotationsToRemove) {
        if (fqn == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(0);
        }
        if (modifierListOwner == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(1);
        }
        if (annotationsToRemove == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(2);
        }
        this(fqn, modifierListOwner, PsiNameValuePair.EMPTY_ARRAY, annotationsToRemove);
    }

    public AddAnnotationModCommandAction(@NotNull String fqn, @NotNull PsiModifierListOwner modifierListOwner, PsiNameValuePair @NotNull [] values, String ... annotationsToRemove) {
        if (fqn == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(3);
        }
        if (modifierListOwner == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(4);
        }
        if (values == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(5);
        }
        if (annotationsToRemove == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(6);
        }
        this(fqn, modifierListOwner, values, AddAnnotationPsiFix.choosePlace(fqn, modifierListOwner), annotationsToRemove);
    }

    public AddAnnotationModCommandAction(@NotNull String fqn, @NotNull PsiModifierListOwner modifierListOwner, PsiNameValuePair @NotNull [] values, @NotNull ExternalAnnotationsManager.AnnotationPlace place, String ... annotationsToRemove) {
        if (fqn == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(7);
        }
        if (modifierListOwner == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(8);
        }
        if (place == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(9);
        }
        if (values == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(10);
        }
        if (annotationsToRemove == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(11);
        }
        this(fqn, modifierListOwner, values, place, AddAnnotationPsiFix.calcText(modifierListOwner, fqn), annotationsToRemove);
    }

    public AddAnnotationModCommandAction(@NotNull String fqn, @NotNull PsiModifierListOwner modifierListOwner, PsiNameValuePair @NotNull [] values, @NotNull ExternalAnnotationsManager.AnnotationPlace place, @IntentionName String text, String ... annotationsToRemove) {
        if (fqn == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(12);
        }
        if (modifierListOwner == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(13);
        }
        if (place == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(14);
        }
        if (values == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(15);
        }
        if (annotationsToRemove == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(16);
        }
        super((PsiElement)modifierListOwner);
        this.myText = text;
        this.myAnnotation = fqn;
        for (PsiNameValuePair value : values) {
            if (!value.isPhysical()) continue;
            throw new IllegalArgumentException("Annotation attributes must be non-physical PSI");
        }
        this.myPairs = values;
        ObjectUtils.assertAllElementsNotNull((Object[])annotationsToRemove);
        this.myAnnotationsToRemove = annotationsToRemove;
        this.myAnnotationPlace = place;
        PsiClass annotationClass = JavaPsiFacade.getInstance((Project)modifierListOwner.getProject()).findClass(this.myAnnotation, modifierListOwner.getResolveScope());
        this.myExistsTypeUseTarget = annotationClass != null && AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE}) != null;
        PsiAnnotationOwner target = AnnotationTargetUtil.getTarget((PsiModifierListOwner)modifierListOwner, (boolean)this.myExistsTypeUseTarget);
        this.myHasApplicableAnnotations = target != null && ContainerUtil.exists((Object[])target.getApplicableAnnotations(), anno -> anno.hasQualifiedName(this.myAnnotation));
    }

    protected boolean isFileAllowed(@NotNull PsiFile file) {
        if (file == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(17);
        }
        return true;
    }

    @Nullable
    public static PsiModifierListOwner getContainer(PsiFile file, int offset) {
        return AddAnnotationModCommandAction.getContainer(file, offset, false);
    }

    @Nullable
    public static PsiModifierListOwner getContainer(PsiFile file, int offset, boolean availableOnReference) {
        return AddAnnotationPsiFix.getContainer(file, offset, availableOnReference);
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"intention.add.annotation.family", (Object[])new Object[0]);
        if (string == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiModifierListOwner element) {
        if (context == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(19);
        }
        if (element == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(20);
        }
        return AddAnnotationModCommandAction.isAvailable(element, this.myAnnotation) ? Presentation.of((String)this.myText) : null;
    }

    public static boolean isAvailable(@NotNull PsiModifierListOwner modifierListOwner, @NotNull String annotationFQN) {
        if (modifierListOwner == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(21);
        }
        if (annotationFQN == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(22);
        }
        return AddAnnotationPsiFix.isAvailable(modifierListOwner, annotationFQN);
    }

    @NotNull
    protected ModCommand perform(@NotNull ActionContext context, @NotNull PsiModifierListOwner listOwner) {
        if (context == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(23);
        }
        if (listOwner == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(24);
        }
        if (this.myHasApplicableAnnotations) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                AddAnnotationModCommandAction.$$$reportNull$$$0(25);
            }
            return modCommand;
        }
        Project project = context.project();
        ModCommandAwareExternalAnnotationsManager annotationsManager = ModCommandAwareExternalAnnotationsManager.getInstance(project);
        ModCommand modCommand = switch (this.myAnnotationPlace) {
            default -> throw new MatchException(null, null);
            case ExternalAnnotationsManager.AnnotationPlace.EXTERNAL -> annotationsManager.annotateExternallyModCommand(listOwner, this.myAnnotation, this.myPairs, Arrays.asList(this.myAnnotationsToRemove));
            case ExternalAnnotationsManager.AnnotationPlace.IN_CODE -> ModCommand.psiUpdate((PsiElement)listOwner, (owner, updater) -> {
                PsiAnnotationOwner target = AnnotationTargetUtil.getTarget((PsiModifierListOwner)owner, (boolean)this.myExistsTypeUseTarget);
                if (target == null) {
                    return;
                }
                AddAnnotationPsiFix.removePhysicalAnnotations(owner, this.myAnnotationsToRemove);
                PsiAnnotation inserted = AddAnnotationPsiFix.addPhysicalAnnotationTo(this.addAnnotation(target, this.myAnnotation), this.myPairs);
                if (inserted != null) {
                    inserted = (PsiAnnotation)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)inserted);
                    this.postProcess(inserted, (ModPsiUpdater)updater);
                }
            });
            case ExternalAnnotationsManager.AnnotationPlace.NEED_ASK_USER -> ModCommand.chooseAction((String)JavaBundle.message((String)"external.annotation.place", (Object[])new Object[0]), (ModCommandAction[])new ModCommandAction[]{new AddAnnotationModCommandAction(this.myAnnotation, listOwner, this.myPairs, ExternalAnnotationsManager.AnnotationPlace.IN_CODE, JavaBundle.message((String)"external.annotation.place.in.code", (Object[])new Object[0]), this.myAnnotationsToRemove), new AddAnnotationModCommandAction(this.myAnnotation, listOwner, this.myPairs, ExternalAnnotationsManager.AnnotationPlace.EXTERNAL, JavaBundle.message((String)"external.annotation.place.external", (Object[])new Object[0]), this.myAnnotationsToRemove)});
            case ExternalAnnotationsManager.AnnotationPlace.NOWHERE -> ModCommand.nop();
        };
        if (modCommand == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(26);
        }
        return modCommand;
    }

    protected void postProcess(@NotNull PsiAnnotation annotation, @NotNull ModPsiUpdater updater) {
        if (annotation == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(27);
        }
        if (updater == null) {
            AddAnnotationModCommandAction.$$$reportNull$$$0(28);
        }
    }

    @Nullable
    protected PsiAnnotation addAnnotation(PsiAnnotationOwner annotationOwner, String fqn) {
        return AddAnnotationPsiFix.expandParameterAndAddAnnotation(annotationOwner, fqn);
    }

    @Nullable
    public static ModCommandAction createAddNullableFix(PsiModifierListOwner owner) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)owner.getProject());
        return AddAnnotationModCommandAction.createAddNullableNotNullFix(owner, manager.getDefaultAnnotation(Nullability.NULLABLE, (PsiElement)owner), manager.getNotNulls());
    }

    @Nullable
    public static ModCommandAction createAddNotNullFix(PsiModifierListOwner owner) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)owner.getProject());
        return AddAnnotationModCommandAction.createAddNullableNotNullFix(owner, manager.getDefaultAnnotation(Nullability.NOT_NULL, (PsiElement)owner), manager.getNullables());
    }

    @Nullable
    private static ModCommandAction createAddNullableNotNullFix(PsiModifierListOwner owner, String annotationToAdd, List<String> annotationsToRemove) {
        if (!AddAnnotationPsiFix.isNullabilityAnnotationApplicable(owner)) {
            return null;
        }
        if (!AnnotationUtil.isAnnotatingApplicable((PsiElement)owner, (String)annotationToAdd)) {
            return null;
        }
        return new AddAnnotationModCommandAction(annotationToAdd, owner, ArrayUtilRt.toStringArray(annotationsToRemove));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationsToRemove";
                break;
            }
            case 5: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/AddAnnotationModCommandAction";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/AddAnnotationModCommandAction";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isFileAllowed";
                break;
            }
            case 18: 
            case 25: 
            case 26: {
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "postProcess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 25, 26 -> new IllegalStateException(string);
        };
    }
}

