/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RedundantLambdaCodeBlockInspection;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class AnonymousCanBeLambdaInspection
extends AbstractBaseJavaLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance(AnonymousCanBeLambdaInspection.class);
    public boolean reportNotAnnotatedInterfaces = true;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.language.level.specific.issues.and.migration.aids", (Object[])new Object[0]);
        if (string == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        return "Convert2Lambda";
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"reportNotAnnotatedInterfaces", (String)JavaAnalysisBundle.message((String)"report.when.interface.is.not.annotated.with.functional.interface", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.LAMBDA_EXPRESSIONS);
        if (set == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(3);
        }
        return new JavaElementVisitor(){

            public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitAnonymousClass(aClass);
                PsiElement parent = aClass.getParent();
                if (AnonymousCanBeLambdaInspection.canBeConvertedToLambda(aClass, false, isOnTheFly || AnonymousCanBeLambdaInspection.this.reportNotAnnotatedInterfaces, Collections.emptySet())) {
                    PsiElement lBrace = aClass.getLBrace();
                    LOG.assertTrue(lBrace != null);
                    TextRange rangeInElement = new TextRange(0, aClass.getStartOffsetInParent() + lBrace.getStartOffsetInParent());
                    ProblemHighlightType type = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    if (isOnTheFly && !AnonymousCanBeLambdaInspection.this.reportNotAnnotatedInterfaces) {
                        PsiClass baseClass = aClass.getBaseClassType().resolve();
                        LOG.assertTrue(baseClass != null);
                        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)baseClass, (String)"java.lang.FunctionalInterface", (int)2)) {
                            type = ProblemHighlightType.INFORMATION;
                        }
                    }
                    holder.registerProblem(parent, JavaAnalysisBundle.message((String)"anonymous.ref.loc.can.be.replaced.with.lambda", (Object[])new Object[0]), type, rangeInElement, new LocalQuickFix[]{new ReplaceWithLambdaFix()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection$1", "visitAnonymousClass"));
            }
        };
    }

    public static boolean mustKeepAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Set<String> runtimeAnnotationsToIgnore) {
        PsiAnnotation[] annotations;
        PsiModifierList modifierList;
        if (listOwner == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(4);
        }
        if (runtimeAnnotationsToIgnore == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(5);
        }
        if ((modifierList = listOwner.getModifierList()) == null) {
            return false;
        }
        for (PsiAnnotation annotation : annotations = modifierList.getAnnotations()) {
            PsiClass containingClass;
            PsiReferenceExpression retentionValue;
            PsiMethod method;
            PsiClass annotationClass;
            String fqn;
            PsiElement psiElement;
            PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
            if (ref == null || !((psiElement = ref.resolve()) instanceof PsiClass) || (fqn = (annotationClass = (PsiClass)psiElement).getQualifiedName()) != null && runtimeAnnotationsToIgnore.contains(fqn) || fqn != null && listOwner instanceof PsiMethod && ContainerUtil.all((Object[])(method = (PsiMethod)listOwner).findSuperMethods(), sm -> {
                PsiAnnotation superAnno = sm.getModifierList().findAnnotation(fqn);
                return superAnno != null && AnnotationUtil.equal((PsiAnnotation)superAnno, (PsiAnnotation)annotation);
            })) continue;
            PsiAnnotation retentionAnno = AnnotationUtil.findAnnotation((PsiModifierListOwner)annotationClass, (String[])new String[]{Retention.class.getName()});
            if (retentionAnno == null) {
                return true;
            }
            PsiAnnotationMemberValue psiAnnotationMemberValue = retentionAnno.findAttributeValue("value");
            if (!(psiAnnotationMemberValue instanceof PsiReferenceExpression) || !((psiAnnotationMemberValue = (retentionValue = (PsiReferenceExpression)psiAnnotationMemberValue).resolve()) instanceof PsiField)) continue;
            PsiField retentionField = (PsiField)psiAnnotationMemberValue;
            if (!RetentionPolicy.RUNTIME.name().equals(retentionField.getName()) && !RetentionPolicy.CLASS.name().equals(retentionField.getName()) || (containingClass = retentionField.getContainingClass()) == null || !RetentionPolicy.class.getName().equals(containingClass.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasForbiddenRefsInsideBody(PsiMethod method, PsiAnonymousClass aClass) {
        ForbiddenRefsChecker checker = new ForbiddenRefsChecker(method, aClass);
        PsiCodeBlock body = method.getBody();
        LOG.assertTrue(body != null);
        body.accept((PsiElementVisitor)checker);
        return checker.hasForbiddenRefs();
    }

    private static PsiType getInferredType(PsiAnonymousClass aClass, PsiMethod method) {
        PsiExpression expression = (PsiExpression)aClass.getParent();
        PsiType psiType = PsiTypesUtil.getExpectedTypeByParent((PsiElement)expression);
        if (psiType != null) {
            return psiType;
        }
        PsiExpression topExpr = expression;
        while (topExpr.getParent() instanceof PsiParenthesizedExpression) {
            topExpr = (PsiExpression)topExpr.getParent();
        }
        PsiCall call = LambdaUtil.treeWalkUp((PsiElement)topExpr);
        if (call != null && call.resolveMethod() != null) {
            Object marker = new Object();
            PsiTreeUtil.mark((PsiElement)aClass, (Object)marker);
            PsiCall copyCall = LambdaUtil.copyTopLevelCall((PsiCall)call);
            if (copyCall == null) {
                return null;
            }
            PsiElement classArg = PsiTreeUtil.releaseMark((PsiElement)copyCall, (Object)marker);
            if (classArg instanceof PsiAnonymousClass) {
                PsiExpression lambda = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createExpressionFromText(ReplaceWithLambdaFix.composeLambdaText(method), (PsiElement)expression);
                lambda = (PsiExpression)classArg.getParent().replace((PsiElement)lambda);
                ((PsiLambdaExpression)lambda).getBody().replace((PsiElement)method.getBody());
                if (copyCall.resolveMethod() == null) {
                    return PsiTypes.nullType();
                }
                PsiType interfaceType = ((PsiLambdaExpression)lambda).getFunctionalInterfaceType();
                return interfaceType;
            }
        }
        return PsiTypes.nullType();
    }

    public static boolean canBeConvertedToLambda(PsiAnonymousClass aClass, boolean acceptParameterizedFunctionTypes, @NotNull Set<String> ignoredRuntimeAnnotations) {
        if (ignoredRuntimeAnnotations == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(6);
        }
        return AnonymousCanBeLambdaInspection.canBeConvertedToLambda(aClass, acceptParameterizedFunctionTypes, true, ignoredRuntimeAnnotations);
    }

    public static boolean isLambdaForm(PsiAnonymousClass aClass, Set<String> ignoredRuntimeAnnotations) {
        PsiMethod[] methods = aClass.getMethods();
        if (methods.length != 1) {
            return false;
        }
        PsiMethod method = methods[0];
        return aClass.getFields().length == 0 && aClass.getInnerClasses().length == 0 && aClass.getInitializers().length == 0 && method.getBody() != null && method.getDocComment() == null && !AnonymousCanBeLambdaInspection.mustKeepAnnotations((PsiModifierListOwner)method, ignoredRuntimeAnnotations) && !method.hasModifierProperty("synchronized") && !method.hasModifierProperty("strictfp") && !AnonymousCanBeLambdaInspection.hasForbiddenRefsInsideBody(method, aClass);
    }

    public static boolean canBeConvertedToLambda(PsiAnonymousClass aClass, boolean acceptParameterizedFunctionTypes, boolean reportNotAnnotatedInterfaces, @NotNull Set<String> ignoredRuntimeAnnotations) {
        PsiElement lambdaContext;
        if (ignoredRuntimeAnnotations == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(7);
        }
        if (aClass.getBaseClassType().hasAnnotations()) {
            return false;
        }
        PsiElement parent = aClass.getParent();
        PsiElement psiElement = lambdaContext = parent != null ? PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent()) : null;
        if (lambdaContext == null || !LambdaUtil.isValidLambdaContext((PsiElement)lambdaContext) && !(lambdaContext instanceof PsiReferenceExpression)) {
            return false;
        }
        return AnonymousCanBeLambdaInspection.isLambdaForm(aClass, acceptParameterizedFunctionTypes, reportNotAnnotatedInterfaces, ignoredRuntimeAnnotations);
    }

    public static boolean isLambdaForm(PsiAnonymousClass aClass, boolean acceptParameterizedFunctionTypes, @NotNull Set<String> ignoredRuntimeAnnotations) {
        if (ignoredRuntimeAnnotations == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(8);
        }
        return AnonymousCanBeLambdaInspection.isLambdaForm(aClass, acceptParameterizedFunctionTypes, true, ignoredRuntimeAnnotations);
    }

    public static boolean isLambdaForm(PsiAnonymousClass aClass, boolean acceptParameterizedFunctionTypes, boolean reportNotAnnotatedInterfaces, @NotNull Set<String> ignoredRuntimeAnnotations) {
        if (ignoredRuntimeAnnotations == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(9);
        }
        if (PsiUtil.isAvailable((JavaFeature)JavaFeature.LAMBDA_EXPRESSIONS, (PsiElement)aClass)) {
            PsiClassType baseClassType = aClass.getBaseClassType();
            PsiClassType.ClassResolveResult resolveResult = baseClassType.resolveGenerics();
            PsiClass baseClass = resolveResult.getElement();
            if (baseClass == null || !reportNotAnnotatedInterfaces && !AnnotationUtil.isAnnotated((PsiModifierListOwner)baseClass, (String)"java.lang.FunctionalInterface", (int)2)) {
                return false;
            }
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult);
            if (interfaceMethod != null && (acceptParameterizedFunctionTypes || !interfaceMethod.hasTypeParameters()) && AnonymousCanBeLambdaInspection.isLambdaForm(aClass, ignoredRuntimeAnnotations)) {
                PsiMethod method = aClass.getMethods()[0];
                return AnonymousCanBeLambdaInspection.getInferredType(aClass, method) != null;
            }
        }
        return false;
    }

    public static PsiExpression replaceAnonymousWithLambda(@NotNull PsiElement anonymousClass, PsiType expectedType) {
        PsiNewExpression newArrayExpression;
        PsiArrayInitializerExpression initializer;
        if (anonymousClass == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(10);
        }
        LOG.assertTrue((initializer = (newArrayExpression = (PsiNewExpression)JavaPsiFacade.getElementFactory((Project)anonymousClass.getProject()).createExpressionFromText("new " + expectedType.getCanonicalText() + "[]{" + anonymousClass.getText() + "}", anonymousClass)).getArrayInitializer()) != null);
        return AnonymousCanBeLambdaInspection.replacePsiElementWithLambda((PsiElement)initializer.getInitializers()[0], true, false);
    }

    public static PsiExpression replacePsiElementWithLambda(@NotNull PsiElement element, boolean ignoreEqualsMethod, boolean forceIgnoreTypeCast) {
        PsiMethod method;
        if (element == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(11);
        }
        if (!(element instanceof PsiNewExpression)) {
            return null;
        }
        PsiNewExpression newExpression = (PsiNewExpression)element;
        PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
        if (anonymousClass == null) {
            return null;
        }
        if (ignoreEqualsMethod) {
            List methods = ContainerUtil.filter((Object[])anonymousClass.getMethods(), method1 -> !"equals".equals(method1.getName()));
            method = (PsiMethod)methods.get(0);
        } else {
            method = anonymousClass.getMethods()[0];
        }
        if (method == null || method.getBody() == null) {
            return null;
        }
        return AnonymousCanBeLambdaInspection.generateLambdaByMethod(anonymousClass, method, lambda -> (PsiLambdaExpression)newExpression.replace((PsiElement)lambda), forceIgnoreTypeCast);
    }

    @NotNull
    static PsiExpression generateLambdaByMethod(PsiAnonymousClass anonymousClass, PsiMethod method, UnaryOperator<PsiLambdaExpression> replacer, boolean forceIgnoreTypeCast) {
        ChangeContextUtil.encodeContextInfo((PsiElement)anonymousClass, true);
        String canonicalText = anonymousClass.getBaseClassType().getCanonicalText();
        PsiCodeBlock body = method.getBody();
        LOG.assertTrue(body != null);
        Collection<PsiComment> comments = AnonymousCanBeLambdaInspection.collectCommentsOutsideMethodBody(anonymousClass.getParent(), body);
        Project project = anonymousClass.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        String withoutTypesDeclared = ReplaceWithLambdaFix.composeLambdaText(method);
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)elementFactory.createExpressionFromText(withoutTypesDeclared, (PsiElement)anonymousClass);
        PsiElement lambdaBody = lambdaExpression.getBody();
        LOG.assertTrue(lambdaBody != null);
        lambdaBody.replace((PsiElement)body);
        lambdaExpression = (PsiLambdaExpression)replacer.apply(lambdaExpression);
        HashSet<PsiVariable> variables = new HashSet<PsiVariable>();
        HashSet<String> usedLocalNames = new HashSet<String>();
        AnonymousCanBeLambdaInspection.collectLocalVariablesDefinedInsideLambda(lambdaExpression, variables, usedLocalNames);
        ReplaceWithLambdaFix.giveUniqueNames(project, elementFactory, (PsiElement)lambdaExpression, usedLocalNames, variables.toArray(new PsiVariable[0]));
        PsiExpression singleExpr = RedundantLambdaCodeBlockInspection.isCodeBlockRedundant(lambdaExpression.getBody());
        if (singleExpr != null) {
            lambdaExpression.getBody().replace((PsiElement)singleExpr);
        }
        ChangeContextUtil.decodeContextInfo((PsiElement)lambdaExpression, null, null);
        AnonymousCanBeLambdaInspection.restoreComments(comments, (PsiElement)lambdaExpression);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        if (forceIgnoreTypeCast) {
            PsiExpression psiExpression = (PsiExpression)javaCodeStyleManager.shortenClassReferences((PsiElement)lambdaExpression);
            if (psiExpression == null) {
                AnonymousCanBeLambdaInspection.$$$reportNull$$$0(12);
            }
            return psiExpression;
        }
        PsiTypeCastExpression typeCast = (PsiTypeCastExpression)elementFactory.createExpressionFromText("(" + canonicalText + ")" + withoutTypesDeclared, (PsiElement)lambdaExpression);
        PsiExpression typeCastOperand = typeCast.getOperand();
        LOG.assertTrue(typeCastOperand instanceof PsiLambdaExpression);
        PsiElement fromText = ((PsiLambdaExpression)typeCastOperand).getBody();
        LOG.assertTrue(fromText != null);
        lambdaBody = lambdaExpression.getBody();
        LOG.assertTrue(lambdaBody != null);
        fromText.replace(lambdaBody);
        ((PsiLambdaExpression)typeCastOperand).getParameterList().replace((PsiElement)lambdaExpression.getParameterList());
        typeCast = (PsiTypeCastExpression)lambdaExpression.replace((PsiElement)typeCast);
        if (RedundantCastUtil.isCastRedundant(typeCast)) {
            PsiExpression operand = typeCast.getOperand();
            LOG.assertTrue(operand != null);
            PsiExpression psiExpression = (PsiExpression)typeCast.replace((PsiElement)operand);
            if (psiExpression == null) {
                AnonymousCanBeLambdaInspection.$$$reportNull$$$0(13);
            }
            return psiExpression;
        }
        PsiExpression psiExpression = (PsiExpression)javaCodeStyleManager.shortenClassReferences((PsiElement)typeCast);
        if (psiExpression == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(14);
        }
        return psiExpression;
    }

    @NotNull
    static @Unmodifiable Collection<PsiComment> collectCommentsOutsideMethodBody(PsiElement anonymousClass, PsiCodeBlock body) {
        List psiComments = ContainerUtil.filter((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)anonymousClass, PsiComment.class), comment -> !PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)comment, (boolean)false));
        List list = ContainerUtil.map((Collection)psiComments, comment -> (PsiComment)comment.copy());
        if (list == null) {
            AnonymousCanBeLambdaInspection.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static void collectLocalVariablesDefinedInsideLambda(PsiLambdaExpression lambdaExpression, final Set<PsiVariable> variables, Set<? super String> namesOfVariablesInTheBlock) {
        PsiElement block = PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)lambdaExpression, null);
        if (block == null) {
            block = lambdaExpression;
        }
        block.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitVariable(@NotNull PsiVariable variable) {
                if (variable == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitVariable(variable);
                if (!(variable instanceof PsiField)) {
                    variables.add(variable);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection$2", "visitVariable"));
            }
        });
        PsiResolveHelper helper = PsiResolveHelper.getInstance((Project)lambdaExpression.getProject());
        Iterator<PsiVariable> iterator = variables.iterator();
        while (iterator.hasNext()) {
            PsiVariable local = iterator.next();
            String localName = local.getName();
            if (localName != null && !AnonymousCanBeLambdaInspection.shadowingResolve(localName, lambdaExpression, helper) && PsiTreeUtil.isAncestor((PsiElement)lambdaExpression, (PsiElement)local, (boolean)false)) continue;
            iterator.remove();
            namesOfVariablesInTheBlock.add(localName);
        }
    }

    private static boolean shadowingResolve(String localName, PsiLambdaExpression lambdaExpression, PsiResolveHelper helper) {
        PsiVariable variable = helper.resolveReferencedVariable(localName, (PsiElement)lambdaExpression);
        return variable == null || variable instanceof PsiField;
    }

    public static boolean functionalInterfaceMethodReferenced(PsiMethod psiMethod, PsiAnonymousClass anonymousClass, PsiCallExpression callExpression) {
        if (psiMethod != null && !psiMethod.hasModifierProperty("static")) {
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass != null && "java.lang.Object".equals(containingClass.getQualifiedName())) {
                return !(callExpression instanceof PsiMethodCallExpression) || !((PsiMethodCallExpression)callExpression).getMethodExpression().isQualified();
            }
            if (callExpression instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)callExpression).getMethodExpression().isQualified()) {
                return false;
            }
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)anonymousClass, (PsiClass)containingClass, (boolean)true) && !InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)containingClass, (PsiElement)anonymousClass.getParent(), (boolean)true, (boolean)true)) {
                return true;
            }
        }
        return false;
    }

    public static void restoreComments(Collection<? extends PsiComment> comments, PsiElement lambda) {
        PsiElement anchor = PsiTreeUtil.getParentOfType((PsiElement)lambda, (Class[])new Class[]{PsiStatement.class, PsiField.class});
        if (anchor == null) {
            anchor = lambda;
        }
        for (PsiComment psiComment : comments) {
            anchor.getParent().addBefore((PsiElement)psiComment, anchor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/AnonymousCanBeLambdaInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtimeAnnotationsToIgnore";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredRuntimeAnnotations";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anonymousClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/AnonymousCanBeLambdaInspection";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "generateLambdaByMethod";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCommentsOutsideMethodBody";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mustKeepAnnotations";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canBeConvertedToLambda";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isLambdaForm";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceAnonymousWithLambda";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replacePsiElementWithLambda";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    private static class ForbiddenRefsChecker
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myBodyContainsForbiddenRefs;
        private final PsiMethod myMethod;
        private final PsiAnonymousClass myAnonymousClass;

        ForbiddenRefsChecker(PsiMethod method, PsiAnonymousClass aClass) {
            this.myMethod = method;
            this.myAnonymousClass = aClass;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression methodCallExpression) {
            if (methodCallExpression == null) {
                ForbiddenRefsChecker.$$$reportNull$$$0(0);
            }
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            super.visitMethodCallExpression(methodCallExpression);
            PsiMethod psiMethod = methodCallExpression.resolveMethod();
            if (psiMethod == this.myMethod || AnonymousCanBeLambdaInspection.functionalInterfaceMethodReferenced(psiMethod, this.myAnonymousClass, (PsiCallExpression)methodCallExpression)) {
                this.myBodyContainsForbiddenRefs = true;
            }
        }

        public void visitThisExpression(@NotNull PsiThisExpression expression) {
            if (expression == null) {
                ForbiddenRefsChecker.$$$reportNull$$$0(1);
            }
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            if (expression.getQualifier() == null) {
                this.myBodyContainsForbiddenRefs = true;
            }
        }

        public void visitSuperExpression(@NotNull PsiSuperExpression expression) {
            if (expression == null) {
                ForbiddenRefsChecker.$$$reportNull$$$0(2);
            }
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            if (expression.getQualifier() == null) {
                this.myBodyContainsForbiddenRefs = true;
            }
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                ForbiddenRefsChecker.$$$reportNull$$$0(3);
            }
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            super.visitVariable(variable);
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                ForbiddenRefsChecker.$$$reportNull$$$0(4);
            }
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            super.visitReferenceExpression(expression);
            if (!(expression.getParent() instanceof PsiMethodCallExpression)) {
                PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)this.myAnonymousClass, PsiMember.class);
                if (member instanceof PsiField || member instanceof PsiClassInitializer) {
                    PsiExpression initializer;
                    PsiElement resolved = expression.resolve();
                    PsiClass memberContainingClass = member.getContainingClass();
                    if (resolved instanceof PsiField && memberContainingClass != null && PsiTreeUtil.isAncestor((PsiElement)((PsiField)resolved).getContainingClass(), (PsiElement)memberContainingClass, (boolean)false) && expression.getQualifierExpression() == null && ((initializer = ((PsiField)resolved).getInitializer()) == null || resolved == member || initializer.getTextOffset() > this.myAnonymousClass.getTextOffset() && ((PsiField)resolved).hasModifierProperty("static") == member.hasModifierProperty("static"))) {
                        this.myBodyContainsForbiddenRefs = true;
                    }
                } else {
                    PsiElement resolved;
                    PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myAnonymousClass, PsiMethod.class);
                    if (method != null && method.isConstructor() && (resolved = expression.resolve()) instanceof PsiField && ((PsiField)resolved).hasModifierProperty("final") && ((PsiField)resolved).getInitializer() == null && ((PsiField)resolved).getContainingClass() == method.getContainingClass()) {
                        try {
                            int startOffset;
                            ControlFlow flow;
                            Collection writtenVariables;
                            PsiCodeBlock constructorBody = method.getBody();
                            if (constructorBody != null && !(writtenVariables = ControlFlowUtil.getWrittenVariables((ControlFlow)(flow = ControlFlowFactory.getControlFlowNoConstantEvaluate((PsiElement)constructorBody)), (int)0, (int)(startOffset = flow.getStartOffset((PsiElement)this.myAnonymousClass)), (boolean)false)).contains(resolved)) {
                                this.myBodyContainsForbiddenRefs = true;
                            }
                        }
                        catch (AnalysisCanceledException e) {
                            this.myBodyContainsForbiddenRefs = true;
                        }
                    }
                }
            }
        }

        public boolean hasForbiddenRefs() {
            return this.myBodyContainsForbiddenRefs;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodCallExpression";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/AnonymousCanBeLambdaInspection$ForbiddenRefsChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitThisExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSuperExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVariable";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReplaceWithLambdaFix
    extends PsiUpdateModCommandQuickFix
    implements HighPriorityAction {
        private ReplaceWithLambdaFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"replace.with.lambda", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithLambdaFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ReplaceWithLambdaFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithLambdaFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithLambdaFix.$$$reportNull$$$0(3);
            }
            AnonymousCanBeLambdaInspection.replacePsiElementWithLambda(element, false, false);
        }

        private static void giveUniqueNames(Project project, final PsiElementFactory elementFactory, PsiElement body, Set<String> usedLocalNames, PsiVariable[] parameters) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            final HashMap<PsiVariable, String> names = new HashMap<PsiVariable, String>();
            for (PsiVariable parameter : parameters) {
                String uniqueVariableName;
                String parameterName = parameter.getName();
                if (Objects.equals(parameterName, uniqueVariableName = UniqueNameGenerator.generateUniqueName((String)codeStyleManager.suggestUniqueVariableName(parameterName, parameter.getParent(), false), usedLocalNames))) continue;
                names.put(parameter, uniqueVariableName);
            }
            if (names.isEmpty()) {
                return;
            }
            final LinkedHashMap replacements = new LinkedHashMap();
            body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitVariable(@NotNull PsiVariable variable) {
                    if (variable == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitVariable(variable);
                    String newName = (String)names.get(variable);
                    if (newName != null) {
                        replacements.put(variable.getNameIdentifier(), elementFactory.createIdentifier(newName));
                    }
                }

                public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                    String newName;
                    if (expression == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.visitReferenceExpression(expression);
                    PsiElement resolve = expression.resolve();
                    if (resolve instanceof PsiVariable && (newName = (String)names.get(resolve)) != null) {
                        replacements.put(expression, elementFactory.createExpressionFromText(newName, (PsiElement)expression));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "variable";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/codeInspection/AnonymousCanBeLambdaInspection$ReplaceWithLambdaFix$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitVariable";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitReferenceExpression";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            for (PsiElement psiElement : replacements.keySet()) {
                psiElement.replace((PsiElement)replacements.get(psiElement));
            }
        }

        private static String composeLambdaText(PsiMethod method) {
            StringBuilder buf = new StringBuilder();
            Object[] parameters = method.getParameterList().getParameters();
            if (parameters.length != 1) {
                buf.append("(");
            }
            buf.append(StringUtil.join((Object[])parameters, ReplaceWithLambdaFix::composeParameter, (String)","));
            if (parameters.length != 1) {
                buf.append(")");
            }
            buf.append("-> {}");
            return buf.toString();
        }

        private static String composeParameter(PsiParameter parameter) {
            return parameter.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/AnonymousCanBeLambdaInspection$ReplaceWithLambdaFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/AnonymousCanBeLambdaInspection$ReplaceWithLambdaFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

