/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class AnonymousHasLambdaAlternativeInspection
extends AbstractBaseJavaLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance(AnonymousHasLambdaAlternativeInspection.class);
    private static final AnonymousLambdaAlternative[] ALTERNATIVES = new AnonymousLambdaAlternative[]{new AnonymousLambdaAlternative("java.lang.ThreadLocal", "initialValue", "java.lang.ThreadLocal.withInitial($lambda$)", "ThreadLocal.withInitial()"), new AnonymousLambdaAlternative("java.lang.Thread", "run", "new java.lang.Thread($lambda$)", "new Thread(() -> {\u2026})")};

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.THREAD_LOCAL_WITH_INITIAL);
        if (set == null) {
            AnonymousHasLambdaAlternativeInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AnonymousHasLambdaAlternativeInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitAnonymousClass(aClass);
                PsiExpressionList argumentList = aClass.getArgumentList();
                if (AnonymousCanBeLambdaInspection.isLambdaForm(aClass, Collections.emptySet()) && argumentList != null && argumentList.isEmpty()) {
                    PsiMethod method = aClass.getMethods()[0];
                    PsiClassType type = aClass.getBaseClassType();
                    AnonymousLambdaAlternative alternative = 1.getAlternative(type.resolve(), method);
                    if (alternative != null) {
                        PsiElement lBrace = aClass.getLBrace();
                        LOG.assertTrue(lBrace != null);
                        TextRange rangeInElement = new TextRange(0, lBrace.getStartOffsetInParent() + aClass.getStartOffsetInParent() - 1);
                        holder.registerProblem(aClass.getParent(), rangeInElement, JavaAnalysisBundle.message((String)"anonymous.ref.loc.can.be.replaced.with.0", (Object[])new Object[]{alternative.myReplacementMessage}), new LocalQuickFix[]{new ReplaceWithLambdaAlternativeFix(alternative)});
                    }
                }
            }

            @Contract(value="null, _ -> null")
            private static AnonymousLambdaAlternative getAlternative(PsiClass type, PsiMethod method) {
                if (type == null) {
                    return null;
                }
                for (AnonymousLambdaAlternative alternative : ALTERNATIVES) {
                    if (!alternative.myClassName.equals(type.getQualifiedName()) || !alternative.myMethodName.equals(method.getName())) continue;
                    return alternative;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInspection/AnonymousHasLambdaAlternativeInspection$1", "visitAnonymousClass"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/AnonymousHasLambdaAlternativeInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/AnonymousHasLambdaAlternativeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    static final class AnonymousLambdaAlternative {
        final String myClassName;
        final String myMethodName;
        final String myLambdaAlternative;
        final String myReplacementMessage;

        AnonymousLambdaAlternative(@NonNls String className, @NonNls String methodName, @NonNls String lambdaAlternative, @NonNls String replacementMessage) {
            this.myClassName = className;
            this.myMethodName = methodName;
            this.myLambdaAlternative = lambdaAlternative;
            this.myReplacementMessage = replacementMessage;
        }
    }

    static class ReplaceWithLambdaAlternativeFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        private final AnonymousLambdaAlternative myAlternative;

        ReplaceWithLambdaAlternativeFix(@NotNull AnonymousLambdaAlternative alternative) {
            if (alternative == null) {
                ReplaceWithLambdaAlternativeFix.$$$reportNull$$$0(0);
            }
            this.myAlternative = alternative;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = JavaAnalysisBundle.message((String)"replace.with.0", (Object[])new Object[]{this.myAlternative.myReplacementMessage});
            if (string == null) {
                ReplaceWithLambdaAlternativeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"replace.anonymous.class.with.lambda.alternative", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithLambdaAlternativeFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ReplaceWithLambdaAlternativeFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                ReplaceWithLambdaAlternativeFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                ReplaceWithLambdaAlternativeFix.$$$reportNull$$$0(5);
            }
            if (!(element instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)element;
            PsiAnonymousClass aClass = newExpression.getAnonymousClass();
            if (aClass == null) {
                return;
            }
            PsiMethod[] methods = aClass.getMethods();
            if (methods.length != 1) {
                return;
            }
            PsiMethod method = methods[0];
            if (method.getBody() == null) {
                return;
            }
            UnaryOperator replacer = lambda -> {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiElement replacement = element.replace((PsiElement)factory.createExpressionFromText(this.myAlternative.myLambdaAlternative, element));
                PsiElement[] lambdaPositions = PsiTreeUtil.collectElements((PsiElement)replacement, e -> e instanceof PsiReference && e.textMatches((CharSequence)"$lambda$"));
                LOG.assertTrue(lambdaPositions.length == 1);
                return (PsiLambdaExpression)lambdaPositions[0].replace((PsiElement)lambda);
            };
            AnonymousCanBeLambdaInspection.generateLambdaByMethod(aClass, method, replacer, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alternative";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/AnonymousHasLambdaAlternativeInspection$ReplaceWithLambdaAlternativeFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/AnonymousHasLambdaAlternativeInspection$ReplaceWithLambdaAlternativeFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

