/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.UpdateInspectionOptionFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConditionalBreakInInfiniteLoopInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean noConversionToDoWhile = false;
    public boolean allowConditionFusion = false;
    public boolean suggestConversionWhenIfIsASingleStmtInLoop = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"noConversionToDoWhile", (String)JavaBundle.message((String)"inspection.conditional.break.in.infinite.loop.no.conversion.with.do.while", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"allowConditionFusion", (String)JavaBundle.message((String)"inspection.conditional.break.in.infinite.loop.allow.condition.fusion", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"suggestConversionWhenIfIsASingleStmtInLoop", (String)JavaBundle.message((String)"inspection.conditional.break.in.infinite.loop.suggest.conversion.when.if.is.single.stmt.in.loop", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ConditionalBreakInInfiniteLoopInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ConditionalBreakInInfiniteLoopInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitForStatement(@NotNull PsiForStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.visitLoop((PsiConditionalLoopStatement)statement, statement.getFirstChild());
            }

            public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.visitLoop((PsiConditionalLoopStatement)statement, statement.getFirstChild());
            }

            public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.visitLoop((PsiConditionalLoopStatement)statement, (PsiElement)statement.getWhileKeyword());
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void visitLoop(@NotNull PsiConditionalLoopStatement loopStatement, @Nullable PsiElement keyword) {
                ProblemHighlightType highlightType;
                LocalQuickFix[] fixes;
                if (loopStatement == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (keyword == null) {
                    return;
                }
                Context context = Context.from(loopStatement, ConditionalBreakInInfiniteLoopInspection.this.noConversionToDoWhile, ConditionalBreakInInfiniteLoopInspection.this.suggestConversionWhenIfIsASingleStmtInLoop);
                if (context == null) {
                    return;
                }
                if (context.conditionInTheBeginning) {
                    fixes = new LocalQuickFix[]{new LoopTransformationFix(ConditionalBreakInInfiniteLoopInspection.this.noConversionToDoWhile)};
                } else {
                    UpdateInspectionOptionFix setInspectionOptionFix = new UpdateInspectionOptionFix((InspectionProfileEntry)ConditionalBreakInInfiniteLoopInspection.this, "noConversionToDoWhile", JavaBundle.message((String)"inspection.conditional.break.in.infinite.loop.no.conversion.with.do.while", (Object[])new Object[0]), true);
                    fixes = new LocalQuickFix[]{new LoopTransformationFix(ConditionalBreakInInfiniteLoopInspection.this.noConversionToDoWhile), LocalQuickFix.from((ModCommandAction)setInspectionOptionFix)};
                }
                if (!ConditionalBreakInInfiniteLoopInspection.this.allowConditionFusion && !context.isInfiniteLoop) {
                    if (!holder.isOnTheFly()) return;
                    highlightType = ProblemHighlightType.INFORMATION;
                } else {
                    highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                }
                holder.registerProblem(keyword, JavaBundle.message((String)"inspection.conditional.break.in.infinite.loop.description", (Object[])new Object[0]), highlightType, fixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "loopStatement";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/ConditionalBreakInInfiniteLoopInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitForStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitWhileStatement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDoWhileStatement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLoop";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static void tryTransform(@NotNull PsiWhileStatement whileStatement) {
        Context context;
        if (whileStatement == null) {
            ConditionalBreakInInfiniteLoopInspection.$$$reportNull$$$0(2);
        }
        if ((context = Context.from((PsiConditionalLoopStatement)whileStatement, true, true)) != null) {
            context.simplify((PsiConditionalLoopStatement)whileStatement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ConditionalBreakInInfiniteLoopInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whileStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ConditionalBreakInInfiniteLoopInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryTransform";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private record Context(@NotNull PsiLoopStatement loopStatement, @NotNull PsiStatement loopBody, @NotNull PsiExpression condition, @NotNull PsiIfStatement statement, boolean conditionInTheBeginning, boolean conditionInThen, boolean isInfiniteLoop) {
        @NotNull
        private final PsiLoopStatement loopStatement;
        @NotNull
        private final PsiStatement loopBody;
        @NotNull
        private final PsiExpression condition;
        @NotNull
        private final PsiIfStatement statement;

        private Context(@NotNull PsiLoopStatement loopStatement, @NotNull PsiStatement loopBody, @NotNull PsiExpression condition, @NotNull PsiIfStatement statement, boolean conditionInTheBeginning, boolean conditionInThen, boolean isInfiniteLoop) {
            if (loopStatement == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (loopBody == null) {
                Context.$$$reportNull$$$0(1);
            }
            if (condition == null) {
                Context.$$$reportNull$$$0(2);
            }
            if (statement == null) {
                Context.$$$reportNull$$$0(3);
            }
        }

        @Nullable
        private static Context from(@NotNull PsiConditionalLoopStatement loopStatement, boolean noConversionToDoWhile, boolean suggestConversionWhenIfIsASingleStmtInLoop) {
            boolean isLoopConditionAtStart;
            PsiForStatement forStatement;
            boolean isEndlessLoop;
            if (loopStatement == null) {
                Context.$$$reportNull$$$0(4);
            }
            if (!(isEndlessLoop = ControlFlowUtils.isEndlessLoop(loopStatement)) && loopStatement instanceof PsiForStatement && ((forStatement = (PsiForStatement)loopStatement).getInitialization() != null && !(forStatement.getInitialization() instanceof PsiEmptyStatement) || forStatement.getUpdate() != null && !(forStatement.getUpdate() instanceof PsiEmptyStatement))) {
                return null;
            }
            PsiStatement body = loopStatement.getBody();
            if (body == null) {
                return null;
            }
            Object[] statements = ControlFlowUtils.unwrapBlock(body);
            if (statements.length < 1) {
                return null;
            }
            if (statements.length == 1 && !suggestConversionWhenIfIsASingleStmtInLoop) {
                return null;
            }
            if (((StreamEx)StreamEx.ofTree((Object)body, el -> StreamEx.of((Object[])el.getChildren())).select(PsiBreakStatement.class).filter(stmt -> ControlFlowUtils.statementBreaksLoop((PsiStatement)stmt, (PsiLoopStatement)loopStatement))).count() != 1L) {
                return null;
            }
            PsiIfStatement first = (PsiIfStatement)ObjectUtils.tryCast((Object)statements[0], PsiIfStatement.class);
            Ref isBreakInThen = new Ref((Object)false);
            PsiExpression firstBreakCondition = Context.extractBreakCondition(first, (PsiLoopStatement)loopStatement, (Ref<? super Boolean>)isBreakInThen);
            PsiExpression loopCondition = loopStatement.getCondition();
            boolean bl = isLoopConditionAtStart = !(loopStatement instanceof PsiDoWhileStatement);
            if (first != null && firstBreakCondition != null && (isEndlessLoop || isLoopConditionAtStart && BoolUtils.getLogicalOperandCount(loopCondition) + BoolUtils.getLogicalOperandCount(firstBreakCondition) < 4)) {
                return new Context((PsiLoopStatement)loopStatement, body, firstBreakCondition, first, true, (Boolean)isBreakInThen.get(), isEndlessLoop);
            }
            if (noConversionToDoWhile) {
                return null;
            }
            PsiIfStatement last = (PsiIfStatement)ObjectUtils.tryCast((Object)statements[statements.length - 1], PsiIfStatement.class);
            if (last != null && last.getElseBranch() != null) {
                return null;
            }
            PsiExpression lastBreakCondition = Context.extractBreakCondition(last, (PsiLoopStatement)loopStatement, (Ref<? super Boolean>)isBreakInThen);
            if (lastBreakCondition == null || !((Boolean)isBreakInThen.get()).booleanValue()) {
                return null;
            }
            if (!isEndlessLoop && (isLoopConditionAtStart || 3 < BoolUtils.getLogicalOperandCount(loopCondition) + BoolUtils.getLogicalOperandCount(lastBreakCondition))) {
                return null;
            }
            if (StreamEx.of((Object[])statements).flatMap(statement -> StreamEx.ofTree((Object)statement, el -> StreamEx.of((Object[])el.getChildren()))).anyMatch(e -> e instanceof PsiContinueStatement && ((PsiContinueStatement)e).findContinuedStatement() == loopStatement)) {
                return null;
            }
            boolean variablesInLoop = ContainerUtil.exists(VariableAccessUtils.collectUsedVariables((PsiElement)lastBreakCondition), variable -> PsiTreeUtil.isAncestor((PsiElement)loopStatement, (PsiElement)variable, (boolean)false));
            if (variablesInLoop) {
                return null;
            }
            return new Context((PsiLoopStatement)loopStatement, body, lastBreakCondition, last, false, (Boolean)isBreakInThen.get(), isEndlessLoop);
        }

        @Contract(value="null, _, _ -> null")
        @Nullable
        private static PsiExpression extractBreakCondition(@Nullable PsiIfStatement ifStatement, @NotNull PsiLoopStatement loopStatement, Ref<? super @NotNull Boolean> isBreakInThen) {
            if (loopStatement == null) {
                Context.$$$reportNull$$$0(5);
            }
            if (ifStatement == null) {
                return null;
            }
            if (ControlFlowUtils.statementBreaksLoop(ControlFlowUtils.stripBraces(ifStatement.getThenBranch()), loopStatement)) {
                if (Context.hasVariableNameConflict(loopStatement, ifStatement, ifStatement.getElseBranch())) {
                    return null;
                }
                isBreakInThen.set((Object)true);
                return ifStatement.getCondition();
            }
            if (ifStatement.getElseBranch() != null && ControlFlowUtils.statementBreaksLoop(ControlFlowUtils.stripBraces(ifStatement.getElseBranch()), loopStatement)) {
                if (Context.hasVariableNameConflict(loopStatement, ifStatement, ifStatement.getThenBranch())) {
                    return null;
                }
                isBreakInThen.set((Object)false);
                return ifStatement.getCondition();
            }
            return null;
        }

        private static boolean hasVariableNameConflict(@NotNull PsiLoopStatement loopStatement, @NotNull PsiIfStatement ifStatement, @Nullable PsiStatement branch) {
            Set otherVariablesUsedInLoop;
            if (loopStatement == null) {
                Context.$$$reportNull$$$0(6);
            }
            if (ifStatement == null) {
                Context.$$$reportNull$$$0(7);
            }
            if (branch == null) {
                return false;
            }
            Set variablesCreatedInBranch = VariableAccessUtils.findDeclaredVariables(branch).stream().map(PsiNamedElement::getName).collect(Collectors.toSet());
            return !Collections.disjoint(variablesCreatedInBranch, otherVariablesUsedInLoop = VariableAccessUtils.collectUsedVariables((PsiElement)loopStatement.getBody()).stream().filter(variable -> !PsiTreeUtil.isAncestor((PsiElement)ifStatement, (PsiElement)variable, (boolean)false)).map(PsiNamedElement::getName).collect(Collectors.toSet()));
        }

        private void simplify(@NotNull PsiConditionalLoopStatement loop) {
            String loopText;
            if (loop == null) {
                Context.$$$reportNull$$$0(8);
            }
            CommentTracker ct = new CommentTracker();
            if (ControlFlowUtils.isEndlessLoop(loop)) {
                String conditionForWhile = this.conditionInThen ? BoolUtils.getNegatedExpressionText(this.condition, ct) : ct.text((PsiElement)this.condition);
                LoopTransformationFix.pullDownStatements(this.statement, this.conditionInThen ? this.statement.getElseBranch() : this.statement.getThenBranch());
                ct.delete((PsiElement)this.statement);
                loopText = this.conditionInTheBeginning ? "while(" + conditionForWhile + ")" + ct.text((PsiElement)this.loopBody) : "do" + ct.text((PsiElement)this.loopBody) + "while(" + conditionForWhile + ");";
            } else {
                String conditionForWhile = this.conditionInThen ? BoolUtils.getNegatedExpressionText(this.condition, 13, ct) : ct.text(this.condition, 13);
                ct.delete((PsiElement)this.statement);
                PsiExpression loopCondition = loop.getCondition();
                assert (loopCondition != null);
                loopText = this.conditionInTheBeginning ? "while(" + ct.text(loopCondition, 13) + " && " + conditionForWhile + ")" + ct.text((PsiElement)this.loopBody) : "do" + ct.text((PsiElement)this.loopBody) + "while(" + conditionForWhile + " && " + ct.text(loopCondition, 13) + ");";
            }
            ct.replaceAndRestoreComments((PsiElement)this.loopStatement, loopText);
        }

        @NotNull
        public PsiLoopStatement loopStatement() {
            PsiLoopStatement psiLoopStatement = this.loopStatement;
            if (psiLoopStatement == null) {
                Context.$$$reportNull$$$0(9);
            }
            return psiLoopStatement;
        }

        @NotNull
        public PsiStatement loopBody() {
            PsiStatement psiStatement = this.loopBody;
            if (psiStatement == null) {
                Context.$$$reportNull$$$0(10);
            }
            return psiStatement;
        }

        @NotNull
        public PsiExpression condition() {
            PsiExpression psiExpression = this.condition;
            if (psiExpression == null) {
                Context.$$$reportNull$$$0(11);
            }
            return psiExpression;
        }

        @NotNull
        public PsiIfStatement statement() {
            PsiIfStatement psiIfStatement = this.statement;
            if (psiIfStatement == null) {
                Context.$$$reportNull$$$0(12);
            }
            return psiIfStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 9, 10, 11, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loopStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loopBody";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loop";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ConditionalBreakInInfiniteLoopInspection$Context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ConditionalBreakInInfiniteLoopInspection$Context";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loopStatement";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loopBody";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "condition";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "statement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "from";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "extractBreakCondition";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "hasVariableNameConflict";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "simplify";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 9, 10, 11, 12 -> new IllegalStateException(string);
            };
        }
    }

    private static class LoopTransformationFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean noConversionToDoWhile;

        private LoopTransformationFix(boolean noConversionToDoWhile) {
            this.noConversionToDoWhile = noConversionToDoWhile;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.conditional.break.in.infinite.loop", (Object[])new Object[0]);
            if (string == null) {
                LoopTransformationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiConditionalLoopStatement loop;
            if (project == null) {
                LoopTransformationFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                LoopTransformationFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                LoopTransformationFix.$$$reportNull$$$0(3);
            }
            if ((loop = (PsiConditionalLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiConditionalLoopStatement.class)) == null) {
                return;
            }
            Context context = Context.from(loop, this.noConversionToDoWhile, false);
            if (context == null) {
                return;
            }
            context.simplify(loop);
        }

        private static void pullDownStatements(@NotNull PsiIfStatement conditionStatement, @Nullable PsiStatement branch) {
            if (conditionStatement == null) {
                LoopTransformationFix.$$$reportNull$$$0(4);
            }
            if (branch != null) {
                PsiElement parent = conditionStatement.getParent();
                PsiStatement[] branchStatements = ControlFlowUtils.unwrapBlock(branch);
                for (int statementIndex = branchStatements.length - 1; 0 <= statementIndex; --statementIndex) {
                    PsiStatement statement = branchStatements[statementIndex];
                    parent.addAfter((PsiElement)statement, (PsiElement)conditionStatement);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ConditionalBreakInInfiniteLoopInspection$LoopTransformationFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conditionStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ConditionalBreakInInfiniteLoopInspection$LoopTransformationFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "pullDownStatements";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

