/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class StringTokenizerDelimiterInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NonNls
    private static final String NEXT_TOKEN = "nextToken";
    @NonNls
    private static final String STRING_TOKENIZER = "java.util.StringTokenizer";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            StringTokenizerDelimiterInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitCallExpression(@NotNull PsiCallExpression callExpression) {
                PsiClass stringTokenizer;
                if (callExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiExpressionList argumentList = callExpression.getArgumentList();
                PsiMethod method = callExpression.resolveMethod();
                if (method != null && argumentList != null && (method.isConstructor() || StringTokenizerDelimiterInspection.NEXT_TOKEN.equals(method.getName())) && (stringTokenizer = method.getContainingClass()) != null && StringTokenizerDelimiterInspection.STRING_TOKENIZER.equals(stringTokenizer.getQualifiedName())) {
                    PsiExpression[] arguments = argumentList.getExpressions();
                    int argCount = arguments.length;
                    if (method.isConstructor()) {
                        if (argCount == 2 || argCount == 3) {
                            StringTokenizerDelimiterInspection.hasArgumentDuplicates(arguments[1], holder);
                        }
                    } else if (argCount == 1) {
                        StringTokenizerDelimiterInspection.hasArgumentDuplicates(arguments[0], holder);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/codeInspection/StringTokenizerDelimiterInspection$1", "visitCallExpression"));
            }
        };
    }

    private static void hasArgumentDuplicates(PsiExpression delimiterArgument, ProblemsHolder holder) {
        PsiLiteralExpression literal;
        Object object;
        if (delimiterArgument instanceof PsiLiteralExpression && (object = (literal = (PsiLiteralExpression)delimiterArgument).getValue()) instanceof String) {
            String delimiters = (String)object;
            HashSet<Character> chars = new HashSet<Character>();
            for (char c : delimiters.toCharArray()) {
                if (chars.add(Character.valueOf(c))) continue;
                holder.problem((PsiElement)delimiterArgument, JavaAnalysisBundle.message((String)"delimiters.argument.contains.duplicated.characters", (Object[])new Object[0])).fix((ModCommandAction)new ReplaceDelimitersWithUnique(literal)).register();
                return;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/StringTokenizerDelimiterInspection", "buildVisitor"));
    }

    private static final class ReplaceDelimitersWithUnique
    extends PsiUpdateModCommandAction<PsiLiteralExpression> {
        ReplaceDelimitersWithUnique(@NotNull PsiLiteralExpression element) {
            if (element == null) {
                ReplaceDelimitersWithUnique.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"replace.stringtokenizer.delimiters.parameter.with.unique.symbols", (Object[])new Object[0]);
            if (string == null) {
                ReplaceDelimitersWithUnique.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiLiteralExpression delimiterArgument, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                ReplaceDelimitersWithUnique.$$$reportNull$$$0(2);
            }
            if (delimiterArgument == null) {
                ReplaceDelimitersWithUnique.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceDelimitersWithUnique.$$$reportNull$$$0(4);
            }
            LinkedHashSet<Character> uniqueChars = new LinkedHashSet<Character>();
            Object object = delimiterArgument.getValue();
            if (!(object instanceof String)) {
                return;
            }
            String value = (String)object;
            for (Object c : (Object)value.toCharArray()) {
                uniqueChars.add(Character.valueOf((char)c));
            }
            String newDelimiters = StringUtil.join(uniqueChars, (String)"");
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)context.project());
            delimiterArgument.replace((PsiElement)elementFactory.createExpressionFromText("\"" + StringUtil.escapeStringCharacters((String)newDelimiters) + "\"", null));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/StringTokenizerDelimiterInspection$ReplaceDelimitersWithUnique";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delimiterArgument";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/StringTokenizerDelimiterInspection$ReplaceDelimitersWithUnique";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

