/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.accessStaticViaInstance;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AccessStaticViaInstanceBase
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    @NonNls
    public static final String ACCESS_STATIC_VIA_INSTANCE = "AccessStaticViaInstance";

    @NotNull
    public String getGroupDisplayName() {
        return "";
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return ACCESS_STATIC_VIA_INSTANCE;
    }

    public String getAlternativeID() {
        return "static-access";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AccessStaticViaInstanceBase.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                AccessStaticViaInstanceBase.this.checkAccessStaticMemberViaInstanceReference(expression, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/accessStaticViaInstance/AccessStaticViaInstanceBase$1", "visitReferenceExpression"));
            }
        };
    }

    private void checkAccessStaticMemberViaInstanceReference(PsiReferenceExpression expr, ProblemsHolder holder) {
        PsiElement qualifierResolved;
        JavaResolveResult result = expr.advancedResolve(false);
        PsiElement resolved = result.getElement();
        if (!(resolved instanceof PsiMember)) {
            return;
        }
        PsiMember member = (PsiMember)resolved;
        PsiExpression qualifierExpression = expr.getQualifierExpression();
        if (qualifierExpression == null) {
            return;
        }
        if (qualifierExpression instanceof PsiReferenceExpression && ((qualifierResolved = ((PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiClass || qualifierResolved instanceof PsiPackage)) {
            return;
        }
        if (!member.hasModifierProperty("static")) {
            return;
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass != null && containingClass.isInterface() && member instanceof PsiMethod) {
            return;
        }
        if (containingClass instanceof PsiAnonymousClass || containingClass instanceof PsiImplicitClass) {
            return;
        }
        String description = JavaErrorBundle.message("static.member.accessed.via.instance.reference", JavaHighlightUtil.formatType(qualifierExpression.getType()), HighlightMessageUtil.getSymbolName((PsiElement)resolved, (PsiSubstitutor)result.getSubstitutor()));
        holder.registerProblem((PsiElement)expr, description, new LocalQuickFix[]{this.createAccessStaticViaInstanceFix(expr, result)});
    }

    protected LocalQuickFix createAccessStaticViaInstanceFix(PsiReferenceExpression expr, JavaResolveResult result) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/accessStaticViaInstance/AccessStaticViaInstanceBase", "buildVisitor"));
    }
}

