/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Member;
import com.intellij.codeInspection.bytecodeAnalysis.MemberDescriptor;
import com.intellij.codeInspection.bytecodeAnalysis.MethodAnnotations;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BytecodeAnalysisConverter {
    @Nullable
    public static EKey psiKey(@NotNull PsiMember psiMethod, @NotNull Direction direction) {
        PsiClass psiClass;
        if (psiMethod == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(0);
        }
        if (direction == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(1);
        }
        if ((psiClass = psiMethod.getContainingClass()) != null) {
            String sig;
            String className = BytecodeAnalysisConverter.getJvmClassName(psiClass);
            String name = psiMethod.getName();
            if (psiMethod instanceof PsiMethod) {
                sig = BytecodeAnalysisConverter.methodSignature((PsiMethod)psiMethod, psiClass);
                if (((PsiMethod)psiMethod).isConstructor()) {
                    name = "<init>";
                }
            } else if (psiMethod instanceof PsiField) {
                sig = BytecodeAnalysisConverter.descriptor(((PsiField)psiMethod).getType());
            } else {
                return null;
            }
            if (className != null && sig != null && name != null) {
                return new EKey((MemberDescriptor)new Member(className, name, sig), direction, true, false);
            }
        }
        return null;
    }

    @Nullable
    private static String methodSignature(@NotNull PsiMethod psiMethod, @NotNull PsiClass psiClass) {
        PsiClass outerClass;
        if (psiMethod == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(2);
        }
        if (psiClass == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(3);
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        if (psiMethod.isConstructor() && !psiClass.hasModifierProperty("static") && (outerClass = psiClass.getContainingClass()) != null) {
            String desc = BytecodeAnalysisConverter.descriptor(outerClass, 0);
            if (desc == null) {
                return null;
            }
            sb.append(desc);
        }
        for (PsiClass parameter : psiMethod.getParameterList().getParameters()) {
            String desc = BytecodeAnalysisConverter.descriptor(parameter.getType());
            if (desc == null) {
                return null;
            }
            sb.append(desc);
        }
        sb.append(')');
        PsiType returnType = psiMethod.getReturnType();
        if (returnType == null) {
            sb.append('V');
        } else {
            String desc = BytecodeAnalysisConverter.descriptor(returnType);
            if (desc == null) {
                return null;
            }
            sb.append(desc);
        }
        return sb.toString();
    }

    @Nullable
    private static String descriptor(@NotNull PsiClass psiClass, int dimensions) {
        String fqn;
        if (psiClass == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(4);
        }
        if ((fqn = BytecodeAnalysisConverter.getJvmClassName(psiClass)) == null) {
            return null;
        }
        return "[".repeat(dimensions) + "L" + fqn + ";";
    }

    @Nullable
    private static String getJvmClassName(@NotNull PsiClass psiClass) {
        String name;
        if (psiClass == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(5);
        }
        return (name = ClassUtil.getJVMClassName((PsiClass)psiClass)) == null ? null : name.replace('.', '/');
    }

    @Nullable
    private static String descriptor(@NotNull PsiType psiType) {
        if (psiType == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(6);
        }
        int dimensions = 0;
        if ((psiType = TypeConversionUtil.erasure((PsiType)psiType)) instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)psiType;
            psiType = arrayType.getDeepComponentType();
            dimensions = arrayType.getArrayDimensions();
        }
        if (psiType instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            if (psiClass != null) {
                return BytecodeAnalysisConverter.descriptor(psiClass, dimensions);
            }
            ProjectBytecodeAnalysis.LOG.debug("resolve was null for " + psiType.getCanonicalText());
            return null;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)psiType)) {
            return "[".repeat(dimensions) + ((PsiPrimitiveType)psiType).getKind().getBinaryName();
        }
        return null;
    }

    @NotNull
    public static ArrayList<EKey> mkInOutKeys(@NotNull PsiMethod psiMethod, @NotNull EKey primaryKey) {
        if (psiMethod == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(7);
        }
        if (primaryKey == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(8);
        }
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        ArrayList<EKey> keys = new ArrayList<EKey>(parameters.length * 2 + 2);
        keys.add(primaryKey);
        for (int i = 0; i < parameters.length; ++i) {
            if (!(parameters[i].getType() instanceof PsiPrimitiveType)) {
                keys.add(primaryKey.withDirection(new Direction.InOut(i, Value.NotNull)));
                keys.add(primaryKey.withDirection(new Direction.InOut(i, Value.Null)));
                keys.add(primaryKey.withDirection(new Direction.InThrow(i, Value.NotNull)));
                keys.add(primaryKey.withDirection(new Direction.InThrow(i, Value.Null)));
                continue;
            }
            if (!PsiTypes.booleanType().equals((Object)parameters[i].getType())) continue;
            keys.add(primaryKey.withDirection(new Direction.InOut(i, Value.True)));
            keys.add(primaryKey.withDirection(new Direction.InOut(i, Value.False)));
            keys.add(primaryKey.withDirection(new Direction.InThrow(i, Value.True)));
            keys.add(primaryKey.withDirection(new Direction.InThrow(i, Value.False)));
        }
        ArrayList<EKey> arrayList = keys;
        if (arrayList == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public static void addEffectAnnotations(Map<EKey, Effects> puritySolutions, MethodAnnotations result, EKey pureKey, boolean constructor) {
        Effects solution = puritySolutions.get(pureKey.mkUnstable());
        if (solution == null && (solution = puritySolutions.get(pureKey.mkStable())) == null) {
            return;
        }
        result.returnValue = solution.returnValue;
        Set<EffectQuantum> effects = solution.effects;
        MutationSignature sig = MutationSignature.pure();
        for (EffectQuantum effect : effects) {
            if (effect.equals(EffectQuantum.ThisChangeQuantum)) {
                if (constructor) continue;
                sig = sig.alsoMutatesThis();
                continue;
            }
            if (effect instanceof EffectQuantum.ParamChangeQuantum) {
                int paramN = ((EffectQuantum.ParamChangeQuantum)effect).n;
                sig = sig.alsoMutatesArg(paramN);
                continue;
            }
            sig = MutationSignature.unknown();
            break;
        }
        result.mutates = sig;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryKey";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisConverter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "mkInOutKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "psiKey";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "methodSignature";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "descriptor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getJvmClassName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mkInOutKeys";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

