/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.ClassDataIndexer;
import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Equations;
import com.intellij.codeInspection.bytecodeAnalysis.FieldAccess;
import com.intellij.codeInspection.bytecodeAnalysis.HMember;
import com.intellij.codeInspection.bytecodeAnalysis.MemberDescriptor;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public final class BytecodeAnalysisIndex
extends ScalarIndexExtension<HMember> {
    private static final boolean IS_ENABLED = SystemProperties.getBooleanProperty((String)"bytecodeAnalysis.index.enabled", (boolean)true);
    static final ID<HMember, Void> NAME = ID.create((String)"bytecodeAnalysis");

    @NotNull
    public ID<HMember, Void> getName() {
        ID<HMember, Void> iD = NAME;
        if (iD == null) {
            BytecodeAnalysisIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<HMember, Void, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            try {
                return BytecodeAnalysisIndex.collectKeys(inputData.getContent());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                ProjectBytecodeAnalysis.LOG.debug("Unexpected Error during indexing of bytecode", e);
                return Collections.emptyMap();
            }
        };
        if (dataIndexer == null) {
            BytecodeAnalysisIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    private static Map<HMember, Void> collectKeys(byte[] content) {
        final HashMap<HMember, Void> map = new HashMap<HMember, Void>();
        ClassReader reader = new ClassReader(content);
        String className = reader.getClassName();
        final long classHash = HMember.classHash(className);
        reader.accept(new ClassVisitor(589824){

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                if ((access & 2) == 0) {
                    map.put(HMember.create(classHash, name, desc), null);
                }
                return null;
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                map.put(HMember.create(classHash, name, desc), null);
                return null;
            }
        }, 7);
        HashMap<HMember, Void> hashMap = map;
        if (hashMap == null) {
            BytecodeAnalysisIndex.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    @NotNull
    public KeyDescriptor<HMember> getKeyDescriptor() {
        HKeyDescriptor hKeyDescriptor = HKeyDescriptor.INSTANCE;
        if (hKeyDescriptor == null) {
            BytecodeAnalysisIndex.$$$reportNull$$$0(3);
        }
        return hKeyDescriptor;
    }

    public boolean hasSnapshotMapping() {
        return true;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return IS_ENABLED ? new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaClassFileType.INSTANCE}) : new DefaultFileTypeSpecificInputFilter(new FileType[0]);
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 11;
    }

    public boolean needsForwardIndexWhenSharing() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectKeys";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class HKeyDescriptor
    implements KeyDescriptor<HMember>,
    DifferentSerializableBytesImplyNonEqualityPolicy {
        static final HKeyDescriptor INSTANCE = new HKeyDescriptor();

        private HKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, HMember value) throws IOException {
            if (out == null) {
                HKeyDescriptor.$$$reportNull$$$0(0);
            }
            out.write(value.asBytes());
        }

        public HMember read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                HKeyDescriptor.$$$reportNull$$$0(1);
            }
            byte[] bytes = new byte[12];
            in.readFully(bytes);
            return new HMember(bytes);
        }

        public int getHashCode(HMember value) {
            return value.hashCode();
        }

        public boolean isEqual(HMember val1, HMember val2) {
            return val1.equals(val2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class EquationsExternalizer
    implements DataExternalizer<Map<HMember, Equations>> {
        public static final EquationsExternalizer INSTANCE = new EquationsExternalizer();

        public void save(@NotNull DataOutput out, Map<HMember, Equations> value) throws IOException {
            if (out == null) {
                EquationsExternalizer.$$$reportNull$$$0(0);
            }
            DataInputOutputUtilRt.writeSeq((DataOutput)out, value.entrySet(), entry -> {
                HKeyDescriptor.INSTANCE.save(out, (HMember)entry.getKey());
                EquationsExternalizer.saveEquations(out, (Equations)entry.getValue());
            });
        }

        public Map<HMember, Equations> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                EquationsExternalizer.$$$reportNull$$$0(1);
            }
            return StreamEx.of((Collection)DataInputOutputUtilRt.readSeq((DataInput)in, () -> Pair.create((Object)HKeyDescriptor.INSTANCE.read(in), (Object)EquationsExternalizer.readEquations(in)))).toMap(p -> (HMember)p.getFirst(), p -> (Equations)p.getSecond(), ClassDataIndexer.MERGER);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static void saveEquations(@NotNull DataOutput out, Equations eqs) throws IOException {
            if (out == null) {
                EquationsExternalizer.$$$reportNull$$$0(2);
            }
            out.writeBoolean(eqs.stable);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)eqs.results.size());
            int maxFinal = Value.values().length;
            for (DirectionResultPair pair : eqs.results) {
                Component[] name;
                DataInputOutputUtil.writeINT((DataOutput)out, (int)pair.directionKey);
                Result rhs = pair.result;
                if (rhs instanceof Value) {
                    Value finalResult = (Value)rhs;
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)finalResult.ordinal());
                    continue;
                }
                if (rhs instanceof Pending) {
                    Pending pendResult = (Pending)rhs;
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)maxFinal);
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)pendResult.delta.length);
                    for (Component component : pendResult.delta) {
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)component.value.ordinal());
                        EKey[] ids = component.ids;
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)ids.length);
                        for (EKey hKey : ids) {
                            EquationsExternalizer.writeKey(out, hKey);
                        }
                    }
                    continue;
                }
                if (rhs instanceof Effects) {
                    Effects effects = (Effects)rhs;
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)effects.effects.size());
                    for (EffectQuantum effect : effects.effects) {
                        EquationsExternalizer.writeEffect(out, effect);
                    }
                    EquationsExternalizer.writeDataValue(out, effects.returnValue);
                    continue;
                }
                if (!(rhs instanceof FieldAccess)) throw new UnsupportedOperationException("Unsupported result: " + String.valueOf(rhs) + " in " + String.valueOf(eqs));
                FieldAccess fieldAccess = (FieldAccess)rhs;
                try {
                    Component[] componentArray = fieldAccess.name();
                    name = componentArray;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)(maxFinal + 1));
                out.writeUTF((String)name);
            }
        }

        private static Equations readEquations(@NotNull DataInput in) throws IOException {
            if (in == null) {
                EquationsExternalizer.$$$reportNull$$$0(3);
            }
            ProgressManager.checkCanceled();
            boolean stable = in.readBoolean();
            int size = DataInputOutputUtil.readINT((DataInput)in);
            ArrayList<DirectionResultPair> results = new ArrayList<DirectionResultPair>(size);
            Value[] values = Value.values();
            for (int k = 0; k < size; ++k) {
                int directionKey = DataInputOutputUtil.readINT((DataInput)in);
                Direction direction = Direction.fromInt(directionKey);
                if (direction == Direction.Pure || direction == Direction.Volatile) {
                    ArrayList<EffectQuantum> effects = new ArrayList<EffectQuantum>();
                    int effectsSize = DataInputOutputUtil.readINT((DataInput)in);
                    for (int i = 0; i < effectsSize; ++i) {
                        effects.add(EquationsExternalizer.readEffect(in));
                    }
                    DataValue returnValue = EquationsExternalizer.readDataValue(in);
                    results.add(new DirectionResultPair(directionKey, new Effects(returnValue, Set.copyOf(effects))));
                    continue;
                }
                int resultKind = DataInputOutputUtil.readINT((DataInput)in);
                if (resultKind == values.length) {
                    int sumLength = DataInputOutputUtil.readINT((DataInput)in);
                    Component[] components = new Component[sumLength];
                    for (int i = 0; i < sumLength; ++i) {
                        int ordinal = DataInputOutputUtil.readINT((DataInput)in);
                        Value value = values[ordinal];
                        int componentSize = DataInputOutputUtil.readINT((DataInput)in);
                        EKey[] ids = new EKey[componentSize];
                        for (int j = 0; j < componentSize; ++j) {
                            ids[j] = EquationsExternalizer.readKey(in);
                        }
                        components[i] = new Component(value, ids);
                    }
                    results.add(new DirectionResultPair(directionKey, new Pending(components)));
                    continue;
                }
                if (resultKind == values.length + 1) {
                    results.add(new DirectionResultPair(directionKey, new FieldAccess(in.readUTF())));
                    continue;
                }
                Value value = values[resultKind];
                results.add(new DirectionResultPair(directionKey, value));
            }
            return new Equations(results, stable);
        }

        @NotNull
        private static EKey readKey(@NotNull DataInput in) throws IOException {
            if (in == null) {
                EquationsExternalizer.$$$reportNull$$$0(4);
            }
            byte[] bytes = new byte[12];
            in.readFully(bytes);
            int rawDirKey = DataInputOutputUtil.readINT((DataInput)in);
            return new EKey((MemberDescriptor)new HMember(bytes), Direction.fromInt(Math.abs(rawDirKey)), in.readBoolean(), rawDirKey < 0);
        }

        private static void writeKey(@NotNull DataOutput out, EKey key) throws IOException {
            if (out == null) {
                EquationsExternalizer.$$$reportNull$$$0(5);
            }
            out.write(key.member.hashed().asBytes());
            int rawDirKey = key.negated ? -key.dirKey : key.dirKey;
            DataInputOutputUtil.writeINT((DataOutput)out, (int)rawDirKey);
            out.writeBoolean(key.stable);
        }

        private static void writeEffect(@NotNull DataOutput out, EffectQuantum effect) throws IOException {
            if (out == null) {
                EquationsExternalizer.$$$reportNull$$$0(6);
            }
            if (effect == EffectQuantum.TopEffectQuantum) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-1);
            } else if (effect == EffectQuantum.ThisChangeQuantum) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-2);
            } else if (effect instanceof EffectQuantum.CallQuantum) {
                EffectQuantum.CallQuantum callQuantum = (EffectQuantum.CallQuantum)effect;
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-3);
                EquationsExternalizer.writeKey(out, callQuantum.key);
                out.writeBoolean(callQuantum.isStatic);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)callQuantum.data.length);
                for (DataValue dataValue : callQuantum.data) {
                    EquationsExternalizer.writeDataValue(out, dataValue);
                }
            } else if (effect instanceof EffectQuantum.ReturnChangeQuantum) {
                EffectQuantum.ReturnChangeQuantum returnChangeQuantum = (EffectQuantum.ReturnChangeQuantum)effect;
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-4);
                EquationsExternalizer.writeKey(out, returnChangeQuantum.key);
            } else if (effect instanceof EffectQuantum.FieldReadQuantum) {
                EffectQuantum.FieldReadQuantum fieldReadQuantum = (EffectQuantum.FieldReadQuantum)effect;
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-5);
                EquationsExternalizer.writeKey(out, fieldReadQuantum.key);
            } else if (effect instanceof EffectQuantum.ParamChangeQuantum) {
                EffectQuantum.ParamChangeQuantum paramChangeQuantum = (EffectQuantum.ParamChangeQuantum)effect;
                DataInputOutputUtil.writeINT((DataOutput)out, (int)paramChangeQuantum.n);
            }
        }

        private static EffectQuantum readEffect(@NotNull DataInput in) throws IOException {
            if (in == null) {
                EquationsExternalizer.$$$reportNull$$$0(7);
            }
            int effectMask = DataInputOutputUtil.readINT((DataInput)in);
            return switch (effectMask) {
                case -1 -> EffectQuantum.TopEffectQuantum;
                case -2 -> EffectQuantum.ThisChangeQuantum;
                case -3 -> {
                    EKey key = EquationsExternalizer.readKey(in);
                    boolean isStatic = in.readBoolean();
                    int dataLength = DataInputOutputUtil.readINT((DataInput)in);
                    DataValue[] data = new DataValue[dataLength];
                    for (int di = 0; di < dataLength; ++di) {
                        data[di] = EquationsExternalizer.readDataValue(in);
                    }
                    yield new EffectQuantum.CallQuantum(key, data, isStatic);
                }
                case -4 -> new EffectQuantum.ReturnChangeQuantum(EquationsExternalizer.readKey(in));
                case -5 -> new EffectQuantum.FieldReadQuantum(EquationsExternalizer.readKey(in));
                default -> new EffectQuantum.ParamChangeQuantum(effectMask);
            };
        }

        private static void writeDataValue(@NotNull DataOutput out, DataValue dataValue) throws IOException {
            if (out == null) {
                EquationsExternalizer.$$$reportNull$$$0(8);
            }
            if (dataValue == DataValue.ThisDataValue) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-1);
            } else if (dataValue == DataValue.LocalDataValue) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-2);
            } else if (dataValue == DataValue.OwnedDataValue) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-3);
            } else if (dataValue == DataValue.UnknownDataValue1) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-4);
            } else if (dataValue == DataValue.UnknownDataValue2) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-5);
            } else if (dataValue instanceof DataValue.ReturnDataValue) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-6);
                EquationsExternalizer.writeKey(out, ((DataValue.ReturnDataValue)dataValue).key);
            } else if (dataValue instanceof DataValue.ParameterDataValue) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)((DataValue.ParameterDataValue)dataValue).n);
            }
        }

        private static DataValue readDataValue(@NotNull DataInput in) throws IOException {
            if (in == null) {
                EquationsExternalizer.$$$reportNull$$$0(9);
            }
            int dataI = DataInputOutputUtil.readINT((DataInput)in);
            return switch (dataI) {
                case -1 -> DataValue.ThisDataValue;
                case -2 -> DataValue.LocalDataValue;
                case -3 -> DataValue.OwnedDataValue;
                case -4 -> DataValue.UnknownDataValue1;
                case -5 -> DataValue.UnknownDataValue2;
                case -6 -> new DataValue.ReturnDataValue(EquationsExternalizer.readKey(in));
                default -> DataValue.ParameterDataValue.create(dataI);
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$EquationsExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveEquations";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readEquations";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readKey";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeKey";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeEffect";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readEffect";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeDataValue";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readDataValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

