/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

final class Conf {
    final int insnIndex;
    final Frame<BasicValue> frame;
    final int fastHashCode;

    Conf(int insnIndex, Frame<BasicValue> frame) {
        int i;
        this.insnIndex = insnIndex;
        this.frame = frame;
        int hash = 0;
        for (i = 0; i < frame.getLocals(); ++i) {
            hash = hash * 31 + ((BasicValue)frame.getLocal(i)).getClass().hashCode();
        }
        for (i = 0; i < frame.getStackSize(); ++i) {
            hash = hash * 31 + ((BasicValue)frame.getStack(i)).getClass().hashCode();
        }
        this.fastHashCode = hash;
    }

    boolean equiv(Conf other) {
        int i;
        if (this == other) {
            return true;
        }
        if (this.fastHashCode != other.fastHashCode) {
            return false;
        }
        Frame<BasicValue> currFr = this.frame;
        Frame<BasicValue> prevFr = other.frame;
        for (i = currFr.getStackSize() - 1; i >= 0; --i) {
            if (AbstractValues.equiv((BasicValue)currFr.getStack(i), (BasicValue)prevFr.getStack(i))) continue;
            return false;
        }
        for (i = currFr.getLocals() - 1; i >= 0; --i) {
            if (AbstractValues.equiv((BasicValue)currFr.getLocal(i), (BasicValue)prevFr.getLocal(i))) continue;
            return false;
        }
        return true;
    }
}

