/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

abstract class EffectQuantum {
    private final int myHash;
    static final EffectQuantum TopEffectQuantum = new EffectQuantum(-1){

        public String toString() {
            return "Top";
        }
    };
    static final EffectQuantum ThisChangeQuantum = new EffectQuantum(-2){

        public String toString() {
            return "Changes this";
        }
    };

    EffectQuantum(int hash) {
        this.myHash = hash;
    }

    Stream<EKey> dependencies() {
        return Stream.empty();
    }

    void processDependencies(Consumer<EKey> consumer) {
    }

    public final int hashCode() {
        return this.myHash;
    }

    static final class CallQuantum
    extends EffectQuantum {
        final EKey key;
        final DataValue[] data;
        final boolean isStatic;

        CallQuantum(EKey key, DataValue[] data, boolean isStatic) {
            super((key.hashCode() * 31 + Arrays.hashCode(data)) * 31 + (isStatic ? 1 : 0));
            this.key = key;
            this.data = data.length == 0 ? DataValue.EMPTY : data;
            this.isStatic = isStatic;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CallQuantum that = (CallQuantum)o;
            if (this.isStatic != that.isStatic) {
                return false;
            }
            if (!this.key.equals(that.key)) {
                return false;
            }
            return Arrays.equals(this.data, that.data);
        }

        @Override
        Stream<EKey> dependencies() {
            return StreamEx.of((Object[])this.data).flatMap(DataValue::dependencies).prepend((Object)this.key);
        }

        @Override
        void processDependencies(Consumer<EKey> consumer) {
            consumer.accept(this.key);
            for (DataValue datum : this.data) {
                datum.processDependencies(consumer);
            }
        }

        public String toString() {
            return "Calls " + String.valueOf(this.key);
        }
    }

    static final class ParamChangeQuantum
    extends EffectQuantum {
        final int n;

        ParamChangeQuantum(int n) {
            super(n);
            this.n = n;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass() && this.n == ((ParamChangeQuantum)o).n;
        }

        public String toString() {
            return "Changes param#" + this.n;
        }
    }

    static final class ReturnChangeQuantum
    extends EffectQuantum {
        @NotNull
        final EKey key;

        ReturnChangeQuantum(@NotNull EKey key) {
            if (key == null) {
                ReturnChangeQuantum.$$$reportNull$$$0(0);
            }
            super(key.hashCode());
            this.key = key;
        }

        @Override
        Stream<EKey> dependencies() {
            return Stream.of(this.key);
        }

        @Override
        void processDependencies(Consumer<EKey> consumer) {
            consumer.accept(this.key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass() && this.key.equals(((ReturnChangeQuantum)o).key);
        }

        public String toString() {
            return "Changes return value of " + String.valueOf(this.key);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/bytecodeAnalysis/EffectQuantum$ReturnChangeQuantum", "<init>"));
        }
    }

    static final class FieldReadQuantum
    extends EffectQuantum {
        @NotNull
        final EKey key;

        FieldReadQuantum(@NotNull EKey key) {
            if (key == null) {
                FieldReadQuantum.$$$reportNull$$$0(0);
            }
            super(key.hashCode());
            this.key = key;
        }

        @Override
        Stream<EKey> dependencies() {
            return Stream.of(this.key);
        }

        @Override
        void processDependencies(Consumer<EKey> consumer) {
            consumer.accept(this.key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass() && this.key.equals(((FieldReadQuantum)o).key);
        }

        public String toString() {
            return "Reads field " + String.valueOf(this.key);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/bytecodeAnalysis/EffectQuantum$FieldReadQuantum", "<init>"));
        }
    }
}

